/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.filters;

import java.io.Serializable;
import java.math.BigDecimal;
import org.marketcetera.core.CoreException;
import org.marketcetera.ors.filters.Messages;
import org.marketcetera.ors.filters.OrderFilter;
import org.marketcetera.quickfix.FIXMessageUtil;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage3P;
import org.marketcetera.util.misc.ClassVersion;
import quickfix.FieldNotFound;
import quickfix.Message;

@ClassVersion(value="$Id: OrderLimitFilter.java 16154 2012-07-14 16:34:05Z colin $$")
public class OrderLimitFilter
implements OrderFilter {
    private boolean mDisallowMarketOrders;
    private BigDecimal mMaxQuantityPerOrder;
    private BigDecimal mMaxNotionalPerOrder;
    private BigDecimal mMinPrice;
    private BigDecimal mMaxPrice;

    public void setDisallowMarketOrders(boolean disallowMarketOrders) {
        this.mDisallowMarketOrders = disallowMarketOrders;
    }

    public boolean getDisallowMarketOrders() {
        return this.mDisallowMarketOrders;
    }

    public void setMaxQuantityPerOrder(BigDecimal maxQuantityPerOrder) {
        this.mMaxQuantityPerOrder = maxQuantityPerOrder;
    }

    public BigDecimal getMaxQuantityPerOrder() {
        return this.mMaxQuantityPerOrder;
    }

    public void setMaxNotionalPerOrder(BigDecimal maxNotionalPerOrder) {
        this.mMaxNotionalPerOrder = maxNotionalPerOrder;
    }

    public BigDecimal getMaxNotionalPerOrder() {
        return this.mMaxNotionalPerOrder;
    }

    public void setMinPrice(BigDecimal minPrice) {
        this.mMinPrice = minPrice;
    }

    public BigDecimal getMinPrice() {
        return this.mMinPrice;
    }

    public void setMaxPrice(BigDecimal maxPrice) {
        this.mMaxPrice = maxPrice;
    }

    public BigDecimal getMaxPrice() {
        return this.mMaxPrice;
    }

    @Override
    public void assertAccepted(Message msg) throws CoreException {
        if (!FIXMessageUtil.isOrderSingle((Message)msg) && !FIXMessageUtil.isCancelReplaceRequest((Message)msg)) {
            return;
        }
        String symbol = null;
        try {
            symbol = msg.getString(55);
        }
        catch (FieldNotFound ex) {
            Messages.NO_SYMBOL.warn((Object)this, (Throwable)ex);
        }
        try {
            if (this.getDisallowMarketOrders() && '1' == msg.getChar(40)) {
                throw new CoreException((I18NBoundMessage)new I18NBoundMessage1P(Messages.MARKET_NOT_ALLOWED, (Serializable)((Object)symbol)));
            }
        }
        catch (FieldNotFound ex) {
            Messages.NO_ORDER_TYPE.warn((Object)this, (Throwable)ex);
        }
        BigDecimal p = null;
        try {
            p = new BigDecimal(msg.getString(44));
        }
        catch (FieldNotFound ex) {
            Messages.NO_PRICE.warn((Object)this, (Throwable)ex);
        }
        BigDecimal q = null;
        try {
            q = new BigDecimal(msg.getString(38));
        }
        catch (FieldNotFound ex) {
            Messages.NO_QUANTITY.warn((Object)this, (Throwable)ex);
        }
        if (p == null && q == null) {
            return;
        }
        if (q != null && this.getMaxQuantityPerOrder() != null && this.getMaxQuantityPerOrder().compareTo(q) < 0) {
            throw new CoreException((I18NBoundMessage)new I18NBoundMessage3P(Messages.MAX_QTY, (Serializable)q, (Serializable)this.getMaxQuantityPerOrder(), (Serializable)((Object)symbol)));
        }
        if (p != null && q != null && this.getMaxNotionalPerOrder() != null) {
            BigDecimal n = p.multiply(q);
            if (this.getMaxNotionalPerOrder().compareTo(n) < 0) {
                throw new CoreException((I18NBoundMessage)new I18NBoundMessage3P(Messages.MAX_NOTIONAL, (Serializable)n, (Serializable)this.getMaxNotionalPerOrder(), (Serializable)((Object)symbol)));
            }
        }
        if (p != null && this.getMinPrice() != null && this.getMinPrice().compareTo(p) > 0) {
            throw new CoreException((I18NBoundMessage)new I18NBoundMessage3P(Messages.MIN_PRICE, (Serializable)p, (Serializable)this.getMinPrice(), (Serializable)((Object)symbol)));
        }
        if (p != null && this.getMaxPrice() != null && this.getMaxPrice().compareTo(p) < 0) {
            throw new CoreException((I18NBoundMessage)new I18NBoundMessage3P(Messages.MAX_PRICE, (Serializable)p, (Serializable)this.getMaxPrice(), (Serializable)((Object)symbol)));
        }
    }
}

