/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import javax.xml.bind.JAXBException;
import org.marketcetera.client.jms.JmsManager;
import org.marketcetera.client.jms.ReceiveOnlyHandler;
import org.marketcetera.core.IDFactory;
import org.marketcetera.ors.history.BasicReportHistoryServices;
import org.marketcetera.ors.history.Messages;
import org.marketcetera.ors.history.PersistentReport;
import org.marketcetera.ors.history.ReportPersistenceException;
import org.marketcetera.ors.history.ReportSavedListener;
import org.marketcetera.persist.PersistenceException;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.TradeMessage;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.jms.core.JmsOperations;

@ClassVersion(value="$Id: AsyncSaveReportHistoryServices.java 16154 2012-07-14 16:34:05Z colin $")
public class AsyncSaveReportHistoryServices
extends BasicReportHistoryServices {
    private static final String PERSIST_QUEUE = "persist-queue";
    private JmsOperations mToPersistQueue;

    @Override
    public void init(IDFactory idFactory, JmsManager jmsManager, ReportSavedListener reportSavedListener) throws ReportPersistenceException {
        super.init(idFactory, jmsManager, reportSavedListener);
        try {
            this.mToPersistQueue = this.getJmsManager().getOutgoingJmsFactory().createJmsTemplateX(PERSIST_QUEUE, false);
            this.getJmsManager().getIncomingJmsFactory().registerHandlerTMX((ReceiveOnlyHandler)new QueueHandler(), PERSIST_QUEUE, false);
        }
        catch (JAXBException ex) {
            throw new ReportPersistenceException(ex, (I18NBoundMessage)Messages.RHS_CANNOT_CREATE_QUEUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ReportBase report) throws PersistenceException {
        boolean success = false;
        try {
            this.assignID(report);
            success = true;
        }
        finally {
            if (!success) {
                this.invokeListener(report, false);
            }
        }
        Messages.RHS_ENQUEUED_REPLY.info((Object)this, (Object)report);
        this.getToPersistQueue().convertAndSend((Object)report);
    }

    private JmsOperations getToPersistQueue() {
        return this.mToPersistQueue;
    }

    public class QueueHandler
    implements ReceiveOnlyHandler<TradeMessage> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveMessage(TradeMessage msg) {
            ReportBase report = (ReportBase)msg;
            Messages.RHS_DEQUEUED_REPLY.info((Object)this, (Object)report);
            boolean success = false;
            try {
                PersistentReport.save(report);
                success = true;
                Messages.RHS_PERSISTED_REPLY.info((Object)this, (Object)report);
            }
            catch (PersistenceException ex) {
                Messages.RHS_PERSIST_ERROR.error((Object)this, (Throwable)ex, (Object)report);
            }
            finally {
                AsyncSaveReportHistoryServices.this.invokeListener(report, success);
            }
        }
    }
}

