/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.marketcetera.client.jms.JmsManager;
import org.marketcetera.core.IDFactory;
import org.marketcetera.core.NoMoreIDsException;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.ors.LongIDFactory;
import org.marketcetera.ors.Principals;
import org.marketcetera.ors.history.ExecutionReportSummary;
import org.marketcetera.ors.history.Messages;
import org.marketcetera.ors.history.MultiPersistentReportQuery;
import org.marketcetera.ors.history.PersistentReport;
import org.marketcetera.ors.history.ReportHistoryServices;
import org.marketcetera.ors.history.ReportPersistenceException;
import org.marketcetera.ors.history.ReportSavedListener;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.persist.PersistenceException;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.ReportBaseImpl;
import org.marketcetera.trade.ReportID;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: BasicReportHistoryServices.java 16154 2012-07-14 16:34:05Z colin $")
public class BasicReportHistoryServices
implements ReportHistoryServices {
    private LongIDFactory mReportIDFactory;
    private JmsManager mJmsManager;
    private ReportSavedListener mReportSavedListener;

    @Override
    public void init(IDFactory idFactory, JmsManager jmsManager, ReportSavedListener reportSavedListener) throws ReportPersistenceException {
        this.mReportIDFactory = new LongIDFactory(idFactory);
        this.mJmsManager = jmsManager;
        this.mReportSavedListener = reportSavedListener;
    }

    @Override
    public ReportBaseImpl[] getReportsSince(SimpleUser inUser, Date inDate) throws PersistenceException, ReportPersistenceException {
        MultiPersistentReportQuery query = MultiPersistentReportQuery.all();
        query.setSendingTimeAfterFilter(inDate);
        if (!inUser.isSuperuser()) {
            query.setViewerFilter(inUser);
        }
        query.setEntityOrder(MultiPersistentReportQuery.BY_ID);
        List<PersistentReport> reportList = query.fetch();
        ReportBaseImpl[] reports = new ReportBaseImpl[reportList.size()];
        int i = 0;
        for (PersistentReport report : reportList) {
            reports[i++] = (ReportBaseImpl)report.toReport();
        }
        return reports;
    }

    @Override
    public BigDecimal getEquityPositionAsOf(SimpleUser inUser, Date inDate, Equity inEquity) throws PersistenceException {
        return ExecutionReportSummary.getEquityPositionAsOf(inUser, inDate, inEquity);
    }

    @Override
    public Map<PositionKey<Equity>, BigDecimal> getAllEquityPositionsAsOf(SimpleUser inUser, Date inDate) throws PersistenceException {
        return ExecutionReportSummary.getAllEquityPositionsAsOf(inUser, inDate);
    }

    @Override
    public Map<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(SimpleUser inUser, Date inDate) throws PersistenceException {
        return ExecutionReportSummary.getAllFuturePositionsAsOf(inUser, inDate);
    }

    @Override
    public BigDecimal getFuturePositionAsOf(SimpleUser inUser, Date inDate, Future inFuture) throws PersistenceException {
        return ExecutionReportSummary.getFuturePositionAsOf(inUser, inDate, inFuture);
    }

    @Override
    public BigDecimal getOptionPositionAsOf(SimpleUser inUser, Date inDate, Option inOption) throws PersistenceException {
        return ExecutionReportSummary.getOptionPositionAsOf(inUser, inDate, inOption);
    }

    @Override
    public Map<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(SimpleUser inUser, Date inDate) throws PersistenceException {
        return ExecutionReportSummary.getAllOptionPositionsAsOf(inUser, inDate);
    }

    @Override
    public Map<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(SimpleUser inUser, Date inDate, String ... inSymbols) throws PersistenceException {
        return ExecutionReportSummary.getOptionPositionsAsOf(inUser, inDate, inSymbols);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ReportBase report) throws PersistenceException {
        boolean success = false;
        try {
            this.assignID(report);
            PersistentReport.save(report);
            success = true;
            Messages.RHS_PERSISTED_REPLY.info((Object)this, (Object)report);
        }
        finally {
            this.invokeListener(report, success);
        }
    }

    @Override
    public Principals getPrincipals(OrderID orderID) throws PersistenceException {
        return PersistentReport.getPrincipals(orderID);
    }

    protected LongIDFactory getReportIDFactory() {
        return this.mReportIDFactory;
    }

    protected JmsManager getJmsManager() {
        return this.mJmsManager;
    }

    protected ReportSavedListener getReportSavedListener() {
        return this.mReportSavedListener;
    }

    protected void assignID(ReportBase report) throws PersistenceException {
        try {
            ReportBaseImpl.assignReportID((ReportBaseImpl)((ReportBaseImpl)report), (ReportID)new ReportID(this.getReportIDFactory().getNext()));
        }
        catch (NoMoreIDsException ex) {
            throw new PersistenceException((Throwable)ex, (I18NBoundMessage)Messages.RHS_NO_MORE_IDS);
        }
    }

    protected void invokeListener(ReportBase report, boolean status) {
        if (this.getReportSavedListener() != null) {
            this.getReportSavedListener().reportSaved(report, status);
        }
    }
}

