/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.ManyToOne;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Query;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.core.position.PositionKeyFactory;
import org.marketcetera.ors.history.InstrumentSummaryFields;
import org.marketcetera.ors.history.PersistentReport;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.persist.EntityBase;
import org.marketcetera.persist.PersistContext;
import org.marketcetera.persist.PersistenceException;
import org.marketcetera.persist.Transaction;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.SecurityType;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: ExecutionReportSummary.java 16154 2012-07-14 16:34:05Z colin $")
@Entity
@Table(name="execreports")
@NamedQuery(name="rootIDForOrderID", query="select e.rootID from ExecutionReportSummary e where e.orderID = :orderID")
@SqlResultSetMappings(value={@SqlResultSetMapping(name="positionForSymbol", columns={@ColumnResult(name="position")}), @SqlResultSetMapping(name="eqAllPositions", columns={@ColumnResult(name="symbol"), @ColumnResult(name="account"), @ColumnResult(name="actor"), @ColumnResult(name="position")}), @SqlResultSetMapping(name="futAllPositions", columns={@ColumnResult(name="symbol"), @ColumnResult(name="expiry"), @ColumnResult(name="account"), @ColumnResult(name="actor"), @ColumnResult(name="position")}), @SqlResultSetMapping(name="optAllPositions", columns={@ColumnResult(name="symbol"), @ColumnResult(name="expiry"), @ColumnResult(name="strikePrice"), @ColumnResult(name="optionType"), @ColumnResult(name="account"), @ColumnResult(name="actor"), @ColumnResult(name="position")})})
@NamedNativeQueries(value={@NamedNativeQuery(name="eqPositionForSymbol", query="select sum(case when e.side = :sideBuy then e.cumQuantity else -e.cumQuantity end) as position from execreports e where e.symbol = :symbol and (e.securityType is null or e.securityType = :securityType) and e.sendingTime <= :sendingTime and (:allViewers or e.viewer_id = :viewerID) and e.id = (select max(s.id) from execreports s where s.rootID = e.rootID and s.orderStatus not in (7,11,15))", resultSetMapping="positionForSymbol"), @NamedNativeQuery(name="eqAllPositions", query="select e.symbol as symbol, e.account as account, r.actor_id as actor, sum(case when e.side = :sideBuy then e.cumQuantity else -e.cumQuantity end) as position from execreports e join reports r on (e.report_id=r.id) where e.sendingTime <= :sendingTime and (e.securityType is null or e.securityType = :securityType) and (:allViewers or e.viewer_id = :viewerID) and e.id = (select max(s.id) from execreports s where s.rootID = e.rootID and s.orderStatus not in (7,11,15)) group by symbol, account, actor having position <> 0", resultSetMapping="eqAllPositions"), @NamedNativeQuery(name="futPositionForSymbol", query="select sum(case when e.side = :sideBuy then e.cumQuantity else -e.cumQuantity end) as position from execreports e where e.symbol = :symbol and e.securityType = :securityType and e.sendingTime <= :sendingTime and (:allViewers or e.viewer_id = :viewerID) and e.id = (select max(s.id) from execreports s where s.rootID = e.rootID and s.orderStatus not in (7,11,15))", resultSetMapping="positionForSymbol"), @NamedNativeQuery(name="futAllPositions", query="select e.symbol as symbol, e.expiry as expiry, e.account as account, r.actor_id as actor, sum(case when e.side = :sideBuy then e.cumQuantity else -e.cumQuantity end) as position from execreports e join reports r on (e.report_id=r.id) where e.sendingTime <= :sendingTime and e.securityType = :securityType and (:allViewers or e.viewer_id = :viewerID) and e.id = (select max(s.id) from execreports s where s.rootID = e.rootID and s.orderStatus not in (7,11,15)) group by symbol, account, actor having position <> 0", resultSetMapping="futAllPositions"), @NamedNativeQuery(name="optPositionForTuple", query="select sum(case when e.side = :sideBuy then e.cumQuantity else -e.cumQuantity end) as position from execreports e where e.symbol = :symbol and e.securityType = :securityType and e.expiry = :expiry and e.strikePrice = :strikePrice and e.optionType = :optionType and e.sendingTime <= :sendingTime and (:allViewers or e.viewer_id = :viewerID) and e.id = (select max(s.id) from execreports s where s.rootID = e.rootID and s.orderStatus not in (7,11,15))", resultSetMapping="positionForSymbol"), @NamedNativeQuery(name="optAllPositions", query="select e.symbol as symbol, e.expiry as expiry, e.strikePrice as strikePrice, e.optionType as optionType, e.account as account, r.actor_id as actor, sum(case when e.side = :sideBuy then e.cumQuantity else -e.cumQuantity end) as position from execreports e join reports r on (e.report_id=r.id) where e.sendingTime <= :sendingTime and e.securityType = :securityType and (:allViewers or e.viewer_id = :viewerID) and e.id = (select max(s.id) from execreports s where s.rootID = e.rootID and s.orderStatus not in (7,11,15)) group by symbol, expiry, strikePrice, optionType, account, actor having position <> 0", resultSetMapping="optAllPositions"), @NamedNativeQuery(name="optPositionsForRoots", query="select e.symbol as symbol, e.expiry as expiry, e.strikePrice as strikePrice, e.optionType as optionType, e.account as account, r.actor_id as actor, sum(case when e.side = :sideBuy then e.cumQuantity else -e.cumQuantity end) as position from execreports e join reports r on (e.report_id=r.id) where e.sendingTime <= :sendingTime and e.securityType = :securityType and e.symbol in (:symbols) and (:allViewers or e.viewer_id = :viewerID) and e.id = (select max(s.id) from execreports s where s.rootID = e.rootID and s.orderStatus not in (7,11,15)) group by symbol, expiry, strikePrice, optionType, account, actor having position <> 0", resultSetMapping="optAllPositions")})
class ExecutionReportSummary
extends EntityBase {
    private OrderID mRootID;
    private OrderID mOrderID;
    private OrderID mOrigOrderID;
    private SecurityType mSecurityType;
    private String mSymbol;
    private String mExpiry;
    private BigDecimal mStrikePrice;
    private OptionType mOptionType;
    private String mAccount;
    private Side mSide;
    private BigDecimal mCumQuantity;
    private BigDecimal mAvgPrice;
    private BigDecimal mLastQuantity;
    private BigDecimal mLastPrice;
    private OrderStatus mOrderStatus;
    private Date mSendingTime;
    private SimpleUser mViewer;
    private PersistentReport mReport;
    static final String ATTRIBUTE_VIEWER = "viewer";
    static final String ENTITY_NAME = ExecutionReportSummary.class.getSimpleName();
    static final int DECIMAL_SCALE = 5;
    static final int DECIMAL_PRECISION = 15;
    private static final long serialVersionUID = 1L;

    static BigDecimal getEquityPositionAsOf(final SimpleUser inUser, final Date inDate, final Equity inEquity) throws PersistenceException {
        BigDecimal position = (BigDecimal)ExecutionReportSummary.executeRemote((Transaction)new Transaction<BigDecimal>(){
            private static final long serialVersionUID = 1L;

            public BigDecimal execute(EntityManager em, PersistContext context) {
                Query query = em.createNamedQuery("eqPositionForSymbol");
                query.setParameter("viewerID", (Object)inUser.getUserID().getValue());
                query.setParameter("allViewers", (Object)inUser.isSuperuser());
                query.setParameter("sideBuy", (Object)Side.Buy.ordinal());
                query.setParameter("symbol", (Object)inEquity.getSymbol());
                query.setParameter("securityType", (Object)SecurityType.CommonStock.ordinal());
                query.setParameter("sendingTime", inDate, TemporalType.TIMESTAMP);
                return (BigDecimal)query.getSingleResult();
            }
        }, null);
        return position == null ? BigDecimal.ZERO : position;
    }

    static Map<PositionKey<Equity>, BigDecimal> getAllEquityPositionsAsOf(final SimpleUser inUser, final Date inDate) throws PersistenceException {
        return (Map)ExecutionReportSummary.executeRemote((Transaction)new Transaction<Map<PositionKey<Equity>, BigDecimal>>(){
            private static final long serialVersionUID = 1L;

            public Map<PositionKey<Equity>, BigDecimal> execute(EntityManager em, PersistContext context) {
                Query query = em.createNamedQuery("eqAllPositions");
                query.setParameter("viewerID", (Object)inUser.getUserID().getValue());
                query.setParameter("allViewers", (Object)inUser.isSuperuser());
                query.setParameter("sideBuy", (Object)Side.Buy.ordinal());
                query.setParameter("securityType", (Object)SecurityType.CommonStock.ordinal());
                query.setParameter("sendingTime", inDate, TemporalType.TIMESTAMP);
                HashMap<PositionKey<Equity>, BigDecimal> map = new HashMap<PositionKey<Equity>, BigDecimal>();
                List list = query.getResultList();
                for (Object o : list) {
                    Object[] columns = (Object[])o;
                    if (columns.length <= 1) continue;
                    map.put((PositionKey<Equity>)PositionKeyFactory.createEquityKey((String)((String)columns[0]), (String)((String)columns[1]), columns[2] == null ? null : ((BigInteger)columns[2]).toString()), (BigDecimal)columns[3]);
                }
                return map;
            }
        }, null);
    }

    static BigDecimal getFuturePositionAsOf(final SimpleUser inUser, final Date inDate, final Future inFuture) throws PersistenceException {
        BigDecimal position = (BigDecimal)ExecutionReportSummary.executeRemote((Transaction)new Transaction<BigDecimal>(){
            private static final long serialVersionUID = 1L;

            public BigDecimal execute(EntityManager em, PersistContext context) {
                Query query = em.createNamedQuery("futPositionForSymbol");
                query.setParameter("viewerID", (Object)inUser.getUserID().getValue());
                query.setParameter("allViewers", (Object)inUser.isSuperuser());
                query.setParameter("sideBuy", (Object)Side.Buy.ordinal());
                query.setParameter("symbol", (Object)inFuture.getSymbol());
                query.setParameter("securityType", (Object)SecurityType.Future.ordinal());
                query.setParameter("sendingTime", inDate, TemporalType.TIMESTAMP);
                return (BigDecimal)query.getSingleResult();
            }
        }, null);
        return position == null ? BigDecimal.ZERO : position;
    }

    static Map<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(final SimpleUser inUser, final Date inDate) throws PersistenceException {
        return (Map)ExecutionReportSummary.executeRemote((Transaction)new Transaction<Map<PositionKey<Future>, BigDecimal>>(){
            private static final long serialVersionUID = 1L;

            public Map<PositionKey<Future>, BigDecimal> execute(EntityManager em, PersistContext context) {
                Query query = em.createNamedQuery("futAllPositions");
                query.setParameter("viewerID", (Object)inUser.getUserID().getValue());
                query.setParameter("allViewers", (Object)inUser.isSuperuser());
                query.setParameter("sideBuy", (Object)Side.Buy.ordinal());
                query.setParameter("securityType", (Object)SecurityType.Future.ordinal());
                query.setParameter("sendingTime", inDate, TemporalType.TIMESTAMP);
                HashMap<PositionKey<Future>, BigDecimal> map = new HashMap<PositionKey<Future>, BigDecimal>();
                List list = query.getResultList();
                for (Object o : list) {
                    Object[] columns = (Object[])o;
                    if (columns.length <= 1) continue;
                    map.put((PositionKey<Future>)PositionKeyFactory.createFutureKey((String)((String)columns[0]), (String)((String)columns[1]), (String)((String)columns[2]), columns[3] == null ? null : ((BigInteger)columns[3]).toString()), (BigDecimal)columns[4]);
                }
                return map;
            }
        }, null);
    }

    static BigDecimal getOptionPositionAsOf(final SimpleUser inUser, final Date inDate, final Option inOption) throws PersistenceException {
        BigDecimal position = (BigDecimal)ExecutionReportSummary.executeRemote((Transaction)new Transaction<BigDecimal>(){
            private static final long serialVersionUID = 1L;

            public BigDecimal execute(EntityManager em, PersistContext context) {
                Query query = em.createNamedQuery("optPositionForTuple");
                query.setParameter("viewerID", (Object)inUser.getUserID().getValue());
                query.setParameter("allViewers", (Object)inUser.isSuperuser());
                query.setParameter("sideBuy", (Object)Side.Buy.ordinal());
                query.setParameter("symbol", (Object)inOption.getSymbol());
                query.setParameter("securityType", (Object)SecurityType.Option.ordinal());
                query.setParameter("expiry", (Object)inOption.getExpiry());
                query.setParameter("strikePrice", (Object)inOption.getStrikePrice());
                query.setParameter("optionType", (Object)inOption.getType().ordinal());
                query.setParameter("sendingTime", inDate, TemporalType.TIMESTAMP);
                return (BigDecimal)query.getSingleResult();
            }
        }, null);
        return position == null ? BigDecimal.ZERO : position;
    }

    static Map<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(final SimpleUser inUser, final Date inDate) throws PersistenceException {
        return (Map)ExecutionReportSummary.executeRemote((Transaction)new Transaction<Map<PositionKey<Option>, BigDecimal>>(){
            private static final long serialVersionUID = 1L;

            public Map<PositionKey<Option>, BigDecimal> execute(EntityManager em, PersistContext context) {
                Query query = em.createNamedQuery("optAllPositions");
                query.setParameter("viewerID", (Object)inUser.getUserID().getValue());
                query.setParameter("allViewers", (Object)inUser.isSuperuser());
                query.setParameter("sideBuy", (Object)Side.Buy.ordinal());
                query.setParameter("securityType", (Object)SecurityType.Option.ordinal());
                query.setParameter("sendingTime", inDate, TemporalType.TIMESTAMP);
                HashMap<PositionKey<Option>, BigDecimal> map = new HashMap<PositionKey<Option>, BigDecimal>();
                List list = query.getResultList();
                for (Object o : list) {
                    Object[] columns = (Object[])o;
                    if (columns.length <= 1) continue;
                    map.put((PositionKey<Option>)PositionKeyFactory.createOptionKey((String)((String)columns[0]), (String)((String)columns[1]), (BigDecimal)((BigDecimal)columns[2]), (OptionType)OptionType.values()[(Integer)columns[3]], (String)((String)columns[4]), columns[5] == null ? null : ((BigInteger)columns[5]).toString()), (BigDecimal)columns[6]);
                }
                return map;
            }
        }, null);
    }

    static Map<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(final SimpleUser inUser, final Date inDate, final String ... inRootSymbols) throws PersistenceException {
        return (Map)ExecutionReportSummary.executeRemote((Transaction)new Transaction<Map<PositionKey<Option>, BigDecimal>>(){
            private static final long serialVersionUID = 1L;

            public Map<PositionKey<Option>, BigDecimal> execute(EntityManager em, PersistContext context) {
                Query query = em.createNamedQuery("optPositionsForRoots");
                query.setParameter("viewerID", (Object)inUser.getUserID().getValue());
                query.setParameter("allViewers", (Object)inUser.isSuperuser());
                query.setParameter("sideBuy", (Object)Side.Buy.ordinal());
                query.setParameter("securityType", (Object)SecurityType.Option.ordinal());
                query.setParameter("symbols", Arrays.asList(inRootSymbols));
                query.setParameter("sendingTime", inDate, TemporalType.TIMESTAMP);
                HashMap<PositionKey<Option>, BigDecimal> map = new HashMap<PositionKey<Option>, BigDecimal>();
                List list = query.getResultList();
                for (Object o : list) {
                    Object[] columns = (Object[])o;
                    if (columns.length <= 1) continue;
                    map.put((PositionKey<Option>)PositionKeyFactory.createOptionKey((String)((String)columns[0]), (String)((String)columns[1]), (BigDecimal)((BigDecimal)columns[2]), (OptionType)OptionType.values()[(Integer)columns[3]], (String)((String)columns[4]), columns[5] == null ? null : ((BigInteger)columns[5]).toString()), (BigDecimal)columns[6]);
                }
                return map;
            }
        }, null);
    }

    ExecutionReportSummary(ExecutionReport inReport, PersistentReport inSavedReport) {
        this.setReport(inSavedReport);
        this.mOrderID = inReport.getOrderID();
        this.mOrigOrderID = inReport.getOriginalOrderID();
        Instrument instrument = inReport.getInstrument();
        if (instrument != null) {
            this.mSecurityType = instrument.getSecurityType();
            this.mSymbol = instrument.getSymbol();
            InstrumentSummaryFields summaryFields = (InstrumentSummaryFields)InstrumentSummaryFields.SELECTOR.forInstrument(instrument);
            this.mOptionType = summaryFields.getOptionType(instrument);
            this.mStrikePrice = summaryFields.getStrikePrice(instrument);
            this.mExpiry = summaryFields.getExpiry(instrument);
        }
        this.mAccount = inReport.getAccount();
        this.mSide = inReport.getSide();
        this.mCumQuantity = inReport.getCumulativeQuantity();
        this.mAvgPrice = inReport.getAveragePrice();
        this.mLastQuantity = inReport.getLastQuantity();
        this.mLastPrice = inReport.getLastPrice();
        this.mOrderStatus = inReport.getOrderStatus();
        this.mSendingTime = inReport.getSendingTime();
        this.mViewer = inSavedReport.getViewer();
    }

    void localSave(EntityManager inManager, PersistContext inContext) throws PersistenceException {
        super.saveLocal(inManager, inContext);
    }

    protected void preSaveLocal(EntityManager em, PersistContext context) throws PersistenceException {
        super.preSaveLocal(em, context);
        Query query = em.createNamedQuery("rootIDForOrderID");
        SLF4JLoggerProxy.debug(ExecutionReportSummary.class, (String)"Searching for rootID for {}", (Object[])new Object[]{this.getOrderID()});
        if (this.getOrigOrderID() == null) {
            SLF4JLoggerProxy.debug(ExecutionReportSummary.class, (String)"No origOrderID present, using orderID for query");
            query.setParameter("orderID", (Object)this.getOrderID());
        } else {
            SLF4JLoggerProxy.debug(ExecutionReportSummary.class, (String)"Using origOrderID {} for query", (Object[])new Object[]{this.getOrigOrderID()});
            query.setParameter("orderID", (Object)this.getOrigOrderID());
        }
        List list = query.getResultList();
        if (list.isEmpty()) {
            SLF4JLoggerProxy.debug(ExecutionReportSummary.class, (String)"No other orders match this orderID - this must be the first in the order chain");
            this.setRootID(this.getOrderID());
        } else {
            OrderID rootID = (OrderID)list.get(0);
            SLF4JLoggerProxy.debug(ExecutionReportSummary.class, (String)"Using {} for rootID", (Object[])new Object[]{rootID});
            this.setRootID(rootID);
        }
    }

    @OneToOne(optional=false)
    PersistentReport getReport() {
        return this.mReport;
    }

    private void setReport(PersistentReport inReport) {
        this.mReport = inReport;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="rootID", nullable=false))})
    @Column(nullable=false)
    OrderID getRootID() {
        return this.mRootID;
    }

    private void setRootID(OrderID inRootID) {
        this.mRootID = inRootID;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="orderID", nullable=false))})
    OrderID getOrderID() {
        return this.mOrderID;
    }

    private void setOrderID(OrderID inOrderID) {
        this.mOrderID = inOrderID;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="origOrderID"))})
    OrderID getOrigOrderID() {
        return this.mOrigOrderID;
    }

    private void setOrigOrderID(OrderID inOrigOrderID) {
        this.mOrigOrderID = inOrigOrderID;
    }

    SecurityType getSecurityType() {
        return this.mSecurityType;
    }

    private void setSecurityType(SecurityType inSecurityType) {
        this.mSecurityType = inSecurityType;
    }

    @Column(nullable=false)
    String getSymbol() {
        return this.mSymbol;
    }

    private void setSymbol(String inSymbol) {
        this.mSymbol = inSymbol;
    }

    String getExpiry() {
        return this.mExpiry;
    }

    private void setExpiry(String inExpiry) {
        this.mExpiry = inExpiry;
    }

    @Column(precision=15, scale=5, nullable=true)
    BigDecimal getStrikePrice() {
        return this.mStrikePrice;
    }

    private void setStrikePrice(BigDecimal inStrikePrice) {
        this.mStrikePrice = inStrikePrice;
    }

    OptionType getOptionType() {
        return this.mOptionType;
    }

    private void setOptionType(OptionType inOptionType) {
        this.mOptionType = inOptionType;
    }

    String getAccount() {
        return this.mAccount;
    }

    private void setAccount(String inAccount) {
        this.mAccount = inAccount;
    }

    @Column(nullable=false)
    Side getSide() {
        return this.mSide;
    }

    private void setSide(Side inSide) {
        this.mSide = inSide;
    }

    @Column(precision=15, scale=5, nullable=false)
    BigDecimal getCumQuantity() {
        return this.mCumQuantity;
    }

    private void setCumQuantity(BigDecimal inCumQuantity) {
        this.mCumQuantity = inCumQuantity;
    }

    @Column(precision=15, scale=5, nullable=false)
    BigDecimal getAvgPrice() {
        return this.mAvgPrice;
    }

    private void setAvgPrice(BigDecimal inAvgPrice) {
        this.mAvgPrice = inAvgPrice;
    }

    @Column(precision=15, scale=5)
    BigDecimal getLastQuantity() {
        return this.mLastQuantity;
    }

    private void setLastQuantity(BigDecimal inLastQuantity) {
        this.mLastQuantity = inLastQuantity;
    }

    @Column(precision=15, scale=5)
    BigDecimal getLastPrice() {
        return this.mLastPrice;
    }

    private void setLastPrice(BigDecimal inLastPrice) {
        this.mLastPrice = inLastPrice;
    }

    @Column(nullable=false)
    OrderStatus getOrderStatus() {
        return this.mOrderStatus;
    }

    private void setOrderStatus(OrderStatus inOrderStatus) {
        this.mOrderStatus = inOrderStatus;
    }

    @Column(nullable=false)
    Date getSendingTime() {
        return this.mSendingTime;
    }

    private void setSendingTime(Date inSendingTime) {
        this.mSendingTime = inSendingTime;
    }

    @ManyToOne
    public SimpleUser getViewer() {
        return this.mViewer;
    }

    private void setViewer(SimpleUser inViewer) {
        this.mViewer = inViewer;
    }

    @Transient
    UserID getViewerID() {
        if (this.getViewer() == null) {
            return null;
        }
        return this.getViewer().getUserID();
    }

    ExecutionReportSummary() {
    }
}

