/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.Query;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.marketcetera.event.HasFIXMessage;
import org.marketcetera.ors.Principals;
import org.marketcetera.ors.history.ExecutionReportSummary;
import org.marketcetera.ors.history.Messages;
import org.marketcetera.ors.history.ReportPersistenceException;
import org.marketcetera.ors.history.ReportType;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.ors.security.SingleSimpleUserQuery;
import org.marketcetera.persist.EntityBase;
import org.marketcetera.persist.PersistContext;
import org.marketcetera.persist.PersistenceException;
import org.marketcetera.persist.Transaction;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.MessageCreationException;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.Originator;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.ReportBaseImpl;
import org.marketcetera.trade.ReportID;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;
import quickfix.InvalidMessage;
import quickfix.Message;

@ClassVersion(value="$Id: PersistentReport.java 16154 2012-07-14 16:34:05Z colin $")
@Entity
@Table(name="reports")
@NamedQuery(name="forOrderID", query="select e from PersistentReport e where e.orderID = :orderID")
class PersistentReport
extends EntityBase {
    static final String ATTRIBUTE_SENDING_TIME = "sendingTime";
    static final String ATTRIBUTE_ACTOR = "actor";
    static final String ATTRIBUTE_VIEWER = "viewer";
    static final String ENTITY_NAME = PersistentReport.class.getSimpleName();
    private Originator mOriginator;
    private OrderID mOrderID;
    private SimpleUser mActor;
    private SimpleUser mViewer;
    private BrokerID mBrokerID;
    private ReportID mReportID;
    private String mFixMessage;
    private Date mSendingTime;
    private ReportType mReportType;
    private ReportBase mReportBase;
    private static final long serialVersionUID = 1L;

    static void save(ReportBase inReport) throws PersistenceException {
        PersistentReport report = new PersistentReport(inReport);
        report.saveRemote(null);
    }

    static Principals getPrincipals(final OrderID orderID) throws PersistenceException {
        return (Principals)PersistentReport.executeRemote((Transaction)new Transaction<Principals>(){
            private static final long serialVersionUID = 1L;

            public Principals execute(EntityManager em, PersistContext context) {
                Query query = em.createNamedQuery("forOrderID");
                query.setParameter("orderID", (Object)orderID);
                List list = query.getResultList();
                if (list.isEmpty()) {
                    return Principals.UNKNOWN;
                }
                PersistentReport report = (PersistentReport)((Object)list.get(0));
                return new Principals(report.getActorID(), report.getViewerID());
            }
        }, null);
    }

    PersistentReport(ReportBase inReport) throws PersistenceException {
        this.mReportBase = inReport;
        this.setBrokerID(inReport.getBrokerID());
        this.setSendingTime(inReport.getSendingTime());
        if (inReport instanceof HasFIXMessage) {
            this.setFixMessage(((HasFIXMessage)inReport).getMessage().toString());
        }
        this.setOriginator(inReport.getOriginator());
        this.setOrderID(inReport.getOrderID());
        this.setReportID(inReport.getReportID());
        if (inReport.getActorID() != null) {
            this.setActor((SimpleUser)new SingleSimpleUserQuery(inReport.getActorID().getValue()).fetch());
        }
        if (inReport.getViewerID() != null) {
            this.setViewer((SimpleUser)new SingleSimpleUserQuery(inReport.getViewerID().getValue()).fetch());
        }
        if (inReport instanceof ExecutionReport) {
            this.mReportType = ReportType.ExecutionReport;
        } else if (inReport instanceof OrderCancelReject) {
            this.mReportType = ReportType.CancelReject;
        } else {
            throw new IllegalArgumentException();
        }
    }

    ReportBase toReport() throws ReportPersistenceException {
        ExecutionReport returnValue = null;
        String fixMsgString = null;
        try {
            fixMsgString = this.getFixMessage();
            Message fixMessage = new Message(fixMsgString);
            switch (this.mReportType) {
                case ExecutionReport: {
                    returnValue = Factory.getInstance().createExecutionReport(fixMessage, this.getBrokerID(), this.getOriginator(), this.getActorID(), this.getViewerID());
                    break;
                }
                case CancelReject: {
                    returnValue = Factory.getInstance().createOrderCancelReject(fixMessage, this.getBrokerID(), this.getOriginator(), this.getActorID(), this.getViewerID());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ReportBaseImpl.assignReportID((ReportBaseImpl)((ReportBaseImpl)returnValue), (ReportID)this.getReportID());
            return returnValue;
        }
        catch (InvalidMessage e) {
            throw new ReportPersistenceException(e, (I18NBoundMessage)new I18NBoundMessage1P(Messages.ERROR_RECONSTITUTE_FIX_MSG, (Serializable)((Object)fixMsgString)));
        }
        catch (MessageCreationException e) {
            throw new ReportPersistenceException(e, (I18NBoundMessage)new I18NBoundMessage1P(Messages.ERROR_RECONSTITUTE_FIX_MSG, (Serializable)((Object)fixMsgString)));
        }
    }

    protected void postSaveLocal(EntityManager em, EntityBase merged, PersistContext context) throws PersistenceException {
        super.postSaveLocal(em, merged, context);
        PersistentReport mergedReport = (PersistentReport)merged;
        if (mergedReport.getReportType() == ReportType.ExecutionReport) {
            new ExecutionReportSummary((ExecutionReport)this.mReportBase, mergedReport).localSave(em, context);
        }
    }

    private Originator getOriginator() {
        return this.mOriginator;
    }

    private void setOriginator(Originator inOriginator) {
        this.mOriginator = inOriginator;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="orderID", nullable=false))})
    OrderID getOrderID() {
        return this.mOrderID;
    }

    private void setOrderID(OrderID inOrderID) {
        this.mOrderID = inOrderID;
    }

    @ManyToOne
    public SimpleUser getActor() {
        return this.mActor;
    }

    private void setActor(SimpleUser inActor) {
        this.mActor = inActor;
    }

    @Transient
    UserID getActorID() {
        if (this.getActor() == null) {
            return null;
        }
        return this.getActor().getUserID();
    }

    @ManyToOne
    public SimpleUser getViewer() {
        return this.mViewer;
    }

    private void setViewer(SimpleUser inViewer) {
        this.mViewer = inViewer;
    }

    @Transient
    UserID getViewerID() {
        if (this.getViewer() == null) {
            return null;
        }
        return this.getViewer().getUserID();
    }

    @Transient
    BrokerID getBrokerID() {
        return this.mBrokerID;
    }

    private void setBrokerID(BrokerID inBrokerID) {
        this.mBrokerID = inBrokerID;
    }

    @Column(name="brokerID")
    private String getBrokerIDAsString() {
        return this.getBrokerID() == null ? null : this.getBrokerID().toString();
    }

    private void setBrokerIDAsString(String inValue) {
        this.setBrokerID(inValue == null ? null : new BrokerID(inValue));
    }

    @Transient
    ReportID getReportID() {
        return this.mReportID;
    }

    private void setReportID(ReportID inReportID) {
        this.mReportID = inReportID;
    }

    @Column(name="reportID", nullable=false)
    private long getReportIDAsLong() {
        return this.getReportID().longValue();
    }

    private void setReportIDAsLong(long inValue) {
        this.setReportID(new ReportID(inValue));
    }

    @Lob
    @Column(nullable=false)
    private String getFixMessage() {
        return this.mFixMessage;
    }

    private void setFixMessage(String inFIXMessage) {
        this.mFixMessage = inFIXMessage;
    }

    @Column(nullable=false)
    private Date getSendingTime() {
        return this.mSendingTime;
    }

    private void setSendingTime(Date inSendingTime) {
        this.mSendingTime = inSendingTime;
    }

    @Column(nullable=false)
    private ReportType getReportType() {
        return this.mReportType;
    }

    private void setReportType(ReportType inReportType) {
        this.mReportType = inReportType;
    }

    PersistentReport() {
    }
}

