/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.marketcetera.client.jms.JmsManager;
import org.marketcetera.core.IDFactory;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.ors.Principals;
import org.marketcetera.ors.history.ReportPersistenceException;
import org.marketcetera.ors.history.ReportSavedListener;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.persist.PersistenceException;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.ReportBaseImpl;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: ReportHistoryServices.java 16154 2012-07-14 16:34:05Z colin $")
public interface ReportHistoryServices {
    public void init(IDFactory var1, JmsManager var2, ReportSavedListener var3) throws ReportPersistenceException;

    public ReportBaseImpl[] getReportsSince(SimpleUser var1, Date var2) throws PersistenceException, ReportPersistenceException;

    public BigDecimal getEquityPositionAsOf(SimpleUser var1, Date var2, Equity var3) throws PersistenceException;

    public Map<PositionKey<Equity>, BigDecimal> getAllEquityPositionsAsOf(SimpleUser var1, Date var2) throws PersistenceException;

    public BigDecimal getOptionPositionAsOf(SimpleUser var1, Date var2, Option var3) throws PersistenceException;

    public Map<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(SimpleUser var1, Date var2) throws PersistenceException;

    public BigDecimal getFuturePositionAsOf(SimpleUser var1, Date var2, Future var3) throws PersistenceException;

    public Map<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(SimpleUser var1, Date var2) throws PersistenceException;

    public Map<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(SimpleUser var1, Date var2, String ... var3) throws PersistenceException;

    public void save(ReportBase var1) throws PersistenceException;

    public Principals getPrincipals(OrderID var1) throws PersistenceException;
}

