/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.info;

import java.util.concurrent.atomic.AtomicInteger;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: NameGenerator.java 16154 2012-07-14 16:34:05Z colin $")
public class NameGenerator {
    public static final String INT_SEPARATOR = "_";
    private static final String INT_FORMAT = "%010d";
    private final String mPrefix;
    private final AtomicInteger mNextInt;

    public NameGenerator(String prefix) {
        this.mPrefix = prefix;
        this.mNextInt = new AtomicInteger(1);
    }

    private String getPrefix() {
        return this.mPrefix;
    }

    private AtomicInteger getNextInt() {
        return this.mNextInt;
    }

    public String getNextName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getPrefix());
        builder.append(INT_SEPARATOR);
        builder.append(String.format(INT_FORMAT, this.getNextInt().getAndIncrement()));
        return builder.toString();
    }
}

