/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.info;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.ors.info.InfoException;
import org.marketcetera.ors.info.InfoRuntimeException;
import org.marketcetera.ors.info.Messages;
import org.marketcetera.ors.info.ReadInfo;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage3P;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: ReadInfoImpl.java 16154 2012-07-14 16:34:05Z colin $")
class ReadInfoImpl
implements ReadInfo {
    static final Object NULL_VALUE = new Object();
    static final String TO_STRING_SEPARATOR = ":";
    private final String mName;
    private final Map<String, Object> mMap;

    ReadInfoImpl(String name) {
        this.mName = name;
        this.mMap = new ConcurrentHashMap<String, Object>();
    }

    static void assertNonNullKey(String key) {
        if (key == null) {
            throw new InfoRuntimeException((I18NBoundMessage)Messages.NULL_KEY);
        }
    }

    Map<String, Object> getMap() {
        return this.mMap;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    @Override
    public boolean contains(String key) {
        ReadInfoImpl.assertNonNullKey(key);
        boolean result = this.getMap().containsKey(key);
        if (SLF4JLoggerProxy.isDebugEnabled((Object)this)) {
            SLF4JLoggerProxy.debug((Object)this, (String)"Store '{}': key '{}' is {}.", (Object[])new Object[]{this.getPath(), key, result ? "present" : "absent"});
        }
        return result;
    }

    @Override
    public Object getValue(String key) {
        ReadInfoImpl.assertNonNullKey(key);
        Object value = this.getMap().get(key);
        if (value == NULL_VALUE) {
            value = null;
        }
        if (SLF4JLoggerProxy.isDebugEnabled((Object)this)) {
            SLF4JLoggerProxy.debug((Object)this, (String)"Store '{}': got key '{}' with value '{}'.", (Object[])new Object[]{this.getPath(), key, value});
        }
        return value;
    }

    @Override
    public Object getValueIfSet(String key) throws InfoException {
        ReadInfoImpl.assertNonNullKey(key);
        if (!this.contains(key)) {
            throw new InfoException((I18NBoundMessage)new I18NBoundMessage1P(Messages.MISSING_VALUE, (Serializable)((Object)key)));
        }
        return this.getValue(key);
    }

    @Override
    public Object getValueIfNonNull(String key) throws InfoException {
        ReadInfoImpl.assertNonNullKey(key);
        Object result = this.getValueIfSet(key);
        if (result == null) {
            throw new InfoException((I18NBoundMessage)new I18NBoundMessage1P(Messages.NULL_VALUE, (Serializable)((Object)key)));
        }
        return result;
    }

    @Override
    public <T> T getValueIfInstanceOf(String key, Class<T> cls) throws InfoException {
        ReadInfoImpl.assertNonNullKey(key);
        Object result = this.getValueIfSet(key);
        if (result != null && !cls.isInstance(result)) {
            throw new InfoException((I18NBoundMessage)new I18NBoundMessage3P(Messages.BAD_CLASS_VALUE, (Serializable)((Object)key), (Serializable)((Object)ObjectUtils.toString((Object)result)), cls));
        }
        return (T)result;
    }

    @Override
    public <T> T getValueIfNonNullInstanceOf(String key, Class<T> cls) throws InfoException {
        ReadInfoImpl.assertNonNullKey(key);
        Object result = this.getValueIfSet(key);
        if (result == null) {
            throw new InfoException((I18NBoundMessage)new I18NBoundMessage1P(Messages.NULL_VALUE, (Serializable)((Object)key)));
        }
        if (!cls.isInstance(result)) {
            throw new InfoException((I18NBoundMessage)new I18NBoundMessage3P(Messages.BAD_CLASS_VALUE, (Serializable)((Object)key), (Serializable)((Object)ObjectUtils.toString((Object)result)), cls));
        }
        return (T)result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getPath());
        builder.append(TO_STRING_SEPARATOR);
        builder.append(this.getMap().toString());
        return builder.toString();
    }
}

