/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.info;

import java.io.Serializable;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.ors.info.InfoException;
import org.marketcetera.ors.info.Messages;
import org.marketcetera.ors.info.ReadInfoImpl;
import org.marketcetera.ors.info.ReadWriteInfo;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage3P;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: ReadWriteInfoImpl.java 16154 2012-07-14 16:34:05Z colin $")
class ReadWriteInfoImpl
extends ReadInfoImpl
implements ReadWriteInfo {
    ReadWriteInfoImpl(String name) {
        super(name);
    }

    @Override
    public void setValue(String key, Object value) {
        ReadWriteInfoImpl.assertNonNullKey(key);
        if (value == null) {
            value = NULL_VALUE;
        }
        this.getMap().put(key, value);
        if (SLF4JLoggerProxy.isDebugEnabled((Object)this)) {
            SLF4JLoggerProxy.debug((Object)this, (String)"Store '{}': set key '{}' to value '{}'.", (Object[])new Object[]{this.getPath(), key, value});
        }
    }

    @Override
    public void setValueIfUnset(String key, Object value) throws InfoException {
        ReadWriteInfoImpl.assertNonNullKey(key);
        if (this.contains(key)) {
            throw new InfoException((I18NBoundMessage)new I18NBoundMessage3P(Messages.VALUE_EXISTS, (Serializable)((Object)key), (Serializable)((Object)ObjectUtils.toString((Object)this.getValue(key))), (Serializable)((Object)ObjectUtils.toString((Object)value))));
        }
        this.setValue(key, value);
    }

    @Override
    public void removeValue(String key) {
        ReadWriteInfoImpl.assertNonNullKey(key);
        this.getMap().remove(key);
        if (SLF4JLoggerProxy.isDebugEnabled((Object)this)) {
            SLF4JLoggerProxy.debug((Object)this, (String)"Store '{}': removed key '{}'.", (Object[])new Object[]{this.getPath(), key});
        }
    }

    @Override
    public void removeValueIfSet(String key) throws InfoException {
        ReadWriteInfoImpl.assertNonNullKey(key);
        if (!this.contains(key)) {
            throw new InfoException((I18NBoundMessage)new I18NBoundMessage1P(Messages.MISSING_VALUE, (Serializable)((Object)key)));
        }
        this.removeValue(key);
    }
}

