/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.mbeans;

import org.marketcetera.core.ClassVersion;
import org.marketcetera.core.IDFactory;
import org.marketcetera.core.NoMoreIDsException;
import org.marketcetera.ors.UserManager;
import org.marketcetera.ors.brokers.Broker;
import org.marketcetera.ors.brokers.Brokers;
import org.marketcetera.ors.mbeans.Messages;
import org.marketcetera.ors.mbeans.ORSAdminMBean;
import org.marketcetera.quickfix.IQuickFIXSender;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import quickfix.IntField;
import quickfix.Message;
import quickfix.SessionID;
import quickfix.SessionNotFound;
import quickfix.StringField;
import quickfix.field.MsgType;
import quickfix.field.NewPassword;
import quickfix.field.Password;
import quickfix.field.UserRequestID;
import quickfix.field.UserRequestType;
import quickfix.field.Username;

@ClassVersion(value="$Id: ORSAdmin.java 16154 2012-07-14 16:34:05Z colin $")
public class ORSAdmin
implements ORSAdminMBean {
    private Brokers brokers;
    protected IQuickFIXSender quickFIXSender;
    private IDFactory idFactory;
    private UserManager userManager;

    public ORSAdmin(Brokers brokers, IQuickFIXSender qfSender, IDFactory idFactory, UserManager userManager) throws NoMoreIDsException, ClassNotFoundException {
        this.brokers = brokers;
        this.quickFIXSender = qfSender;
        this.idFactory = idFactory;
        this.userManager = userManager;
    }

    @Override
    public void sendPasswordReset(String broker, String oldPassword, String newPassword) {
        Broker b = this.brokers.getBroker(new BrokerID(broker));
        SLF4JLoggerProxy.debug((Object)this, (String)"Trade session halted, resetting password");
        SessionID session = b.getSessionID();
        Message msg = b.getFIXMessageFactory().createMessage("BE");
        if (!msg.getHeader().isSetField(35)) {
            msg.getHeader().setField((StringField)new MsgType("BE"));
        }
        msg.setField((StringField)new UserRequestID(this.getNextID()));
        msg.setField((IntField)new UserRequestType(3));
        msg.setField((StringField)new Username(session.getSenderCompID()));
        msg.setField((StringField)new Password(oldPassword));
        msg.setField((StringField)new NewPassword(newPassword));
        try {
            this.quickFIXSender.sendToTarget(msg, session);
        }
        catch (SessionNotFound sessionNotFound) {
            sessionNotFound.printStackTrace();
        }
    }

    @Override
    public void syncSessions() {
        this.userManager.sync();
    }

    private String getNextID() {
        try {
            return this.idFactory.getNext();
        }
        catch (NoMoreIDsException ex) {
            Messages.ERROR_GENERATING_EXEC_ID.error((Object)this, (Object)ex.getMessage());
            return "ZZ-INTERNAL";
        }
    }
}

