/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.security;

import java.io.Console;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.PropertyConfigurator;
import org.marketcetera.core.ApplicationBase;
import org.marketcetera.ors.security.Messages;
import org.marketcetera.ors.security.MultiSimpleUserQuery;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.ors.security.SingleSimpleUserQuery;
import org.marketcetera.persist.PersistenceException;
import org.marketcetera.persist.StringFilter;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NMessage1P;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@ClassVersion(value="$Id: ORSAdminCLI.java 16154 2012-07-14 16:34:05Z colin $")
public class ORSAdminCLI
extends ApplicationBase {
    private AbstractApplicationContext context;
    private PrintStream out;
    private PrintStream err;
    private static final String CMD_LIST_USERS = "listUsers";
    private static final String CMD_ADD_USER = "addUser";
    private static final String CMD_DELETE_USER = "deleteUser";
    private static final String CMD_RESTORE_USER = "restoreUser";
    private static final String CMD_CHANGE_PASS = "changePassword";
    private static final String CMD_CHANGE_SUPERUSER = "changeSuperuser";
    private static final String OPT_CURRENT_USER = "u";
    private static final String OPT_CURRENT_PASSWORD = "p";
    private static final String OPT_OPERATED_USER = "n";
    private static final String OPT_OPERATED_PASSWORD = "w";
    private static final String OPT_OPERATED_SUPERUSER = "s";
    private static final String OPT_OPERATED_ACTIVE = "a";
    private static final String ADMIN_USER_NAME = "admin";
    private static final String OPT_YES = "y";
    private static final String OPT_NO = "n";
    static final String CMD_NAME = "orsadmin";

    public ORSAdminCLI(PrintStream out, PrintStream err) {
        PropertyConfigurator.configureAndWatch((String)(CONF_DIR + "log4j" + File.separator + "cli.properties"), (long)20000L);
        this.out = out;
        this.err = err;
        this.context = new ClassPathXmlApplicationContext(this.getConfigurations());
        this.context.registerShutdownHook();
    }

    public static void main(String[] args) {
        ORSAdminCLI cli = new ORSAdminCLI(System.out, System.err);
        try {
            cli.parseAndRun(args);
            System.exit(0);
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    public void close() {
        this.context.close();
    }

    public void parseAndRun(String ... args) throws Exception {
        try {
            this.execute(new GnuParser().parse(ORSAdminCLI.options(), args));
        }
        catch (Exception e) {
            this.printError(e.getLocalizedMessage());
            this.printUsage();
            throw e;
        }
    }

    protected String[] getConfigurations() {
        return new String[]{"file:" + CONF_DIR + "cli.xml"};
    }

    protected char[] readPasswordFromConsole(String message) {
        Console console = System.console();
        if (console == null) {
            return null;
        }
        return console.readPassword(message, new Object[0]);
    }

    private void execute(CommandLine commandLine) throws I18NException {
        String userName = commandLine.getOptionValue(OPT_CURRENT_USER);
        String password = commandLine.getOptionValue(OPT_CURRENT_PASSWORD);
        String opUser = commandLine.getOptionValue("n");
        String opPass = commandLine.getOptionValue(OPT_OPERATED_PASSWORD);
        Boolean opSuperuser = null;
        if (commandLine.hasOption(OPT_OPERATED_SUPERUSER)) {
            opSuperuser = commandLine.getOptionValue(OPT_OPERATED_SUPERUSER).trim().equals(OPT_YES);
        }
        Boolean opActive = null;
        if (commandLine.hasOption(OPT_OPERATED_ACTIVE)) {
            opActive = commandLine.getOptionValue(OPT_OPERATED_ACTIVE).trim().equals(OPT_YES);
        }
        if (commandLine.hasOption(CMD_ADD_USER)) {
            if (!commandLine.hasOption("n")) {
                throw new I18NException((I18NBoundMessage)new I18NBoundMessage1P(Messages.CLI_ERR_OPTION_MISSING, (Serializable)((Object)"n")));
            }
            if (!commandLine.hasOption(OPT_OPERATED_PASSWORD)) {
                opPass = this.getOptionFromConsole(opUser, opPass, OPT_OPERATED_PASSWORD, Messages.CLI_PROMPT_PASSWORD);
            }
            this.authorize(Authorization.ADD_USER, userName, password);
            this.addUser(opUser, opPass, opSuperuser);
        } else if (commandLine.hasOption(CMD_DELETE_USER)) {
            if (!commandLine.hasOption("n")) {
                throw new I18NException((I18NBoundMessage)new I18NBoundMessage1P(Messages.CLI_ERR_OPTION_MISSING, (Serializable)((Object)"n")));
            }
            this.authorize(Authorization.DELETE_USER, userName, password);
            this.deleteUser(opUser);
        } else if (commandLine.hasOption(CMD_RESTORE_USER)) {
            if (!commandLine.hasOption("n")) {
                throw new I18NException((I18NBoundMessage)new I18NBoundMessage1P(Messages.CLI_ERR_OPTION_MISSING, (Serializable)((Object)"n")));
            }
            this.authorize(Authorization.RESTORE_USER, userName, password);
            this.restoreUser(opUser);
        } else if (commandLine.hasOption(CMD_LIST_USERS)) {
            this.authorize(Authorization.LIST_USERS, userName, password);
            this.listUsers(opUser, opActive);
        } else if (commandLine.hasOption(CMD_CHANGE_PASS)) {
            if (!commandLine.hasOption(OPT_CURRENT_PASSWORD)) {
                password = this.getOptionFromConsole(userName, password, OPT_CURRENT_PASSWORD, Messages.CLI_PROMPT_PASSWORD);
            }
            if (!commandLine.hasOption(OPT_OPERATED_PASSWORD)) {
                String curUser = opUser == null ? userName : opUser;
                opPass = this.getOptionFromConsole(curUser, opPass, OPT_OPERATED_PASSWORD, Messages.CLI_PROMPT_NEW_PASSWORD);
            }
            if (commandLine.hasOption("n") && !userName.equals(opUser)) {
                this.authorize(Authorization.CHANGE_PASSWORD, userName, password);
            }
            this.changePassword(userName, opUser, password, opPass);
        } else if (commandLine.hasOption(CMD_CHANGE_SUPERUSER)) {
            if (!commandLine.hasOption("n")) {
                throw new I18NException((I18NBoundMessage)new I18NBoundMessage1P(Messages.CLI_ERR_OPTION_MISSING, (Serializable)((Object)"n")));
            }
            if (opSuperuser == null) {
                throw new I18NException((I18NBoundMessage)new I18NBoundMessage1P(Messages.CLI_ERR_OPTION_MISSING, (Serializable)((Object)OPT_OPERATED_SUPERUSER)));
            }
            this.authorize(Authorization.CHANGE_SUPERUSER, userName, password);
            this.changeSuperuser(opUser, opSuperuser);
        } else {
            throw new IllegalStateException();
        }
    }

    private void authorize(Authorization auth, String userName, String password) throws I18NException {
        password = this.getOptionFromConsole(userName, password, OPT_CURRENT_PASSWORD, Messages.CLI_PROMPT_PASSWORD);
        auth.authorize(userName, password);
    }

    private String getOptionFromConsole(String userName, String password, String optName, I18NMessage1P prompt) throws I18NException {
        if (password == null) {
            char[] p = this.readPasswordFromConsole(prompt.getText((Object)userName));
            if (p == null) {
                throw new I18NException((I18NBoundMessage)new I18NBoundMessage1P(Messages.CLI_ERR_OPTION_MISSING, (Serializable)((Object)optName)));
            }
            password = new String(p);
            Arrays.fill(p, '0');
        }
        return password;
    }

    private SimpleUser fetchUser(String user) throws I18NException {
        SimpleUser u = (SimpleUser)new SingleSimpleUserQuery(user).fetch();
        if (!u.isActive()) {
            throw new I18NException((I18NBoundMessage)Messages.CLI_ERR_INACTIVE_USER);
        }
        return u;
    }

    private void changePassword(String userName, String opUser, String password, String opPass) throws I18NException {
        SimpleUser u = null;
        if (opUser != null && !opUser.equals(userName)) {
            u = this.fetchUser(opUser);
            String name = u.getName();
            u.setName(null);
            u.setName(name);
            u.setPassword(opPass.toCharArray());
        } else {
            u = this.fetchUser(userName);
            u.changePassword(password.toCharArray(), opPass.toCharArray());
        }
        u.save();
        this.out.println(Messages.CLI_OUT_USER_CHG_PASS.getText((Object)u.getName()));
    }

    private void listUsers(String nameFilter, Boolean active) throws PersistenceException {
        MultiSimpleUserQuery q = MultiSimpleUserQuery.all();
        q.setActiveFilter(active);
        q.setEntityOrder(MultiSimpleUserQuery.BY_NAME);
        if (nameFilter != null) {
            q.setNameFilter(new StringFilter(nameFilter));
        }
        List<SimpleUser> l = q.fetch();
        for (SimpleUser u : l) {
            StringBuilder flags = new StringBuilder();
            if (u.isSuperuser()) {
                flags.append(OPT_OPERATED_SUPERUSER);
            }
            if (active == null && u.isActive()) {
                flags.append(OPT_OPERATED_ACTIVE);
            }
            this.out.print(u.getName());
            if (flags.length() > 0) {
                this.out.print(" [");
                this.out.print(flags.toString());
                this.out.print(']');
            }
            this.out.println();
        }
    }

    private void deleteUser(String opUser) throws I18NException {
        if (ADMIN_USER_NAME.equals(opUser)) {
            throw new I18NException((I18NBoundMessage)new I18NBoundMessage1P(Messages.CLI_ERR_UNAUTH_DELETE, (Serializable)((Object)opUser)));
        }
        SimpleUser u = (SimpleUser)new SingleSimpleUserQuery(opUser).fetch();
        u.setActive(false);
        u.save();
        this.out.println(Messages.CLI_OUT_USER_DELETED.getText((Object)u.getName()));
    }

    private void restoreUser(String opUser) throws I18NException {
        if (ADMIN_USER_NAME.equals(opUser)) {
            throw new I18NException((I18NBoundMessage)new I18NBoundMessage1P(Messages.CLI_ERR_UNAUTH_RESTORE, (Serializable)((Object)opUser)));
        }
        SimpleUser u = (SimpleUser)new SingleSimpleUserQuery(opUser).fetch();
        u.setActive(true);
        u.save();
        this.out.println(Messages.CLI_OUT_USER_RESTORED.getText((Object)u.getName()));
    }

    private void changeSuperuser(String opUser, Boolean superuser) throws I18NException {
        if (ADMIN_USER_NAME.equals(opUser)) {
            throw new I18NException((I18NBoundMessage)new I18NBoundMessage1P(Messages.CLI_ERR_UNAUTH_CHANGE_SUPERUSER, (Serializable)((Object)opUser)));
        }
        SimpleUser u = this.fetchUser(opUser);
        u.setSuperuser(superuser);
        u.save();
        this.out.println(Messages.CLI_OUT_USER_CHG_SUPERUSER.getText((Object)u.getName()));
    }

    private void addUser(String opUser, String opPass, Boolean superuser) throws PersistenceException {
        SimpleUser u = new SimpleUser();
        u.setName(opUser);
        u.setPassword(opPass.toCharArray());
        if (superuser != null) {
            u.setSuperuser(superuser);
        }
        u.save();
        this.out.println(Messages.CLI_OUT_USER_CREATED.getText((Object)u.getName()));
    }

    private static Options options() {
        Options opts = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)Messages.CLI_ARG_LOGIN_VALUE.getText());
        OptionBuilder.withDescription((String)Messages.CLI_PARM_USER.getText());
        OptionBuilder.isRequired((boolean)true);
        opts.addOption(OptionBuilder.create((String)OPT_CURRENT_USER));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)Messages.CLI_ARG_LOGIN_PASSWORD_VALUE.getText());
        OptionBuilder.withDescription((String)Messages.CLI_PARM_PASSWORD.getText());
        OptionBuilder.isRequired((boolean)false);
        opts.addOption(OptionBuilder.create((String)OPT_CURRENT_PASSWORD));
        OptionGroup commands = new OptionGroup();
        commands.setRequired(true);
        OptionBuilder.withLongOpt((String)CMD_LIST_USERS);
        OptionBuilder.withDescription((String)Messages.CLI_CMD_LIST_USERS.getText());
        OptionBuilder.isRequired();
        commands.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_ADD_USER);
        OptionBuilder.withDescription((String)Messages.CLI_CMD_ADD_USER.getText());
        OptionBuilder.isRequired();
        commands.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_DELETE_USER);
        OptionBuilder.withDescription((String)Messages.CLI_CMD_DELETE_USER.getText());
        OptionBuilder.isRequired();
        commands.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_RESTORE_USER);
        OptionBuilder.withDescription((String)Messages.CLI_CMD_RESTORE_USER.getText());
        OptionBuilder.isRequired();
        commands.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_CHANGE_PASS);
        OptionBuilder.withDescription((String)Messages.CLI_CMD_CHANGE_PASSWORD.getText());
        OptionBuilder.isRequired();
        commands.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_CHANGE_SUPERUSER);
        OptionBuilder.withDescription((String)Messages.CLI_CMD_CHANGE_SUPERUSER.getText());
        OptionBuilder.isRequired();
        commands.addOption(OptionBuilder.create());
        opts.addOptionGroup(commands);
        OptionBuilder.withLongOpt((String)"username");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)Messages.CLI_ARG_USER_NAME_VALUE.getText());
        OptionBuilder.withDescription((String)Messages.CLI_PARM_OP_USER.getText());
        OptionBuilder.isRequired((boolean)false);
        opts.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)Messages.CLI_ARG_USER_PASSWORD_VALUE.getText());
        OptionBuilder.withDescription((String)Messages.CLI_PARM_OP_PASSWORD.getText());
        OptionBuilder.isRequired((boolean)false);
        opts.addOption(OptionBuilder.create((String)OPT_OPERATED_PASSWORD));
        OptionBuilder.withLongOpt((String)"superuser");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)Messages.CLI_ARG_USER_SUPERUSER_VALUE.getText());
        OptionBuilder.withDescription((String)Messages.CLI_PARM_OP_SUPERUSER.getText());
        OptionBuilder.isRequired((boolean)false);
        opts.addOption(OptionBuilder.create((String)OPT_OPERATED_SUPERUSER));
        OptionBuilder.withLongOpt((String)"active");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)Messages.CLI_ARG_USER_ACTIVE_VALUE.getText());
        OptionBuilder.withDescription((String)Messages.CLI_PARM_OP_ACTIVE.getText());
        OptionBuilder.isRequired((boolean)false);
        opts.addOption(OptionBuilder.create((String)OPT_OPERATED_ACTIVE));
        return opts;
    }

    private void printError(String msg) {
        this.err.println(msg);
    }

    private void printUsage() {
        HelpFormatter h = new HelpFormatter();
        int width = 100;
        int leftPad = 4;
        int descPad = 4;
        String LS = SystemUtils.LINE_SEPARATOR;
        String l = "-u <" + Messages.CLI_ARG_LOGIN_VALUE.getText() + "> ";
        String p = "-p <" + Messages.CLI_ARG_LOGIN_PASSWORD_VALUE.getText() + "> ";
        String u = "-n <" + Messages.CLI_ARG_USER_NAME_VALUE.getText() + "> ";
        String up = "-w <" + Messages.CLI_ARG_USER_PASSWORD_VALUE.getText() + "> ";
        String us = "-s y|n";
        String ua = "-a y|n";
        String prefix = "orsadmin " + l + p;
        String s = prefix + "--" + CMD_LIST_USERS + " [" + "-a y|n" + "] " + LS + prefix + "--" + CMD_ADD_USER + " " + u + " " + up + " [" + "-s y|n" + "] " + LS + prefix + "--" + CMD_DELETE_USER + " " + u + LS + prefix + "--" + CMD_RESTORE_USER + " " + u + LS + prefix + "--" + CMD_CHANGE_PASS + " " + up + " [" + u + "]" + LS + prefix + "--" + CMD_CHANGE_SUPERUSER + " " + u + " " + "-s y|n" + LS;
        PrintWriter writer = new PrintWriter(this.err);
        h.printHelp(writer, 100, s, Messages.CLI_DESC_OPTIONS_HEADER.getText(), ORSAdminCLI.options(), 4, 4, "", false);
        writer.flush();
    }

    private static enum Authorization {
        ADD_USER,
        DELETE_USER,
        RESTORE_USER,
        CHANGE_PASSWORD,
        CHANGE_SUPERUSER,
        LIST_USERS{

            @Override
            public void authorize(String userName, String password) throws I18NException {
                Authorization.validateUser(userName, password);
            }
        };


        public void authorize(String userName, String password) throws I18NException {
            Authorization.validateUser(userName, password);
            if (!userName.toLowerCase().equals(ORSAdminCLI.ADMIN_USER_NAME)) {
                throw new I18NException((I18NBoundMessage)Messages.CLI_UNAUTHORIZED_ACTION);
            }
        }

        private static void validateUser(String userName, String password) throws I18NException {
            SimpleUser u;
            try {
                u = (SimpleUser)new SingleSimpleUserQuery(userName).fetch();
                u.validatePassword(password.toCharArray());
            }
            catch (PersistenceException e) {
                throw new I18NException((I18NBoundMessage)Messages.CLI_ERR_INVALID_LOGIN);
            }
            if (!u.isActive()) {
                throw new I18NException((I18NBoundMessage)Messages.CLI_ERR_INVALID_LOGIN);
            }
        }
    }
}

