/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.security;

import com.sun.security.auth.UserPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.ors.security.Messages;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.ors.security.SingleSimpleUserQuery;
import org.marketcetera.persist.NoResultException;
import org.marketcetera.persist.PersistenceException;
import org.marketcetera.util.log.SLF4JLoggerProxy;

@ClassVersion(value="$Id: ORSLoginModule.java 16154 2012-07-14 16:34:05Z colin $")
public class ORSLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callback;
    private Set<Principal> principals = new HashSet<Principal>();
    private String username;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callback = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback(Messages.PROMPT_USERNAME.getText()), new PasswordCallback(Messages.PROMPT_PASSWORD.getText(), false)};
        try {
            this.callback.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            FailedLoginException ex = new FailedLoginException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            FailedLoginException ex = new FailedLoginException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        this.username = ((NameCallback)callbacks[0]).getName();
        if (this.username == null || this.username.trim().length() == 0) {
            throw new AccountNotFoundException(Messages.EMPTY_USERNAME.getText());
        }
        char[] password = ((PasswordCallback)callbacks[1]).getPassword();
        try {
            SimpleUser u = (SimpleUser)new SingleSimpleUserQuery(this.username).fetch();
            if (!u.isActive()) {
                Messages.USER_LOGIN_ERROR_LOG.warn((Object)this, (Object)this.username);
                throw new AccountNotFoundException(Messages.USER_LOGIN_ERROR.getText());
            }
            u.validatePassword(password);
        }
        catch (NoResultException e) {
            Messages.USER_LOGIN_ERROR_LOG.warn((Object)this, (Throwable)e, (Object)this.username);
            throw new AccountNotFoundException(Messages.USER_LOGIN_ERROR.getText());
        }
        catch (PersistenceException e) {
            Messages.USER_LOGIN_ERROR_LOG.warn((Object)this, (Throwable)e, (Object)this.username);
            throw new FailedLoginException(Messages.USER_LOGIN_ERROR.getText());
        }
        SLF4JLoggerProxy.debug((Object)this, (String)"login done for user {}", (Object[])new Object[]{this.username});
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.principals.add(new UserPrincipal(this.username));
        this.subject.getPrincipals().addAll(this.principals);
        Messages.USER_LOGIN_LOG.info((Object)this, (Object)this.username);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        SLF4JLoggerProxy.debug((Object)this, (String)"Aborting login for user {}", (Object[])new Object[]{this.username});
        this.clear();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        Messages.USER_LOGOUT_LOG.info((Object)this, (Object)this.username);
        this.clear();
        return true;
    }

    private void clear() {
        this.username = null;
    }
}

