/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.security;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.ors.security.Messages;
import org.marketcetera.persist.NDEntityBase;
import org.marketcetera.persist.PersistenceException;
import org.marketcetera.persist.ValidationException;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NMessage0P;

@ClassVersion(value="$Id: SimpleUser.java 16154 2012-07-14 16:34:05Z colin $")
@Entity
@Table(name="ors_users", uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
@AttributeOverride(name="name", column=@Column(nullable=false))
public class SimpleUser
extends NDEntityBase {
    private static final long serialVersionUID = -244334398553751199L;
    private boolean superuser = false;
    private boolean active = true;
    private String userData;
    private String systemData;
    private String hashedPassword = null;
    private static ThreadLocal<MessageDigest> digest = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e);
            }
        }
    };
    static final String ATTRIBUTE_ACTIVE = "active";
    static final String ENTITY_NAME = "SimpleUser";

    @Column(nullable=false)
    public boolean isSuperuser() {
        return this.superuser;
    }

    public void setSuperuser(boolean superuser) {
        this.superuser = superuser;
    }

    @Column(nullable=false)
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Column(nullable=true, columnDefinition="text")
    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String inUserData) {
        this.userData = inUserData;
    }

    @Column(nullable=true, columnDefinition="text")
    public String getSystemData() {
        return this.systemData;
    }

    public void setSystemData(String inSystemData) {
        this.systemData = inSystemData;
    }

    @Transient
    public UserID getUserID() {
        return new UserID(this.getId());
    }

    @Transient
    public boolean isPasswordSet() {
        return this.getHashedPassword() != null;
    }

    public void setName(String name) {
        if (name == null || !name.equals(this.getName())) {
            super.setName(name);
            this.setHashedPassword(null);
        }
    }

    public void setPassword(char[] password) throws ValidationException {
        if (this.getName() == null) {
            throw new ValidationException((I18NBoundMessage)org.marketcetera.persist.Messages.UNSPECIFIED_NAME_ATTRIBUTE);
        }
        if (this.isPasswordSet()) {
            throw new ValidationException((I18NBoundMessage)new I18NBoundMessage1P(Messages.CANNOT_SET_PASSWORD, (Serializable)((Object)this.getName())));
        }
        this.validateAndSetPassword(password);
    }

    public void changePassword(char[] originalPassword, char[] newPassword) throws ValidationException {
        this.validatePassword(originalPassword);
        this.validateAndSetPassword(newPassword);
    }

    public void validatePassword(char[] password) throws ValidationException {
        if (this.getHashedPassword() == null || this.getHashedPassword().length() == 0) {
            return;
        }
        SimpleUser.validatePasswordValue(password);
        if (!this.getHashedPassword().equals(SimpleUser.hash(this.getName().toCharArray(), password))) {
            throw new ValidationException((I18NBoundMessage)Messages.INVALID_PASSWORD);
        }
    }

    public void validate() throws PersistenceException {
        super.validate();
        if (this.getHashedPassword() == null || this.getHashedPassword().length() == 0) {
            throw new ValidationException((I18NBoundMessage)Messages.EMPTY_PASSWORD);
        }
    }

    public void save() throws PersistenceException {
        this.saveRemote(null);
    }

    public void delete() throws PersistenceException {
        this.deleteRemote(null);
    }

    private void validateAndSetPassword(char[] password) throws ValidationException {
        SimpleUser.validatePasswordValue(password);
        this.setHashedPassword(SimpleUser.hash(this.getName().toCharArray(), password));
    }

    @Column(nullable=false)
    private String getHashedPassword() {
        return this.hashedPassword;
    }

    private void setHashedPassword(String hashedPassword) {
        this.hashedPassword = hashedPassword;
    }

    private static void validatePasswordValue(char[] password) throws ValidationException {
        if (password == null || password.length == 0) {
            throw new ValidationException((I18NBoundMessage)Messages.EMPTY_PASSWORD);
        }
    }

    private static I18NMessage0P getUserFriendlyName() {
        return Messages.SIMPLE_USER_NAME;
    }

    private static String hash(char[] ... value) {
        try {
            MessageDigest dig = digest.get();
            for (char[] c : value) {
                dig.update(new String(c).getBytes("UTF-16"));
            }
            return new BigInteger(dig.digest()).toString(36);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

