/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.ws;

import org.marketcetera.ors.info.SessionInfo;
import org.marketcetera.ors.info.SessionInfoImpl;
import org.marketcetera.ors.info.SystemInfo;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.ors.ws.Messages;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.tags.SessionId;
import org.springframework.jms.core.JmsOperations;

@ClassVersion(value="$Id: ClientSession.java 16154 2012-07-14 16:34:05Z colin $")
public class ClientSession {
    private final SessionId mSessionId;
    private final SimpleUser mUser;
    private final JmsOperations mReplyTopic;
    private final SessionInfo mSessionInfo;

    public ClientSession(SystemInfo systemInfo, SessionId sessionId, SimpleUser user, JmsOperations replyTopic) {
        this.mSessionId = sessionId;
        this.mUser = user;
        this.mReplyTopic = replyTopic;
        this.mSessionInfo = new SessionInfoImpl(systemInfo);
        this.getSessionInfo().setValue("SESSION_ID", this.getSessionId());
        this.getSessionInfo().setValue("ACTOR", (Object)this.getUser());
        this.getSessionInfo().setValue("ACTOR_ID", this.getUser().getUserID());
    }

    public SessionId getSessionId() {
        return this.mSessionId;
    }

    public SimpleUser getUser() {
        return this.mUser;
    }

    public JmsOperations getReplyTopic() {
        return this.mReplyTopic;
    }

    public SessionInfo getSessionInfo() {
        return this.mSessionInfo;
    }

    public String toString() {
        return Messages.CLIENT_SESSION_STRING.getText((Object)this.getSessionId(), (Object)this.getUser().getUserID());
    }
}

