/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.ws;

import java.io.Serializable;
import javax.xml.bind.JAXBException;
import org.marketcetera.client.jms.JmsManager;
import org.marketcetera.client.jms.JmsUtils;
import org.marketcetera.ors.UserManager;
import org.marketcetera.ors.info.SystemInfo;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.ors.security.SingleSimpleUserQuery;
import org.marketcetera.ors.ws.ClientSession;
import org.marketcetera.ors.ws.Messages;
import org.marketcetera.persist.PersistenceException;
import org.marketcetera.util.except.I18NRuntimeException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.SessionFactory;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.tags.SessionId;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;

@ClassVersion(value="$Id: ClientSessionFactory.java 16154 2012-07-14 16:34:05Z colin $")
public class ClientSessionFactory
implements SessionFactory<ClientSession> {
    private final SystemInfo mSystemInfo;
    private final JmsManager mJmsManager;
    private final UserManager mUserManager;

    public ClientSessionFactory(SystemInfo systemInfo, JmsManager jmsManager, UserManager userManager) {
        this.mSystemInfo = systemInfo;
        this.mJmsManager = jmsManager;
        this.mUserManager = userManager;
    }

    public SystemInfo getSystemInfo() {
        return this.mSystemInfo;
    }

    private JmsManager getJmsManager() {
        return this.mJmsManager;
    }

    private UserManager getUserManager() {
        return this.mUserManager;
    }

    public ClientSession createSession(StatelessClientContext context, String user, SessionId id) {
        SimpleUser dbUser;
        JmsTemplate jmsOps;
        String topicName = JmsUtils.getReplyTopicName((SessionId)id);
        try {
            jmsOps = this.getJmsManager().getOutgoingJmsFactory().createJmsTemplateX(topicName, true);
        }
        catch (JAXBException ex) {
            throw new I18NRuntimeException((Throwable)ex, (I18NBoundMessage)new I18NBoundMessage1P(Messages.CANNOT_CREATE_REPLY_TOPIC, (Serializable)((Object)topicName)));
        }
        try {
            dbUser = (SimpleUser)new SingleSimpleUserQuery(user).fetch();
        }
        catch (PersistenceException ex) {
            throw new I18NRuntimeException((Throwable)ex, (I18NBoundMessage)new I18NBoundMessage1P(Messages.CANNOT_RETRIEVE_USER, (Serializable)((Object)user)));
        }
        ClientSession session = new ClientSession(this.getSystemInfo(), id, dbUser, (JmsOperations)jmsOps);
        this.getUserManager().addSession(session);
        return session;
    }

    public void removedSession(ClientSession session) {
        this.getUserManager().removedSession(session);
    }
}

