/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.ws;

import java.io.Serializable;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.client.IncompatibleComponentsException;
import org.marketcetera.core.ApplicationVersion;
import org.marketcetera.core.Util;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.ors.security.SingleSimpleUserQuery;
import org.marketcetera.ors.ws.Messages;
import org.marketcetera.persist.NoResultException;
import org.marketcetera.persist.PersistenceException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.I18NBoundMessage3P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.Authenticator;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.tags.AppId;

@ClassVersion(value="$Id: DBAuthenticator.java 16154 2012-07-14 16:34:05Z colin $")
public class DBAuthenticator
implements Authenticator {
    static boolean compatibleVersions(String clientVersion, String serverVersion) {
        return "No Version".equals(serverVersion) || ObjectUtils.equals((Object)clientVersion, (Object)serverVersion);
    }

    static boolean compatibleApp(String clientName) {
        return "Client".equals(clientName);
    }

    public boolean shouldAllow(StatelessClientContext context, String user, char[] password) throws IncompatibleComponentsException {
        String serverVersion = ApplicationVersion.getVersion();
        String clientName = Util.getName((AppId)context.getAppId());
        String clientVersion = Util.getVersion((AppId)context.getAppId());
        if (!DBAuthenticator.compatibleApp(clientName)) {
            throw new IncompatibleComponentsException((I18NBoundMessage)new I18NBoundMessage2P(Messages.APP_MISMATCH, (Serializable)((Object)clientName), (Serializable)((Object)user)), serverVersion);
        }
        if (!DBAuthenticator.compatibleVersions(clientVersion, serverVersion)) {
            throw new IncompatibleComponentsException((I18NBoundMessage)new I18NBoundMessage3P(Messages.VERSION_MISMATCH, (Serializable)((Object)clientVersion), (Serializable)((Object)serverVersion), (Serializable)((Object)user)), serverVersion);
        }
        try {
            SimpleUser u = (SimpleUser)new SingleSimpleUserQuery(user).fetch();
            if (!u.isActive()) {
                Messages.BAD_CREDENTIALS.warn((Object)this, (Object)user);
                return false;
            }
            u.validatePassword(password);
        }
        catch (NoResultException ex) {
            Messages.BAD_CREDENTIALS.warn((Object)this, (Throwable)ex, (Object)user);
            return false;
        }
        catch (PersistenceException ex) {
            Messages.BAD_CREDENTIALS.warn((Object)this, (Throwable)ex, (Object)user);
            return false;
        }
        return true;
    }
}

