/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.ws;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.marketcetera.client.Service;
import org.marketcetera.client.brokers.BrokersStatus;
import org.marketcetera.client.users.UserInfo;
import org.marketcetera.core.CoreException;
import org.marketcetera.core.IDFactory;
import org.marketcetera.core.Util;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.ors.OptionRootUnderlyingMap;
import org.marketcetera.ors.brokers.Brokers;
import org.marketcetera.ors.history.ReportHistoryServices;
import org.marketcetera.ors.history.ReportPersistenceException;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.ors.security.SingleSimpleUserQuery;
import org.marketcetera.ors.ws.ClientSession;
import org.marketcetera.persist.PersistenceException;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.ReportBaseImpl;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.ClientContext;
import org.marketcetera.util.ws.stateful.RemoteCaller;
import org.marketcetera.util.ws.stateful.RemoteRunner;
import org.marketcetera.util.ws.stateful.ServiceBaseImpl;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.wrappers.DateWrapper;
import org.marketcetera.util.ws.wrappers.MapWrapper;
import org.marketcetera.util.ws.wrappers.RemoteException;

@ClassVersion(value="$Id: ServiceImpl.java 16154 2012-07-14 16:34:05Z colin $")
public class ServiceImpl
extends ServiceBaseImpl<ClientSession>
implements Service {
    private final Brokers mBrokers;
    private final IDFactory mIDFactory;
    private final ReportHistoryServices mHistoryServices;

    public ServiceImpl(SessionManager<ClientSession> sessionManager, Brokers brokers, IDFactory idFactory, ReportHistoryServices historyServices) {
        super(sessionManager);
        this.mBrokers = brokers;
        this.mIDFactory = idFactory;
        this.mHistoryServices = historyServices;
    }

    private Brokers getBrokers() {
        return this.mBrokers;
    }

    public IDFactory getIDFactory() {
        return this.mIDFactory;
    }

    public ReportHistoryServices getHistoryServices() {
        return this.mHistoryServices;
    }

    private BrokersStatus getBrokersStatusImpl() {
        return this.getBrokers().getStatus();
    }

    private UserInfo getUserInfoImpl(UserID id) throws PersistenceException {
        SimpleUser u = (SimpleUser)new SingleSimpleUserQuery(id.getValue()).fetch();
        return new UserInfo(u.getName(), u.getUserID(), u.isActive(), u.isSuperuser(), Util.propertiesFromString((String)u.getUserData()), Util.propertiesFromString((String)u.getSystemData()));
    }

    private ReportBaseImpl[] getReportsSinceImpl(ClientSession session, Date date) throws ReportPersistenceException, PersistenceException {
        return this.getHistoryServices().getReportsSince(session.getUser(), date);
    }

    private BigDecimal getEquityPositionAsOfImpl(ClientSession session, Date date, Equity equity) throws PersistenceException {
        return this.getHistoryServices().getEquityPositionAsOf(session.getUser(), date, equity);
    }

    private MapWrapper<PositionKey<Equity>, BigDecimal> getAllEquityPositionsAsOfImpl(ClientSession session, Date date) throws PersistenceException {
        return new MapWrapper(this.getHistoryServices().getAllEquityPositionsAsOf(session.getUser(), date));
    }

    private BigDecimal getFuturePositionAsOfImpl(ClientSession inSession, Date inDate, Future inFuture) throws PersistenceException {
        return this.getHistoryServices().getFuturePositionAsOf(inSession.getUser(), inDate, inFuture);
    }

    private MapWrapper<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOfImpl(ClientSession inSession, Date inDate) throws PersistenceException {
        return new MapWrapper(this.getHistoryServices().getAllFuturePositionsAsOf(inSession.getUser(), inDate));
    }

    private BigDecimal getOptionPositionAsOfImpl(ClientSession session, Date date, Option inOption) throws PersistenceException {
        return this.getHistoryServices().getOptionPositionAsOf(session.getUser(), date, inOption);
    }

    private MapWrapper<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOfImpl(ClientSession session, Date date) throws PersistenceException {
        return new MapWrapper(this.getHistoryServices().getAllOptionPositionsAsOf(session.getUser(), date));
    }

    private MapWrapper<PositionKey<Option>, BigDecimal> getOptionPositionsAsOfImpl(ClientSession session, Date date, String ... symbols) throws PersistenceException {
        return new MapWrapper(this.getHistoryServices().getOptionPositionsAsOf(session.getUser(), date, symbols));
    }

    private String getNextOrderIDImpl() throws CoreException {
        return this.getIDFactory().getNext();
    }

    private String getUnderlyingImpl(String inOptionRoot) {
        OptionRootUnderlyingMap map = OptionRootUnderlyingMap.getInstance();
        return map == null ? null : map.getUnderlying(inOptionRoot);
    }

    private Collection<String> getOptionRootsImpl(String inUnderlying) {
        OptionRootUnderlyingMap map = OptionRootUnderlyingMap.getInstance();
        return map == null ? null : map.getOptionRoots(inUnderlying);
    }

    private String getUserDataImpl(String inUsername) throws PersistenceException {
        return ((SimpleUser)new SingleSimpleUserQuery(inUsername).fetch()).getUserData();
    }

    private void setUserDataImpl(String inUsername, String inUserData) throws PersistenceException {
        SimpleUser user = (SimpleUser)new SingleSimpleUserQuery(inUsername).fetch();
        user.setUserData(inUserData);
        user.save();
    }

    public BrokersStatus getBrokersStatus(ClientContext context) throws RemoteException {
        return (BrokersStatus)new RemoteCaller<ClientSession, BrokersStatus>(this.getSessionManager()){

            protected BrokersStatus call(ClientContext context, SessionHolder<ClientSession> sessionHolder) {
                return ServiceImpl.this.getBrokersStatusImpl();
            }
        }.execute(context);
    }

    public UserInfo getUserInfo(ClientContext context, final UserID id) throws RemoteException {
        return (UserInfo)new RemoteCaller<ClientSession, UserInfo>(this.getSessionManager()){

            protected UserInfo call(ClientContext context, SessionHolder<ClientSession> sessionHolder) throws PersistenceException {
                return ServiceImpl.this.getUserInfoImpl(id);
            }
        }.execute(context);
    }

    public ReportBaseImpl[] getReportsSince(ClientContext context, final DateWrapper date) throws RemoteException {
        return (ReportBaseImpl[])new RemoteCaller<ClientSession, ReportBaseImpl[]>(this.getSessionManager()){

            protected ReportBaseImpl[] call(ClientContext context, SessionHolder<ClientSession> sessionHolder) throws ReportPersistenceException, PersistenceException {
                return ServiceImpl.this.getReportsSinceImpl((ClientSession)sessionHolder.getSession(), (Date)date.getRaw());
            }
        }.execute(context);
    }

    public BigDecimal getEquityPositionAsOf(ClientContext context, final DateWrapper date, final Equity equity) throws RemoteException {
        return (BigDecimal)new RemoteCaller<ClientSession, BigDecimal>(this.getSessionManager()){

            protected BigDecimal call(ClientContext context, SessionHolder<ClientSession> sessionHolder) throws PersistenceException {
                return ServiceImpl.this.getEquityPositionAsOfImpl((ClientSession)sessionHolder.getSession(), (Date)date.getRaw(), equity);
            }
        }.execute(context);
    }

    public MapWrapper<PositionKey<Equity>, BigDecimal> getAllEquityPositionsAsOf(ClientContext context, final DateWrapper date) throws RemoteException {
        return (MapWrapper)new RemoteCaller<ClientSession, MapWrapper<PositionKey<Equity>, BigDecimal>>(this.getSessionManager()){

            protected MapWrapper<PositionKey<Equity>, BigDecimal> call(ClientContext context, SessionHolder<ClientSession> sessionHolder) throws PersistenceException {
                return ServiceImpl.this.getAllEquityPositionsAsOfImpl((ClientSession)sessionHolder.getSession(), (Date)date.getRaw());
            }
        }.execute(context);
    }

    public MapWrapper<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(ClientContext inContext, final DateWrapper inDate) throws RemoteException {
        return (MapWrapper)new RemoteCaller<ClientSession, MapWrapper<PositionKey<Future>, BigDecimal>>(this.getSessionManager()){

            protected MapWrapper<PositionKey<Future>, BigDecimal> call(ClientContext context, SessionHolder<ClientSession> sessionHolder) throws PersistenceException {
                return ServiceImpl.this.getAllFuturePositionsAsOfImpl((ClientSession)sessionHolder.getSession(), (Date)inDate.getRaw());
            }
        }.execute(inContext);
    }

    public BigDecimal getFuturePositionAsOf(ClientContext inContext, final DateWrapper inDate, final Future inFuture) throws RemoteException {
        return (BigDecimal)new RemoteCaller<ClientSession, BigDecimal>(this.getSessionManager()){

            protected BigDecimal call(ClientContext context, SessionHolder<ClientSession> sessionHolder) throws PersistenceException {
                return ServiceImpl.this.getFuturePositionAsOfImpl((ClientSession)sessionHolder.getSession(), (Date)inDate.getRaw(), inFuture);
            }
        }.execute(inContext);
    }

    public BigDecimal getOptionPositionAsOf(ClientContext context, final DateWrapper date, final Option inOption) throws RemoteException {
        return (BigDecimal)new RemoteCaller<ClientSession, BigDecimal>(this.getSessionManager()){

            protected BigDecimal call(ClientContext context, SessionHolder<ClientSession> sessionHolder) throws PersistenceException {
                return ServiceImpl.this.getOptionPositionAsOfImpl((ClientSession)sessionHolder.getSession(), (Date)date.getRaw(), inOption);
            }
        }.execute(context);
    }

    public MapWrapper<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(ClientContext context, final DateWrapper date) throws RemoteException {
        return (MapWrapper)new RemoteCaller<ClientSession, MapWrapper<PositionKey<Option>, BigDecimal>>(this.getSessionManager()){

            protected MapWrapper<PositionKey<Option>, BigDecimal> call(ClientContext context, SessionHolder<ClientSession> sessionHolder) throws PersistenceException {
                return ServiceImpl.this.getAllOptionPositionsAsOfImpl((ClientSession)sessionHolder.getSession(), (Date)date.getRaw());
            }
        }.execute(context);
    }

    public MapWrapper<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(ClientContext context, final DateWrapper date, final String ... rootSymbols) throws RemoteException {
        return (MapWrapper)new RemoteCaller<ClientSession, MapWrapper<PositionKey<Option>, BigDecimal>>(this.getSessionManager()){

            protected MapWrapper<PositionKey<Option>, BigDecimal> call(ClientContext context, SessionHolder<ClientSession> sessionHolder) throws PersistenceException {
                return ServiceImpl.this.getOptionPositionsAsOfImpl((ClientSession)sessionHolder.getSession(), (Date)date.getRaw(), rootSymbols);
            }
        }.execute(context);
    }

    public String getNextOrderID(ClientContext context) throws RemoteException {
        return (String)new RemoteCaller<ClientSession, String>(this.getSessionManager()){

            protected String call(ClientContext context, SessionHolder<ClientSession> sessionHolder) throws CoreException {
                return ServiceImpl.this.getNextOrderIDImpl();
            }
        }.execute(context);
    }

    public String getUnderlying(ClientContext context, final String optionRoot) throws RemoteException {
        return (String)new RemoteCaller<ClientSession, String>(this.getSessionManager()){

            protected String call(ClientContext context, SessionHolder<ClientSession> sessionHolder) throws CoreException {
                return ServiceImpl.this.getUnderlyingImpl(optionRoot);
            }
        }.execute(context);
    }

    public Collection<String> getOptionRoots(ClientContext context, final String underlying) throws RemoteException {
        return (Collection)new RemoteCaller<ClientSession, Collection<String>>(this.getSessionManager()){

            protected Collection<String> call(ClientContext context, SessionHolder<ClientSession> sessionHolder) throws CoreException {
                return ServiceImpl.this.getOptionRootsImpl(underlying);
            }
        }.execute(context);
    }

    public void heartbeat(ClientContext context) throws RemoteException {
        new RemoteRunner<ClientSession>(this.getSessionManager()){

            protected void run(ClientContext context, SessionHolder<ClientSession> sessionHolder) {
                SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Received heartbeat for: {}", (Object[])new Object[]{context.getSessionId()});
            }
        }.execute(context);
    }

    public String getUserData(final ClientContext inContext) throws RemoteException {
        String userData = (String)new RemoteCaller<ClientSession, String>(this.getSessionManager()){

            protected String call(ClientContext context, SessionHolder<ClientSession> sessionHolder) throws CoreException, PersistenceException {
                return ServiceImpl.this.getUserDataImpl(((ClientSession)this.getSessionManager().get(inContext.getSessionId()).getSession()).getUser().getName());
            }
        }.execute(inContext);
        return userData;
    }

    public void setUserData(final ClientContext inContext, final String inData) throws RemoteException {
        new RemoteRunner<ClientSession>(this.getSessionManager()){

            protected void run(ClientContext context, SessionHolder<ClientSession> sessionHolder) throws PersistenceException {
                ServiceImpl.this.setUserDataImpl(((ClientSession)this.getSessionManager().get(inContext.getSessionId()).getSession()).getUser().getName(), inData);
            }
        }.execute(inContext);
    }
}

