/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.scene.control.Label;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@EnableAutoConfiguration
@Scope(value="prototype")
public class ClockUpdater {
    @Value(value="${metc.workspace.footer.clock.format:dd-MMM-YYYY kk:mm:ss}")
    private String clockFormat;
    private Timer timer;
    private final Label target;

    public ClockUpdater(Label inTarget) {
        this.target = inTarget;
    }

    @PostConstruct
    public void start() {
        final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)this.clockFormat);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Platform.runLater(() -> ClockUpdater.this.target.setText(formatter.print(System.currentTimeMillis())));
            }
        }, new Date(), 1000L);
    }

    @PreDestroy
    public void stop() {
        this.timer.cancel();
    }
}

