/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui;

import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Rectangle;

public class DragResizeMod {
    private static final OnDragResizeEventListener defaultListener = new OnDragResizeEventListener(){

        @Override
        public void onDrag(Node node, double x, double y, double h, double w) {
            this.setNodeSize(node, x, y, h, w);
        }

        @Override
        public void onResize(Node node, double x, double y, double h, double w) {
            this.setNodeSize(node, x, y, h, w);
        }

        private void setNodeSize(Node node, double x, double y, double h, double w) {
            node.setLayoutX(x);
            node.setLayoutY(y);
            if (node instanceof Canvas) {
                ((Canvas)node).setWidth(w);
                ((Canvas)node).setHeight(h);
            } else if (node instanceof Rectangle) {
                ((Rectangle)node).setWidth(w);
                ((Rectangle)node).setHeight(h);
            }
        }
    };
    private double clickX;
    private double clickY;
    private double nodeX;
    private double nodeY;
    private double nodeH;
    private double nodeW;
    private S state = S.DEFAULT;
    private Node node;
    private OnDragResizeEventListener listener = defaultListener;
    private static final int MARGIN = 8;
    private static final double MIN_W = 30.0;
    private static final double MIN_H = 20.0;

    private DragResizeMod(Node node, OnDragResizeEventListener listener) {
        this.node = node;
        if (listener != null) {
            this.listener = listener;
        }
    }

    public static void makeResizable(Node node) {
        DragResizeMod.makeResizable(node, null);
    }

    public static void makeResizable(Node node, OnDragResizeEventListener listener) {
        final DragResizeMod resizer = new DragResizeMod(node, listener);
        node.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                resizer.mousePressed(event);
            }
        });
        node.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                resizer.mouseDragged(event);
            }
        });
        node.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                resizer.mouseOver(event);
            }
        });
        node.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                resizer.mouseReleased(event);
            }
        });
    }

    protected void mouseReleased(MouseEvent event) {
        this.node.setCursor(Cursor.DEFAULT);
        this.state = S.DEFAULT;
    }

    protected void mouseOver(MouseEvent event) {
        S state = this.currentMouseState(event);
        Cursor cursor = DragResizeMod.getCursorForState(state);
        this.node.setCursor(cursor);
    }

    private S currentMouseState(MouseEvent event) {
        S state = S.DEFAULT;
        boolean left = this.isLeftResizeZone(event);
        boolean right = this.isRightResizeZone(event);
        boolean top = this.isTopResizeZone(event);
        boolean bottom = this.isBottomResizeZone(event);
        if (left && top) {
            state = S.NW_RESIZE;
        } else if (left && bottom) {
            state = S.SW_RESIZE;
        } else if (right && top) {
            state = S.NE_RESIZE;
        } else if (right && bottom) {
            state = S.SE_RESIZE;
        } else if (right) {
            state = S.E_RESIZE;
        } else if (left) {
            state = S.W_RESIZE;
        } else if (top) {
            state = S.N_RESIZE;
        } else if (bottom) {
            state = S.S_RESIZE;
        } else if (this.isInDragZone(event)) {
            state = S.DRAG;
        }
        return state;
    }

    private static Cursor getCursorForState(S state) {
        switch (state) {
            case NW_RESIZE: {
                return Cursor.NW_RESIZE;
            }
            case SW_RESIZE: {
                return Cursor.SW_RESIZE;
            }
            case NE_RESIZE: {
                return Cursor.NE_RESIZE;
            }
            case SE_RESIZE: {
                return Cursor.SE_RESIZE;
            }
            case E_RESIZE: {
                return Cursor.E_RESIZE;
            }
            case W_RESIZE: {
                return Cursor.W_RESIZE;
            }
            case N_RESIZE: {
                return Cursor.N_RESIZE;
            }
            case S_RESIZE: {
                return Cursor.S_RESIZE;
            }
        }
        return Cursor.DEFAULT;
    }

    protected void mouseDragged(MouseEvent event) {
        if (this.listener != null) {
            double mouseX = this.parentX(event.getX());
            double mouseY = this.parentY(event.getY());
            if (this.state == S.DRAG) {
                this.listener.onDrag(this.node, mouseX - this.clickX, mouseY - this.clickY, this.nodeH, this.nodeW);
            } else if (this.state != S.DEFAULT) {
                double newX = this.nodeX;
                double newY = this.nodeY;
                double newH = this.nodeH;
                double newW = this.nodeW;
                if (this.state == S.E_RESIZE || this.state == S.NE_RESIZE || this.state == S.SE_RESIZE) {
                    newW = mouseX - this.nodeX;
                }
                if (this.state == S.W_RESIZE || this.state == S.NW_RESIZE || this.state == S.SW_RESIZE) {
                    newX = mouseX;
                    newW = this.nodeW + this.nodeX - newX;
                }
                if (this.state == S.S_RESIZE || this.state == S.SE_RESIZE || this.state == S.SW_RESIZE) {
                    newH = mouseY - this.nodeY;
                }
                if (this.state == S.N_RESIZE || this.state == S.NW_RESIZE || this.state == S.NE_RESIZE) {
                    newY = mouseY;
                    newH = this.nodeH + this.nodeY - newY;
                }
                if (newW < 30.0) {
                    if (this.state == S.W_RESIZE || this.state == S.NW_RESIZE || this.state == S.SW_RESIZE) {
                        newX = newX - 30.0 + newW;
                    }
                    newW = 30.0;
                }
                if (newH < 20.0) {
                    if (this.state == S.N_RESIZE || this.state == S.NW_RESIZE || this.state == S.NE_RESIZE) {
                        newY = newY + newH - 20.0;
                    }
                    newH = 20.0;
                }
                this.listener.onResize(this.node, newX, newY, newH, newW);
            }
        }
    }

    protected void mousePressed(MouseEvent event) {
        if (this.isInResizeZone(event)) {
            this.setNewInitialEventCoordinates(event);
            this.state = this.currentMouseState(event);
        } else if (this.isInDragZone(event)) {
            this.setNewInitialEventCoordinates(event);
            this.state = S.DRAG;
        } else {
            this.state = S.DEFAULT;
        }
    }

    private void setNewInitialEventCoordinates(MouseEvent event) {
        this.nodeX = this.nodeX();
        this.nodeY = this.nodeY();
        this.nodeH = this.nodeH();
        this.nodeW = this.nodeW();
        this.clickX = event.getX();
        this.clickY = event.getY();
    }

    private boolean isInResizeZone(MouseEvent event) {
        return this.isLeftResizeZone(event) || this.isRightResizeZone(event) || this.isBottomResizeZone(event) || this.isTopResizeZone(event);
    }

    private boolean isInDragZone(MouseEvent event) {
        double xPos = this.parentX(event.getX());
        double yPos = this.parentY(event.getY());
        double nodeX = this.nodeX() + 8.0;
        double nodeY = this.nodeY() + 8.0;
        double nodeX0 = this.nodeX() + this.nodeW() - 8.0;
        double nodeY0 = this.nodeY() + this.nodeH() - 8.0;
        return xPos > nodeX && xPos < nodeX0 && yPos > nodeY && yPos < nodeY0;
    }

    private boolean isLeftResizeZone(MouseEvent event) {
        return this.intersect(0.0, event.getX());
    }

    private boolean isRightResizeZone(MouseEvent event) {
        return this.intersect(this.nodeW(), event.getX());
    }

    private boolean isTopResizeZone(MouseEvent event) {
        return this.intersect(0.0, event.getY());
    }

    private boolean isBottomResizeZone(MouseEvent event) {
        return this.intersect(this.nodeH(), event.getY());
    }

    private boolean intersect(double side, double point) {
        return side + 8.0 > point && side - 8.0 < point;
    }

    private double parentX(double localX) {
        return this.nodeX() + localX;
    }

    private double parentY(double localY) {
        return this.nodeY() + localY;
    }

    private double nodeX() {
        return this.node.getBoundsInParent().getMinX();
    }

    private double nodeY() {
        return this.node.getBoundsInParent().getMinY();
    }

    private double nodeW() {
        return this.node.getBoundsInParent().getWidth();
    }

    private double nodeH() {
        return this.node.getBoundsInParent().getHeight();
    }

    public static enum S {
        DEFAULT,
        DRAG,
        NW_RESIZE,
        SW_RESIZE,
        NE_RESIZE,
        SE_RESIZE,
        E_RESIZE,
        W_RESIZE,
        N_RESIZE,
        S_RESIZE;

    }

    public static interface OnDragResizeEventListener {
        public void onDrag(Node var1, double var2, double var4, double var6, double var8);

        public void onResize(Node var1, double var2, double var4, double var6, double var8);
    }
}

