/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui;

import com.google.common.eventbus.Subscribe;
import java.awt.Image;
import java.awt.Taskbar;
import java.awt.Toolkit;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.ToolBar;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.marketcetera.ui.ClientStatusUpdater;
import org.marketcetera.ui.ClockUpdater;
import org.marketcetera.ui.LoginView;
import org.marketcetera.ui.PhotonServices;
import org.marketcetera.ui.events.LoginEvent;
import org.marketcetera.ui.events.LogoutEvent;
import org.marketcetera.ui.service.PhotonNotificationService;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.ui.service.StyleService;
import org.marketcetera.ui.service.UiMessageService;
import org.marketcetera.ui.view.ApplicationMenu;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class PhotonApp
extends Application {
    private ImageView clientStatusImageView;
    private ClientStatusUpdater clientStatusUpdater;
    private static Stage primaryStage;
    private static Scene scene;
    private boolean isShuttingDown = false;
    private StyleService styleService;
    private UiMessageService uiMessageService;
    private VBox menuLayout;
    private ApplicationContext applicationContext;
    private VBox root;
    private HBox footer;
    private Label clockLabel;
    private Label userLabel;
    private static Pane workspace;
    private ToolBar statusToolBar;
    private ToolBar footerToolBar;
    private PhotonNotificationService notificationService;
    private static PhotonApp instance;

    public static void main(String[] args) {
        PhotonApp.launch((String[])new String[0]);
    }

    public void init() throws Exception {
        instance = this;
        super.init();
        this.applicationContext = new AnnotationConfigApplicationContext(new String[]{"org.marketcetera", "com.marketcetera"});
        this.uiMessageService = (UiMessageService)this.applicationContext.getBean(UiMessageService.class);
        this.styleService = (StyleService)this.applicationContext.getBean(StyleService.class);
        this.uiMessageService.register((Object)this);
    }

    public void start(Stage inPrimaryStage) throws Exception {
        Taskbar taskbar;
        SLF4JLoggerProxy.info((Object)((Object)this), (String)"Starting main stage");
        primaryStage = inPrimaryStage;
        this.root = new VBox();
        this.menuLayout = new VBox();
        workspace = new Pane();
        workspace.setId(((Object)((Object)this)).getClass().getCanonicalName() + ".workspace");
        workspace.setPrefWidth(1024.0);
        workspace.setPrefHeight(768.0);
        this.initializeFooter();
        Separator separator = new Separator(Orientation.HORIZONTAL);
        this.root.getChildren().addAll((Object[])new Node[]{this.menuLayout, workspace, separator, this.footer});
        scene = new Scene((Parent)this.root);
        inPrimaryStage.setScene(scene);
        inPrimaryStage.setTitle("Marketcetera Automated Trading Platform");
        inPrimaryStage.getIcons().addAll((Object[])new javafx.scene.image.Image[]{new javafx.scene.image.Image("/images/photon-16x16.png"), new javafx.scene.image.Image("/images/photon-24x24.png"), new javafx.scene.image.Image("/images/photon-32x32.png"), new javafx.scene.image.Image("/images/photon-48x48.png"), new javafx.scene.image.Image("/images/photon-48x48.png"), new javafx.scene.image.Image("/images/photon-64x64.png"), new javafx.scene.image.Image("/images/photon-128x128.png")});
        if (Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_IMAGE)) {
            Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
            Image dockIcon = defaultToolkit.getImage(((Object)((Object)this)).getClass().getResource("/images/photon-128x128.png"));
            taskbar.setIconImage(dockIcon);
        }
        inPrimaryStage.setOnCloseRequest(closeEvent -> this.doAppShutdown());
        VBox.setVgrow((Node)this.menuLayout, (Priority)Priority.NEVER);
        VBox.setVgrow((Node)workspace, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.footer, (Priority)Priority.NEVER);
        this.styleService.addStyleToAll(new Node[]{this.menuLayout, workspace, separator, this.footer, this.root});
        PhotonServices.style(scene);
        inPrimaryStage.show();
        this.doLogin();
    }

    public void doAppShutdown() {
        this.isShuttingDown = true;
        this.uiMessageService.post(new LogoutEvent());
        try {
            ((ConfigurableApplicationContext)this.applicationContext).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Platform.exit();
        System.exit(0);
    }

    @Subscribe
    public void onLogon(LoginEvent inEvent) {
        Platform.runLater(() -> this.userLabel.setText(inEvent.getSessionUser().getUsername()));
        this.notificationService = (PhotonNotificationService)this.applicationContext.getBean(PhotonNotificationService.class);
        this.clientStatusUpdater = (ClientStatusUpdater)this.applicationContext.getBean(ClientStatusUpdater.class, new Object[]{this.clientStatusImageView});
    }

    @Subscribe
    public void onLogout(LogoutEvent inEvent) {
        if (this.notificationService != null) {
            this.notificationService.stop();
            this.notificationService = null;
        }
        if (this.clientStatusUpdater != null) {
            this.clientStatusUpdater.stop();
            this.clientStatusUpdater = null;
        }
        if (SessionUser.getCurrent() != null) {
            SessionUser.getCurrent().setAttribute(ApplicationMenu.class, null);
            SessionUser.getCurrent().setAttribute(SessionUser.class, null);
        }
        Platform.runLater(() -> {
            this.userLabel.setText("");
            this.menuLayout.getChildren().clear();
            if (!this.isShuttingDown) {
                this.doLogin();
            }
        });
    }

    public static Stage getPrimaryStage() {
        return primaryStage;
    }

    public static Pane getWorkspace() {
        return workspace;
    }

    public static PhotonApp getApp() {
        return instance;
    }

    private void initializeFooter() {
        this.footer = new HBox();
        this.footer.setId(((Object)((Object)this)).getClass().getCanonicalName() + ".footer");
        this.footerToolBar = new ToolBar();
        this.footerToolBar.setOrientation(Orientation.HORIZONTAL);
        this.footerToolBar.setId(((Object)((Object)this)).getClass().getCanonicalName() + ".footerToolBar");
        this.statusToolBar = new ToolBar();
        this.statusToolBar.setId(((Object)((Object)this)).getClass().getCanonicalName() + ".statusToolBar");
        this.clientStatusImageView = new ImageView(new javafx.scene.image.Image(String.valueOf(((Object)((Object)this)).getClass().getClassLoader().getResource("images/LedNone.gif"))));
        this.statusToolBar.getItems().add((Object)this.clientStatusImageView);
        this.clockLabel = new Label();
        this.clockLabel.setId(((Object)((Object)this)).getClass().getCanonicalName() + ".clockLabel");
        this.applicationContext.getBean(ClockUpdater.class, new Object[]{this.clockLabel});
        this.userLabel = new Label();
        this.userLabel.setId(((Object)((Object)this)).getClass().getCanonicalName() + ".userLabel");
        Separator footerToolBarSeparator1 = new Separator(Orientation.VERTICAL);
        footerToolBarSeparator1.setId(((Object)((Object)this)).getClass().getCanonicalName() + ".footerToolBarSeparator1");
        Separator footerToolBarSeparator2 = new Separator(Orientation.VERTICAL);
        footerToolBarSeparator2.setId(((Object)((Object)this)).getClass().getCanonicalName() + ".footerToolBarSeparator2");
        this.footerToolBar.getItems().addAll((Object[])new Node[]{this.statusToolBar, footerToolBarSeparator1, this.clockLabel, footerToolBarSeparator2, this.userLabel});
        HBox.setHgrow((Node)this.footerToolBar, (Priority)Priority.ALWAYS);
        this.footer.getChildren().add((Object)this.footerToolBar);
        this.styleService.addStyleToAll(new Node[]{this.footer, this.footerToolBar, footerToolBarSeparator1, footerToolBarSeparator2, this.clockLabel, this.userLabel});
    }

    private void showMenu() {
        SessionUser currentUser = SessionUser.getCurrent();
        if (currentUser == null) {
            return;
        }
        ApplicationMenu applicationMenu = currentUser.getAttribute(ApplicationMenu.class);
        if (applicationMenu == null) {
            SLF4JLoggerProxy.debug(PhotonApp.class, (String)"Session is now logged in, building application menu");
            applicationMenu = (ApplicationMenu)this.applicationContext.getBean(ApplicationMenu.class);
            this.menuLayout.getChildren().add((Object)applicationMenu.getMenu());
            SessionUser.getCurrent().setAttribute(ApplicationMenu.class, applicationMenu);
        }
        applicationMenu.refreshMenuPermissions();
    }

    private void doLogin() {
        LoginView loginView = (LoginView)((Object)this.applicationContext.getBean(LoginView.class));
        loginView.showAndWait();
        this.showMenu();
    }
}

