/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.fix.view;

import java.util.Objects;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.marketcetera.fix.ActiveFixSession;
import org.marketcetera.fix.FixSessionStatus;

public class DisplayFixSession {
    private final StringProperty nameProperty = new SimpleStringProperty();
    private final StringProperty descriptionProperty = new SimpleStringProperty();
    private final StringProperty sessionIdProperty = new SimpleStringProperty();
    private final StringProperty brokerIdProperty = new SimpleStringProperty();
    private final StringProperty hostIdProperty = new SimpleStringProperty();
    private final ObjectProperty<FixSessionStatus> statusProperty = new SimpleObjectProperty();
    private final IntegerProperty targetSeqNumProperty = new SimpleIntegerProperty();
    private final IntegerProperty senderSeqNumProperty = new SimpleIntegerProperty();
    private final ObjectProperty<ActiveFixSession> sourceProperty = new SimpleObjectProperty();

    public DisplayFixSession(ActiveFixSession inFixSession) {
        this.nameProperty.set((Object)inFixSession.getFixSession().getName());
        this.descriptionProperty.set((Object)inFixSession.getFixSession().getDescription());
        this.sessionIdProperty.set((Object)inFixSession.getFixSession().getSessionId());
        this.brokerIdProperty.set((Object)inFixSession.getFixSession().getBrokerId());
        this.hostIdProperty.set((Object)inFixSession.getClusterData().toString());
        this.statusProperty.set((Object)inFixSession.getStatus());
        this.targetSeqNumProperty.set(inFixSession.getTargetSequenceNumber());
        this.senderSeqNumProperty.set(inFixSession.getSenderSequenceNumber());
        this.sourceProperty.set((Object)inFixSession);
    }

    public ReadOnlyObjectProperty<ActiveFixSession> sourceProperty() {
        return this.sourceProperty;
    }

    public StringProperty nameProperty() {
        return this.nameProperty;
    }

    public StringProperty descriptionProperty() {
        return this.descriptionProperty;
    }

    public StringProperty sessionIdProperty() {
        return this.sessionIdProperty;
    }

    public StringProperty brokerIdProperty() {
        return this.brokerIdProperty;
    }

    public StringProperty hostIdProperty() {
        return this.hostIdProperty;
    }

    public ObjectProperty<FixSessionStatus> statusProperty() {
        return this.statusProperty;
    }

    public IntegerProperty targetSeqNumProperty() {
        return this.targetSeqNumProperty;
    }

    public IntegerProperty senderSeqNumProperty() {
        return this.senderSeqNumProperty;
    }

    public int hashCode() {
        return Objects.hash(this.brokerIdProperty.get(), this.descriptionProperty.get(), this.hostIdProperty.get(), this.nameProperty.get(), this.senderSeqNumProperty.get(), this.sessionIdProperty.get(), this.statusProperty.get(), this.targetSeqNumProperty.get());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisplayFixSession)) {
            return false;
        }
        DisplayFixSession other = (DisplayFixSession)obj;
        return Objects.equals(this.brokerIdProperty.get(), other.brokerIdProperty.get()) && Objects.equals(this.descriptionProperty.get(), other.descriptionProperty.get()) && Objects.equals(this.hostIdProperty.get(), other.hostIdProperty.get()) && Objects.equals(this.nameProperty.get(), other.nameProperty.get()) && this.senderSeqNumProperty.get() == other.senderSeqNumProperty.get() && Objects.equals(this.sessionIdProperty.get(), other.sessionIdProperty.get()) && this.statusProperty.get() == other.statusProperty.get() && this.targetSeqNumProperty.get() == other.targetSeqNumProperty.get();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DisplayFixSession [name=").append((String)this.nameProperty.get()).append(", description=").append((String)this.descriptionProperty.get()).append(", sessionId=").append((String)this.sessionIdProperty.get()).append(", brokerId=").append((String)this.brokerIdProperty.get()).append(", hostId=").append((String)this.hostIdProperty.get()).append(", status=").append(this.statusProperty.get()).append(", targetSeqNum=").append(this.targetSeqNumProperty.get()).append(", senderSeqNum=").append(this.senderSeqNumProperty.get()).append("]");
        return builder.toString();
    }
}

