/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.fix.view;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.controlsfx.dialog.Wizard;
import org.controlsfx.dialog.WizardPane;
import org.marketcetera.admin.AdminPermissions;
import org.marketcetera.cluster.ClusterData;
import org.marketcetera.cluster.SimpleClusterData;
import org.marketcetera.core.Pair;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.fix.ActiveFixSession;
import org.marketcetera.fix.FixSession;
import org.marketcetera.fix.FixSessionAttributeDescriptor;
import org.marketcetera.fix.FixSessionDay;
import org.marketcetera.fix.FixSessionInstanceData;
import org.marketcetera.fix.FixSessionStatus;
import org.marketcetera.fix.MutableFixSession;
import org.marketcetera.fix.impl.SimpleActiveFixSession;
import org.marketcetera.fix.impl.SimpleFixSession;
import org.marketcetera.fix.impl.SimpleFixSessionAttributeDescriptor;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.ui.PhotonApp;
import org.marketcetera.ui.PhotonServices;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.events.NotificationEvent;
import org.marketcetera.ui.fix.view.DisplayFixSession;
import org.marketcetera.ui.service.AuthorizationHelperService;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.ui.service.admin.AdminClientService;
import org.marketcetera.ui.view.AbstractContentView;
import org.marketcetera.ui.view.ContentView;
import org.marketcetera.ui.view.ValidatingTextField;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;
import quickfix.SessionID;
import quickfix.field.ApplVerID;

@Component
@Scope(value="prototype")
public class FixSessionView
extends AbstractContentView
implements ContentView {
    private MenuItem enableSessionContextMenuItem;
    private MenuItem startSessionContextMenuItem;
    private MenuItem stopSessionContextMenuItem;
    private MenuItem editSessionContextMenuItem;
    private MenuItem deleteSessionContextMenuItem;
    private MenuItem sequenceSessionContextMenuItem;
    private MenuItem disableSessionContextMenuItem;
    private ContextMenu fixSessionsContextMenu;
    private TableColumn<DisplayFixSession, String> nameTableColumn;
    private TableColumn<DisplayFixSession, String> brokerIdTableColumn;
    private TableColumn<DisplayFixSession, String> hostIdTableColumn;
    private TableColumn<DisplayFixSession, FixSessionStatus> statusTableColumn;
    private TableColumn<DisplayFixSession, Integer> senderSequenceNumberTableColumn;
    private TableColumn<DisplayFixSession, Integer> targetSequenceNumberTableColumn;
    private AdminClientService fixAdminClient;
    private VBox rootLayout;
    private TableView<DisplayFixSession> fixSessionsTable;
    private HBox buttonLayout;
    private Button addFixSessionButton;
    @Autowired
    protected AuthorizationHelperService authzHelperService;
    private static final String NAME = "FIX Session View";

    @Override
    public Region getMainLayout() {
        return this.rootLayout;
    }

    @Override
    protected void onBrokerStatusChange(final ActiveFixSession inActiveFixSession) {
        SLF4JLoggerProxy.trace((Object)this, (String)"{} receiveBrokerStatus: {}", (Object[])new Object[]{PlatformServices.getServiceName(this.getClass()), inActiveFixSession});
        String fixSessionName = inActiveFixSession.getFixSession().getName();
        DisplayFixSession fixSessionToUpdate = null;
        for (DisplayFixSession fixSession : this.fixSessionsTable.getItems()) {
            if (!((String)fixSession.nameProperty().get()).equals(fixSessionName)) continue;
            fixSessionToUpdate = fixSession;
            break;
        }
        if (fixSessionToUpdate != null) {
            final DisplayFixSession displayFixSession = fixSessionToUpdate;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    displayFixSession.statusProperty().set((Object)inActiveFixSession.getStatus());
                    displayFixSession.senderSeqNumProperty().set(inActiveFixSession.getSenderSequenceNumber());
                    displayFixSession.targetSeqNumProperty().set(inActiveFixSession.getTargetSequenceNumber());
                }
            });
        } else {
            this.updateSessions();
        }
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    public FixSessionView(Region inParent, NewWindowEvent inEvent, Properties inProperties) {
        super(inParent, inEvent, inProperties);
    }

    @Override
    protected void onStart() {
        this.fixAdminClient = this.serviceManager.getService(AdminClientService.class);
        this.rootLayout = new VBox();
        this.buttonLayout = new HBox();
        this.rootLayout.setPadding(new Insets(10.0));
        this.addFixSessionButton = new Button("Add FIX Session");
        this.addFixSessionButton.setOnAction(inEvent -> {
            SimpleClusterData clusterData = new SimpleClusterData();
            SimpleFixSession newFixSession = new SimpleFixSession();
            SimpleActiveFixSession newActiveFixSession = new SimpleActiveFixSession((FixSession)newFixSession, (ClusterData)clusterData, FixSessionStatus.UNKNOWN, null);
            DisplayFixSession selectedItem = new DisplayFixSession((ActiveFixSession)newActiveFixSession);
            this.updateFixSession(selectedItem, true);
        });
        this.buttonLayout.getChildren().add((Object)this.addFixSessionButton);
        this.buttonLayout.setPadding(new Insets(5.0));
        this.addFixSessionButton.visibleProperty().set(this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.AddSessionAction));
        this.initializeTable();
        this.rootLayout.prefHeightProperty().bind((ObservableValue)this.getParentWindow().heightProperty());
        this.rootLayout.getChildren().addAll((Object[])new Node[]{this.fixSessionsTable, this.buttonLayout});
        this.updateSessions();
        this.initializeBrokerStatusListener();
    }

    private void initializeTable() {
        this.fixSessionsTable = new TableView();
        this.initializeColumns();
        this.initializeContextMenu();
        this.fixSessionsTable.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.fixSessionsTable.getSelectionModel().selectedItemProperty().addListener((inObservable, inOldValue, inNewValue) -> {
            if (inNewValue == null) {
                return;
            }
            Platform.runLater((Runnable)new Runnable((DisplayFixSession)inNewValue){
                final /* synthetic */ DisplayFixSession val$inNewValue;
                {
                    this.val$inNewValue = displayFixSession;
                }

                @Override
                public void run() {
                    for (MenuItem contextMenuItem : FixSessionView.this.fixSessionsTable.getContextMenu().getItems()) {
                        contextMenuItem.setDisable(true);
                    }
                    switch ((FixSessionStatus)this.val$inNewValue.statusProperty().get()) {
                        case AFFINITY_MISMATCH: 
                        case BACKUP: 
                        case DELETED: 
                        case UNKNOWN: {
                            break;
                        }
                        case CONNECTED: 
                        case DISCONNECTED: 
                        case NOT_CONNECTED: {
                            FixSessionView.this.stopSessionContextMenuItem.setDisable(false);
                            break;
                        }
                        case DISABLED: {
                            FixSessionView.this.enableSessionContextMenuItem.setDisable(false);
                            FixSessionView.this.sequenceSessionContextMenuItem.setDisable(false);
                            FixSessionView.this.editSessionContextMenuItem.setDisable(false);
                            FixSessionView.this.deleteSessionContextMenuItem.setDisable(false);
                            break;
                        }
                        case STOPPED: {
                            FixSessionView.this.startSessionContextMenuItem.setDisable(false);
                            FixSessionView.this.disableSessionContextMenuItem.setDisable(false);
                            FixSessionView.this.sequenceSessionContextMenuItem.setDisable(false);
                            break;
                        }
                    }
                }
            });
        });
        this.fixSessionsTable.prefWidthProperty().bind((ObservableValue)this.getParentWindow().widthProperty());
        this.fixSessionsTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
    }

    private void updateSessions() {
        final CollectionPageResponse<ActiveFixSession> response = this.fixAdminClient.getFixSessions(PageRequest.ALL);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FixSessionView.this.fixSessionsTable.getItems().clear();
                for (ActiveFixSession activeFixSession : response.getElements()) {
                    FixSessionView.this.fixSessionsTable.getItems().add((Object)new DisplayFixSession(activeFixSession));
                }
            }
        });
    }

    private void initializeColumns() {
        this.nameTableColumn = new TableColumn("Name");
        this.nameTableColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.brokerIdTableColumn = new TableColumn("Broker Id");
        this.brokerIdTableColumn.setCellValueFactory((Callback)new PropertyValueFactory("brokerId"));
        this.hostIdTableColumn = new TableColumn("Host Id");
        this.hostIdTableColumn.setCellValueFactory((Callback)new PropertyValueFactory("hostId"));
        this.statusTableColumn = new TableColumn("Status");
        this.statusTableColumn.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.statusTableColumn.setCellFactory(tableColumn -> this.renderFixSessionStatusCell((TableColumn<DisplayFixSession, FixSessionStatus>)tableColumn));
        this.senderSequenceNumberTableColumn = new TableColumn("Sender Seq Num");
        this.senderSequenceNumberTableColumn.setCellValueFactory((Callback)new PropertyValueFactory("senderSeqNum"));
        this.targetSequenceNumberTableColumn = new TableColumn("Target Seq Num");
        this.targetSequenceNumberTableColumn.setCellValueFactory((Callback)new PropertyValueFactory("targetSeqNum"));
        this.fixSessionsTable.getColumns().add(this.nameTableColumn);
        this.fixSessionsTable.getColumns().add(this.brokerIdTableColumn);
        this.fixSessionsTable.getColumns().add(this.hostIdTableColumn);
        this.fixSessionsTable.getColumns().add(this.statusTableColumn);
        this.fixSessionsTable.getColumns().add(this.senderSequenceNumberTableColumn);
        this.fixSessionsTable.getColumns().add(this.targetSequenceNumberTableColumn);
    }

    protected TableCell<DisplayFixSession, FixSessionStatus> renderFixSessionStatusCell(TableColumn<DisplayFixSession, FixSessionStatus> inTableColumn) {
        TableCell<DisplayFixSession, FixSessionStatus> tableCell = new TableCell<DisplayFixSession, FixSessionStatus>(){

            protected void updateItem(FixSessionStatus inItem, boolean isEmpty) {
                super.updateItem((Object)inItem, isEmpty);
                this.setText(null);
                this.setGraphic(null);
                if (!isEmpty && inItem != null) {
                    this.setText(inItem.getHumanReadable());
                }
            }
        };
        return tableCell;
    }

    private void performSessionAction(DisplayFixSession inSelectedItem, String inTitle, String inContent, Consumer<String> inAction) {
        if (inSelectedItem == null) {
            return;
        }
        Alert alert = PhotonServices.generateAlert(inTitle, inContent + "?", Alert.AlertType.CONFIRMATION);
        ButtonType okButton = new ButtonType("Ok", ButtonBar.ButtonData.OK_DONE);
        ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{okButton, cancelButton});
        alert.showAndWait().ifPresent(type -> {
            if (type == okButton) {
                try {
                    SLF4JLoggerProxy.info((Object)this, (String)"{} performing {} on {}", (Object[])new Object[]{SessionUser.getCurrent(), inTitle, inSelectedItem});
                    inAction.accept((String)inSelectedItem.nameProperty().get());
                    SLF4JLoggerProxy.info((Object)this, (String)"{} on {} succeeded", (Object[])new Object[]{inTitle, inSelectedItem});
                    this.updateSessions();
                    this.uiMessageService.post(new NotificationEvent(inTitle, inContent + " succeeded", Alert.AlertType.INFORMATION));
                }
                catch (Exception e) {
                    String message = PlatformServices.getMessage((Throwable)e);
                    SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Unable to perform {} on {}: {}", (Object[])new Object[]{inTitle, inSelectedItem, message});
                    this.uiMessageService.post(new NotificationEvent(inTitle, inContent + " failed: " + message, Alert.AlertType.ERROR));
                }
            } else {
                return;
            }
        });
    }

    private void initializeContextMenu() {
        this.fixSessionsContextMenu = new ContextMenu();
        this.fixSessionsTable.setContextMenu(this.fixSessionsContextMenu);
        this.enableSessionContextMenuItem = new MenuItem("Enable");
        this.enableSessionContextMenuItem.setOnAction(event -> {
            DisplayFixSession selectedItem = (DisplayFixSession)this.fixSessionsTable.getSelectionModel().getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            this.performSessionAction(selectedItem, "Enable Session", "Enable " + (String)selectedItem.nameProperty().get(), this.fixAdminClient::enableSession);
        });
        this.disableSessionContextMenuItem = new MenuItem("Disable");
        this.disableSessionContextMenuItem.setOnAction(event -> {
            DisplayFixSession selectedItem = (DisplayFixSession)this.fixSessionsTable.getSelectionModel().getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            this.performSessionAction(selectedItem, "Disable Session", "Disable " + (String)selectedItem.nameProperty().get(), this.fixAdminClient::disableSession);
        });
        this.startSessionContextMenuItem = new MenuItem("Start");
        this.startSessionContextMenuItem.setOnAction(event -> {
            DisplayFixSession selectedItem = (DisplayFixSession)this.fixSessionsTable.getSelectionModel().getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            this.performSessionAction(selectedItem, "Start Session", "Start " + (String)selectedItem.nameProperty().get(), this.fixAdminClient::startSession);
        });
        this.stopSessionContextMenuItem = new MenuItem("Stop");
        this.stopSessionContextMenuItem.setOnAction(event -> {
            DisplayFixSession selectedItem = (DisplayFixSession)this.fixSessionsTable.getSelectionModel().getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            this.performSessionAction(selectedItem, "Stop Session", "Stop " + (String)selectedItem.nameProperty().get(), this.fixAdminClient::stopSession);
        });
        this.editSessionContextMenuItem = new MenuItem("Edit");
        this.editSessionContextMenuItem.setOnAction(event -> {
            DisplayFixSession selectedItem = (DisplayFixSession)this.fixSessionsTable.getSelectionModel().getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            this.updateFixSession(selectedItem, false);
        });
        this.deleteSessionContextMenuItem = new MenuItem("Delete");
        this.deleteSessionContextMenuItem.setOnAction(event -> {
            DisplayFixSession selectedItem = (DisplayFixSession)this.fixSessionsTable.getSelectionModel().getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            this.performSessionAction(selectedItem, "Delete Session", "Delete " + (String)selectedItem.nameProperty().get(), this.fixAdminClient::deleteSession);
        });
        this.sequenceSessionContextMenuItem = new MenuItem("Update Sequence Numbers");
        this.sequenceSessionContextMenuItem.setOnAction(event -> {
            DisplayFixSession selectedItem = (DisplayFixSession)this.fixSessionsTable.getSelectionModel().getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            this.doUpdateSessionSequenceNumbers(selectedItem);
            this.updateSessions();
        });
        if (this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.EnableSessionAction)) {
            this.fixSessionsContextMenu.getItems().add((Object)this.enableSessionContextMenuItem);
        }
        if (this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.DisableSessionAction)) {
            this.fixSessionsContextMenu.getItems().add((Object)this.disableSessionContextMenuItem);
        }
        if (this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.StartSessionAction)) {
            this.fixSessionsContextMenu.getItems().add((Object)this.startSessionContextMenuItem);
        }
        if (this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.StopSessionAction)) {
            this.fixSessionsContextMenu.getItems().add((Object)this.stopSessionContextMenuItem);
        }
        if (this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.EditSessionAction)) {
            this.fixSessionsContextMenu.getItems().add((Object)this.editSessionContextMenuItem);
        }
        if (this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.DeleteSessionAction)) {
            this.fixSessionsContextMenu.getItems().add((Object)this.deleteSessionContextMenuItem);
        }
        if (this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.UpdateSequenceAction)) {
            this.fixSessionsContextMenu.getItems().add((Object)this.sequenceSessionContextMenuItem);
        }
        for (MenuItem contextMenuItem : this.fixSessionsContextMenu.getItems()) {
            contextMenuItem.setDisable(true);
        }
    }

    private void updateFixSession(final DisplayFixSession inFixSession, final boolean inIsNew) {
        String acceptorString = "Acceptor";
        String initiatorString = "Initiator";
        String incomingFixSessionName = (String)inFixSession.nameProperty().get();
        Wizard wizard = new Wizard((Object)PhotonApp.getPrimaryStage());
        wizard.setTitle((inIsNew ? "Add" : "Edit") + " Session");
        final ComboBox connectionTypeComboBox = new ComboBox();
        connectionTypeComboBox.getItems().addAll((Object[])new String[]{"Acceptor", "Initiator"});
        connectionTypeComboBox.setId("sessionType.connectionType");
        connectionTypeComboBox.setTooltip(new Tooltip("Indicates whether the session will receive orders (acceptor) or send them (initiator)"));
        final ValidatingTextField affinityTextField = new ValidatingTextField(input -> input.matches("^\\d+$"));
        affinityTextField.setId("sessionType.affinity");
        affinityTextField.setTooltip(new Tooltip("Indicates which cluster instance will host this session, if unsure, leave as 1"));
        Label adviceLabel = new Label();
        SimpleBooleanProperty sessionTypeValid = new SimpleBooleanProperty(false);
        connectionTypeComboBox.valueProperty().addListener((arg_0, arg_1, arg_2) -> FixSessionView.lambda$updateFixSession$12((BooleanProperty)sessionTypeValid, connectionTypeComboBox, affinityTextField, arg_0, arg_1, arg_2));
        affinityTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> FixSessionView.lambda$updateFixSession$13((BooleanProperty)sessionTypeValid, connectionTypeComboBox, affinityTextField, arg_0, arg_1, arg_2));
        affinityTextField.isValidProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                affinityTextField.setStyle(PhotonServices.successStyle);
                adviceLabel.setText("");
                adviceLabel.setStyle(PhotonServices.successMessage);
            } else {
                affinityTextField.setStyle(PhotonServices.successStyle);
                adviceLabel.setText("affinity must be an integer value");
                adviceLabel.setStyle(PhotonServices.errorMessage);
            }
        });
        WizardPane sessionTypePane = new WizardPane((BooleanProperty)sessionTypeValid){
            final /* synthetic */ BooleanProperty val$sessionTypeValid;
            {
                this.val$sessionTypeValid = booleanProperty;
            }

            public void onEnteringPage(Wizard inWizard) {
                super.onEnteringPage(inWizard);
                connectionTypeComboBox.setValue((Object)(inIsNew ? "Initiator" : (((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().isAcceptor() ? "Acceptor" : "Initiator")));
                affinityTextField.setText(inIsNew ? "1" : String.valueOf(((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getAffinity()));
                inWizard.invalidProperty().bind((ObservableValue)this.val$sessionTypeValid);
            }

            public void onExitingPage(Wizard inWizard) {
                ((MutableFixSession)((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getMutableView()).setIsAcceptor(((String)connectionTypeComboBox.getValue()).equals("Acceptor"));
                ((MutableFixSession)((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getMutableView()).setAffinity(Integer.parseInt(affinityTextField.getText()));
                super.onExitingPage(inWizard);
            }
        };
        sessionTypePane.setId("sessionType");
        GridPane sessionTypeLayout = new GridPane();
        sessionTypeLayout.setHgap(10.0);
        sessionTypeLayout.setVgap(10.0);
        sessionTypeLayout.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        sessionTypePane.setHeaderText("Session Type");
        sessionTypeLayout.add((Node)new Label("Connection Type"), 0, 0);
        sessionTypeLayout.add((Node)connectionTypeComboBox, 1, 0);
        sessionTypeLayout.add((Node)new Label("Affinity"), 0, 1);
        sessionTypeLayout.add((Node)affinityTextField, 1, 1);
        sessionTypeLayout.add((Node)adviceLabel, 0, 2, 2, 1);
        sessionTypePane.setContent((Node)sessionTypeLayout);
        SimpleBooleanProperty networkInvalid = new SimpleBooleanProperty(false);
        final ValidatingTextField hostnameTextField = new ValidatingTextField(input -> PhotonServices.isValidHostNameSyntax(input));
        hostnameTextField.setId("network.hostname");
        hostnameTextField.setPromptText("fix gateway host or ip address");
        final ValidatingTextField portTextField = new ValidatingTextField(input -> input.matches("^([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])$"));
        portTextField.setId("network.port");
        portTextField.setPromptText("fix gateway port");
        hostnameTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> FixSessionView.lambda$updateFixSession$17((BooleanProperty)networkInvalid, hostnameTextField, portTextField, arg_0, arg_1, arg_2));
        portTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> FixSessionView.lambda$updateFixSession$18((BooleanProperty)networkInvalid, hostnameTextField, portTextField, arg_0, arg_1, arg_2));
        final Button testConnectionButton = new Button("Test Connection");
        final Label testConnectionLabel = new Label();
        networkInvalid.addListener((observable, oldValue, newValue) -> {
            if (((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().isAcceptor()) {
                testConnectionButton.setDisable(true);
                testConnectionButton.setVisible(false);
                testConnectionLabel.setDisable(true);
                testConnectionLabel.setVisible(false);
            } else {
                testConnectionButton.setDisable(newValue.booleanValue());
                testConnectionButton.setVisible(newValue == false);
                testConnectionLabel.setDisable(newValue.booleanValue());
                testConnectionLabel.setVisible(newValue == false);
            }
        });
        hostnameTextField.isValidProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                hostnameTextField.setStyle(PhotonServices.successStyle);
                adviceLabel.setText("");
                adviceLabel.setStyle(PhotonServices.successMessage);
            } else {
                hostnameTextField.setStyle(PhotonServices.errorStyle);
                adviceLabel.setText("hostname must be a valid host specification");
                adviceLabel.setStyle(PhotonServices.errorMessage);
            }
        });
        portTextField.isValidProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                portTextField.setStyle(PhotonServices.successStyle);
                adviceLabel.setText("");
                adviceLabel.setStyle(PhotonServices.successMessage);
            } else {
                portTextField.setStyle(PhotonServices.errorStyle);
                adviceLabel.setText("port must be a valid port");
                adviceLabel.setStyle(PhotonServices.errorMessage);
            }
        });
        WizardPane networkPane = new WizardPane((BooleanProperty)networkInvalid, inIsNew){
            final /* synthetic */ BooleanProperty val$networkInvalid;
            final /* synthetic */ boolean val$inIsNew;
            {
                this.val$networkInvalid = booleanProperty;
                this.val$inIsNew = bl;
            }

            public void onEnteringPage(Wizard inWizard) {
                super.onEnteringPage(inWizard);
                if (((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().isAcceptor()) {
                    hostnameTextField.setTooltip(new Tooltip("The acceptor hostname is determined by the server and is not modifiable"));
                    hostnameTextField.setDisable(true);
                    portTextField.setTooltip(new Tooltip("The acceptor port is determined by the server cluster framework and is not modifiable"));
                    portTextField.setDisable(true);
                    testConnectionButton.setDisable(true);
                    testConnectionButton.setVisible(false);
                    testConnectionLabel.setDisable(true);
                    testConnectionLabel.setVisible(false);
                    FixSessionInstanceData instanceData = AdminClientService.getInstance().getFixSessionInstanceData(((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getAffinity());
                    hostnameTextField.setText(instanceData.getHostname());
                    portTextField.setText(String.valueOf(instanceData.getPort()));
                } else {
                    hostnameTextField.setTooltip(new Tooltip("Hostname of the FIX gateway to connect to"));
                    hostnameTextField.setDisable(false);
                    portTextField.setTooltip(new Tooltip("Port of the FIX gateway to connect to"));
                    portTextField.setDisable(false);
                    testConnectionButton.setDisable(this.val$networkInvalid.get());
                    testConnectionButton.setVisible(!this.val$networkInvalid.get());
                    testConnectionLabel.setDisable(this.val$networkInvalid.get());
                    testConnectionLabel.setVisible(!this.val$networkInvalid.get());
                    if (this.val$inIsNew) {
                        hostnameTextField.setText("exchange.marketcetera.com");
                        portTextField.setText("7004");
                    } else {
                        hostnameTextField.setText(((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getHost());
                        portTextField.setText(String.valueOf(((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getPort()));
                    }
                }
                inWizard.invalidProperty().bind((ObservableValue)this.val$networkInvalid);
            }

            public void onExitingPage(Wizard inWizard) {
                if (!((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().isAcceptor()) {
                    ((MutableFixSession)((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getMutableView()).setHost(hostnameTextField.getText());
                    ((MutableFixSession)((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getMutableView()).setPort(Integer.parseInt(portTextField.getText()));
                }
                super.onExitingPage(inWizard);
            }
        };
        GridPane networkLayout = new GridPane();
        networkLayout.setHgap(10.0);
        networkLayout.setVgap(10.0);
        networkLayout.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        networkPane.setHeaderText("Network");
        networkLayout.add((Node)new Label("Hostname"), 0, 0);
        networkLayout.add((Node)hostnameTextField, 1, 0);
        networkLayout.add((Node)new Label("Port"), 0, 1);
        networkLayout.add((Node)portTextField, 1, 1);
        networkLayout.add((Node)adviceLabel, 0, 2, 2, 1);
        networkLayout.add((Node)testConnectionButton, 0, 3);
        networkLayout.add((Node)testConnectionLabel, 1, 3);
        networkPane.setContent((Node)networkLayout);
        testConnectionButton.setOnAction(event -> {
            testConnectionLabel.setText("");
            testConnectionLabel.setStyle(PhotonServices.successMessage);
            String hostname = hostnameTextField.getText();
            int port = Integer.parseInt(portTextField.getText());
            InetSocketAddress socketAddress = new InetSocketAddress(hostname, port);
            Socket socket = new Socket();
            int timeout = 2000;
            try {
                socket.connect(socketAddress, timeout);
                socket.close();
                testConnectionLabel.setText("Test connection succeeded");
                testConnectionLabel.setStyle(PhotonServices.successMessage);
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn(PhotonServices.class, (String)("Unable to connect to {}:{} -> " + e.getMessage()), (Object[])new Object[]{hostname, port, ExceptionUtils.getRootCauseMessage((Throwable)e)});
                testConnectionLabel.setText("Test connection failed: " + ExceptionUtils.getRootCauseMessage((Throwable)e));
                testConnectionLabel.setStyle(PhotonServices.errorMessage);
            }
            finally {
                if (networkLayout.getScene() != null) {
                    ((Stage)networkLayout.getScene().getWindow()).sizeToScene();
                }
            }
        });
        wizard.setFlow((Wizard.Flow)new Wizard.LinearFlow(new WizardPane[]{sessionTypePane, networkPane, this.initializeSessionIdentityPane(inFixSession, inIsNew, adviceLabel), new SessionTimesPane(inFixSession, inIsNew).generateWizardPane("Session Times"), new SessionSettingsPane(inFixSession, inIsNew).generateWizardPane("Settings")}));
        PhotonServices.style(sessionTypePane.getScene());
        wizard.showAndWait().ifPresent(result -> {
            if (result == ButtonType.FINISH) {
                try {
                    if (inIsNew) {
                        SLF4JLoggerProxy.info((Object)this, (String)"{} creating {}", (Object[])new Object[]{SessionUser.getCurrent(), inFixSession});
                        this.fixAdminClient.createFixSession(((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession());
                        this.uiMessageService.post(new NotificationEvent("Create FIX Session", "Create FIX Session '" + (String)inFixSession.nameProperty().get() + "' succeeded", Alert.AlertType.INFORMATION));
                    } else {
                        SLF4JLoggerProxy.info((Object)this, (String)"{} updating {} -> {}", (Object[])new Object[]{SessionUser.getCurrent(), incomingFixSessionName, inFixSession});
                        this.fixAdminClient.updateFixSession(incomingFixSessionName, ((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession());
                        this.uiMessageService.post(new NotificationEvent("Update FIX Session", "Update FIX Session '" + (String)inFixSession.nameProperty().get() + "' succeeded", Alert.AlertType.INFORMATION));
                    }
                }
                catch (Exception e) {
                    String message = PlatformServices.getMessage((Throwable)e);
                    SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Unable to create or update FIX session {}: {}", (Object[])new Object[]{inFixSession, message});
                    this.uiMessageService.post(new NotificationEvent("Create or Update FIX Session", "Create or update FIX sesssion '" + (String)inFixSession.nameProperty().get() + " 'failed: " + message, Alert.AlertType.ERROR));
                }
            }
        });
    }

    private WizardPane initializeSessionIdentityPane(final DisplayFixSession inFixSession, final boolean inIsNew, final Label inAdviceLabel) {
        final Collection<ActiveFixSession> existingSessions = AdminClientService.getInstance().getFixSessions();
        TreeMap<String, FIXVersion[]> sortedDescriptors = new TreeMap<String, FIXVersion[]>();
        Collection<FixSessionAttributeDescriptor> descriptors = AdminClientService.getInstance().getFixSessionAttributeDescriptors();
        for (FixSessionAttributeDescriptor descriptor : descriptors) {
            FIXVersion[] actualDescriptor = new DecoratedDescriptor(descriptor);
            sortedDescriptors.put(descriptor.getName(), actualDescriptor);
        }
        SimpleBooleanProperty sessionIdentityInvalid = new SimpleBooleanProperty(false);
        Predicate<String> sessionNameValidator = new Predicate<String>(){

            @Override
            public boolean test(String inValue) {
                String computedValue = StringUtils.trimToNull((String)inValue);
                if (computedValue == null) {
                    return false;
                }
                if (computedValue.length() > 255) {
                    inAdviceLabel.setText("Name may contain up to 255 characters");
                    return false;
                }
                for (ActiveFixSession existingSession : existingSessions) {
                    if (!inIsNew || !existingSession.getFixSession().getName().equals(computedValue)) continue;
                    inAdviceLabel.setText("Name is already in use");
                    return false;
                }
                return true;
            }
        };
        final ValidatingTextField sessionNameTextField = new ValidatingTextField(sessionNameValidator);
        sessionNameTextField.setId("sesssionIdentity.sessionName");
        sessionNameTextField.setPromptText("fix session name");
        sessionNameTextField.setTooltip(new Tooltip("Unique human-readable name of the session"));
        final ValidatingTextField sessionDescriptionTextField = new ValidatingTextField(inValue -> {
            String computedValue = StringUtils.trimToNull((String)inValue);
            if (computedValue == null) {
                return false;
            }
            if (computedValue.length() > 255) {
                inAdviceLabel.setText("Description may contain up to 255 characters");
                return false;
            }
            return true;
        });
        sessionDescriptionTextField.setId("sesssionIdentity.sessionDescription");
        sessionDescriptionTextField.setPromptText("fix session description");
        sessionDescriptionTextField.setTooltip(new Tooltip("Optional description of the session"));
        final ValidatingTextField sessionBrokerIdTextField = new ValidatingTextField(new Predicate<String>(){

            @Override
            public boolean test(String inValue) {
                String computedValue = StringUtils.trimToNull((String)inValue);
                if (computedValue == null) {
                    return false;
                }
                if (computedValue.length() > 255) {
                    inAdviceLabel.setText("Broker Id may contain up to 255 characters");
                    return false;
                }
                for (ActiveFixSession existingSession : existingSessions) {
                    if (!inIsNew || !existingSession.getFixSession().getBrokerId().equals(computedValue)) continue;
                    inAdviceLabel.setText("Broker Id is already in use");
                    return false;
                }
                return true;
            }
        });
        sessionBrokerIdTextField.setId("sesssionIdentity.brokerId");
        sessionBrokerIdTextField.setPromptText("fix session broker id");
        sessionBrokerIdTextField.setTooltip(new Tooltip("Unique system identifier for this FIX session used to target orders, pick something short and descriptive"));
        final ComboBox fixVersionComboBox = new ComboBox();
        fixVersionComboBox.setId("sesssionIdentity.fixVersion");
        for (FIXVersion fixVersion : FIXVersion.values()) {
            if (fixVersion == FIXVersion.FIX_SYSTEM) continue;
            fixVersionComboBox.getItems().add((Object)fixVersion);
        }
        final ValidatingTextField senderCompIdTextField = new ValidatingTextField(inValue -> {
            String computedValue = StringUtils.trimToNull((String)inValue);
            if (computedValue == null) {
                return false;
            }
            if (computedValue.length() > 255) {
                inAdviceLabel.setText("Broker Id may contain up to 255 characters");
                return false;
            }
            return true;
        });
        senderCompIdTextField.setId("sesssionIdentity.senderCompId");
        senderCompIdTextField.setPromptText("sender comp id");
        senderCompIdTextField.setTooltip(new Tooltip("Sender Comp Id of the session"));
        final ValidatingTextField targetCompIdTextField = new ValidatingTextField(inValue -> {
            String computedValue = StringUtils.trimToNull((String)inValue);
            if (computedValue == null) {
                return false;
            }
            if (computedValue.length() > 255) {
                inAdviceLabel.setText("Broker Id may contain up to 255 characters");
                return false;
            }
            return true;
        });
        targetCompIdTextField.setId("sesssionIdentity.targetCompId");
        targetCompIdTextField.setPromptText("target comp id");
        targetCompIdTextField.setTooltip(new Tooltip("Target Comp Id of the session"));
        sessionNameTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> FixSessionView.lambda$initializeSessionIdentityPane$27((BooleanProperty)sessionIdentityInvalid, sessionNameTextField, sessionDescriptionTextField, fixVersionComboBox, sessionBrokerIdTextField, senderCompIdTextField, targetCompIdTextField, arg_0, arg_1, arg_2));
        sessionNameTextField.isValidProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                sessionNameTextField.setStyle(PhotonServices.successStyle);
                inAdviceLabel.setText("");
                inAdviceLabel.setStyle(PhotonServices.successMessage);
            } else {
                sessionNameTextField.setStyle(PhotonServices.errorStyle);
                inAdviceLabel.setStyle(PhotonServices.errorMessage);
            }
        });
        sessionDescriptionTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> FixSessionView.lambda$initializeSessionIdentityPane$29((BooleanProperty)sessionIdentityInvalid, sessionNameTextField, sessionDescriptionTextField, fixVersionComboBox, sessionBrokerIdTextField, senderCompIdTextField, targetCompIdTextField, arg_0, arg_1, arg_2));
        sessionDescriptionTextField.isValidProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                sessionNameTextField.setStyle(PhotonServices.successStyle);
                inAdviceLabel.setText("");
                inAdviceLabel.setStyle(PhotonServices.successMessage);
            } else {
                sessionNameTextField.setStyle(PhotonServices.errorStyle);
                inAdviceLabel.setStyle(PhotonServices.errorMessage);
            }
        });
        fixVersionComboBox.valueProperty().addListener((arg_0, arg_1, arg_2) -> FixSessionView.lambda$initializeSessionIdentityPane$31((BooleanProperty)sessionIdentityInvalid, sessionNameTextField, sessionDescriptionTextField, fixVersionComboBox, sessionBrokerIdTextField, senderCompIdTextField, targetCompIdTextField, arg_0, arg_1, arg_2));
        sessionBrokerIdTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> FixSessionView.lambda$initializeSessionIdentityPane$32((BooleanProperty)sessionIdentityInvalid, sessionNameTextField, sessionDescriptionTextField, fixVersionComboBox, sessionBrokerIdTextField, senderCompIdTextField, targetCompIdTextField, arg_0, arg_1, arg_2));
        sessionBrokerIdTextField.isValidProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                sessionBrokerIdTextField.setStyle(PhotonServices.successStyle);
                inAdviceLabel.setText("");
                inAdviceLabel.setStyle(PhotonServices.successMessage);
            } else {
                sessionBrokerIdTextField.setStyle(PhotonServices.errorStyle);
                inAdviceLabel.setStyle(PhotonServices.errorMessage);
            }
        });
        senderCompIdTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> FixSessionView.lambda$initializeSessionIdentityPane$34((BooleanProperty)sessionIdentityInvalid, sessionNameTextField, sessionDescriptionTextField, fixVersionComboBox, sessionBrokerIdTextField, senderCompIdTextField, targetCompIdTextField, arg_0, arg_1, arg_2));
        senderCompIdTextField.isValidProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                senderCompIdTextField.setStyle(PhotonServices.successStyle);
                inAdviceLabel.setText("");
                inAdviceLabel.setStyle(PhotonServices.successMessage);
            } else {
                senderCompIdTextField.setStyle(PhotonServices.errorStyle);
                inAdviceLabel.setStyle(PhotonServices.errorMessage);
            }
        });
        targetCompIdTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> FixSessionView.lambda$initializeSessionIdentityPane$36((BooleanProperty)sessionIdentityInvalid, sessionNameTextField, sessionDescriptionTextField, fixVersionComboBox, sessionBrokerIdTextField, senderCompIdTextField, targetCompIdTextField, arg_0, arg_1, arg_2));
        targetCompIdTextField.isValidProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                targetCompIdTextField.setStyle(PhotonServices.successStyle);
                inAdviceLabel.setText("");
                inAdviceLabel.setStyle(PhotonServices.successMessage);
            } else {
                targetCompIdTextField.setStyle(PhotonServices.errorStyle);
                inAdviceLabel.setStyle(PhotonServices.errorMessage);
            }
        });
        Predicate<String> sessionIdValidator = new Predicate<String>(){

            @Override
            public boolean test(String value) {
                String fixVersionValue = fixVersionComboBox.getValue() == null ? null : String.valueOf(fixVersionComboBox.getValue());
                SessionID sessionId = new SessionID(fixVersionValue, senderCompIdTextField.getText(), targetCompIdTextField.getText());
                for (ActiveFixSession existingSession : existingSessions) {
                    if (!inIsNew || !existingSession.getFixSession().getSessionId().equals(sessionId.toString())) continue;
                    inAdviceLabel.setText("'" + existingSession.getFixSession().getSessionId() + "' is already in use");
                    return false;
                }
                return true;
            }
        };
        WizardPane sessionIdentityPane = new WizardPane((BooleanProperty)sessionIdentityInvalid, sortedDescriptors){
            final /* synthetic */ BooleanProperty val$sessionIdentityInvalid;
            final /* synthetic */ SortedMap val$sortedDescriptors;
            {
                this.val$sessionIdentityInvalid = booleanProperty;
                this.val$sortedDescriptors = sortedMap;
            }

            public void onEnteringPage(Wizard inWizard) {
                super.onEnteringPage(inWizard);
                sessionNameTextField.setText(((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getName());
                sessionDescriptionTextField.setText(((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getDescription());
                sessionBrokerIdTextField.setText(((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getBrokerId());
                if (((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getSessionId() != null) {
                    SessionID sessionId = new SessionID(((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getSessionId());
                    if (sessionId.isFIXT()) {
                        String defaultApplVerId = (String)((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getSessionSettings().get("DefaultApplVerID");
                        if (defaultApplVerId != null) {
                            fixVersionComboBox.setValue((Object)FIXVersion.getFIXVersion((ApplVerID)new ApplVerID(defaultApplVerId)));
                        }
                    } else {
                        fixVersionComboBox.setValue((Object)FIXVersion.getFIXVersion((SessionID)sessionId));
                    }
                    senderCompIdTextField.setText(sessionId.getSenderCompID());
                    targetCompIdTextField.setText(sessionId.getTargetCompID());
                } else {
                    fixVersionComboBox.setValue((Object)FIXVersion.FIX42);
                }
                inWizard.invalidProperty().bind((ObservableValue)this.val$sessionIdentityInvalid);
            }

            public void onExitingPage(Wizard inWizard) {
                String fixVersionValue;
                ((MutableFixSession)((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getMutableView()).setName(sessionNameTextField.getText());
                ((MutableFixSession)((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getMutableView()).setDescription(sessionDescriptionTextField.getText());
                ((MutableFixSession)((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getMutableView()).setBrokerId(sessionBrokerIdTextField.getText());
                String string = fixVersionValue = fixVersionComboBox.getValue() == null ? null : String.valueOf(fixVersionComboBox.getValue());
                if (fixVersionValue != null) {
                    FIXVersion fixVersion = FIXVersion.getFIXVersion((String)fixVersionValue);
                    if (fixVersion.isFixT()) {
                        fixVersionValue = fixVersion.getApplicationVersion();
                        ((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getSessionSettings().put("DefaultApplVerID", fixVersionValue);
                        DecoratedDescriptor defaultApplVerId = (DecoratedDescriptor)((Object)this.val$sortedDescriptors.get("DefaultApplVerID"));
                        defaultApplVerId.setValue(fixVersionValue);
                        fixVersionValue = "FIXT.1.1";
                    }
                    SessionID sessionId = new SessionID(fixVersionValue, senderCompIdTextField.getText(), targetCompIdTextField.getText());
                    ((MutableFixSession)((ActiveFixSession)inFixSession.sourceProperty().get()).getFixSession().getMutableView()).setSessionId(sessionId.toString());
                }
            }
        };
        GridPane sessionIdentityLayout = new GridPane();
        sessionIdentityLayout.setHgap(10.0);
        sessionIdentityLayout.setVgap(10.0);
        sessionIdentityLayout.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        sessionIdentityPane.setHeaderText("Session Identity");
        sessionIdentityLayout.add((Node)new Label("Name"), 0, 0);
        sessionIdentityLayout.add((Node)sessionNameTextField, 1, 0);
        sessionIdentityLayout.add((Node)new Label("Description"), 0, 1);
        sessionIdentityLayout.add((Node)sessionDescriptionTextField, 1, 1);
        sessionIdentityLayout.add((Node)new Label("Broker ID"), 0, 2);
        sessionIdentityLayout.add((Node)sessionBrokerIdTextField, 1, 2);
        sessionIdentityLayout.add((Node)new Label("Version"), 0, 3);
        sessionIdentityLayout.add((Node)fixVersionComboBox, 1, 3);
        sessionIdentityLayout.add((Node)new Label("Sender Comp Id"), 0, 4);
        sessionIdentityLayout.add((Node)senderCompIdTextField, 1, 4);
        sessionIdentityLayout.add((Node)new Label("Target Comp Id"), 0, 5);
        sessionIdentityLayout.add((Node)targetCompIdTextField, 1, 5);
        sessionIdentityLayout.add((Node)inAdviceLabel, 0, 6, 2, 1);
        sessionIdentityPane.setContent((Node)sessionIdentityLayout);
        return sessionIdentityPane;
    }

    private void doUpdateSessionSequenceNumbers(DisplayFixSession inSession) {
        Dialog dialog = new Dialog();
        dialog.setTitle("Update Sequence Numbers");
        dialog.setHeaderText("Update Session Sequence Numbers for " + (String)inSession.nameProperty().get());
        ButtonType updateButtonType = new ButtonType("Update", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{updateButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        ValidatingTextField senderSequenceNumberTextField = new ValidatingTextField(input -> input.matches("^\\d+$"));
        senderSequenceNumberTextField.textProperty().set((Object)String.valueOf(inSession.senderSeqNumProperty().get()));
        ValidatingTextField targetSequenceNumberTextField = new ValidatingTextField(input -> input.matches("^\\d+$"));
        targetSequenceNumberTextField.textProperty().set((Object)String.valueOf(inSession.targetSeqNumProperty().get()));
        grid.add((Node)new Label("Sender Sequence Number:"), 0, 0);
        grid.add((Node)senderSequenceNumberTextField, 1, 0);
        grid.add((Node)new Label("Target Sequence Number:"), 0, 1);
        grid.add((Node)targetSequenceNumberTextField, 1, 1);
        Node updateButton = dialog.getDialogPane().lookupButton(updateButtonType);
        updateButton.setDisable(false);
        senderSequenceNumberTextField.isValidProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                senderSequenceNumberTextField.setStyle(PhotonServices.successStyle);
            } else {
                senderSequenceNumberTextField.setStyle(PhotonServices.errorStyle);
            }
        });
        targetSequenceNumberTextField.isValidProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                targetSequenceNumberTextField.setStyle(PhotonServices.successStyle);
            } else {
                targetSequenceNumberTextField.setStyle(PhotonServices.errorStyle);
            }
        });
        senderSequenceNumberTextField.textProperty().addListener((observable, oldValue, newvalue) -> {
            String senderFieldValue = StringUtils.trimToNull((String)((String)senderSequenceNumberTextField.textProperty().get()));
            String targetFieldValue = StringUtils.trimToNull((String)((String)targetSequenceNumberTextField.textProperty().get()));
            updateButton.setDisable(senderFieldValue == null || targetFieldValue == null || !senderSequenceNumberTextField.isValidProperty().get() || !targetSequenceNumberTextField.isValidProperty().get());
        });
        targetSequenceNumberTextField.textProperty().addListener((observable, oldValue, newvalue) -> {
            String senderFieldValue = StringUtils.trimToNull((String)((String)senderSequenceNumberTextField.textProperty().get()));
            String targetFieldValue = StringUtils.trimToNull((String)((String)targetSequenceNumberTextField.textProperty().get()));
            updateButton.setDisable(senderFieldValue == null || targetFieldValue == null || !senderSequenceNumberTextField.isValidProperty().get() || !targetSequenceNumberTextField.isValidProperty().get());
        });
        dialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> senderSequenceNumberTextField.requestFocus());
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == updateButtonType) {
                return Pair.create((Object)Integer.parseInt(senderSequenceNumberTextField.getText()), (Object)Integer.parseInt(targetSequenceNumberTextField.getText()));
            }
            return null;
        });
        PhotonServices.style(dialog);
        Optional result = dialog.showAndWait();
        result.ifPresent(sequenceNumberPairs -> {
            int newSenderSequenceNumber = (Integer)sequenceNumberPairs.getFirstMember();
            int newTargetSequenceNumber = (Integer)sequenceNumberPairs.getSecondMember();
            try {
                SLF4JLoggerProxy.info((Object)this, (String)"{} updating sequence numbers for {} to {},{}", (Object[])new Object[]{SessionUser.getCurrent(), inSession, newSenderSequenceNumber, newTargetSequenceNumber});
                this.fixAdminClient.updateSequenceNumbers((String)inSession.nameProperty().get(), newSenderSequenceNumber, newTargetSequenceNumber);
                this.updateSessions();
                this.uiMessageService.post(new NotificationEvent("Update Sequence Numbers", "Update sequence numbers on " + (String)inSession.nameProperty().get() + " succeeded", Alert.AlertType.INFORMATION));
            }
            catch (Exception e) {
                String message = PlatformServices.getMessage((Throwable)e);
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Unable to update sequence numbers on {}: {}", (Object[])new Object[]{inSession, message});
                this.uiMessageService.post(new NotificationEvent("Update Sequence Numbers", "Update sequence numbers on " + (String)inSession.nameProperty().get() + " failed: " + message, Alert.AlertType.ERROR));
            }
        });
    }

    private static /* synthetic */ void lambda$initializeSessionIdentityPane$36(BooleanProperty sessionIdentityInvalid, ValidatingTextField sessionNameTextField, ValidatingTextField sessionDescriptionTextField, ComboBox fixVersionComboBox, ValidatingTextField sessionBrokerIdTextField, ValidatingTextField senderCompIdTextField, ValidatingTextField targetCompIdTextField, ObservableValue observable, String oldValue, String newValue) {
        sessionIdentityInvalid.set(!sessionNameTextField.isValidProperty().get() || !sessionDescriptionTextField.isValidProperty().get() || fixVersionComboBox.getValue() == null || !sessionBrokerIdTextField.isValidProperty().get() || !senderCompIdTextField.isValidProperty().get() || !targetCompIdTextField.isValidProperty().get());
    }

    private static /* synthetic */ void lambda$initializeSessionIdentityPane$34(BooleanProperty sessionIdentityInvalid, ValidatingTextField sessionNameTextField, ValidatingTextField sessionDescriptionTextField, ComboBox fixVersionComboBox, ValidatingTextField sessionBrokerIdTextField, ValidatingTextField senderCompIdTextField, ValidatingTextField targetCompIdTextField, ObservableValue observable, String oldValue, String newValue) {
        sessionIdentityInvalid.set(!sessionNameTextField.isValidProperty().get() || !sessionDescriptionTextField.isValidProperty().get() || fixVersionComboBox.getValue() == null || !sessionBrokerIdTextField.isValidProperty().get() || !senderCompIdTextField.isValidProperty().get() || !targetCompIdTextField.isValidProperty().get());
    }

    private static /* synthetic */ void lambda$initializeSessionIdentityPane$32(BooleanProperty sessionIdentityInvalid, ValidatingTextField sessionNameTextField, ValidatingTextField sessionDescriptionTextField, ComboBox fixVersionComboBox, ValidatingTextField sessionBrokerIdTextField, ValidatingTextField senderCompIdTextField, ValidatingTextField targetCompIdTextField, ObservableValue observable, String oldValue, String newValue) {
        sessionIdentityInvalid.set(!sessionNameTextField.isValidProperty().get() || !sessionDescriptionTextField.isValidProperty().get() || fixVersionComboBox.getValue() == null || !sessionBrokerIdTextField.isValidProperty().get() || !senderCompIdTextField.isValidProperty().get() || !targetCompIdTextField.isValidProperty().get());
    }

    private static /* synthetic */ void lambda$initializeSessionIdentityPane$31(BooleanProperty sessionIdentityInvalid, ValidatingTextField sessionNameTextField, ValidatingTextField sessionDescriptionTextField, ComboBox fixVersionComboBox, ValidatingTextField sessionBrokerIdTextField, ValidatingTextField senderCompIdTextField, ValidatingTextField targetCompIdTextField, ObservableValue observable, FIXVersion oldValue, FIXVersion newValue) {
        sessionIdentityInvalid.set(!sessionNameTextField.isValidProperty().get() || !sessionDescriptionTextField.isValidProperty().get() || fixVersionComboBox.getValue() == null || !sessionBrokerIdTextField.isValidProperty().get() || !senderCompIdTextField.isValidProperty().get() || !targetCompIdTextField.isValidProperty().get());
    }

    private static /* synthetic */ void lambda$initializeSessionIdentityPane$29(BooleanProperty sessionIdentityInvalid, ValidatingTextField sessionNameTextField, ValidatingTextField sessionDescriptionTextField, ComboBox fixVersionComboBox, ValidatingTextField sessionBrokerIdTextField, ValidatingTextField senderCompIdTextField, ValidatingTextField targetCompIdTextField, ObservableValue observable, String oldValue, String newValue) {
        sessionIdentityInvalid.set(!sessionNameTextField.isValidProperty().get() || !sessionDescriptionTextField.isValidProperty().get() || fixVersionComboBox.getValue() == null || !sessionBrokerIdTextField.isValidProperty().get() || !senderCompIdTextField.isValidProperty().get() || !targetCompIdTextField.isValidProperty().get());
    }

    private static /* synthetic */ void lambda$initializeSessionIdentityPane$27(BooleanProperty sessionIdentityInvalid, ValidatingTextField sessionNameTextField, ValidatingTextField sessionDescriptionTextField, ComboBox fixVersionComboBox, ValidatingTextField sessionBrokerIdTextField, ValidatingTextField senderCompIdTextField, ValidatingTextField targetCompIdTextField, ObservableValue observable, String oldValue, String newValue) {
        sessionIdentityInvalid.set(!sessionNameTextField.isValidProperty().get() || !sessionDescriptionTextField.isValidProperty().get() || fixVersionComboBox.getValue() == null || !sessionBrokerIdTextField.isValidProperty().get() || !senderCompIdTextField.isValidProperty().get() || !targetCompIdTextField.isValidProperty().get());
    }

    private static /* synthetic */ void lambda$updateFixSession$18(BooleanProperty networkInvalid, ValidatingTextField hostnameTextField, ValidatingTextField portTextField, ObservableValue observable, String oldValue, String newValue) {
        networkInvalid.set(!hostnameTextField.isValidProperty().get() || !portTextField.isValidProperty().get());
    }

    private static /* synthetic */ void lambda$updateFixSession$17(BooleanProperty networkInvalid, ValidatingTextField hostnameTextField, ValidatingTextField portTextField, ObservableValue observable, String oldValue, String newValue) {
        networkInvalid.set(!hostnameTextField.isValidProperty().get() || !portTextField.isValidProperty().get());
    }

    private static /* synthetic */ void lambda$updateFixSession$13(BooleanProperty sessionTypeValid, ComboBox connectionTypeComboBox, ValidatingTextField affinityTextField, ObservableValue observable, String oldValue, String newValue) {
        sessionTypeValid.set(connectionTypeComboBox.getValue() == null || !affinityTextField.isValidProperty().get());
    }

    private static /* synthetic */ void lambda$updateFixSession$12(BooleanProperty sessionTypeValid, ComboBox connectionTypeComboBox, ValidatingTextField affinityTextField, ObservableValue observable, String oldValue, String newValue) {
        sessionTypeValid.set(connectionTypeComboBox.getValue() == null || !affinityTextField.isValidProperty().get());
    }

    public static class DecoratedDescriptor
    extends SimpleFixSessionAttributeDescriptor {
        private final StringProperty value;
        private static final long serialVersionUID = 142085523837757672L;

        public DecoratedDescriptor(FixSessionAttributeDescriptor inDescriptor) {
            this.setAdvice(inDescriptor.getAdvice());
            this.setDefaultValue(inDescriptor.getDefaultValue());
            this.setDescription(inDescriptor.getDescription());
            this.setName(inDescriptor.getName());
            this.setPattern(inDescriptor.getPattern());
            this.setRequired(inDescriptor.isRequired());
            this.value = new SimpleStringProperty();
        }

        public StringProperty getValue() {
            return this.value;
        }

        public void setValue(String inValue) {
            this.value.set((Object)inValue);
        }

        public void reset() {
            this.value.set((Object)this.getDefaultValue());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DecoratedDescriptor [").append(this.getName()).append("=").append(this.value).append("]");
            return builder.toString();
        }

        public StringProperty valueProperty() {
            return this.value;
        }
    }

    private class SessionSettingsPane
    extends AbstractWizardPane {
        private final TableView<DecoratedDescriptor> descriptorGrid;

        private SessionSettingsPane(DisplayFixSession inFixSession, boolean inIsNew) {
            super(inFixSession, inIsNew);
            this.descriptorGrid = new TableView();
            this.descriptorGrid.setEditable(true);
            TableColumn nameColumn = new TableColumn("Name");
            nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
            nameColumn.setEditable(false);
            TableColumn descriptionColumn = new TableColumn("Description");
            descriptionColumn.setCellValueFactory((Callback)new PropertyValueFactory("description"));
            descriptionColumn.setEditable(false);
            TableColumn defaultValueColumn = new TableColumn("Default");
            defaultValueColumn.setCellValueFactory((Callback)new PropertyValueFactory("defaultValue"));
            defaultValueColumn.setEditable(true);
            TableColumn valueColumn = new TableColumn("Value");
            valueColumn.setCellValueFactory((Callback)new PropertyValueFactory("value"));
            valueColumn.setCellValueFactory(cellData -> ((DecoratedDescriptor)((Object)((Object)cellData.getValue()))).valueProperty());
            valueColumn.setCellFactory(TextFieldTableCell.forTableColumn());
            valueColumn.setEditable(true);
            this.descriptorGrid.getColumns().add((Object)nameColumn);
            this.descriptorGrid.getColumns().add((Object)valueColumn);
            this.descriptorGrid.getColumns().add((Object)defaultValueColumn);
            this.descriptorGrid.getColumns().add((Object)descriptionColumn);
            this.fieldsInvalid.set(false);
        }

        @Override
        protected void setFieldsInGrid() {
            this.mainLayout.getChildren().add(this.descriptorGrid);
        }

        @Override
        protected void doOnEnteringPage(Wizard inWizard) {
            this.descriptorGrid.getItems().clear();
            Map sessionSettings = ((ActiveFixSession)this.fixSession.sourceProperty().get()).getFixSession().getSessionSettings();
            Collection<FixSessionAttributeDescriptor> attributeDescriptors = FixSessionView.this.fixAdminClient.getFixSessionAttributeDescriptors();
            for (FixSessionAttributeDescriptor descriptor : attributeDescriptors) {
                DecoratedDescriptor newItem = new DecoratedDescriptor(descriptor);
                newItem.value.set((Object)((String)sessionSettings.get(newItem.getName())));
                this.descriptorGrid.getItems().add((Object)newItem);
            }
            this.descriptorGrid.setPrefWidth(1024.0);
        }

        @Override
        protected void doOnExitingPage(Wizard inWizard) {
            Map settings = ((ActiveFixSession)this.fixSession.sourceProperty().get()).getFixSession().getSessionSettings();
            for (DecoratedDescriptor decoratedDescriptor : this.descriptorGrid.getItems()) {
                String name = decoratedDescriptor.getName();
                String value = StringUtils.trimToNull((String)((String)decoratedDescriptor.valueProperty().get()));
                if (value == null) {
                    settings.remove(name);
                    continue;
                }
                settings.put(name, value);
            }
        }
    }

    private static class SessionTimesPane
    extends AbstractWizardPane {
        private final String CONTINUOUS = "Continuous";
        private final String DAILY = "Daily";
        private final String WEEKLY = "Weekly";
        private final String YES = "Y";
        private final ComboBox<String> sessionTypeComboBox;
        private final ValidatingTextField startTimeField;
        private final ValidatingTextField endTimeField;
        private final ComboBox<String> timeZoneComboBox;
        private final ComboBox<FixSessionDay> startDayComboBox;
        private final ComboBox<FixSessionDay> endDayComboBox;

        @Override
        protected void setFieldsInGrid() {
            String value;
            this.paneLayout.getChildren().clear();
            int rowIndex = 0;
            this.paneLayout.add((Node)new Label("Type"), 0, rowIndex);
            this.paneLayout.add(this.sessionTypeComboBox, 1, rowIndex);
            switch (value = String.valueOf(this.sessionTypeComboBox.getValue())) {
                case "Continuous": {
                    break;
                }
                case "Daily": {
                    this.paneLayout.add((Node)new Label("Start Time"), 0, ++rowIndex);
                    this.paneLayout.add((Node)this.startTimeField, 1, rowIndex);
                    this.paneLayout.add((Node)new Label("End Time"), 0, ++rowIndex);
                    this.paneLayout.add((Node)this.endTimeField, 1, rowIndex);
                    this.paneLayout.add((Node)new Label("Time Zone"), 0, ++rowIndex);
                    this.paneLayout.add(this.timeZoneComboBox, 1, rowIndex);
                    break;
                }
                case "Weekly": {
                    this.paneLayout.add((Node)new Label("Start Time"), 0, ++rowIndex);
                    this.paneLayout.add((Node)this.startTimeField, 1, rowIndex);
                    this.paneLayout.add((Node)new Label("End Time"), 0, ++rowIndex);
                    this.paneLayout.add((Node)this.endTimeField, 1, rowIndex);
                    this.paneLayout.add((Node)new Label("Start Day"), 0, ++rowIndex);
                    this.paneLayout.add(this.startDayComboBox, 1, rowIndex);
                    this.paneLayout.add((Node)new Label("End Day"), 0, ++rowIndex);
                    this.paneLayout.add(this.endDayComboBox, 1, rowIndex);
                    this.paneLayout.add((Node)new Label("Time Zone"), 0, ++rowIndex);
                    this.paneLayout.add(this.timeZoneComboBox, 1, rowIndex);
                }
            }
            this.paneLayout.add((Node)this.adviceLabel, 0, ++rowIndex, 2, 1);
            if (this.paneLayout.getScene() != null) {
                ((Stage)this.paneLayout.getScene().getWindow()).sizeToScene();
            }
        }

        @Override
        protected void doOnEnteringPage(Wizard inWizard) {
            Map settings = ((ActiveFixSession)this.fixSession.sourceProperty().get()).getFixSession().getSessionSettings();
            this.startTimeField.setText(settings.containsKey("StartTime") ? (String)settings.get("StartTime") : "00:00:00");
            this.endTimeField.setText(settings.containsKey("EndTime") ? (String)settings.get("EndTime") : "00:00:00");
            this.startDayComboBox.setValue((Object)(settings.containsKey("StartDay") ? FixSessionDay.valueOf((String)((String)settings.get("StartDay"))) : FixSessionDay.Monday));
            this.endDayComboBox.setValue((Object)(settings.containsKey("EndDay") ? FixSessionDay.valueOf((String)((String)settings.get("EndDay"))) : FixSessionDay.Friday));
            this.timeZoneComboBox.setValue((Object)(settings.containsKey("TimeZone") ? (String)settings.get("TimeZone") : TimeZone.getDefault().getID()));
            this.startTimeField.setVisible(true);
            this.endTimeField.setVisible(true);
            String value = (String)settings.get("NonStopSession");
            if ("Y".equals(value)) {
                this.sessionTypeComboBox.setValue((Object)"Continuous");
            } else {
                value = (String)settings.get("StartDay");
                if (value != null) {
                    this.sessionTypeComboBox.setValue((Object)"Weekly");
                } else {
                    this.sessionTypeComboBox.setValue((Object)"Daily");
                }
            }
            this.updateFields();
        }

        @Override
        protected void doOnExitingPage(Wizard inWizard) {
            String value;
            Map settings = ((ActiveFixSession)this.fixSession.sourceProperty().get()).getFixSession().getSessionSettings();
            switch (value = String.valueOf(this.sessionTypeComboBox.getValue())) {
                case "Continuous": {
                    settings.remove("StartTime");
                    settings.remove("EndTime");
                    settings.remove("StartDay");
                    settings.remove("EndDay");
                    settings.remove("TimeZone");
                    settings.put("NonStopSession", "Y");
                    break;
                }
                case "Daily": {
                    settings.remove("StartDay");
                    settings.remove("EndDay");
                    settings.remove("NonStopSession");
                    settings.put("StartTime", this.startTimeField.getText());
                    settings.put("EndTime", this.endTimeField.getText());
                    settings.put("TimeZone", String.valueOf(this.timeZoneComboBox.getValue()));
                    break;
                }
                case "Weekly": {
                    settings.remove("NonStopSession");
                    settings.put("StartTime", this.startTimeField.getText());
                    settings.put("EndTime", this.endTimeField.getText());
                    settings.put("TimeZone", String.valueOf(this.timeZoneComboBox.getValue()));
                    settings.put("StartDay", String.valueOf(this.startDayComboBox.getValue()));
                    settings.put("EndDay", String.valueOf(this.endDayComboBox.getValue()));
                }
            }
        }

        private SessionTimesPane(DisplayFixSession inFixSession, boolean inIsNew) {
            super(inFixSession, inIsNew);
            Predicate<String> timeFieldPredicate = value -> value.matches("^([01]\\d|2[0-3]):([0-5]\\d):([0-5]\\d)$");
            Function<Void, Boolean> invalidTestFunction = new Function<Void, Boolean>(){

                @Override
                public Boolean apply(Void inIgnored) {
                    String value;
                    if (sessionTypeComboBox.getValue() == null) {
                        return true;
                    }
                    boolean isValid = false;
                    switch (value = String.valueOf(sessionTypeComboBox.getValue())) {
                        case "Continuous": {
                            isValid = true;
                            break;
                        }
                        case "Daily": {
                            isValid = startTimeField.isValidProperty().get() && endTimeField.isValidProperty().get() && timeZoneComboBox.getValue() != null;
                            break;
                        }
                        case "Weekly": {
                            isValid = startTimeField.isValidProperty().get() && endTimeField.isValidProperty().get() && startDayComboBox.getValue() != null && endDayComboBox.getValue() != null && timeZoneComboBox.getValue() != null;
                        }
                    }
                    return !isValid;
                }
            };
            this.sessionTypeComboBox = new ComboBox();
            this.sessionTypeComboBox.setId("sessionType");
            this.sessionTypeComboBox.getItems().add((Object)"Daily");
            this.sessionTypeComboBox.getItems().add((Object)"Weekly");
            this.sessionTypeComboBox.getItems().add((Object)"Continuous");
            this.startTimeField = new ValidatingTextField(timeFieldPredicate);
            this.startTimeField.setId("sessionStartTime");
            this.endTimeField = new ValidatingTextField(timeFieldPredicate);
            this.endTimeField.setId("sessionEndTime");
            this.timeZoneComboBox = new ComboBox();
            this.timeZoneComboBox.setId("sessionTimeZone");
            for (String timeZoneId : TimeZone.getAvailableIDs()) {
                this.timeZoneComboBox.getItems().add((Object)timeZoneId);
            }
            this.startDayComboBox = new ComboBox();
            this.startDayComboBox.setId("sessionStartDay");
            this.endDayComboBox = new ComboBox();
            this.endDayComboBox.setId("sessionEndDay");
            this.sessionTypeComboBox.valueProperty().addListener((observableValue, oldValue, newValue) -> {
                this.fieldsInvalid.set(((Boolean)invalidTestFunction.apply(null)).booleanValue());
                this.updateFields();
            });
            this.startTimeField.setId("sessionTimes.startTime");
            this.startTimeField.setPromptText("00:00:00");
            this.startTimeField.setTooltip(new Tooltip("Enter a time value in the form 00:00:00"));
            this.startTimeField.isValidProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.startTimeField.setStyle(PhotonServices.successStyle);
                    this.adviceLabel.setText("");
                    this.adviceLabel.setStyle(PhotonServices.successMessage);
                } else {
                    this.adviceLabel.setText("Start time must be in the form 00:00:00");
                    this.startTimeField.setStyle(PhotonServices.errorStyle);
                    this.adviceLabel.setStyle(PhotonServices.errorMessage);
                }
            });
            this.startTimeField.textProperty().addListener((observableValue, oldValue, newValue) -> this.fieldsInvalid.set(((Boolean)invalidTestFunction.apply(null)).booleanValue()));
            this.endTimeField.setId("sessionTimes.endTime");
            this.endTimeField.setPromptText("00:00:00");
            this.endTimeField.setTooltip(new Tooltip("Enter a time value in the form 00:00:00"));
            this.endTimeField.isValidProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.endTimeField.setStyle(PhotonServices.successStyle);
                    this.adviceLabel.setText("");
                    this.adviceLabel.setStyle(PhotonServices.successMessage);
                } else {
                    this.adviceLabel.setText("End time must be in the form 00:00:00");
                    this.endTimeField.setStyle(PhotonServices.errorStyle);
                    this.adviceLabel.setStyle(PhotonServices.errorMessage);
                }
            });
            this.endTimeField.textProperty().addListener((observableValue, oldValue, newValue) -> this.fieldsInvalid.set(((Boolean)invalidTestFunction.apply(null)).booleanValue()));
            this.startDayComboBox.getItems().addAll((Object[])FixSessionDay.values());
            this.endDayComboBox.getItems().addAll((Object[])FixSessionDay.values());
        }

        private void updateFields() {
            String value;
            switch (value = String.valueOf(this.sessionTypeComboBox.getValue())) {
                case "Continuous": {
                    this.startTimeField.setVisible(false);
                    this.endTimeField.setVisible(false);
                    this.timeZoneComboBox.setVisible(false);
                    this.startDayComboBox.setVisible(false);
                    this.endDayComboBox.setVisible(false);
                    break;
                }
                case "Daily": {
                    this.startTimeField.setVisible(true);
                    this.endTimeField.setVisible(true);
                    this.timeZoneComboBox.setVisible(true);
                    this.startDayComboBox.setVisible(false);
                    this.endDayComboBox.setVisible(false);
                    break;
                }
                case "Weekly": {
                    this.startTimeField.setVisible(true);
                    this.endTimeField.setVisible(true);
                    this.timeZoneComboBox.setVisible(true);
                    this.startDayComboBox.setVisible(true);
                    this.endDayComboBox.setVisible(true);
                }
            }
            this.setFieldsInGrid();
        }
    }

    private static abstract class AbstractWizardPane {
        protected final FlowPane mainLayout;
        protected final BooleanProperty fieldsInvalid;
        protected final DisplayFixSession fixSession;
        protected final boolean isNew;
        protected final Label adviceLabel;
        protected final GridPane paneLayout;

        protected WizardPane generateWizardPane(String inHeaderText) {
            WizardPane wizardPane = new WizardPane(){

                public void onEnteringPage(Wizard inWizard) {
                    this.doOnEnteringPage(inWizard);
                    inWizard.invalidProperty().bind((ObservableValue)fieldsInvalid);
                }

                public void onExitingPage(Wizard inWizard) {
                    this.doOnExitingPage(inWizard);
                }
            };
            this.paneLayout.setHgap(10.0);
            this.paneLayout.setVgap(10.0);
            this.paneLayout.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
            wizardPane.setHeaderText(inHeaderText);
            wizardPane.setId(this.getPaneName());
            this.mainLayout.getChildren().add((Object)this.paneLayout);
            this.setFieldsInGrid();
            wizardPane.setContent((Node)this.mainLayout);
            return wizardPane;
        }

        protected String getPaneName() {
            return this.getClass().getSimpleName();
        }

        protected void setFieldsInGrid() {
        }

        protected void doOnEnteringPage(Wizard inWizard) {
        }

        protected void doOnExitingPage(Wizard inWizard) {
        }

        protected AbstractWizardPane(DisplayFixSession inFixSession, boolean inIsNew) {
            this.fixSession = inFixSession;
            this.isNew = inIsNew;
            this.adviceLabel = new Label();
            this.paneLayout = new GridPane();
            this.fieldsInvalid = new SimpleBooleanProperty(true);
            this.mainLayout = new FlowPane();
        }
    }
}

