/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.marketdata.view;

import java.math.BigDecimal;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.joda.time.DateTime;
import org.marketcetera.event.AskEvent;
import org.marketcetera.event.BidEvent;
import org.marketcetera.event.Event;
import org.marketcetera.event.MarketstatEvent;
import org.marketcetera.event.TradeEvent;
import org.marketcetera.trade.Instrument;
import org.marketcetera.util.log.SLF4JLoggerProxy;

public class MarketDataItem {
    private final Instrument instrument;
    private final StringProperty symbolProperty;
    private final StringProperty tradeExchangeProperty;
    private final ObjectProperty<BigDecimal> lastPriceProperty;
    private final ObjectProperty<BigDecimal> lastQuantityProperty;
    private final ObjectProperty<DateTime> tradeTimestampProperty;
    private final ObjectProperty<DateTime> bidTimestampProperty;
    private final ObjectProperty<DateTime> askTimestampProperty;
    private final StringProperty bidExchangeProperty;
    private final StringProperty askExchangeProperty;
    private final ObjectProperty<BigDecimal> bidQuantityProperty;
    private final ObjectProperty<BigDecimal> bidPriceProperty;
    private final ObjectProperty<BigDecimal> askPriceProperty;
    private final ObjectProperty<BigDecimal> askQuantityProperty;
    private final ObjectProperty<BigDecimal> previousClosePriceProperty;
    private final ObjectProperty<BigDecimal> openPriceProperty;
    private final ObjectProperty<BigDecimal> highPriceProperty;
    private final ObjectProperty<BigDecimal> lowPriceProperty;
    private final ObjectProperty<BigDecimal> closePriceProperty;
    private final ObjectProperty<BigDecimal> tradeVolumeProperty;
    private final StringProperty marketDataRequestIdProperty;
    private final StringProperty providerProperty = new SimpleStringProperty();

    public MarketDataItem(Instrument inInstrument, String inMarketDataRequestId) {
        this.instrument = inInstrument;
        this.marketDataRequestIdProperty = new SimpleStringProperty(inMarketDataRequestId);
        this.symbolProperty = new SimpleStringProperty(this.instrument.getFullSymbol());
        this.tradeExchangeProperty = new SimpleStringProperty();
        this.lastPriceProperty = new SimpleObjectProperty();
        this.lastQuantityProperty = new SimpleObjectProperty();
        this.tradeTimestampProperty = new SimpleObjectProperty();
        this.bidQuantityProperty = new SimpleObjectProperty();
        this.bidPriceProperty = new SimpleObjectProperty();
        this.askPriceProperty = new SimpleObjectProperty();
        this.askQuantityProperty = new SimpleObjectProperty();
        this.previousClosePriceProperty = new SimpleObjectProperty();
        this.openPriceProperty = new SimpleObjectProperty();
        this.highPriceProperty = new SimpleObjectProperty();
        this.lowPriceProperty = new SimpleObjectProperty();
        this.closePriceProperty = new SimpleObjectProperty();
        this.tradeVolumeProperty = new SimpleObjectProperty();
        this.bidExchangeProperty = new SimpleStringProperty();
        this.bidTimestampProperty = new SimpleObjectProperty();
        this.askExchangeProperty = new SimpleStringProperty();
        this.askTimestampProperty = new SimpleObjectProperty();
    }

    public ReadOnlyStringProperty marketDataRequestIdProperty() {
        return this.marketDataRequestIdProperty;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public ReadOnlyStringProperty symbolProperty() {
        return this.symbolProperty;
    }

    public ReadOnlyStringProperty tradeExchangeProperty() {
        return this.tradeExchangeProperty;
    }

    public ReadOnlyObjectProperty<BigDecimal> lastPriceProperty() {
        return this.lastPriceProperty;
    }

    public ReadOnlyObjectProperty<BigDecimal> lastQuantityProperty() {
        return this.lastQuantityProperty;
    }

    public ReadOnlyObjectProperty<DateTime> tradeTimestampProperty() {
        return this.tradeTimestampProperty;
    }

    public ReadOnlyObjectProperty<DateTime> bidTimestampProperty() {
        return this.bidTimestampProperty;
    }

    public ReadOnlyObjectProperty<DateTime> askTimestampProperty() {
        return this.askTimestampProperty;
    }

    public ReadOnlyStringProperty bidExchangeProperty() {
        return this.bidExchangeProperty;
    }

    public ReadOnlyStringProperty askExchangeProperty() {
        return this.askExchangeProperty;
    }

    public ReadOnlyObjectProperty<BigDecimal> bidQuantityProperty() {
        return this.bidQuantityProperty;
    }

    public ReadOnlyObjectProperty<BigDecimal> bidPriceProperty() {
        return this.bidPriceProperty;
    }

    public ReadOnlyObjectProperty<BigDecimal> askPriceProperty() {
        return this.askPriceProperty;
    }

    public ReadOnlyObjectProperty<BigDecimal> askQuantityProperty() {
        return this.askQuantityProperty;
    }

    public ReadOnlyObjectProperty<BigDecimal> previousClosePriceProperty() {
        return this.previousClosePriceProperty;
    }

    public ReadOnlyObjectProperty<BigDecimal> openPriceProperty() {
        return this.openPriceProperty;
    }

    public ReadOnlyObjectProperty<BigDecimal> highPriceProperty() {
        return this.highPriceProperty;
    }

    public ReadOnlyObjectProperty<BigDecimal> lowPriceProperty() {
        return this.lowPriceProperty;
    }

    public ReadOnlyObjectProperty<BigDecimal> closePriceProperty() {
        return this.closePriceProperty;
    }

    public ReadOnlyObjectProperty<BigDecimal> tradeVolumeProperty() {
        return this.tradeVolumeProperty;
    }

    public ReadOnlyStringProperty providerProperty() {
        return this.providerProperty;
    }

    public void update(Event inEvent) {
        SLF4JLoggerProxy.trace((Object)this, (String)"Received {}", (Object[])new Object[]{inEvent});
        this.providerProperty.set((Object)inEvent.getProvider());
        if (inEvent instanceof TradeEvent) {
            TradeEvent tradeEvent = (TradeEvent)inEvent;
            this.lastPriceProperty.set((Object)tradeEvent.getPrice());
            this.lastQuantityProperty.set((Object)tradeEvent.getSize());
            this.tradeExchangeProperty.set((Object)tradeEvent.getExchange());
            this.tradeTimestampProperty.set((Object)new DateTime((Object)tradeEvent.getExchangeTimestamp()));
        }
        if (inEvent instanceof BidEvent) {
            BidEvent bidEvent = (BidEvent)inEvent;
            this.bidPriceProperty.set((Object)bidEvent.getPrice());
            this.bidQuantityProperty.set((Object)bidEvent.getSize());
            this.bidExchangeProperty.set((Object)bidEvent.getExchange());
            this.bidTimestampProperty.set((Object)new DateTime((Object)bidEvent.getQuoteDate()));
        }
        if (inEvent instanceof AskEvent) {
            AskEvent askEvent = (AskEvent)inEvent;
            this.askPriceProperty.set((Object)askEvent.getPrice());
            this.askQuantityProperty.set((Object)askEvent.getSize());
            this.askExchangeProperty.set((Object)askEvent.getExchange());
            this.askTimestampProperty.set((Object)new DateTime((Object)askEvent.getQuoteDate()));
        }
        if (inEvent instanceof MarketstatEvent) {
            MarketstatEvent marketstatEvent = (MarketstatEvent)inEvent;
            this.previousClosePriceProperty.set((Object)marketstatEvent.getPreviousClose());
            this.openPriceProperty.set((Object)marketstatEvent.getOpen());
            this.highPriceProperty.set((Object)marketstatEvent.getHigh());
            this.lowPriceProperty.set((Object)marketstatEvent.getLow());
            this.closePriceProperty.set((Object)marketstatEvent.getClose());
            this.tradeVolumeProperty.set((Object)marketstatEvent.getVolume());
        }
    }
}

