/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.marketdata.view;

import java.math.BigDecimal;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.joda.time.DateTime;
import org.marketcetera.event.Event;
import org.marketcetera.event.EventType;
import org.marketcetera.event.QuoteAction;
import org.marketcetera.event.QuoteEvent;
import org.marketcetera.trade.Instrument;
import org.marketcetera.util.log.SLF4JLoggerProxy;

public class MarketDataQuoteItem {
    private final ObjectProperty<QuoteAction> quoteActionProperty = new SimpleObjectProperty();
    private final ObjectProperty<EventType> eventTypeProperty = new SimpleObjectProperty();
    private final IntegerProperty quoteLevelProperty = new SimpleIntegerProperty();
    private final IntegerProperty quoteCountProperty = new SimpleIntegerProperty();
    private final Instrument instrument;
    private final StringProperty symbolProperty;
    private final ObjectProperty<DateTime> timestampProperty;
    private final StringProperty exchangeProperty;
    private final ObjectProperty<BigDecimal> quantityProperty;
    private final ObjectProperty<BigDecimal> priceProperty;

    public MarketDataQuoteItem(Instrument inInstrument) {
        this.instrument = inInstrument;
        this.symbolProperty = new SimpleStringProperty(this.instrument.getFullSymbol());
        this.quantityProperty = new SimpleObjectProperty();
        this.priceProperty = new SimpleObjectProperty();
        this.exchangeProperty = new SimpleStringProperty();
        this.timestampProperty = new SimpleObjectProperty();
    }

    public MarketDataQuoteItem(QuoteEvent inQuoteEvent) {
        this(inQuoteEvent.getInstrument());
        this.eventTypeProperty.set((Object)inQuoteEvent.getEventType());
        this.exchangeProperty.set((Object)inQuoteEvent.getExchange());
        this.priceProperty.set((Object)inQuoteEvent.getPrice());
        this.quantityProperty.set((Object)inQuoteEvent.getSize());
        this.quoteActionProperty.set((Object)inQuoteEvent.getAction());
        this.quoteCountProperty.set(inQuoteEvent.getCount());
        this.quoteLevelProperty.set(inQuoteEvent.getLevel());
        this.timestampProperty.set((Object)new DateTime((Object)inQuoteEvent.getTimestamp()));
    }

    public ObjectProperty<QuoteAction> quoteActionProperty() {
        return this.quoteActionProperty;
    }

    public ObjectProperty<EventType> eventTypeProperty() {
        return this.eventTypeProperty;
    }

    public IntegerProperty quoteLevelProperty() {
        return this.quoteLevelProperty;
    }

    public IntegerProperty quoteCountProperty() {
        return this.quoteCountProperty;
    }

    public StringProperty symbolProperty() {
        return this.symbolProperty;
    }

    public ObjectProperty<DateTime> timestampProperty() {
        return this.timestampProperty;
    }

    public StringProperty exchangeProperty() {
        return this.exchangeProperty;
    }

    public ObjectProperty<BigDecimal> quantityProperty() {
        return this.quantityProperty;
    }

    public ObjectProperty<BigDecimal> priceProperty() {
        return this.priceProperty;
    }

    public void update(Event inEvent) {
        SLF4JLoggerProxy.trace((Object)this, (String)"Received {}", (Object[])new Object[]{inEvent});
        if (inEvent instanceof QuoteEvent) {
            QuoteEvent quoteEvent = (QuoteEvent)inEvent;
            this.priceProperty.set((Object)quoteEvent.getPrice());
            this.quantityProperty.set((Object)quoteEvent.getSize());
            this.exchangeProperty.set((Object)quoteEvent.getExchange());
            this.timestampProperty.set((Object)new DateTime((Object)quoteEvent.getQuoteDate()));
            this.eventTypeProperty.set((Object)quoteEvent.getEventType());
            this.quoteActionProperty.set((Object)quoteEvent.getAction());
            this.quoteLevelProperty.set(quoteEvent.getLevel());
            this.quoteCountProperty.set(quoteEvent.getCount());
        }
    }
}

