/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.service;

import com.google.common.eventbus.Subscribe;
import javafx.application.Platform;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.controlsfx.control.Notifications;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.ui.PhotonApp;
import org.marketcetera.ui.events.NotificationEvent;
import org.marketcetera.ui.service.UiMessageService;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@EnableAutoConfiguration
@Scope(value="prototype")
public class PhotonNotificationService {
    @Value(value="${metc.notifications.delay.seconds:3}")
    private int notificationDelay;
    @Value(value="${metc.notifications.threshold:10}")
    private int notificationThreshold;
    @Autowired
    private UiMessageService webMessageService;

    @PostConstruct
    public void start() {
        SLF4JLoggerProxy.info((Object)this, (String)"Starting {}", (Object[])new Object[]{PlatformServices.getServiceName(this.getClass())});
        this.webMessageService.register(this);
    }

    @PreDestroy
    public void stop() {
        SLF4JLoggerProxy.info((Object)this, (String)"Stopping {}", (Object[])new Object[]{PlatformServices.getServiceName(this.getClass())});
        this.webMessageService.unregister(this);
    }

    @Subscribe
    public void onNotification(final NotificationEvent inEvent) {
        SLF4JLoggerProxy.debug((Object)this, (String)"Received: {}", (Object[])new Object[]{inEvent});
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Notifications notification = Notifications.create().darkStyle().title(inEvent.getTitle()).text(inEvent.getMessage()).owner((Object)PhotonApp.getWorkspace()).hideAfter(Duration.seconds((double)PhotonNotificationService.this.notificationDelay));
                notification.threshold(PhotonNotificationService.this.notificationThreshold, notification);
                switch (inEvent.getAlertType()) {
                    case CONFIRMATION: {
                        notification.showConfirm();
                        break;
                    }
                    case ERROR: {
                        notification.showError();
                        break;
                    }
                    case INFORMATION: {
                        notification.showInformation();
                        break;
                    }
                    case NONE: {
                        notification.show();
                        break;
                    }
                    case WARNING: {
                        notification.showWarning();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        });
    }
}

