/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.ui.service.ConnectableService;
import org.marketcetera.ui.service.ConnectableServiceFactory;
import org.marketcetera.ui.service.NoServiceException;
import org.marketcetera.ui.service.ServerConnectionService;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
@EnableAutoConfiguration
public class ServiceManager {
    private final LoadingCache<SessionUser, Cache<String, ConnectableService>> servicesByUser = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<SessionUser, Cache<String, ConnectableService>>(){

        public Cache<String, ConnectableService> load(SessionUser inKey) throws Exception {
            return CacheBuilder.newBuilder().build();
        }
    });
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ServerConnectionService serverConnectionService;
    private final Map<Class<?>, ConnectableServiceFactory<?>> connectableServiceFactoriesByServiceClass = Maps.newHashMap();
    @Autowired(required=false)
    private Collection<ConnectableServiceFactory<?>> connectableServiceFactories = Lists.newArrayList();
    private static ServiceManager instance;

    @PostConstruct
    public void start() {
        SLF4JLoggerProxy.info((Object)this, (String)"Starting service manager");
        for (ConnectableServiceFactory<?> factory : this.connectableServiceFactories) {
            this.connectableServiceFactoriesByServiceClass.put(factory.getServiceType(), factory);
        }
        instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void stop() {
        try {
            for (Cache services : this.servicesByUser.asMap().values()) {
                for (ConnectableService service : services.asMap().values()) {
                    try {
                        service.disconnect();
                    }
                    catch (Exception e) {
                        try {
                            SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            SLF4JLoggerProxy.info((Object)this, (String)"{} stopped", (Object[])new Object[]{service});
                            throw throwable;
                        }
                        SLF4JLoggerProxy.info((Object)this, (String)"{} stopped", (Object[])new Object[]{service});
                        continue;
                    }
                    SLF4JLoggerProxy.info((Object)this, (String)"{} stopped", (Object[])new Object[]{service});
                }
            }
            this.servicesByUser.invalidateAll();
            instance = null;
        }
        catch (Throwable throwable) {
            instance = null;
            SLF4JLoggerProxy.info((Object)this, (String)"{} stopped", (Object[])new Object[]{PlatformServices.getServiceName(this.getClass())});
            throw throwable;
        }
        SLF4JLoggerProxy.info((Object)this, (String)"{} stopped", (Object[])new Object[]{PlatformServices.getServiceName(this.getClass())});
    }

    public <ServiceClazz extends ConnectableService> ServiceClazz getService(Class<ServiceClazz> inServiceClass) throws NoServiceException {
        SessionUser sessionUser = SessionUser.getCurrent();
        if (sessionUser == null) {
            throw new IllegalStateException("No current user");
        }
        Cache serviceCache = (Cache)this.servicesByUser.getUnchecked((Object)sessionUser);
        ConnectableService service = (ConnectableService)serviceCache.getIfPresent((Object)inServiceClass.getSimpleName());
        if (service == null) {
            ConnectableServiceFactory<?> serviceFactory = this.connectableServiceFactoriesByServiceClass.get(inServiceClass);
            if (serviceFactory == null) {
                throw new NoServiceException("No connectable service factory for " + inServiceClass.getSimpleName());
            }
            SLF4JLoggerProxy.debug((Object)this, (String)"Creating {} service for {}", (Object[])new Object[]{inServiceClass.getSimpleName(), sessionUser});
            service = serviceFactory.create();
            PlatformServices.autowire((Object)service, (ApplicationContext)this.applicationContext);
        }
        if (!service.isRunning()) {
            SLF4JLoggerProxy.debug((Object)this, (String)"{} service exists for {}, but is not running", (Object[])new Object[]{inServiceClass.getSimpleName(), sessionUser});
            try {
                service.disconnect();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
            }
            try {
                SLF4JLoggerProxy.debug((Object)this, (String)"Connecting {} service for {}", (Object[])new Object[]{inServiceClass.getSimpleName(), sessionUser});
                ServerConnectionService.ServerConnectionData connectionData = this.serverConnectionService.getConnectionData();
                if (service.connect(sessionUser.getUsername(), sessionUser.getPassword(), connectionData.getHostname(), connectionData.getPort(), connectionData.useSsl())) {
                    SLF4JLoggerProxy.debug((Object)this, (String)"Created {} for {}", (Object[])new Object[]{service, sessionUser});
                    serviceCache.put((Object)inServiceClass.getSimpleName(), (Object)service);
                }
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Failed to connect {} service for {}", (Object[])new Object[]{inServiceClass.getSimpleName(), sessionUser});
                throw new NoServiceException("Failed to connect " + sessionUser + " to " + inServiceClass.getSimpleName(), e);
            }
        }
        if (!service.isRunning()) {
            SLF4JLoggerProxy.warn((Object)this, (String)"Failed to connect {} service for {}", (Object[])new Object[]{inServiceClass.getSimpleName(), sessionUser});
            throw new NoServiceException("Failed to connect " + sessionUser + " to " + inServiceClass.getSimpleName());
        }
        return (ServiceClazz)service;
    }

    public static ServiceManager getInstance() {
        return instance;
    }
}

