/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.service.admin;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.marketcetera.admin.AdminClient;
import org.marketcetera.admin.AdminRpcClientFactory;
import org.marketcetera.admin.AdminRpcClientParameters;
import org.marketcetera.admin.Permission;
import org.marketcetera.admin.Role;
import org.marketcetera.admin.User;
import org.marketcetera.admin.UserAttribute;
import org.marketcetera.admin.UserAttributeType;
import org.marketcetera.brokers.BrokerStatusListener;
import org.marketcetera.core.ClientStatusListener;
import org.marketcetera.fix.ActiveFixSession;
import org.marketcetera.fix.FixAdminClient;
import org.marketcetera.fix.FixAdminRpcClientFactory;
import org.marketcetera.fix.FixAdminRpcClientParameters;
import org.marketcetera.fix.FixSession;
import org.marketcetera.fix.FixSessionAttributeDescriptor;
import org.marketcetera.fix.FixSessionInstanceData;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.ui.service.ConnectableService;
import org.marketcetera.ui.service.ServiceManager;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.util.log.SLF4JLoggerProxy;

public class AdminClientService
implements ConnectableService {
    private AdminRpcClientFactory adminClientFactory;
    private FixAdminRpcClientFactory fixAdminClientFactory;
    private AdminClient adminClient;
    private FixAdminClient fixAdminClient;

    public static AdminClientService getInstance() {
        return ServiceManager.getInstance().getService(AdminClientService.class);
    }

    @Override
    public boolean isRunning() {
        return this.adminClient != null && this.adminClient.isRunning();
    }

    @Override
    public void disconnect() {
        if (this.adminClient != null) {
            try {
                this.adminClient.close();
            }
            catch (IOException e) {
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
            }
        }
        this.adminClient = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(String inUsername, String inPassword, String inHostname, int inPort, boolean inUseSsl) throws Exception {
        if (this.adminClient != null) {
            try {
                this.adminClient.stop();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)this, (String)"Unable to stop existing admin client for {}: {}", (Object[])new Object[]{inUsername, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
            finally {
                this.adminClient = null;
            }
        }
        SLF4JLoggerProxy.debug((Object)this, (String)"Creating admin client for {} to {}:{} with ssl: {}", (Object[])new Object[]{inUsername, inHostname, inPort, inUseSsl});
        AdminRpcClientParameters params = new AdminRpcClientParameters();
        params.setHostname(inHostname);
        params.setPort(inPort);
        params.setUsername(inUsername);
        params.setPassword(inPassword);
        params.setUseSsl(inUseSsl);
        this.adminClient = this.adminClientFactory.create(params);
        this.adminClient.start();
        if (this.fixAdminClient != null) {
            try {
                this.fixAdminClient.stop();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)this, (String)"Unable to stop existing fix admin client for {}: {}", (Object[])new Object[]{inUsername, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
            finally {
                this.fixAdminClient = null;
            }
        }
        SLF4JLoggerProxy.debug((Object)this, (String)"Creating fixAdmin client for {} to {}:{}", (Object[])new Object[]{inUsername, inHostname, inPort});
        FixAdminRpcClientParameters fixParams = new FixAdminRpcClientParameters();
        fixParams.setHostname(inHostname);
        fixParams.setPort(inPort);
        fixParams.setUsername(inUsername);
        fixParams.setPassword(inPassword);
        fixParams.setUseSsl(inUseSsl);
        this.fixAdminClient = this.fixAdminClientFactory.create(fixParams);
        this.fixAdminClient.start();
        if (this.adminClient.isRunning() && this.fixAdminClient.isRunning()) {
            SessionUser.getCurrent().setAttribute(AdminClientService.class, this);
        }
        return this.adminClient.isRunning() && this.fixAdminClient.isRunning();
    }

    public User getCurrentUser() {
        return this.adminClient.getCurrentUser();
    }

    public void addClientStatusListener(ClientStatusListener inListener) {
        this.adminClient.addClientStatusListener(inListener);
    }

    public void removeClientStatusListener(ClientStatusListener inListener) {
        this.adminClient.removeClientStatusListener(inListener);
    }

    public void changeUserPassword(String inUsername, String inOldPassword, String inNewPassword) {
        this.adminClient.changeUserPassword(inUsername, inOldPassword, inNewPassword);
    }

    public void createUser(User inSubject, String inPassword) {
        this.adminClient.createUser(inSubject, inPassword);
    }

    public Collection<User> getUsers() {
        return this.adminClient.readUsers();
    }

    public UserAttribute getUserAttribute(String inUsername, UserAttributeType inAttributeType) {
        return this.adminClient.getUserAttribute(inUsername, inAttributeType);
    }

    public void setUserAttribute(String inUsername, UserAttributeType inAttributeType, String inAttribute) {
        this.adminClient.setUserAttribute(inUsername, inAttributeType, inAttribute);
    }

    public CollectionPageResponse<User> getUsers(PageRequest inPageRequest) {
        return this.adminClient.readUsers(inPageRequest);
    }

    public void updateUser(String inName, User inSubject) {
        this.adminClient.updateUser(inName, inSubject);
    }

    public void deleteUser(String inName) {
        this.adminClient.deleteUser(inName);
    }

    public void deactivateUser(String inName) {
        this.adminClient.deactivateUser(inName);
    }

    public Collection<Role> getRoles() {
        return this.adminClient.readRoles();
    }

    public CollectionPageResponse<Role> getRoles(PageRequest inPageRequest) {
        return this.adminClient.readRoles(inPageRequest);
    }

    public Collection<Permission> getPermissions() {
        return this.adminClient.readPermissions();
    }

    public CollectionPageResponse<Permission> getPermissions(PageRequest inPageRequest) {
        return this.adminClient.readPermissions(inPageRequest);
    }

    public Set<Permission> getPermissionsForUser() {
        return this.adminClient.getPermissionsForCurrentUser();
    }

    public void deletePermission(String inName) {
        this.adminClient.deletePermission(inName);
    }

    public void deleteRole(String inName) {
        this.adminClient.deleteRole(inName);
    }

    public void updateRole(String inName, Role inRole) {
        this.adminClient.updateRole(inName, inRole);
    }

    public void createRole(Role inRole) {
        this.adminClient.createRole(inRole);
    }

    public Collection<ActiveFixSession> getFixSessions() {
        return this.fixAdminClient.readFixSessions();
    }

    public CollectionPageResponse<ActiveFixSession> getFixSessions(PageRequest inPageRequest) {
        return this.fixAdminClient.readFixSessions(inPageRequest);
    }

    public Collection<FixSessionAttributeDescriptor> getFixSessionAttributeDescriptors() {
        return this.fixAdminClient.getFixSessionAttributeDescriptors();
    }

    public FixSession createFixSession(FixSession inFixSession) {
        return this.fixAdminClient.createFixSession(inFixSession);
    }

    public void updateFixSession(String inIncomingName, FixSession inFixSession) {
        this.fixAdminClient.updateFixSession(inIncomingName, inFixSession);
    }

    public void enableSession(String inName) {
        this.fixAdminClient.enableFixSession(inName);
    }

    public void disableSession(String inName) {
        this.fixAdminClient.disableFixSession(inName);
    }

    public void deleteSession(String inName) {
        this.fixAdminClient.deleteFixSession(inName);
    }

    public void stopSession(String inName) {
        this.fixAdminClient.stopFixSession(inName);
    }

    public void startSession(String inName) {
        this.fixAdminClient.startFixSession(inName);
    }

    public void updateSequenceNumbers(String inSessionName, int inSenderSequenceNumber, int inTargetSequenceNumber) {
        this.fixAdminClient.updateSequenceNumbers(inSessionName, inSenderSequenceNumber, inTargetSequenceNumber);
    }

    public void updateSenderSequenceNumber(String inSessionName, int inSenderSequenceNumber) {
        this.fixAdminClient.updateSenderSequenceNumber(inSessionName, inSenderSequenceNumber);
    }

    public void updateTargetSequenceNumber(String inSessionName, int inTargetSequenceNumber) {
        this.fixAdminClient.updateTargetSequenceNumber(inSessionName, inTargetSequenceNumber);
    }

    public void createPermission(Permission inPermission) {
        this.adminClient.createPermission(inPermission);
    }

    public void updatePermission(String inPermissionName, Permission inPermission) {
        this.adminClient.updatePermission(inPermissionName, inPermission);
    }

    public FixSessionInstanceData getFixSessionInstanceData(int inAffinity) {
        return this.fixAdminClient.getFixSessionInstanceData(inAffinity);
    }

    public void addBrokerStatusListener(BrokerStatusListener inBrokerStatusListener) {
        this.fixAdminClient.addBrokerStatusListener(inBrokerStatusListener);
    }

    public void removeBrokerStatusListener(BrokerStatusListener inBrokerStatusListener) {
        this.fixAdminClient.removeBrokerStatusListener(inBrokerStatusListener);
    }

    public void setAdminClientFactory(AdminRpcClientFactory inAdminClientFactory) {
        this.adminClientFactory = inAdminClientFactory;
    }

    public void setFixAdminClientFactory(FixAdminRpcClientFactory inFixAdminClientFactory) {
        this.fixAdminClientFactory = inFixAdminClientFactory;
    }
}

