/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.service.admin;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.marketcetera.admin.Permission;
import org.marketcetera.ui.service.AuthorizationHelperService;
import org.marketcetera.ui.service.ServiceManager;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.ui.service.admin.AdminClientService;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Service;

@Service
public class WebAuthorizationHelperService
implements AuthorizationHelperService {
    @Value(value="${metc.user.authorization.permission.cache.ttl:300000}")
    private long userPermissionCacheTtl = 300000L;
    private LoadingCache<String, LoadingCache<String, Boolean>> permissionMapsByUsername;
    @Autowired
    private ServiceManager serviceManager;

    @Override
    public boolean hasPermission(GrantedAuthority inGrantedAuthority) {
        SessionUser sessionUser = SessionUser.getCurrent();
        if (sessionUser == null) {
            SLF4JLoggerProxy.trace((Object)this, (String)"No current user, permission {} is denied", (Object[])new Object[]{inGrantedAuthority});
            return false;
        }
        return (Boolean)((LoadingCache)this.permissionMapsByUsername.getUnchecked((Object)sessionUser.getUsername())).getUnchecked((Object)inGrantedAuthority.getAuthority());
    }

    @PostConstruct
    public void start() {
        this.permissionMapsByUsername = CacheBuilder.newBuilder().expireAfterAccess(this.userPermissionCacheTtl, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, LoadingCache<String, Boolean>>(){

            public LoadingCache<String, Boolean> load(final String inUsername) throws Exception {
                AdminClientService adminClientService = WebAuthorizationHelperService.this.serviceManager.getService(AdminClientService.class);
                final Set<Permission> permissions = adminClientService.getPermissionsForUser();
                LoadingCache permissionsByPermissionName = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Boolean>(){

                    public Boolean load(String inPermissionName) throws Exception {
                        SLF4JLoggerProxy.trace((Object)WebAuthorizationHelperService.this, (String)"Checking to see if {} has permission {} in {}", (Object[])new Object[]{inUsername, inPermissionName, permissions});
                        if (permissions == null) {
                            return false;
                        }
                        for (Permission permission : permissions) {
                            if (!permission.getAuthority().equals(inPermissionName)) continue;
                            return true;
                        }
                        return false;
                    }
                });
                return permissionsByPermissionName;
            }
        });
    }
}

