/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.service.impl;

import org.marketcetera.ui.service.ServerConnectionService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.stereotype.Service;

@Service
@EnableAutoConfiguration
public class ServerConnectionServiceImpl
implements ServerConnectionService {
    @Value(value="${metc.security.use.ssl:false}")
    private boolean useSsl;
    @Value(value="${host.name}")
    private String hostname;
    @Value(value="${host.port}")
    private int port;

    @Override
    public ServerConnectionService.ServerConnectionData getConnectionData() {
        return new ServerConnectionDataImpl(this.hostname, this.port, this.useSsl);
    }

    @Override
    public void setConnectionData(ServerConnectionService.ServerConnectionData inServerConnectionData) {
        this.hostname = inServerConnectionData.getHostname();
        this.port = inServerConnectionData.getPort();
        this.useSsl = inServerConnectionData.useSsl();
    }

    private static class ServerConnectionDataImpl
    implements ServerConnectionService.ServerConnectionData {
        private String hostname;
        private int port;
        private boolean useSsl;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ServerConnectionDataImpl [hostname=").append(this.hostname).append(", port=").append(this.port).append(", useSsl=").append(this.useSsl).append("]");
            return builder.toString();
        }

        private ServerConnectionDataImpl(String inHostname, int inPort, boolean inUseSsl) {
            this.hostname = inHostname;
            this.port = inPort;
            this.useSsl = inUseSsl;
        }

        @Override
        public String getHostname() {
            return this.hostname;
        }

        @Override
        public void setHostname(String inHostname) {
            this.hostname = inHostname;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public void setPort(int inPort) {
            this.port = inPort;
        }

        @Override
        public boolean useSsl() {
            return this.useSsl;
        }

        @Override
        public void setUseSsl(boolean inUseSsl) {
            this.useSsl = inUseSsl;
        }
    }
}

