/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.strategy.view;

import java.util.Date;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.marketcetera.strategy.StrategyInstance;
import org.marketcetera.strategy.StrategyStatus;

public class DisplayStrategyInstance {
    private final ObjectProperty<Date> startedProperty = new SimpleObjectProperty();
    private final StringProperty strategyNameProperty = new SimpleStringProperty();
    private final ObjectProperty<Period> uptimeProperty = new SimpleObjectProperty();
    private final StringProperty ownerProperty = new SimpleStringProperty();
    private final ObjectProperty<StrategyStatus> strategyStatusProperty = new SimpleObjectProperty();
    private final DoubleProperty uploadProgress = new SimpleDoubleProperty();

    public DisplayStrategyInstance(String inName, String inOwnerName) {
        this.strategyNameProperty.setValue(inName);
        this.ownerProperty.setValue(inOwnerName);
        this.strategyStatusProperty.setValue((Object)StrategyStatus.PREPARING);
        this.uploadProgress.setValue((Number)0.0);
        this.startedProperty.setValue(null);
        this.uptimeProperty.setValue((Object)new Period(0L));
        this.setupRuntimeListener();
    }

    public DisplayStrategyInstance(StrategyInstance inStrategyInstance) {
        this.strategyNameProperty.setValue(inStrategyInstance.getName());
        this.ownerProperty.setValue(inStrategyInstance.getUser().getName());
        this.strategyStatusProperty.setValue((Object)inStrategyInstance.getStatus());
        this.startedProperty.setValue((Object)inStrategyInstance.getStarted());
        this.setupRuntimeListener();
        this.updateRunningProperty();
    }

    public void updateRunningProperty() {
        if (this.startedProperty.get() == null || ((Date)this.startedProperty.get()).getTime() == 0L) {
            this.uptimeProperty.setValue((Object)new Period(0L));
        } else {
            this.uptimeProperty.setValue((Object)new Period(DateTime.now().minus(((Date)this.startedProperty.get()).getTime()).getMillis()));
        }
    }

    public ReadOnlyStringProperty strategyNameProperty() {
        return this.strategyNameProperty;
    }

    public ObjectProperty<Period> uptimeProperty() {
        return this.uptimeProperty;
    }

    public ReadOnlyStringProperty ownerProperty() {
        return this.ownerProperty;
    }

    public ObjectProperty<Date> startedProperty() {
        return this.startedProperty;
    }

    public ObjectProperty<StrategyStatus> strategyStatusProperty() {
        return this.strategyStatusProperty;
    }

    public DoubleProperty uploadProgressProperty() {
        return this.uploadProgress;
    }

    private void setupRuntimeListener() {
        this.strategyStatusProperty.addListener((observableValue, oldValue, newValue) -> this.updateRunningProperty());
    }
}

