/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.strategy.view;

import com.google.common.collect.Lists;
import info.schnatterer.mobynamesgenerator.MobyNamesGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.marketcetera.admin.User;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.core.notifications.INotification;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.strategy.FileUploadRequest;
import org.marketcetera.strategy.FileUploadStatus;
import org.marketcetera.strategy.SimpleFileUploadRequest;
import org.marketcetera.strategy.StrategyEventListener;
import org.marketcetera.strategy.StrategyInstance;
import org.marketcetera.strategy.StrategyMessage;
import org.marketcetera.strategy.StrategyPermissions;
import org.marketcetera.strategy.StrategyStatus;
import org.marketcetera.strategy.events.StrategyEvent;
import org.marketcetera.strategy.events.StrategyMessageEvent;
import org.marketcetera.strategy.events.StrategyStartFailedEvent;
import org.marketcetera.strategy.events.StrategyStartedEvent;
import org.marketcetera.strategy.events.StrategyStatusChangedEvent;
import org.marketcetera.strategy.events.StrategyStoppedEvent;
import org.marketcetera.strategy.events.StrategyUnloadedEvent;
import org.marketcetera.strategy.events.StrategyUploadFailedEvent;
import org.marketcetera.strategy.events.StrategyUploadSucceededEvent;
import org.marketcetera.ui.PhotonApp;
import org.marketcetera.ui.PhotonServices;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.events.NotificationEvent;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.ui.strategy.service.StrategyClientService;
import org.marketcetera.ui.strategy.view.DisplayStrategyInstance;
import org.marketcetera.ui.strategy.view.DisplayStrategyMessage;
import org.marketcetera.ui.view.AbstractContentView;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.nocrala.tools.texttablefmt.BorderStyle;
import org.nocrala.tools.texttablefmt.ShownBorders;
import org.nocrala.tools.texttablefmt.Table;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
@AutoConfiguration
@Scope(value="prototype")
public class StrategyView
extends AbstractContentView {
    private StrategyEventListener strategyEventListener;
    @Value(value="${metc.strategy.runtime.update.interval:1000}")
    private long strategyRuntimeUpdateInterval;
    private Timer strategyRuntimeUpdateTimer;
    private final String ALL_STRATEGIES = "<all strategies>";
    private int eventTableCurrentPage;
    private int eventTablePageSize;
    private Pagination eventTablePagination;
    private MenuItem startStrategyMenuItem;
    private MenuItem stopStrategyMenuItem;
    private MenuItem unloadStrategyMenuItem;
    private MenuItem clearEventsMenuItem;
    private MenuItem copyStrategyEventMenuItem;
    private MenuItem deleteStrategyEventMenuItem;
    private MenuItem cancelStrategyUploadMenuItem;
    private ContextMenu strategyTableContextMenu;
    private ContextMenu eventTableContextMenu;
    private ComboBox<String> strategyNameComboBox;
    private ComboBox<INotification.Severity> severityComboBox;
    private GridPane filterLayout;
    private VBox mainLayout;
    private HBox buttonLayout;
    private TableColumn<DisplayStrategyInstance, String> strategyNameColumn;
    private TableColumn<DisplayStrategyInstance, StrategyStatus> strategyStatusColumn;
    private TableColumn<DisplayStrategyInstance, Period> strategyUptimeColumn;
    private TableColumn<DisplayStrategyInstance, String> strategyOwnerColumn;
    private TableColumn<DisplayStrategyMessage, String> eventStrategyNameColumn;
    private TableColumn<DisplayStrategyMessage, DateTime> eventTimestampColumn;
    private TableColumn<DisplayStrategyMessage, INotification.Severity> eventSeverityColumn;
    private TableColumn<DisplayStrategyMessage, String> eventMessageColumn;
    private Button loadStrategyButton;
    private TableView<DisplayStrategyInstance> strategyTable;
    private TableView<DisplayStrategyMessage> eventTable;
    private StrategyClientService strategyClient;
    private static final String NAME = "Strategy View";

    @Override
    protected void onStart() {
        this.strategyClient = this.serviceManager.getService(StrategyClientService.class);
        this.mainLayout = new VBox(10.0);
        this.initializeStrategyTable();
        this.initializeEventTable();
        this.eventTableCurrentPage = 0;
        this.eventTablePageSize = 20;
        this.eventTablePagination = new Pagination();
        this.eventTablePagination.setPageCount(1);
        this.eventTablePagination.setCurrentPageIndex(this.eventTableCurrentPage);
        this.eventTablePagination.setMaxPageIndicatorCount(1);
        this.eventTablePagination.currentPageIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> inObservable, Number inOldValue, Number inNewValue) {
                StrategyView.this.eventTableCurrentPage = inNewValue.intValue();
                StrategyView.this.updateEvents();
            }
        });
        this.strategyNameComboBox = new ComboBox();
        this.strategyNameComboBox.getItems().add((Object)"<all strategies>");
        this.strategyNameComboBox.valueProperty().addListener((observableValue, oldValue, newValue) -> this.updateEvents());
        this.severityComboBox = new ComboBox();
        this.severityComboBox.getItems().addAll((Object[])INotification.Severity.values());
        this.severityComboBox.setValue((Object)INotification.Severity.INFO);
        this.severityComboBox.valueProperty().addListener((observableValue, oldValue, newValue) -> this.updateEvents());
        this.filterLayout = new GridPane();
        this.filterLayout.setHgap(10.0);
        this.filterLayout.setVgap(10.0);
        this.filterLayout.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        int rowCount = 0;
        int colCount = 0;
        this.filterLayout.add((Node)new Label("Strategy Name"), colCount, rowCount);
        this.filterLayout.add(this.strategyNameComboBox, ++colCount, rowCount);
        this.filterLayout.add((Node)new Label("Severity"), ++colCount, rowCount);
        this.filterLayout.add(this.severityComboBox, ++colCount, rowCount);
        this.loadStrategyButton = new Button("Load Strategy");
        this.loadStrategyButton.setDisable(!this.authzHelperService.hasPermission((GrantedAuthority)StrategyPermissions.LoadStrategyAction));
        this.loadStrategyButton.setOnAction(event -> this.loadStrategy());
        this.buttonLayout = new HBox(10.0);
        this.buttonLayout.getChildren().add((Object)this.loadStrategyButton);
        this.strategyTable.prefWidthProperty().bind((ObservableValue)this.mainLayout.widthProperty());
        this.eventTable.prefWidthProperty().bind((ObservableValue)this.mainLayout.widthProperty());
        this.strategyTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.eventTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.mainLayout.getChildren().addAll((Object[])new Node[]{this.strategyTable, new Separator(Orientation.HORIZONTAL), this.buttonLayout, new Separator(Orientation.HORIZONTAL), this.filterLayout, this.eventTable, this.eventTablePagination});
        this.updateStrategies();
        this.updateEvents();
        this.initializeStrategyEventListener();
        this.strategyRuntimeUpdateTimer = new Timer();
        this.strategyRuntimeUpdateTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    StrategyView.this.updateStrategyRuntime();
                }
                catch (Exception e) {
                    SLF4JLoggerProxy.warn((Object)StrategyView.this, (Throwable)e);
                }
            }
        }, new Date(System.currentTimeMillis() + this.strategyRuntimeUpdateInterval), this.strategyRuntimeUpdateInterval);
    }

    @Override
    public void onClose() {
        try {
            this.strategyRuntimeUpdateTimer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.strategyEventListener != null) {
            try {
                this.strategyClient.removeStrategyEventListener(this.strategyEventListener);
                this.strategyEventListener = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.onClose();
    }

    @Override
    public Region getMainLayout() {
        return this.mainLayout;
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    protected void onClientConnect() {
        this.updateStrategies();
        this.updateEvents();
        this.initializeStrategyEventListener();
    }

    @Override
    protected void onClientDisconnect() {
        Platform.runLater(() -> {
            this.strategyTable.getItems().clear();
            this.eventTable.getItems().clear();
        });
    }

    public StrategyView(Region inParent, NewWindowEvent inEvent, Properties inProperties) {
        super(inParent, inEvent, inProperties);
    }

    private void initializeStrategyEventListener() {
        if (this.strategyEventListener != null) {
            try {
                this.strategyClient.removeStrategyEventListener(this.strategyEventListener);
                this.strategyEventListener = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.strategyEventListener = new StrategyEventListener(){

            public void receiveStrategyEvent(final StrategyEvent inEvent) {
                SLF4JLoggerProxy.trace((Object)StrategyView.this, (String)"Received {}", (Object[])new Object[]{inEvent});
                String instanceName = inEvent.getStrategyInstance().getName();
                DisplayStrategyInstance strategyToUpdate = null;
                for (DisplayStrategyInstance strategy : StrategyView.this.strategyTable.getItems()) {
                    if (!((String)strategy.strategyNameProperty().get()).equals(instanceName)) continue;
                    strategyToUpdate = strategy;
                    break;
                }
                if (strategyToUpdate != null) {
                    final DisplayStrategyInstance displayStrategyInstance = strategyToUpdate;
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (inEvent instanceof StrategyStoppedEvent) {
                                displayStrategyInstance.startedProperty().set(null);
                            } else if (inEvent instanceof StrategyStartedEvent) {
                                displayStrategyInstance.startedProperty().set((Object)inEvent.getStrategyInstance().getStarted());
                            } else if (!(inEvent instanceof StrategyUploadFailedEvent) && !(inEvent instanceof StrategyUploadSucceededEvent)) {
                                if (inEvent instanceof StrategyStartFailedEvent) {
                                    StrategyStartFailedEvent event = (StrategyStartFailedEvent)inEvent;
                                    SLF4JLoggerProxy.warn((Object)this, (String)"Received strategy start failed event: {}", (Object[])new Object[]{inEvent});
                                    StrategyView.this.uiMessageService.post(new NotificationEvent("Start Strategy", "Strategy strategy failed: " + event.getErrorMessage(), Alert.AlertType.INFORMATION));
                                } else if (inEvent instanceof StrategyStatusChangedEvent) {
                                    StrategyStatusChangedEvent event = (StrategyStatusChangedEvent)inEvent;
                                    displayStrategyInstance.strategyStatusProperty().set((Object)event.getNewValue());
                                } else if (inEvent instanceof StrategyUnloadedEvent) {
                                    StrategyView.this.strategyTable.getItems().remove((Object)displayStrategyInstance);
                                } else if (inEvent instanceof StrategyMessageEvent) {
                                    StrategyView.this.updateEvents();
                                }
                            }
                        }
                    });
                } else {
                    StrategyView.this.updateStrategies();
                    StrategyView.this.updateEvents();
                }
            }
        };
        this.strategyClient.addStrategyEventListener(this.strategyEventListener);
    }

    private void updateStrategyRuntime() {
        Platform.runLater(() -> {
            for (DisplayStrategyInstance displayStrategyInstance : this.strategyTable.getItems()) {
                displayStrategyInstance.updateRunningProperty();
            }
        });
    }

    private void updateEvents() {
        PageRequest pageRequest = new PageRequest(this.eventTableCurrentPage, this.eventTablePageSize);
        String selectedStrategyName = (String)this.strategyNameComboBox.valueProperty().get();
        final CollectionPageResponse<? extends StrategyMessage> response = this.strategyClient.getStrategyMessages(selectedStrategyName == null || "<all strategies>".equals(selectedStrategyName) ? null : selectedStrategyName, (INotification.Severity)this.severityComboBox.getValue(), pageRequest);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                StrategyView.this.eventTablePagination.setPageCount(response.getTotalPages());
                StrategyView.this.eventTablePagination.setCurrentPageIndex(StrategyView.this.eventTableCurrentPage);
                StrategyView.this.eventTable.getItems().clear();
                for (StrategyMessage strategyMessage : response.getElements()) {
                    StrategyView.this.eventTable.getItems().add((Object)new DisplayStrategyMessage(strategyMessage));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStrategy() {
        Optional<User> ownerOption = PhotonServices.getCurrentUser();
        if (ownerOption.isEmpty()) {
            SLF4JLoggerProxy.warn((Object)this, (String)"Cannot load a strategy because the current user cannot be determined");
            this.uiMessageService.post(new NotificationEvent("Load Strategy", "Cannot load a new strategy because the current user cannot be determined", Alert.AlertType.ERROR));
            return;
        }
        User owner = ownerOption.get();
        FileChooser strategyFileChooser = new FileChooser();
        strategyFileChooser.setTitle("Choose the Strategy JAR File");
        strategyFileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("JAR Files", new String[]{"*.jar"}));
        File result = strategyFileChooser.showOpenDialog((Window)PhotonApp.getPrimaryStage());
        if (result != null) {
            if (!result.exists() || !result.canRead()) {
                this.uiMessageService.post(new NotificationEvent("Load Strategy", "File '" + result.getAbsolutePath() + "' could not be read", Alert.AlertType.WARNING));
                return;
            }
            String name = MobyNamesGenerator.getRandomName();
            Dialog nameConfirmationDialog = new Dialog();
            GridPane nameConfirmationGrid = new GridPane();
            nameConfirmationGrid.setHgap(10.0);
            nameConfirmationGrid.setVgap(10.0);
            nameConfirmationGrid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
            TextField nameField = new TextField();
            Label adviceLabel = new Label();
            int rowCount = 0;
            int colCount = 0;
            nameConfirmationGrid.add((Node)new Label("Strategy Name"), colCount, rowCount);
            nameConfirmationGrid.add((Node)nameField, ++colCount, rowCount);
            colCount = 0;
            nameConfirmationGrid.add((Node)adviceLabel, colCount, ++rowCount, 2, 1);
            colCount = 0;
            SimpleBooleanProperty disableOkButton = new SimpleBooleanProperty(false);
            ButtonType okButtonType = new ButtonType("Ok", ButtonBar.ButtonData.OK_DONE);
            ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
            nameField.textProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$loadStrategy$5(adviceLabel, nameField, (BooleanProperty)disableOkButton, arg_0, arg_1, arg_2));
            nameField.textProperty().set((Object)name);
            DialogPane nameConfirmationDialogPane = new DialogPane();
            nameConfirmationDialogPane.setContent((Node)nameConfirmationGrid);
            nameConfirmationDialog.dialogPaneProperty().set((Object)nameConfirmationDialogPane);
            nameConfirmationDialog.setTitle("Confirm Strategy Name");
            nameConfirmationDialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{okButtonType, cancelButton});
            nameConfirmationDialog.getDialogPane().lookupButton(okButtonType).disableProperty().bind((ObservableValue)disableOkButton);
            PhotonServices.style(nameConfirmationDialog);
            nameConfirmationDialog.initModality(Modality.APPLICATION_MODAL);
            nameConfirmationDialog.setResultConverter(dialogButton -> {
                if (dialogButton == okButtonType) {
                    return StringUtils.trimToNull((String)nameField.getText());
                }
                return null;
            });
            Optional nameOption = nameConfirmationDialog.showAndWait();
            if (nameOption.isEmpty()) {
                this.uiMessageService.post(new NotificationEvent("Load Strategy", "Strategy load canceled", Alert.AlertType.INFORMATION));
                return;
            }
            name = (String)nameOption.get();
            String nonce = UUID.randomUUID().toString();
            final DisplayStrategyInstance newItem = new DisplayStrategyInstance(name, owner.getName());
            this.strategyTable.getItems().add((Object)newItem);
            try {
                this.getMainLayout().setCursor(Cursor.WAIT);
                SimpleFileUploadRequest uploadRequest = new SimpleFileUploadRequest(name, nonce, result.getAbsolutePath(), owner){

                    public void onProgress(double inPercentComplete) {
                        SLF4JLoggerProxy.trace(StrategyView.class, (String)"Reporting file upload progress: {}", (Object[])new Object[]{inPercentComplete});
                        Platform.runLater(() -> newItem.uploadProgressProperty().set(inPercentComplete));
                    }

                    public void onStatus(FileUploadStatus inStatus) {
                        SLF4JLoggerProxy.trace(StrategyView.class, (String)"Reporting file upload status: {}", (Object[])new Object[]{inStatus});
                        switch (inStatus) {
                            case SUCCESS: 
                            case FAILED: {
                                break;
                            }
                            case IN_PROGRESS: 
                            case PENDING: {
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("Unexpected file upload status: " + inStatus);
                            }
                        }
                    }

                    public void onError(Throwable inThrowable) {
                        SLF4JLoggerProxy.trace(StrategyView.class, (Throwable)inThrowable, (String)"Reporting file upload error", (Object[])new Object[0]);
                    }
                };
                this.strategyClient.uploadFile((FileUploadRequest)uploadRequest);
                this.updateStrategies();
                this.uiMessageService.post(new NotificationEvent("Load Strategy", "Strategy '" + name + "' loaded", Alert.AlertType.INFORMATION));
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Unable to create '{}'", (Object[])new Object[]{name});
                this.uiMessageService.post(new NotificationEvent("Load Strategy", "File '" + result.getAbsolutePath() + "' could not be read", Alert.AlertType.WARNING));
            }
            finally {
                this.getMainLayout().setCursor(Cursor.DEFAULT);
            }
        }
    }

    private void unloadStrategy(DisplayStrategyInstance inSelectedItem) {
        if (inSelectedItem == null) {
            return;
        }
        SLF4JLoggerProxy.info((Object)this, (String)"{} unloading strategy instance {}", (Object[])new Object[]{SessionUser.getCurrent().getUsername(), inSelectedItem.strategyNameProperty().get()});
        this.strategyClient.unloadStrategyInstance((String)inSelectedItem.strategyNameProperty().get());
        this.updateStrategies();
    }

    private void cancelStrategyUpload(DisplayStrategyInstance inSelectedItem) {
    }

    private void updateStrategies() {
        Platform.runLater(() -> {
            String selectedStrategyName = (String)this.strategyNameComboBox.valueProperty().get();
            this.strategyNameComboBox.getItems().clear();
            this.strategyTable.getItems().clear();
            Collection<? extends StrategyInstance> results = this.strategyClient.getStrategyInstances();
            if (results == null) {
                return;
            }
            ArrayList displayStrategies = Lists.newArrayList();
            ArrayList strategyNames = Lists.newArrayList();
            results.forEach(result -> {
                displayStrategies.add(new DisplayStrategyInstance((StrategyInstance)result));
                strategyNames.add(result.getName());
            });
            Collections.sort(strategyNames);
            this.strategyNameComboBox.getItems().add((Object)"<all strategies>");
            this.strategyNameComboBox.getItems().addAll((Collection)strategyNames);
            this.strategyTable.getItems().addAll((Collection)displayStrategies);
            if (this.strategyNameComboBox.getItems().contains((Object)selectedStrategyName)) {
                this.strategyNameComboBox.valueProperty().set((Object)selectedStrategyName);
            } else {
                this.strategyNameComboBox.valueProperty().set((Object)"<all strategies>");
            }
        });
    }

    private void initializeStrategyTable() {
        this.strategyTable = new TableView();
        this.strategyTable.setPlaceholder((Node)new Label("no loaded strategies"));
        this.initializeStrategyTableColumns();
        this.initializeStrategyContextMenu();
        this.strategyTable.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
    }

    private void initializeEventTable() {
        this.eventTable = new TableView();
        this.eventTable.setPlaceholder((Node)new Label("no strategy events to display"));
        this.initializeEventTableColumns();
        this.initializeEventContextMenu();
        this.eventTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    private void initializeEventTableColumns() {
        this.eventStrategyNameColumn = new TableColumn("Strategy");
        this.eventStrategyNameColumn.setCellValueFactory((Callback)new PropertyValueFactory("strategyName"));
        this.eventTimestampColumn = new TableColumn("Timestamp");
        this.eventTimestampColumn.setCellValueFactory((Callback)new PropertyValueFactory("timestamp"));
        this.eventTimestampColumn.setCellFactory(tableColumn -> PhotonServices.renderDateTimeCell(tableColumn));
        this.eventSeverityColumn = new TableColumn("Severity");
        this.eventSeverityColumn.setCellValueFactory((Callback)new PropertyValueFactory("severity"));
        this.eventMessageColumn = new TableColumn("Message");
        this.eventMessageColumn.setCellValueFactory((Callback)new PropertyValueFactory("message"));
        this.eventTable.getColumns().add(this.eventStrategyNameColumn);
        this.eventTable.getColumns().add(this.eventTimestampColumn);
        this.eventTable.getColumns().add(this.eventSeverityColumn);
        this.eventTable.getColumns().add(this.eventMessageColumn);
    }

    private void initializeStrategyTableColumns() {
        this.strategyNameColumn = new TableColumn("Name");
        this.strategyNameColumn.setCellValueFactory((Callback)new PropertyValueFactory("strategyName"));
        this.strategyStatusColumn = new TableColumn("Status");
        this.strategyStatusColumn.setCellValueFactory((Callback)new PropertyValueFactory("strategyStatus"));
        this.strategyUptimeColumn = new TableColumn("Uptime");
        this.strategyUptimeColumn.setCellValueFactory((Callback)new PropertyValueFactory("uptime"));
        this.strategyUptimeColumn.setCellFactory(tableColumn -> PhotonServices.renderPeriodCell(tableColumn));
        this.strategyOwnerColumn = new TableColumn("Owner");
        this.strategyOwnerColumn.setCellValueFactory((Callback)new PropertyValueFactory("owner"));
        this.strategyTable.getColumns().add(this.strategyNameColumn);
        this.strategyTable.getColumns().add(this.strategyStatusColumn);
        this.strategyTable.getColumns().add(this.strategyUptimeColumn);
        this.strategyTable.getColumns().add(this.strategyOwnerColumn);
        this.strategyTable.getSelectionModel().selectedItemProperty().addListener((inObservable, inOldValue, inNewValue) -> this.enableStrategyContextMenuItems((DisplayStrategyInstance)inNewValue));
    }

    private Collection<DisplayStrategyMessage> getSelectedMessages() {
        return this.eventTable.getSelectionModel().getSelectedItems();
    }

    private String renderStrategyMessages(Collection<DisplayStrategyMessage> inStrategyMessages) {
        Table table = new Table(4, BorderStyle.CLASSIC_COMPATIBLE_WIDE, ShownBorders.ALL, false);
        table.addCell("Strategy Messages", PlatformServices.cellStyle, 4);
        table.addCell("Timestamp", PlatformServices.cellStyle);
        table.addCell("Strategy", PlatformServices.cellStyle);
        table.addCell("Severity", PlatformServices.cellStyle);
        table.addCell("Message", PlatformServices.cellStyle);
        for (DisplayStrategyMessage message : inStrategyMessages) {
            table.addCell(String.valueOf(message.timestampProperty().get()));
            table.addCell((String)message.strategyNameProperty().get());
            table.addCell(((INotification.Severity)message.severityProperty().get()).name());
            table.addCell((String)message.messageProperty().get());
        }
        return table.render();
    }

    private void initializeEventContextMenu() {
        this.eventTableContextMenu = new ContextMenu();
        this.copyStrategyEventMenuItem = new MenuItem("Copy");
        this.copyStrategyEventMenuItem.setOnAction(event -> {
            Collection<DisplayStrategyMessage> selectedItems = this.getSelectedMessages();
            if (selectedItems == null || selectedItems.isEmpty()) {
                return;
            }
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.putString(this.renderStrategyMessages(selectedItems));
            clipboard.setContent((Map)clipboardContent);
        });
        this.deleteStrategyEventMenuItem = new MenuItem("Delete");
        this.deleteStrategyEventMenuItem.setOnAction(event -> {
            Collection<DisplayStrategyMessage> selectedItems = this.getSelectedMessages();
            if (selectedItems == null || selectedItems.isEmpty()) {
                return;
            }
            for (DisplayStrategyMessage message : selectedItems) {
                try {
                    this.strategyClient.deleteStrategyMessage(message.strategyIdProperty().get());
                    this.uiMessageService.post(new NotificationEvent("Delete Strategy", "Strategy message deleted", Alert.AlertType.INFORMATION));
                    this.updateEvents();
                }
                catch (Exception e) {
                    String errorMessage = PlatformServices.getMessage((Throwable)e);
                    this.uiMessageService.post(new NotificationEvent("Delete Strategy Message", "Unable to delete strategy message: " + errorMessage, Alert.AlertType.ERROR));
                }
            }
        });
        this.eventTableContextMenu.getItems().addAll((Object[])new MenuItem[]{this.copyStrategyEventMenuItem, new SeparatorMenuItem(), this.deleteStrategyEventMenuItem});
        this.eventTable.setContextMenu(this.eventTableContextMenu);
    }

    private void enableStrategyContextMenuItems(DisplayStrategyInstance inNewValue) {
        if (inNewValue == null) {
            this.startStrategyMenuItem.setDisable(true);
            this.stopStrategyMenuItem.setDisable(true);
            this.unloadStrategyMenuItem.setDisable(true);
            this.clearEventsMenuItem.setDisable(true);
            return;
        }
        StrategyStatus status = (StrategyStatus)inNewValue.strategyStatusProperty().get();
        switch (status) {
            case ERROR: {
                this.startStrategyMenuItem.setDisable(false);
                this.stopStrategyMenuItem.setDisable(true);
                this.unloadStrategyMenuItem.setDisable(false);
                this.clearEventsMenuItem.setDisable(false);
                this.cancelStrategyUploadMenuItem.setDisable(true);
                break;
            }
            case RUNNING: {
                this.startStrategyMenuItem.setDisable(true);
                this.stopStrategyMenuItem.setDisable(false);
                this.unloadStrategyMenuItem.setDisable(true);
                this.clearEventsMenuItem.setDisable(false);
                this.cancelStrategyUploadMenuItem.setDisable(true);
                break;
            }
            case STOPPED: {
                this.startStrategyMenuItem.setDisable(false);
                this.stopStrategyMenuItem.setDisable(true);
                this.unloadStrategyMenuItem.setDisable(false);
                this.clearEventsMenuItem.setDisable(false);
                this.cancelStrategyUploadMenuItem.setDisable(true);
                break;
            }
            case LOADING: 
            case PREPARING: {
                this.startStrategyMenuItem.setDisable(true);
                this.stopStrategyMenuItem.setDisable(true);
                this.unloadStrategyMenuItem.setDisable(true);
                this.clearEventsMenuItem.setDisable(true);
                this.cancelStrategyUploadMenuItem.setDisable(false);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected strategy status: " + status);
            }
        }
    }

    private void initializeStrategyContextMenu() {
        this.strategyTableContextMenu = new ContextMenu();
        this.startStrategyMenuItem = new MenuItem("Start");
        this.stopStrategyMenuItem = new MenuItem("Stop");
        this.unloadStrategyMenuItem = new MenuItem("Unload");
        this.clearEventsMenuItem = new MenuItem("Clear Events");
        this.cancelStrategyUploadMenuItem = new MenuItem("Cancel Upload");
        this.unloadStrategyMenuItem.setOnAction(event -> {
            DisplayStrategyInstance selectedStrategy = (DisplayStrategyInstance)this.strategyTable.getSelectionModel().getSelectedItem();
            if (selectedStrategy == null) {
                return;
            }
            this.unloadStrategy(selectedStrategy);
        });
        this.cancelStrategyUploadMenuItem.setOnAction(event -> {
            DisplayStrategyInstance selectedStrategy = (DisplayStrategyInstance)this.strategyTable.getSelectionModel().getSelectedItem();
            if (selectedStrategy == null) {
                return;
            }
            this.cancelStrategyUpload(selectedStrategy);
        });
        this.startStrategyMenuItem.setOnAction(event -> {
            DisplayStrategyInstance selectedStrategy = (DisplayStrategyInstance)this.strategyTable.getSelectionModel().getSelectedItem();
            if (selectedStrategy == null) {
                return;
            }
            this.startStrategy(selectedStrategy);
        });
        this.stopStrategyMenuItem.setOnAction(event -> {
            DisplayStrategyInstance selectedStrategy = (DisplayStrategyInstance)this.strategyTable.getSelectionModel().getSelectedItem();
            if (selectedStrategy == null) {
                return;
            }
            this.stopStrategy(selectedStrategy);
        });
        this.clearEventsMenuItem.setOnAction(event -> {
            DisplayStrategyInstance selectedStrategy = (DisplayStrategyInstance)this.strategyTable.getSelectionModel().getSelectedItem();
            if (selectedStrategy == null) {
                return;
            }
            try {
                this.strategyClient.deleteAllStrategyMessages((String)selectedStrategy.strategyNameProperty().get());
                this.uiMessageService.post(new NotificationEvent("Delete All Strategy Messages", "Strategy messages deleted", Alert.AlertType.INFORMATION));
                this.updateEvents();
            }
            catch (Exception e) {
                String errorMessage = PlatformServices.getMessage((Throwable)e);
                this.uiMessageService.post(new NotificationEvent("Delete Strategy All Messages", "Unable to delete strategy messages: " + errorMessage, Alert.AlertType.ERROR));
            }
        });
        boolean firstGroup = false;
        if (this.authzHelperService.hasPermission((GrantedAuthority)StrategyPermissions.StartStrategyAction)) {
            firstGroup = true;
            this.strategyTableContextMenu.getItems().add((Object)this.startStrategyMenuItem);
        }
        if (this.authzHelperService.hasPermission((GrantedAuthority)StrategyPermissions.StopStrategyAction)) {
            firstGroup = true;
            this.strategyTableContextMenu.getItems().add((Object)this.stopStrategyMenuItem);
        }
        if (this.authzHelperService.hasPermission((GrantedAuthority)StrategyPermissions.UnloadStrategyAction)) {
            firstGroup = true;
            this.strategyTableContextMenu.getItems().add((Object)this.unloadStrategyMenuItem);
        }
        if (this.authzHelperService.hasPermission((GrantedAuthority)StrategyPermissions.ClearStrategyEventsAction)) {
            if (firstGroup) {
                this.strategyTableContextMenu.getItems().add((Object)new SeparatorMenuItem());
            }
            this.strategyTableContextMenu.getItems().add((Object)this.clearEventsMenuItem);
        }
        this.strategyTable.setContextMenu(this.strategyTableContextMenu);
    }

    private void stopStrategy(DisplayStrategyInstance inSelectedStrategy) {
        SLF4JLoggerProxy.info((Object)this, (String)"{} stopping '{}'", (Object[])new Object[]{SessionUser.getCurrent().getUsername(), inSelectedStrategy.strategyNameProperty().get()});
        try {
            this.strategyClient.stopStrategyInstance((String)inSelectedStrategy.strategyNameProperty().get());
            this.uiMessageService.post(new NotificationEvent("Stop Strategy", "Strategy '" + (String)inSelectedStrategy.strategyNameProperty().get() + " stopped", Alert.AlertType.INFORMATION));
        }
        catch (Exception e) {
            SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
            this.uiMessageService.post(new NotificationEvent("Stop Strategy", "Strategy '" + (String)inSelectedStrategy.strategyNameProperty().get() + " stop failed: " + PlatformServices.getMessage((Throwable)e), Alert.AlertType.ERROR));
        }
        this.updateStrategies();
    }

    private void startStrategy(DisplayStrategyInstance inSelectedStrategy) {
        SLF4JLoggerProxy.info((Object)this, (String)"{} starting '{}'", (Object[])new Object[]{SessionUser.getCurrent().getUsername(), inSelectedStrategy.strategyNameProperty().get()});
        try {
            this.strategyClient.startStrategyInstance((String)inSelectedStrategy.strategyNameProperty().get());
            this.uiMessageService.post(new NotificationEvent("Start Strategy", "Strategy '" + (String)inSelectedStrategy.strategyNameProperty().get() + " started", Alert.AlertType.INFORMATION));
        }
        catch (Exception e) {
            SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
            this.uiMessageService.post(new NotificationEvent("Start Strategy", "Strategy '" + (String)inSelectedStrategy.strategyNameProperty().get() + " start failed: " + PlatformServices.getMessage((Throwable)e), Alert.AlertType.ERROR));
        }
        this.updateStrategies();
    }

    private /* synthetic */ void lambda$loadStrategy$5(Label adviceLabel, TextField nameField, BooleanProperty disableOkButton, ObservableValue observableValue, String oldValue, String newValue) {
        String value = StringUtils.trimToNull((String)newValue);
        adviceLabel.textProperty().set((Object)"");
        adviceLabel.setStyle(PhotonServices.successMessage);
        nameField.setStyle(PhotonServices.successStyle);
        if (value == null) {
            adviceLabel.textProperty().set((Object)"Unique name required");
            adviceLabel.setStyle(PhotonServices.errorMessage);
            nameField.setStyle(PhotonServices.errorStyle);
            disableOkButton.set(true);
            return;
        }
        Optional<? extends StrategyInstance> strategyInstanceOption = this.strategyClient.findByName(value);
        if (strategyInstanceOption.isPresent()) {
            adviceLabel.textProperty().set((Object)"Unique name required");
            adviceLabel.setStyle(PhotonServices.errorMessage);
            nameField.setStyle(PhotonServices.errorStyle);
            disableOkButton.set(true);
        } else {
            adviceLabel.textProperty().set((Object)"");
            adviceLabel.setStyle(PhotonServices.successMessage);
            nameField.setStyle(PhotonServices.successStyle);
            disableOkButton.set(false);
        }
    }
}

