/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.strategy.view;

import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.marketcetera.core.Pair;
import org.marketcetera.strategy.StrategyPermissions;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.strategy.view.StrategyContentCategory;
import org.marketcetera.ui.strategy.view.StrategyView;
import org.marketcetera.ui.view.AbstractContentViewFactory;
import org.marketcetera.ui.view.ContentView;
import org.marketcetera.ui.view.ContentViewFactory;
import org.marketcetera.ui.view.MenuContent;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class StrategyViewFactory
extends AbstractContentViewFactory
implements MenuContent {
    private static final Set<GrantedAuthority> requiredPermissions = Collections.unmodifiableSet(Sets.newHashSet((Object[])new StrategyPermissions[]{StrategyPermissions.ReadStrategyAction}));

    @Override
    public String getMenuCaption() {
        return "Strategy Control";
    }

    @Override
    public int getWeight() {
        return 100;
    }

    @Override
    public MenuContent getCategory() {
        return StrategyContentCategory.instance;
    }

    @Override
    public URL getMenuIcon() {
        return this.getClass().getClassLoader().getResource("images/puzzle-piece.svg");
    }

    @Override
    public Runnable getCommand() {
        return new Runnable(){

            @Override
            public void run() {
                StrategyViewFactory.this.webMessageService.post(new NewWindowEvent(){

                    @Override
                    public Pair<Double, Double> getWindowSize() {
                        return Pair.create((Object)530.0, (Object)400.0);
                    }

                    @Override
                    public String getWindowTitle() {
                        return StrategyViewFactory.this.getMenuCaption();
                    }

                    @Override
                    public Class<? extends ContentViewFactory> getViewFactoryType() {
                        return StrategyViewFactory.class;
                    }
                });
            }
        };
    }

    @Override
    protected Class<? extends ContentView> getViewType() {
        return StrategyView.class;
    }

    @Override
    public Set<GrantedAuthority> getAllPermissions() {
        return requiredPermissions;
    }
}

