/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.trade.view;

import java.util.Collection;
import java.util.Properties;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableView;
import javafx.scene.layout.Region;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.trade.TradePermissions;
import org.marketcetera.ui.PhotonServices;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.events.NotificationEvent;
import org.marketcetera.ui.trade.view.AbstractFixMessageView;
import org.marketcetera.ui.trade.view.DeletableFixMessageDisplayType;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.security.core.GrantedAuthority;

public abstract class AbstractDeletableFixMessageView<FixClazz extends DeletableFixMessageDisplayType, ClientClazz>
extends AbstractFixMessageView<FixClazz, ClientClazz> {
    private MenuItem deleteReportMenuItem;

    protected AbstractDeletableFixMessageView(Region inParentWindow, NewWindowEvent inEvent, Properties inViewProperties) {
        super(inParentWindow, inEvent, inViewProperties);
    }

    @Override
    protected void initializeContextMenu(TableView<FixClazz> inTableView) {
        super.initializeContextMenu(inTableView);
        ContextMenu reportsTableContextMenu = inTableView.getContextMenu();
        SeparatorMenuItem contextMenuSeparator = new SeparatorMenuItem();
        this.deleteReportMenuItem = new MenuItem("Delete Report");
        this.deleteReportMenuItem.setOnAction(event -> {
            DeletableFixMessageDisplayType report = (DeletableFixMessageDisplayType)inTableView.getSelectionModel().getSelectedItem();
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle("Delete Report " + report.getReportID());
            alert.setContentText("Deleting a report may modify positions, continue?");
            ButtonType okButton = new ButtonType("Ok", ButtonBar.ButtonData.OK_DONE);
            ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
            alert.getButtonTypes().setAll((Object[])new ButtonType[]{okButton, cancelButton});
            PhotonServices.style(alert);
            alert.showAndWait().ifPresent(type -> {
                if (type == okButton) {
                    try {
                        this.tradeClientService.deleteReport(report.getReportID());
                        this.updateReports();
                        this.uiMessageService.post(new NotificationEvent("Delete Report", "Report " + report.getReportID() + " deleted", Alert.AlertType.INFORMATION));
                    }
                    catch (Exception e) {
                        SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Unable to delete {}", (Object[])new Object[]{report});
                        this.uiMessageService.post(new NotificationEvent("Delete Report", "Report " + report.getReportID() + " not deleted: " + PlatformServices.getMessage((Throwable)e), Alert.AlertType.ERROR));
                    }
                } else {
                    return;
                }
            });
        });
        if (this.authzHelperService.hasPermission((GrantedAuthority)TradePermissions.DeleteReportAction)) {
            reportsTableContextMenu.getItems().addAll((Object[])new MenuItem[]{contextMenuSeparator, this.deleteReportMenuItem});
        }
    }

    @Override
    protected void enableContextMenuItems(Collection<FixClazz> inSelectedItems) {
        super.enableContextMenuItems(inSelectedItems);
        if (inSelectedItems == null || inSelectedItems.isEmpty()) {
            this.deleteReportMenuItem.setDisable(true);
            return;
        }
        this.deleteReportMenuItem.setDisable(false);
    }
}

