/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.trade.view;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.core.time.TimeFactoryImpl;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.quickfix.FIXMessageUtil;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Order;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.TradeMessage;
import org.marketcetera.trade.TradeMessageListener;
import org.marketcetera.trade.TradePermissions;
import org.marketcetera.trade.client.SendOrderResponse;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.events.NotificationEvent;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.ui.service.trade.TradeClientService;
import org.marketcetera.ui.trade.event.FixMessageDetailsViewEvent;
import org.marketcetera.ui.trade.event.ReplaceOrderEvent;
import org.marketcetera.ui.trade.executionreport.view.FixMessageDisplayType;
import org.marketcetera.ui.view.AbstractContentView;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.quickfix.AnalyzedMessage;
import org.springframework.security.core.GrantedAuthority;
import quickfix.FieldMap;
import quickfix.Message;

public abstract class AbstractFixMessageView<FixClazz extends FixMessageDisplayType, ClientClazz>
extends AbstractContentView {
    protected static final DateTimeFormatter isoDateFormatter = TimeFactoryImpl.FULL_MILLISECONDS;
    protected TradeClientService tradeClientService;
    protected int currentPage;
    protected int pageSize;
    protected VBox mainLayout;
    protected Pagination pagination;
    protected TableView<FixClazz> reportsTableView;
    protected ContextMenu reportsTableContextMenu;
    protected TableColumn<FixClazz, Date> transactTimeColumn;
    protected TableColumn<FixClazz, Date> sendingTimeColumn;
    protected TableColumn<FixClazz, OrderID> orderIdColumn;
    protected TableColumn<FixClazz, OrderID> origOrderIdColumn;
    protected TableColumn<FixClazz, OrderStatus> orderStatusColumn;
    protected TableColumn<FixClazz, Side> sideColumn;
    protected TableColumn<FixClazz, Instrument> symbolColumn;
    protected TableColumn<FixClazz, BigDecimal> ordQtyColumn;
    protected TableColumn<FixClazz, BigDecimal> cumQtyColumn;
    protected TableColumn<FixClazz, BigDecimal> leavesQtyColumn;
    protected TableColumn<FixClazz, BigDecimal> orderPriceColumn;
    protected TableColumn<FixClazz, BigDecimal> averagePriceColumn;
    protected TableColumn<FixClazz, String> accountColumn;
    protected TableColumn<FixClazz, BigDecimal> lastQtyColumn;
    protected TableColumn<FixClazz, BigDecimal> lastPriceColumn;
    protected TableColumn<FixClazz, String> exchangeColumn;
    protected TableColumn<FixClazz, BrokerID> brokerIdColumn;
    protected TableColumn<FixClazz, String> traderColumn;
    protected MenuItem cancelOrderMenuItem;
    protected MenuItem replaceOrderMenuItem;
    protected MenuItem viewFixMessageDetailsMenuItem;
    protected MenuItem copyOrderMenuItem;
    private TradeMessageListener tradeMessageListener;
    private FlowPane aboveTableLayout;

    @Override
    protected void onStart() {
        this.tradeClientService = this.serviceManager.getService(TradeClientService.class);
        this.initializeTradeMessageListener();
        this.mainLayout = new VBox();
        this.aboveTableLayout = new FlowPane();
        this.reportsTableView = new TableView();
        this.reportsTableView.setPlaceholder(this.getPlaceholder());
        TableView.TableViewSelectionModel selectionModel = this.reportsTableView.getSelectionModel();
        selectionModel.setSelectionMode(this.getTableSelectionMode());
        this.initializeColumns(this.reportsTableView);
        this.initializeContextMenu(this.reportsTableView);
        this.pagination = new Pagination();
        this.pagination.setPageCount(0);
        this.pagination.setCurrentPageIndex(1);
        this.pagination.setMaxPageIndicatorCount(0);
        this.pagination.currentPageIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> inObservable, Number inOldValue, Number inNewValue) {
                AbstractFixMessageView.this.currentPage = inNewValue.intValue();
                AbstractFixMessageView.this.updateReports();
            }
        });
        this.reportsTableView.prefWidthProperty().bind((ObservableValue)this.getParentWindow().widthProperty());
        this.reportsTableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.mainLayout.prefHeightProperty().bind((ObservableValue)this.getParentWindow().heightProperty());
        this.mainLayout.getChildren().addAll((Object[])new Node[]{this.aboveTableLayout, this.reportsTableView, this.pagination});
        this.currentPage = 0;
        this.pageSize = 10;
        this.updateReports();
    }

    @Override
    public Region getMainLayout() {
        return this.mainLayout;
    }

    @Override
    public void onClose() {
        if (this.tradeMessageListener != null) {
            this.tradeClientService.removeTradeMessageListener(this.tradeMessageListener);
        }
        super.onClose();
    }

    @Override
    protected void onClientConnect() {
        this.updateReports();
        this.initializeTradeMessageListener();
    }

    @Override
    protected void onClientDisconnect() {
        Platform.runLater(() -> this.reportsTableView.getItems().clear());
    }

    protected SelectionMode getTableSelectionMode() {
        return SelectionMode.SINGLE;
    }

    protected void initializeTradeMessageListener() {
        this.tradeMessageListener = new TradeMessageListener(){

            public void receiveTradeMessage(TradeMessage inTradeMessage) {
                SLF4JLoggerProxy.trace(this.getClass(), (String)"{} received {}", (Object[])new Object[]{AbstractFixMessageView.this.viewName, inTradeMessage});
                AbstractFixMessageView.this.updateReports();
            }
        };
        this.tradeClientService.addTradeMessageListener(this.tradeMessageListener);
    }

    protected void cancelOrder(FixClazz inReport) {
        ExecutionReport executionReport = this.tradeClientService.getLatestExecutionReportForOrderChain(inReport.getOrderId());
        if (executionReport == null) {
            this.uiMessageService.post(new NotificationEvent("Cancel Order", "Unable to cancel " + inReport.getOrderId() + ": no execution report", Alert.AlertType.ERROR));
            return;
        }
        OrderCancel orderCancel = Factory.getInstance().createOrderCancel(executionReport);
        SLF4JLoggerProxy.info((Object)this, (String)"{} sending {}", (Object[])new Object[]{SessionUser.getCurrent().getUsername(), orderCancel});
        SendOrderResponse response = this.tradeClientService.send((Order)orderCancel);
        if (response.getFailed()) {
            this.uiMessageService.post(new NotificationEvent("Cancel Order", "Unable to submit cancel: " + response.getOrderId() + " " + response.getMessage(), Alert.AlertType.ERROR));
            return;
        }
        this.uiMessageService.post(new NotificationEvent("Cancel Order", "Cancel order " + response.getOrderId() + " submitted", Alert.AlertType.INFORMATION));
    }

    protected Collection<FixClazz> getSelectedItems() {
        switch (this.reportsTableView.getSelectionModel().getSelectionMode()) {
            case MULTIPLE: {
                return this.reportsTableView.getSelectionModel().getSelectedItems();
            }
            case SINGLE: {
                FixMessageDisplayType report = (FixMessageDisplayType)this.reportsTableView.getSelectionModel().getSelectedItem();
                if (report == null) {
                    return Collections.emptyList();
                }
                return Lists.newArrayList((Object[])new FixMessageDisplayType[]{report});
            }
        }
        throw new UnsupportedOperationException("Unexpected selection mode: " + this.reportsTableView.getSelectionModel().getSelectionMode());
    }

    protected void initializeContextMenu(TableView<FixClazz> inTableView) {
        this.reportsTableContextMenu = new ContextMenu();
        this.cancelOrderMenuItem = new MenuItem("Cancel Order");
        this.cancelOrderMenuItem.setOnAction(event -> {
            Collection<FixClazz> selectedItems = this.getSelectedItems();
            for (FixMessageDisplayType report : selectedItems) {
                this.cancelOrder(report);
            }
        });
        this.replaceOrderMenuItem = new MenuItem("Replace Order");
        this.replaceOrderMenuItem.setOnAction(event -> {
            Collection<FixClazz> selectedItems = this.getSelectedItems();
            for (FixMessageDisplayType report : selectedItems) {
                String executionReportXml;
                ExecutionReport executionReport = this.tradeClientService.getLatestExecutionReportForOrderChain(report.getOrderId());
                if (executionReport == null) {
                    this.uiMessageService.post(new NotificationEvent("Replace Order", "Unable to replace " + report.getOrderId() + ": no execution report", Alert.AlertType.ERROR));
                    continue;
                }
                try {
                    executionReportXml = this.xmlService.marshall((Object)executionReport);
                }
                catch (Exception e) {
                    this.uiMessageService.post(new NotificationEvent("Replace Order", "Unable to replace " + report.getOrderId() + ": " + PlatformServices.getMessage((Throwable)e), Alert.AlertType.ERROR));
                    continue;
                }
                Properties replaceProperties = new Properties();
                replaceProperties.setProperty(ExecutionReport.class.getCanonicalName(), executionReportXml);
                ReplaceOrderEvent replaceOrderEvent = (ReplaceOrderEvent)this.applicationContext.getBean(ReplaceOrderEvent.class, new Object[]{executionReport, replaceProperties});
                this.uiMessageService.post(replaceOrderEvent);
            }
        });
        SeparatorMenuItem contextMenuSeparator1 = new SeparatorMenuItem();
        this.viewFixMessageDetailsMenuItem = new MenuItem("View FIX Message Details");
        this.copyOrderMenuItem = new MenuItem("Copy");
        this.copyOrderMenuItem.setOnAction(event -> {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent clipboardContent = new ClipboardContent();
            Collection<FixClazz> selectedItems = this.getSelectedItems();
            StringBuilder output = new StringBuilder();
            for (FixMessageDisplayType report : selectedItems) {
                Message fixMessage = report.getMessage();
                try {
                    output.append(new AnalyzedMessage(FIXMessageUtil.getDataDictionary((FIXVersion)FIXVersion.getFIXVersion((Message)fixMessage)), fixMessage).toString());
                    output.append("\n");
                }
                catch (Exception e) {
                    SLF4JLoggerProxy.warn(this.getClass(), (Throwable)e, (String)"Unable to generate pretty string for {}", (Object[])new Object[]{fixMessage});
                    output.append(FIXMessageUtil.toHumanDelimitedString((FieldMap)fixMessage)).append("\n");
                }
            }
            clipboardContent.putString(output.toString());
            clipboard.setContent((Map)clipboardContent);
        });
        this.viewFixMessageDetailsMenuItem.setOnAction(event -> {
            Collection<FixClazz> selectedItems = this.getSelectedItems();
            for (FixMessageDisplayType report : selectedItems) {
                Properties replaceProperties = new Properties();
                replaceProperties.setProperty(Message.class.getCanonicalName(), report.getMessage().toString());
                FixMessageDetailsViewEvent viewFixMessageDetailsEvent = (FixMessageDetailsViewEvent)this.applicationContext.getBean(FixMessageDetailsViewEvent.class, new Object[]{report, replaceProperties});
                this.uiMessageService.post(viewFixMessageDetailsEvent);
            }
        });
        if (this.authzHelperService.hasPermission((GrantedAuthority)TradePermissions.SendOrderAction)) {
            this.reportsTableContextMenu.getItems().addAll((Object[])new MenuItem[]{this.cancelOrderMenuItem, this.replaceOrderMenuItem, contextMenuSeparator1});
        }
        if (this.authzHelperService.hasPermission((GrantedAuthority)TradePermissions.ViewReportAction)) {
            this.reportsTableContextMenu.getItems().addAll((Object[])new MenuItem[]{this.viewFixMessageDetailsMenuItem, this.copyOrderMenuItem});
        }
        inTableView.getSelectionModel().selectedItemProperty().addListener((inObservable, inOldValue, inNewValue) -> this.enableContextMenuItems(this.getSelectedItems()));
        inTableView.setContextMenu(this.reportsTableContextMenu);
    }

    protected void enableContextMenuItems(Collection<FixClazz> inSelectedItems) {
        if (inSelectedItems == null || inSelectedItems.isEmpty()) {
            this.cancelOrderMenuItem.setDisable(true);
            this.replaceOrderMenuItem.setDisable(true);
            this.viewFixMessageDetailsMenuItem.setDisable(true);
            this.copyOrderMenuItem.setDisable(true);
            return;
        }
        this.viewFixMessageDetailsMenuItem.setDisable(false);
        this.copyOrderMenuItem.setDisable(false);
        boolean disable = false;
        for (FixMessageDisplayType report : inSelectedItems) {
            OrderStatus orderStatus = report.getOrderStatus();
            if (orderStatus.isCancellable()) continue;
            disable = true;
            break;
        }
        this.cancelOrderMenuItem.setDisable(disable);
        this.replaceOrderMenuItem.setDisable(disable);
    }

    protected FlowPane getAboveTableLayout() {
        return this.aboveTableLayout;
    }

    protected TableCell<FixClazz, Date> renderDateCell(TableColumn<FixClazz, Date> inTableColumn) {
        TableCell tableCell = new TableCell<FixClazz, Date>(){

            protected void updateItem(Date inItem, boolean isEmpty) {
                super.updateItem((Object)inItem, isEmpty);
                this.setText(null);
                this.setGraphic(null);
                if (!isEmpty) {
                    this.setText(isoDateFormatter.print((ReadableInstant)new DateTime((Object)inItem)));
                }
            }
        };
        return tableCell;
    }

    protected TableCell<FixClazz, Instrument> renderInstrumentCell(TableColumn<FixClazz, Instrument> inTableColumn) {
        TableCell tableCell = new TableCell<FixClazz, Instrument>(){

            protected void updateItem(Instrument inItem, boolean isEmpty) {
                super.updateItem((Object)inItem, isEmpty);
                this.setText(null);
                this.setGraphic(null);
                if (!isEmpty && inItem != null) {
                    this.setText(inItem.getFullSymbol());
                }
            }
        };
        return tableCell;
    }

    protected TableCell<FixClazz, BigDecimal> renderOrderPriceCell(TableColumn<FixClazz, BigDecimal> inTableColumn) {
        TableCell tableCell = new TableCell<FixClazz, BigDecimal>(){

            protected void updateItem(BigDecimal inItem, boolean isEmpty) {
                super.updateItem((Object)inItem, isEmpty);
                this.setText(null);
                this.setGraphic(null);
                if (!isEmpty) {
                    if (inItem == null) {
                        this.setText("MKT");
                    } else {
                        this.setText(inItem.toPlainString());
                    }
                }
            }
        };
        return tableCell;
    }

    protected TableCell<FixClazz, BigDecimal> renderNumberCell(TableColumn<FixClazz, BigDecimal> inTableColumn) {
        TableCell tableCell = new TableCell<FixClazz, BigDecimal>(){

            protected void updateItem(BigDecimal inItem, boolean isEmpty) {
                super.updateItem((Object)inItem, isEmpty);
                this.setText(null);
                this.setGraphic(null);
                if (!isEmpty && inItem != null) {
                    this.setText(inItem.toPlainString());
                }
            }
        };
        return tableCell;
    }

    protected boolean includeOrderQuantityColumn() {
        return true;
    }

    protected boolean includeLeavesQuantityColumn() {
        return true;
    }

    protected boolean includeLastQuantityColumn() {
        return true;
    }

    protected boolean includeLastPriceColumn() {
        return true;
    }

    protected boolean includeOrderPriceColumn() {
        return true;
    }

    protected boolean includeOriginalOrderIdColumn() {
        return true;
    }

    protected boolean includeExchangeColumn() {
        return true;
    }

    protected boolean includeTransactTimeColumn() {
        return true;
    }

    protected boolean includeSendingTimeColumn() {
        return true;
    }

    protected boolean includeOrderIdColumn() {
        return true;
    }

    protected boolean includeOrderStatusColumn() {
        return true;
    }

    protected boolean includeAccountColumn() {
        return true;
    }

    protected boolean includeBrokerIdColumn() {
        return true;
    }

    protected boolean includeTraderColumn() {
        return true;
    }

    protected void initializeColumns(TableView<FixClazz> inTableView) {
        this.transactTimeColumn = new TableColumn("TransactTime");
        this.sendingTimeColumn = new TableColumn("SendingTime");
        this.orderIdColumn = new TableColumn("OrdId");
        this.origOrderIdColumn = new TableColumn("OrigOrdId");
        this.orderStatusColumn = new TableColumn("OrdStatus");
        this.sideColumn = new TableColumn("Side");
        this.sideColumn.setCellValueFactory((Callback)new PropertyValueFactory("side"));
        this.symbolColumn = new TableColumn("Symbol");
        this.symbolColumn.setCellValueFactory((Callback)new PropertyValueFactory("instrument"));
        this.symbolColumn.setCellFactory(tableColumn -> this.renderInstrumentCell((TableColumn<FixClazz, Instrument>)tableColumn));
        this.ordQtyColumn = new TableColumn("OrdQty");
        this.cumQtyColumn = new TableColumn("CumQty");
        this.cumQtyColumn.setCellValueFactory((Callback)new PropertyValueFactory("cumulativeQuantity"));
        this.cumQtyColumn.setCellFactory(tableColumn -> this.renderNumberCell((TableColumn<FixClazz, BigDecimal>)tableColumn));
        this.leavesQtyColumn = new TableColumn("LeavesQty");
        this.orderPriceColumn = new TableColumn("OrderPx");
        this.averagePriceColumn = new TableColumn("AvgPx");
        this.averagePriceColumn.setCellValueFactory((Callback)new PropertyValueFactory("averagePrice"));
        this.averagePriceColumn.setCellFactory(tableColumn -> this.renderNumberCell((TableColumn<FixClazz, BigDecimal>)tableColumn));
        this.accountColumn = new TableColumn("Account");
        this.lastQtyColumn = new TableColumn("LastQty");
        this.lastPriceColumn = new TableColumn("LastPx");
        this.exchangeColumn = new TableColumn("Exchange");
        this.brokerIdColumn = new TableColumn("BrokerId");
        this.traderColumn = new TableColumn("Trader");
        if (this.includeTransactTimeColumn()) {
            this.transactTimeColumn.setCellValueFactory((Callback)new PropertyValueFactory("transactTime"));
            this.transactTimeColumn.setCellFactory(tableColumn -> this.renderDateCell((TableColumn<FixClazz, Date>)tableColumn));
            inTableView.getColumns().add(this.transactTimeColumn);
        }
        if (this.includeSendingTimeColumn()) {
            this.sendingTimeColumn.setCellValueFactory((Callback)new PropertyValueFactory("sendingTime"));
            this.sendingTimeColumn.setCellFactory(tableColumn -> this.renderDateCell((TableColumn<FixClazz, Date>)tableColumn));
            inTableView.getColumns().add(this.sendingTimeColumn);
        }
        if (this.includeOrderIdColumn()) {
            this.orderIdColumn.setCellValueFactory((Callback)new PropertyValueFactory("orderId"));
            inTableView.getColumns().add(this.orderIdColumn);
        }
        if (this.includeOriginalOrderIdColumn()) {
            this.origOrderIdColumn.setCellValueFactory((Callback)new PropertyValueFactory("originalOrderId"));
            inTableView.getColumns().add(this.origOrderIdColumn);
        }
        if (this.includeOrderStatusColumn()) {
            this.orderStatusColumn.setCellValueFactory((Callback)new PropertyValueFactory("orderStatus"));
            inTableView.getColumns().add(this.orderStatusColumn);
        }
        inTableView.getColumns().add(this.sideColumn);
        inTableView.getColumns().add(this.symbolColumn);
        if (this.includeOrderQuantityColumn()) {
            this.ordQtyColumn.setCellValueFactory((Callback)new PropertyValueFactory("orderQuantity"));
            this.ordQtyColumn.setCellFactory(tableColumn -> this.renderNumberCell((TableColumn<FixClazz, BigDecimal>)tableColumn));
            inTableView.getColumns().add(this.ordQtyColumn);
        }
        inTableView.getColumns().add(this.cumQtyColumn);
        if (this.includeLeavesQuantityColumn()) {
            this.leavesQtyColumn.setCellValueFactory((Callback)new PropertyValueFactory("leavesQuantity"));
            this.leavesQtyColumn.setCellFactory(tableColumn -> this.renderNumberCell((TableColumn<FixClazz, BigDecimal>)tableColumn));
            inTableView.getColumns().add(this.leavesQtyColumn);
        }
        if (this.includeOrderPriceColumn()) {
            this.orderPriceColumn.setCellValueFactory((Callback)new PropertyValueFactory("orderPrice"));
            this.orderPriceColumn.setCellFactory(tableColumn -> this.renderOrderPriceCell((TableColumn<FixClazz, BigDecimal>)tableColumn));
            inTableView.getColumns().add(this.orderPriceColumn);
        }
        inTableView.getColumns().add(this.averagePriceColumn);
        if (this.includeAccountColumn()) {
            this.accountColumn.setCellValueFactory((Callback)new PropertyValueFactory("account"));
            inTableView.getColumns().add(this.accountColumn);
        }
        if (this.includeLastQuantityColumn()) {
            this.lastQtyColumn.setCellValueFactory((Callback)new PropertyValueFactory("lastQuantity"));
            this.lastQtyColumn.setCellFactory(tableColumn -> this.renderNumberCell((TableColumn<FixClazz, BigDecimal>)tableColumn));
            inTableView.getColumns().add(this.lastQtyColumn);
        }
        if (this.includeLastPriceColumn()) {
            this.lastPriceColumn.setCellValueFactory((Callback)new PropertyValueFactory("lastPrice"));
            this.lastPriceColumn.setCellFactory(tableColumn -> this.renderNumberCell((TableColumn<FixClazz, BigDecimal>)tableColumn));
            inTableView.getColumns().add(this.lastPriceColumn);
        }
        if (this.includeExchangeColumn()) {
            this.exchangeColumn.setCellValueFactory((Callback)new PropertyValueFactory("exchange"));
            inTableView.getColumns().add(this.exchangeColumn);
        }
        if (this.includeBrokerIdColumn()) {
            this.brokerIdColumn.setCellValueFactory((Callback)new PropertyValueFactory("brokerId"));
            inTableView.getColumns().add(this.brokerIdColumn);
        }
        if (this.includeTraderColumn()) {
            this.traderColumn.setCellValueFactory((Callback)new PropertyValueFactory("trader"));
            inTableView.getColumns().add(this.traderColumn);
        }
    }

    protected void updateReports() {
        final CollectionPageResponse<ClientClazz> response = this.getClientReports(new PageRequest(this.currentPage, this.pageSize));
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractFixMessageView.this.pagination.setPageCount(response.getTotalPages());
                AbstractFixMessageView.this.pagination.setCurrentPageIndex(AbstractFixMessageView.this.currentPage);
                AbstractFixMessageView.this.reportsTableView.getItems().clear();
                for (Object report : response.getElements()) {
                    AbstractFixMessageView.this.reportsTableView.getItems().add(AbstractFixMessageView.this.createFixDisplayObject(report));
                }
            }
        });
    }

    protected abstract CollectionPageResponse<ClientClazz> getClientReports(PageRequest var1);

    protected abstract FixClazz createFixDisplayObject(ClientClazz var1);

    protected Node getPlaceholder() {
        return new Label("no reports");
    }

    protected AbstractFixMessageView(Region inParentWindow, NewWindowEvent inEvent, Properties inViewProperties) {
        super(inParentWindow, inEvent, inViewProperties);
    }
}

