/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.trade.view.openorders;

import java.math.BigDecimal;
import java.util.Date;
import org.marketcetera.admin.User;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.HasBrokerID;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.OrderSummary;
import org.marketcetera.trade.Report;
import org.marketcetera.trade.Side;
import org.marketcetera.ui.trade.executionreport.view.FixMessageDisplayType;
import quickfix.FieldNotFound;
import quickfix.InvalidMessage;
import quickfix.Message;

public class DisplayOrderSummary
implements FixMessageDisplayType,
OrderSummary,
HasBrokerID {
    private final OrderID originalOrderId;
    private final String exchange;
    private final OrderSummary orderSummary;
    private final Message fixMessage;

    public Message getMessage() {
        return this.fixMessage;
    }

    public OrderID getOrderId() {
        return this.orderSummary.getOrderId();
    }

    public void setOrderId(OrderID inOrderId) {
        throw new UnsupportedOperationException();
    }

    public OrderStatus getOrderStatus() {
        return this.orderSummary.getOrderStatus();
    }

    public Report getReport() {
        return this.orderSummary.getReport();
    }

    public OrderID getRootOrderId() {
        return this.orderSummary.getRootOrderId();
    }

    public BigDecimal getCumulativeQuantity() {
        return this.orderSummary.getCumulativeQuantity();
    }

    public String getAccount() {
        return this.orderSummary.getAccount();
    }

    public BrokerID getBrokerId() {
        return this.orderSummary.getBrokerId();
    }

    public Side getSide() {
        return this.orderSummary.getSide();
    }

    public Instrument getInstrument() {
        return this.orderSummary.getInstrument();
    }

    public BigDecimal getAveragePrice() {
        return this.orderSummary.getAveragePrice();
    }

    public BigDecimal getLastQuantity() {
        return this.orderSummary.getLastQuantity();
    }

    public BigDecimal getLeavesQuantity() {
        return this.orderSummary.getLeavesQuantity();
    }

    public BigDecimal getOrderQuantity() {
        return this.orderSummary.getOrderQuantity();
    }

    public BigDecimal getLastPrice() {
        return this.orderSummary.getLastPrice();
    }

    public BigDecimal getOrderPrice() {
        return this.orderSummary.getOrderPrice();
    }

    public Date getSendingTime() {
        return this.orderSummary.getSendingTime();
    }

    public Date getTransactTime() {
        return this.orderSummary.getTransactTime();
    }

    public User getActor() {
        return this.orderSummary.getActor();
    }

    public User getViewer() {
        return this.orderSummary.getViewer();
    }

    public String getTrader() {
        return this.orderSummary.getViewer().getName();
    }

    public String getExchange() {
        return this.exchange;
    }

    public OrderID getOriginalOrderId() {
        return this.originalOrderId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DisplayOrderSummary [orderSummary=").append(this.orderSummary).append(", fixMessage=").append(this.fixMessage).append("]");
        return builder.toString();
    }

    public DisplayOrderSummary(OrderSummary inOrderSummary) {
        this.orderSummary = inOrderSummary;
        try {
            this.fixMessage = new Message(this.orderSummary.getReport().getFixMessage());
            this.exchange = this.fixMessage.isSetField(207) ? this.fixMessage.getString(207) : null;
            this.originalOrderId = this.fixMessage.isSetField(41) ? new OrderID(this.fixMessage.getString(41)) : null;
        }
        catch (FieldNotFound | InvalidMessage e) {
            throw new RuntimeException(e);
        }
    }
}

