/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.trade.view.openorders;

import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.marketcetera.trade.TradePermissions;
import org.marketcetera.ui.trade.view.AbstractTradeViewFactory;
import org.marketcetera.ui.trade.view.openorders.OpenOrderView;
import org.marketcetera.ui.view.ContentView;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class OpenOrderViewFactory
extends AbstractTradeViewFactory {
    private static final Set<GrantedAuthority> requiredPermissions = Collections.unmodifiableSet(Sets.newHashSet((Object[])new TradePermissions[]{TradePermissions.ViewOpenOrdersAction}));

    @Override
    public String getMenuCaption() {
        return "Open Orders";
    }

    @Override
    public int getWeight() {
        return 100;
    }

    @Override
    public URL getMenuIcon() {
        return this.getClass().getClassLoader().getResource("images/barcode.svg");
    }

    @Override
    protected String getViewName() {
        return this.getMenuCaption();
    }

    @Override
    public Set<GrantedAuthority> getAllPermissions() {
        return requiredPermissions;
    }

    @Override
    protected Class<? extends ContentView> getViewType() {
        return OpenOrderView.class;
    }

    @Override
    protected Class<? extends AbstractTradeViewFactory> getViewFactoryType() {
        return OpenOrderViewFactory.class;
    }
}

