/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.trade.view.orderticket;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Properties;
import java.util.SortedMap;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.annotation.concurrent.GuardedBy;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;
import org.marketcetera.algo.BrokerAlgoSpec;
import org.marketcetera.algo.BrokerAlgoTag;
import org.marketcetera.client.Validations;
import org.marketcetera.core.BigDecimalUtil;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.core.XmlService;
import org.marketcetera.event.AskEvent;
import org.marketcetera.event.BidEvent;
import org.marketcetera.event.Event;
import org.marketcetera.fix.ActiveFixSession;
import org.marketcetera.marketdata.Content;
import org.marketcetera.marketdata.MarketDataListener;
import org.marketcetera.marketdata.MarketDataRequestBuilder;
import org.marketcetera.trade.AverageFillPrice;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.HasSuggestion;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Order;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.Suggestion;
import org.marketcetera.trade.TimeInForce;
import org.marketcetera.trade.client.OrderValidationException;
import org.marketcetera.trade.client.SendOrderResponse;
import org.marketcetera.ui.PhotonServices;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.events.NotificationEvent;
import org.marketcetera.ui.marketdata.service.MarketDataClientService;
import org.marketcetera.ui.service.ServiceManager;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.ui.service.StyleService;
import org.marketcetera.ui.service.admin.AdminClientService;
import org.marketcetera.ui.service.trade.TradeClientService;
import org.marketcetera.ui.view.AbstractContentView;
import org.marketcetera.ui.view.ContentView;
import org.marketcetera.ui.view.ValidatingTextField;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OrderTicketView
extends AbstractContentView
implements ContentView {
    private final ObjectProperty<BidEvent> pegToMidpointBidEventProperty = new SimpleObjectProperty();
    private final ObjectProperty<AskEvent> pegToMidpointAskEventProperty = new SimpleObjectProperty();
    private String pegToMidpointMarketDataRequestId;
    private VBox rootLayout;
    private VBox brokerLayout;
    private Label brokerLabel;
    private ComboBox<BrokerID> brokerComboBox;
    private VBox sideLayout;
    private Label sideLabel;
    private ComboBox<Side> sideComboBox;
    private VBox quantityLayout;
    private Label quantityLabel;
    private ValidatingTextField quantityTextField;
    private VBox symbolLayout;
    private Label symbolLabel;
    private TextField symbolTextField;
    private VBox orderTypeLayout;
    private Label orderTypeLabel;
    private ComboBox<OrderType> orderTypeComboBox;
    private VBox priceLayout;
    private Label priceLabel;
    private ValidatingTextField priceTextField;
    private VBox timeInForceLayout;
    private Label timeInForceLabel;
    private ComboBox<TimeInForce> timeInForceComboBox;
    private Accordion otherAccordion;
    private TitledPane otherPane;
    private GridPane otherLayout;
    private Label textLabel;
    private TextField textTextField;
    private Label accountLabel;
    private TextField accountTextField;
    private Label exDestinationLabel;
    private TextField exDestinationTextField;
    private Label maxFloorLabel;
    private ValidatingTextField maxFloorTextField;
    private Label pegToMidpointLabel;
    private CheckBox pegToMidpointCheckBox;
    private Label pegToMidpointLockedLabel;
    private CheckBox pegToMidpointLockedCheckBox;
    private Accordion brokerAlgoAccordion;
    private TitledPane brokerAlgoPane;
    private GridPane brokerAlgoLayout;
    private Label brokerAlgoLabel;
    private ComboBox<BrokerAlgoSpec> brokerAlgoComboBox;
    private TableView<BrokerAlgoTag> brokerAlgoTagTable;
    private Accordion customFieldsAccordion;
    private TitledPane customFieldsPane;
    private TableView<DisplayCustomField> customFieldsTable;
    private Button sendButton;
    private Button clearButton;
    private HBox buttonLayout;
    private Instrument resolvedInstrument;
    private Label adviceLabel;
    private Separator adviceSeparator;
    @GuardedBy(value="availableBrokers")
    private final SortedMap<BrokerID, ActiveFixSession> availableBrokers = Maps.newTreeMap();
    private static final BrokerID AUTO_SELECT_BROKER = new BrokerID("Auto Select");
    private static final String NAME = "Order Ticket View";
    private Optional<Suggestion> suggestionOption;
    private Optional<ExecutionReport> replaceExecutionReportOption;
    private Optional<AverageFillPrice> averageFillPriceOption;
    private GridPane orderTicketLayout;
    private MarketDataClientService marketDataClient;
    @Autowired
    private StyleService styleService;
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private XmlService xmlService;

    @Override
    public Region getMainLayout() {
        return this.rootLayout;
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public void onClose() {
        this.cancelPegToMidpointMarketDataRequest();
    }

    @Override
    protected void onStart() {
        this.marketDataClient = this.serviceManager.getService(MarketDataClientService.class);
        this.rootLayout = new VBox();
        this.orderTicketLayout = new GridPane();
        this.brokerLabel = new Label("Broker");
        this.brokerComboBox = new ComboBox();
        this.pegToMidpointLabel = new Label("Peg to Midpoint");
        this.pegToMidpointCheckBox = new CheckBox();
        this.pegToMidpointLockedLabel = new Label("Peg to Midpoint Locked");
        this.pegToMidpointLockedCheckBox = new CheckBox();
        this.textLabel = new Label("Text");
        this.textTextField = new TextField();
        this.accountLabel = new Label("Account");
        this.accountTextField = new TextField();
        this.brokerLayout = new VBox(5.0);
        this.sideLayout = new VBox(5.0);
        this.sideLabel = new Label("Side");
        this.sideComboBox = new ComboBox();
        this.quantityLayout = new VBox(5.0);
        this.quantityLabel = new Label("Quantity");
        this.quantityTextField = new ValidatingTextField(input -> input.matches("^(-|\\+)?(([1-9][0-9]*)|(0))(?:\\.[0-9]+)?$"));
        this.symbolLayout = new VBox(5.0);
        this.symbolLabel = new Label("Symbol");
        this.symbolTextField = new TextField();
        this.orderTypeLayout = new VBox(5.0);
        this.orderTypeLabel = new Label("Order Type");
        this.orderTypeComboBox = new ComboBox();
        this.priceLayout = new VBox(5.0);
        this.priceLabel = new Label("Price");
        this.priceTextField = new ValidatingTextField(input -> input.matches("^(-|\\+)?(([1-9][0-9]*)|(0))(?:\\.[0-9]+)?$"));
        this.timeInForceLayout = new VBox(5.0);
        this.timeInForceLabel = new Label("Time in Force");
        this.timeInForceComboBox = new ComboBox();
        this.otherAccordion = new Accordion();
        this.otherLayout = new GridPane();
        this.otherPane = new TitledPane("Other", (Node)this.otherLayout);
        this.exDestinationLabel = new Label("External Destination");
        this.exDestinationTextField = new TextField();
        this.maxFloorLabel = new Label("Max Floor");
        this.maxFloorTextField = new ValidatingTextField(input -> input.matches("^(-|\\+)?(([1-9][0-9]*)|(0))(?:\\.[0-9]+)?$"));
        this.brokerAlgoAccordion = new Accordion();
        this.brokerAlgoLayout = new GridPane();
        this.brokerAlgoPane = new TitledPane("Broker Algos", (Node)this.brokerAlgoLayout);
        this.brokerAlgoLabel = new Label("Algo");
        this.brokerAlgoComboBox = new ComboBox();
        this.brokerAlgoTagTable = new TableView();
        this.customFieldsAccordion = new Accordion();
        this.customFieldsTable = new TableView();
        this.customFieldsPane = new TitledPane("Custom Fields", this.customFieldsTable);
        this.sendButton = new Button("Send");
        this.clearButton = new Button("Clear");
        this.buttonLayout = new HBox(5.0);
        this.adviceLabel = new Label("");
        this.adviceSeparator = new Separator(Orientation.HORIZONTAL);
        String xmlData = StringUtils.trimToNull((String)this.getViewProperties().getProperty(ExecutionReport.class.getCanonicalName()));
        ExecutionReport replaceExecutionReport = null;
        if (xmlData != null) {
            try {
                replaceExecutionReport = (ExecutionReport)this.xmlService.unmarshall(xmlData);
            }
            catch (JAXBException e) {
                this.uiMessageService.post(new NotificationEvent("Replace Order", "Unable to replace order: " + PlatformServices.getMessage((Throwable)e), Alert.AlertType.ERROR));
            }
        }
        this.replaceExecutionReportOption = Optional.ofNullable(replaceExecutionReport);
        xmlData = StringUtils.trimToNull((String)this.getViewProperties().getProperty(AverageFillPrice.class.getCanonicalName()));
        AverageFillPrice averageFillPrice = null;
        if (xmlData != null) {
            try {
                averageFillPrice = (AverageFillPrice)this.xmlService.unmarshall(xmlData);
            }
            catch (JAXBException e) {
                this.uiMessageService.post(new NotificationEvent("Trade Order", "Unable to trade order: " + PlatformServices.getMessage((Throwable)e), Alert.AlertType.ERROR));
            }
        }
        this.averageFillPriceOption = Optional.ofNullable(averageFillPrice);
        Suggestion suggestion = null;
        if (this.getNewWindowEvent() instanceof HasSuggestion) {
            suggestion = ((HasSuggestion)this.getNewWindowEvent()).getSuggestion();
        }
        this.suggestionOption = Optional.ofNullable(suggestion);
        this.brokerComboBox.setPromptText("Broker");
        this.brokerComboBox.setId(this.getClass().getCanonicalName() + ".brokerComboBox");
        this.brokerComboBox.setTooltip(new Tooltip("Select order destination"));
        this.brokerComboBox.getItems().add((Object)AUTO_SELECT_BROKER);
        this.brokerComboBox.setValue((Object)AUTO_SELECT_BROKER);
        this.brokerComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<BrokerID>(){

            public void changed(ObservableValue<? extends BrokerID> inObservable, BrokerID inOldValue, BrokerID inNewValue) {
                BrokerID selectedBroker = inNewValue;
                OrderTicketView.this.brokerAlgoComboBox.setValue(null);
                if (selectedBroker == null || AUTO_SELECT_BROKER.equals((Object)selectedBroker)) {
                    OrderTicketView.this.brokerAlgoComboBox.setDisable(true);
                    OrderTicketView.this.brokerAlgoLabel.setTooltip(new Tooltip("Broker algos available only when a broker is selected and that broker offers algos"));
                    OrderTicketView.this.brokerAlgoTagTable.setPrefHeight(100.0);
                } else {
                    OrderTicketView.this.brokerAlgoLabel.setTooltip(null);
                    OrderTicketView.this.brokerAlgoComboBox.setTooltip(new Tooltip("Select broker algo"));
                    ActiveFixSession underlyingFixSession = (ActiveFixSession)OrderTicketView.this.availableBrokers.get(selectedBroker);
                    if (underlyingFixSession != null && !underlyingFixSession.getBrokerAlgos().isEmpty()) {
                        OrderTicketView.this.brokerAlgoComboBox.setDisable(false);
                        OrderTicketView.this.brokerAlgoComboBox.getItems().addAll((Collection)underlyingFixSession.getBrokerAlgos());
                    }
                }
                OrderTicketView.this.adjustSendButton();
            }
        });
        this.brokerLayout.getChildren().addAll((Object[])new Node[]{this.brokerLabel, this.brokerComboBox});
        this.styleService.addStyleToAll(new Node[]{this.brokerLabel, this.brokerComboBox, this.brokerLayout});
        this.initializeBrokerStatusListener();
        this.sideComboBox.setPromptText("Side");
        this.sideComboBox.setId(this.getClass().getCanonicalName() + ".sideComboBox");
        this.sideComboBox.getItems().addAll(EnumSet.complementOf(EnumSet.of(Side.Unknown)));
        this.sideComboBox.setValue((Object)Side.Buy);
        this.sideComboBox.setTooltip(new Tooltip("FIX field 54"));
        this.sideComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<Side>(){

            public void changed(ObservableValue<? extends Side> inObservable, Side inOldValue, Side inNewValue) {
                OrderTicketView.this.adjustSendButton();
            }
        });
        this.sideLayout.getChildren().addAll((Object[])new Node[]{this.sideLabel, this.sideComboBox});
        this.styleService.addStyleToAll(new Node[]{this.sideLabel, this.sideComboBox, this.sideLayout});
        this.quantityTextField.setPromptText("100");
        this.quantityTextField.setId(this.getClass().getCanonicalName() + ".quantityTextField");
        this.quantityTextField.textProperty().addListener((inObservable, inOldValue, inNewValue) -> this.adjustSendButton());
        this.quantityTextField.setTooltip(new Tooltip("FIX field 38"));
        this.quantityTextField.isValidProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.quantityTextField.setStyle(PhotonServices.successStyle);
                this.adviceLabel.textProperty().set((Object)"");
            } else {
                this.quantityTextField.setStyle(PhotonServices.errorStyle);
                this.adviceLabel.textProperty().set((Object)"Numeric quantity required");
            }
        });
        this.styleService.addStyleToAll(new Node[]{this.quantityLabel, this.quantityTextField, this.quantityLayout});
        this.quantityLayout.getChildren().addAll((Object[])new Node[]{this.quantityLabel, this.quantityTextField});
        this.symbolTextField.textProperty().addListener((inObservable, inOldValue, inNewValue) -> {
            try {
                String symbol = this.serviceManager.getService(TradeClientService.class).getTreatedSymbol(String.valueOf(inNewValue));
                if (symbol == null) {
                    this.pegToMidpointCheckBox.setDisable(true);
                    this.pegToMidpointLockedCheckBox.setDisable(true);
                    this.pegToMidpointCheckBox.selectedProperty().set(false);
                    this.pegToMidpointLockedCheckBox.selectedProperty().set(false);
                    this.cancelPegToMidpointMarketDataRequest();
                    return;
                }
                this.resolvedInstrument = this.serviceManager.getService(TradeClientService.class).resolveSymbol(symbol);
                if (this.resolvedInstrument == null) {
                    this.symbolTextField.setStyle(PhotonServices.errorStyle);
                    this.adviceLabel.textProperty().set((Object)"Cannot resolve symbol");
                    this.pegToMidpointCheckBox.setDisable(true);
                    this.pegToMidpointLockedCheckBox.setDisable(true);
                    this.pegToMidpointCheckBox.selectedProperty().set(false);
                    this.pegToMidpointLockedCheckBox.selectedProperty().set(false);
                    this.cancelPegToMidpointMarketDataRequest();
                    return;
                }
                this.pegToMidpointCheckBox.setDisable(false);
                this.symbolTextField.setStyle(PhotonServices.successStyle);
                this.adviceLabel.textProperty().set((Object)"");
                this.symbolTextField.setTooltip(new Tooltip(this.resolvedInstrument.toString()));
                this.doPegToMidpointMarketDataRequest();
            }
            finally {
                this.adjustSendButton();
            }
        });
        this.symbolLayout.getChildren().addAll((Object[])new Node[]{this.symbolLabel, this.symbolTextField});
        this.styleService.addStyleToAll(new Node[]{this.symbolLabel, this.symbolTextField, this.symbolLayout});
        this.orderTypeComboBox.setPromptText("Order Type");
        this.orderTypeComboBox.setId(this.getClass().getCanonicalName() + ".orderTypeComboBox");
        this.orderTypeComboBox.getItems().addAll(EnumSet.complementOf(EnumSet.of(OrderType.Unknown)));
        this.orderTypeComboBox.setValue(null);
        this.orderTypeComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<OrderType>(){

            public void changed(ObservableValue<? extends OrderType> inObservable, OrderType inOldValue, OrderType inNewValue) {
                OrderType value = inNewValue;
                boolean isMarket = false;
                isMarket = value == null ? false : value.isMarketOrder();
                if (isMarket) {
                    OrderTicketView.this.cancelPegToMidpointMarketDataRequest();
                    OrderTicketView.this.priceTextField.setText("");
                    OrderTicketView.this.pegToMidpointCheckBox.selectedProperty().set(false);
                    OrderTicketView.this.pegToMidpointLockedCheckBox.selectedProperty().set(false);
                }
                OrderTicketView.this.priceTextField.setDisable(isMarket);
                OrderTicketView.this.pegToMidpointCheckBox.setDisable(isMarket);
                OrderTicketView.this.adjustSendButton();
            }
        });
        this.orderTypeComboBox.setTooltip(new Tooltip("FIX Field 40"));
        this.styleService.addStyleToAll(new Node[]{this.orderTypeLabel, this.orderTypeComboBox, this.orderTypeLayout});
        this.orderTypeLayout.getChildren().addAll((Object[])new Node[]{this.orderTypeLabel, this.orderTypeComboBox});
        this.priceTextField.setPromptText("50.00");
        this.priceTextField.setId(this.getClass().getCanonicalName() + ".priceTextField");
        this.priceTextField.setTooltip(new Tooltip("FIX field 38"));
        this.priceTextField.isValidProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.priceTextField.setStyle(PhotonServices.successStyle);
                this.adviceLabel.textProperty().set((Object)"");
            } else {
                this.priceTextField.setStyle(PhotonServices.errorStyle);
                this.adviceLabel.textProperty().set((Object)"Numeric price required");
            }
            this.adjustSendButton();
        });
        this.priceTextField.textProperty().addListener((inObservable, inOldValue, inNewValue) -> this.adjustSendButton());
        this.styleService.addStyleToAll(new Node[]{this.priceLabel, this.priceTextField, this.priceLayout});
        this.priceLayout.getChildren().addAll((Object[])new Node[]{this.priceLabel, this.priceTextField});
        this.timeInForceComboBox.setPromptText("Time in Force");
        this.timeInForceComboBox.setId(this.getClass().getCanonicalName() + ".timeInForceComboBox");
        this.timeInForceComboBox.getItems().addAll(EnumSet.complementOf(EnumSet.of(TimeInForce.Unknown)));
        this.timeInForceComboBox.setValue(null);
        this.timeInForceComboBox.setTooltip(new Tooltip("FIX Field 59"));
        this.timeInForceComboBox.valueProperty().addListener((inObservable, inOldValue, inNewValue) -> this.adjustSendButton());
        this.timeInForceLayout.getChildren().addAll((Object[])new Node[]{this.timeInForceLabel, this.timeInForceComboBox});
        this.styleService.addStyleToAll(new Node[]{this.timeInForceLabel, this.timeInForceComboBox, this.timeInForceLayout});
        this.otherAccordion.setId(this.getClass().getCanonicalName() + ".otherAccordion");
        this.otherPane.expandedProperty().set(false);
        this.otherPane.setId(this.getClass().getCanonicalName() + ".otherPane");
        this.otherLayout.setHgap(5.0);
        this.otherLayout.setVgap(5.0);
        this.otherLayout.setId(this.getClass().getCanonicalName() + ".otherLayout");
        this.otherAccordion.getPanes().add((Object)this.otherPane);
        this.styleService.addStyleToAll(new Node[]{this.otherAccordion, this.otherLayout, this.otherPane});
        this.textLabel.setId(this.getClass().getCanonicalName() + ".textLabel");
        this.textTextField.setPromptText("optional order text");
        this.textTextField.setId(this.getClass().getCanonicalName() + ".textTextField");
        this.textTextField.setTooltip(new Tooltip("FIX field 58"));
        this.otherLayout.add((Node)this.textLabel, 0, 0);
        this.otherLayout.add((Node)this.textTextField, 1, 0);
        this.styleService.addStyleToAll(new Node[]{this.textLabel, this.textTextField});
        this.accountLabel.setId(this.getClass().getCanonicalName() + ".accountLabel");
        this.accountTextField.setPromptText("optional account");
        this.accountTextField.setId(this.getClass().getCanonicalName() + ".accountTextField");
        this.accountTextField.setTooltip(new Tooltip("FIX field 1"));
        this.otherLayout.add((Node)this.accountLabel, 0, 1);
        this.otherLayout.add((Node)this.accountTextField, 1, 1);
        this.styleService.addStyleToAll(new Node[]{this.accountLabel, this.accountTextField});
        this.exDestinationLabel.setId(this.getClass().getCanonicalName() + ".exDestinationLabel");
        this.exDestinationTextField.setPromptText("optional ex destination");
        this.exDestinationTextField.setId(this.getClass().getCanonicalName() + ".exDestinationTextField");
        this.exDestinationTextField.setTooltip(new Tooltip("FIX field 100"));
        this.styleService.addStyleToAll(new Node[]{this.exDestinationLabel, this.exDestinationTextField});
        this.otherLayout.add((Node)this.exDestinationLabel, 0, 2);
        this.otherLayout.add((Node)this.exDestinationTextField, 1, 2);
        this.maxFloorTextField.setPromptText("max floor");
        this.maxFloorTextField.setId(this.getClass().getCanonicalName() + ".maxFloorTextField");
        this.maxFloorTextField.setTooltip(new Tooltip("FIX field 111"));
        this.maxFloorTextField.isValidProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue() || StringUtils.trimToNull((String)((String)this.maxFloorTextField.textProperty().get())) == null) {
                this.maxFloorTextField.setStyle(PhotonServices.successStyle);
                this.adviceLabel.textProperty().set((Object)"");
            } else {
                this.maxFloorTextField.setStyle(PhotonServices.errorStyle);
                this.adviceLabel.textProperty().set((Object)"Numeric max floor quantity required");
            }
            this.adjustSendButton();
        });
        this.styleService.addStyleToAll(new Node[]{this.maxFloorLabel, this.maxFloorTextField});
        this.otherLayout.add((Node)this.maxFloorLabel, 0, 3);
        this.otherLayout.add((Node)this.maxFloorTextField, 1, 3);
        this.pegToMidpointLabel.setId(this.getClass().getCanonicalName() + ".pegToMidpointLabel");
        this.pegToMidpointCheckBox.setId(this.getClass().getCanonicalName() + ".pegToMidpointCheckBox");
        this.pegToMidpointCheckBox.setTooltip(new Tooltip("Price pegged to the midpoint of the spread when the order is routed"));
        this.pegToMidpointBidEventProperty.addListener((observableValue, oldValue, newValue) -> this.updatePegToMidpointPrice());
        this.pegToMidpointAskEventProperty.addListener((observableValue, oldValue, newValue) -> this.updatePegToMidpointPrice());
        this.pegToMidpointCheckBox.setDisable(true);
        this.pegToMidpointLockedCheckBox.setDisable(true);
        this.pegToMidpointCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> {
            boolean value = newValue;
            this.pegToMidpointLockedCheckBox.setDisable(!value);
            this.priceTextField.setDisable(value);
            if (!value) {
                this.pegToMidpointLockedCheckBox.selectedProperty().set(false);
                this.cancelPegToMidpointMarketDataRequest();
                this.adjustSendButton();
                return;
            }
            this.doPegToMidpointMarketDataRequest();
        });
        this.styleService.addStyleToAll(new Node[]{this.pegToMidpointLabel, this.pegToMidpointCheckBox});
        this.otherLayout.add((Node)this.pegToMidpointLabel, 0, 4);
        this.otherLayout.add((Node)this.pegToMidpointCheckBox, 1, 4);
        this.pegToMidpointLockedLabel.setId(this.getClass().getCanonicalName() + ".pegToMidpointLockedLabel");
        this.pegToMidpointLockedCheckBox.setId(this.getClass().getCanonicalName() + ".pegToMidpointLockedCheckBox");
        this.pegToMidpointLockedCheckBox.setDisable(true);
        this.pegToMidpointLockedCheckBox.setTooltip(new Tooltip("Price pegged to the midpoint of the spread when the order is sent"));
        this.styleService.addStyleToAll(new Node[]{this.pegToMidpointLockedLabel, this.pegToMidpointLockedCheckBox});
        this.otherLayout.add((Node)this.pegToMidpointLockedLabel, 0, 5);
        this.otherLayout.add((Node)this.pegToMidpointLockedCheckBox, 1, 5);
        this.brokerAlgoAccordion.setId(this.getClass().getCanonicalName() + ".brokerAlgoAccordion");
        this.brokerAlgoPane.expandedProperty().set(false);
        this.brokerAlgoPane.setId(this.getClass().getCanonicalName() + ".brokerAlgoPane");
        this.brokerAlgoLayout.setHgap(5.0);
        this.brokerAlgoLayout.setVgap(5.0);
        this.brokerAlgoLayout.setId(this.getClass().getCanonicalName() + ".brokerAlgoLayout");
        this.brokerAlgoAccordion.getPanes().add((Object)this.brokerAlgoPane);
        this.styleService.addStyleToAll(new Node[]{this.brokerAlgoAccordion, this.brokerAlgoLayout, this.brokerAlgoPane});
        this.brokerAlgoComboBox.setPromptText("Broker Algo");
        this.brokerAlgoComboBox.valueProperty().addListener((observable, oldValue, newValue) -> {});
        this.brokerAlgoLabel.setId(this.getClass().getCanonicalName() + ".brokerAlgoLabel");
        this.brokerAlgoComboBox.setId(this.getClass().getCanonicalName() + ".brokerAlgoComboBox");
        this.styleService.addStyleToAll(new Node[]{this.brokerAlgoLabel, this.brokerAlgoComboBox});
        this.brokerAlgoLayout.add((Node)this.brokerAlgoLabel, 0, 0);
        this.brokerAlgoLayout.add(this.brokerAlgoComboBox, 1, 0);
        this.brokerAlgoTagTable.setId(this.getClass().getCanonicalName() + ".brokerAlgoTable");
        TableColumn brokerAlgoTagLabelColumn = new TableColumn("Tag");
        brokerAlgoTagLabelColumn.setCellValueFactory((Callback)new PropertyValueFactory("label"));
        TableColumn brokerAlgoTagValueColumn = new TableColumn("Value");
        brokerAlgoTagValueColumn.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.brokerAlgoTagTable.getColumns().add((Object)brokerAlgoTagLabelColumn);
        this.brokerAlgoTagTable.getColumns().add((Object)brokerAlgoTagValueColumn);
        this.brokerAlgoTagTable.setPlaceholder((Node)new Label("No broker algos available from this broker"));
        this.styleService.addStyleToAll(new Node[]{this.brokerAlgoTagTable});
        this.brokerAlgoLayout.add(this.brokerAlgoTagTable, 0, 1, 2, 1);
        this.customFieldsTable.setEditable(true);
        this.customFieldsAccordion.setId(this.getClass().getCanonicalName() + ".customFieldsAccordion");
        this.customFieldsPane.expandedProperty().set(false);
        this.customFieldsPane.setId(this.getClass().getCanonicalName() + ".customFieldsPane");
        this.customFieldsAccordion.getPanes().add((Object)this.customFieldsPane);
        this.customFieldsTable.setId(this.getClass().getCanonicalName() + ".customFieldsTable");
        TableColumn customFieldsEnabledColumn = new TableColumn("Enabled");
        customFieldsEnabledColumn.setCellValueFactory(cellData -> new ReadOnlyBooleanWrapper(((DisplayCustomField)cellData.getValue()).isEnabledProperty().get()));
        customFieldsEnabledColumn.setCellFactory(CheckBoxTableCell.forTableColumn((TableColumn)customFieldsEnabledColumn));
        customFieldsEnabledColumn.setId(this.getClass().getCanonicalName() + ".customFieldsEnabledColumn");
        customFieldsEnabledColumn.setEditable(true);
        TableColumn customFieldsKeyColumn = new TableColumn("Key");
        customFieldsKeyColumn.setCellValueFactory(cellData -> ((DisplayCustomField)cellData.getValue()).keyProperty());
        customFieldsKeyColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        customFieldsKeyColumn.setId(this.getClass().getCanonicalName() + ".customFieldsKeyColumn");
        customFieldsKeyColumn.setEditable(true);
        TableColumn customFieldsValueColumn = new TableColumn("Value");
        customFieldsValueColumn.setCellValueFactory(cellData -> ((DisplayCustomField)cellData.getValue()).valueProperty());
        customFieldsValueColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        customFieldsValueColumn.setId(this.getClass().getCanonicalName() + ".customFieldsValueColumn");
        customFieldsValueColumn.setEditable(true);
        this.customFieldsTable.getColumns().add((Object)customFieldsEnabledColumn);
        this.customFieldsTable.getColumns().add((Object)customFieldsKeyColumn);
        this.customFieldsTable.getColumns().add((Object)customFieldsValueColumn);
        this.customFieldsTable.setPlaceholder((Node)new Label("No custom fields selected"));
        this.customFieldsTable.setTooltip(new Tooltip("Double click to add a custom field"));
        this.customFieldsTable.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent inEvent) {
                if (inEvent.getClickCount() == 2) {
                    OrderTicketView.this.customFieldsTable.getItems().add((Object)new DisplayCustomField());
                }
            }
        });
        this.styleService.addStyleToAll(new Node[]{this.customFieldsAccordion, this.customFieldsPane, this.customFieldsTable});
        this.buttonLayout.getChildren().addAll((Object[])new Node[]{this.sendButton, this.clearButton});
        this.rootLayout.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER && !this.sendButton.disabledProperty().get()) {
                this.sendButton.fire();
                event.consume();
            }
        });
        this.sendButton.setOnMouseClicked(inEvent -> {
            String rawQuantity;
            String rawPrice;
            String maxFloorQtyRaw;
            BrokerID selectedBroker;
            Object newOrder = this.replaceExecutionReportOption.isPresent() ? Factory.getInstance().createOrderReplace(this.replaceExecutionReportOption.get()) : Factory.getInstance().createOrderSingle();
            newOrder.setAccount(StringUtils.trimToNull((String)((String)this.accountTextField.textProperty().get())));
            if (this.brokerAlgoComboBox.getValue() != null) {
                BrokerAlgoSpec brokerAlgoSpec = (BrokerAlgoSpec)this.brokerAlgoComboBox.getValue();
            }
            if (this.brokerComboBox.getValue() != null && !AUTO_SELECT_BROKER.equals((Object)(selectedBroker = (BrokerID)this.brokerComboBox.getValue()))) {
                ActiveFixSession selectedActiveFixSession = (ActiveFixSession)this.availableBrokers.get(selectedBroker);
                newOrder.setBrokerID(new BrokerID(selectedActiveFixSession.getFixSession().getBrokerId()));
            }
            if ((maxFloorQtyRaw = StringUtils.trimToNull((String)((String)this.maxFloorTextField.textProperty().get()))) != null) {
                newOrder.setDisplayQuantity(new BigDecimal(maxFloorQtyRaw));
            }
            newOrder.setExecutionDestination(StringUtils.trimToNull((String)((String)this.exDestinationTextField.textProperty().get())));
            newOrder.setInstrument(this.resolvedInstrument);
            if (this.orderTypeComboBox.getValue() != null) {
                newOrder.setOrderType((OrderType)this.orderTypeComboBox.getValue());
            }
            if (this.pegToMidpointCheckBox.selectedProperty().get() && !this.pegToMidpointLockedCheckBox.selectedProperty().get()) {
                newOrder.setPegToMidpoint(true);
            }
            if ((rawPrice = StringUtils.trimToNull((String)((String)this.priceTextField.textProperty().get()))) != null) {
                newOrder.setPrice(new BigDecimal(rawPrice));
            }
            if ((rawQuantity = StringUtils.trimToNull((String)((String)this.quantityTextField.textProperty().get()))) != null) {
                newOrder.setQuantity(new BigDecimal(rawQuantity));
            }
            if (this.sideComboBox.getValue() != null) {
                newOrder.setSide((Side)this.sideComboBox.getValue());
            }
            if (this.timeInForceComboBox.getValue() != null) {
                newOrder.setTimeInForce((TimeInForce)this.timeInForceComboBox.getValue());
            }
            SLF4JLoggerProxy.debug((Object)this, (String)"Validating {}", (Object[])new Object[]{newOrder});
            try {
                if (this.replaceExecutionReportOption.isPresent()) {
                    Validations.validate((OrderReplace)((OrderReplace)newOrder));
                } else {
                    Validations.validate((OrderSingle)newOrder);
                }
            }
            catch (OrderValidationException e) {
                String errorMessage = PlatformServices.getMessage((Throwable)e);
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"{} failed validation: {}", (Object[])new Object[]{newOrder, errorMessage});
                this.uiMessageService.post(new NotificationEvent("Submit Order Failed", "Unable to submit order: " + errorMessage, Alert.AlertType.ERROR));
                this.sendButton.requestFocus();
                return;
            }
            SLF4JLoggerProxy.info((Object)this, (String)"{} submitting {}", (Object[])new Object[]{SessionUser.getCurrent(), newOrder});
            SendOrderResponse response = this.serviceManager.getService(TradeClientService.class).send((Order)newOrder);
            if (response.getFailed()) {
                this.uiMessageService.post(new NotificationEvent("Submit Order Failed", "Unable to submit: " + response.getOrderId() + " " + response.getMessage(), Alert.AlertType.ERROR));
                this.sendButton.requestFocus();
                return;
            }
            this.uiMessageService.post(new NotificationEvent("Submit Order Succeeded", response.getOrderId() + " submitted", Alert.AlertType.INFORMATION));
            if (this.replaceExecutionReportOption.isPresent()) {
                this.getParentWindow().setVisible(false);
            } else {
                this.resetTicket(false);
            }
        });
        this.clearButton.setOnAction(event -> this.resetTicket(true));
        this.orderTicketLayout.setVgap(5.0);
        this.orderTicketLayout.setHgap(5.0);
        int rowCount = 0;
        int colCount = 0;
        this.orderTicketLayout.add((Node)this.brokerLayout, colCount, rowCount);
        this.orderTicketLayout.add((Node)this.sideLayout, ++colCount, rowCount);
        this.orderTicketLayout.add((Node)this.quantityLayout, ++colCount, rowCount);
        this.orderTicketLayout.add((Node)this.symbolLayout, ++colCount, rowCount);
        this.orderTicketLayout.add((Node)this.orderTypeLayout, ++colCount, rowCount);
        this.orderTicketLayout.add((Node)this.priceLayout, ++colCount, rowCount);
        this.orderTicketLayout.add((Node)this.timeInForceLayout, ++colCount, rowCount);
        colCount = 0;
        this.orderTicketLayout.add((Node)this.otherAccordion, colCount, ++rowCount);
        this.orderTicketLayout.add((Node)this.brokerAlgoAccordion, ++colCount, rowCount);
        this.orderTicketLayout.add((Node)this.customFieldsAccordion, ++colCount, rowCount);
        colCount = 0;
        this.orderTicketLayout.add((Node)this.buttonLayout, colCount, ++rowCount);
        this.adviceSeparator.setId(this.getClass().getCanonicalName() + ".adviceSeparator");
        this.adviceLabel.setId(this.getClass().getCanonicalName() + ".adviceLabel");
        this.styleService.addStyleToAll(new Node[]{this.adviceSeparator, this.adviceLabel, this.rootLayout});
        this.orderTicketLayout.prefHeightProperty().bind((ObservableValue)this.rootLayout.widthProperty());
        this.rootLayout.prefHeightProperty().bind((ObservableValue)this.getParentWindow().heightProperty());
        this.rootLayout.prefWidthProperty().bind((ObservableValue)this.getParentWindow().widthProperty());
        this.rootLayout.getChildren().addAll((Object[])new Node[]{this.orderTicketLayout, this.adviceSeparator, this.adviceLabel});
        this.serviceManager.getService(AdminClientService.class).addClientStatusListener(this);
        this.fillFromExecutionReport(this.replaceExecutionReportOption);
    }

    public OrderTicketView(Region inParent, NewWindowEvent inEvent, Properties inProperties) {
        super(inParent, inEvent, inProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveClientStatus(boolean inIsAvailable) {
        SLF4JLoggerProxy.trace((Object)this, (String)"Received client status available: {}", (Object[])new Object[]{inIsAvailable});
        if (inIsAvailable) {
            this.initializeBrokerStatusListener();
        } else {
            SortedMap<BrokerID, ActiveFixSession> sortedMap = this.availableBrokers;
            synchronized (sortedMap) {
                this.availableBrokers.clear();
            }
            Platform.runLater(() -> {
                this.brokerComboBox.getItems().clear();
                this.brokerComboBox.valueProperty().set(null);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onClientDisconnect() {
        SortedMap<BrokerID, ActiveFixSession> sortedMap = this.availableBrokers;
        synchronized (sortedMap) {
            this.availableBrokers.clear();
        }
        Platform.runLater(() -> {
            this.brokerComboBox.getItems().clear();
            this.brokerComboBox.valueProperty().set(null);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onBrokerStatusChange(ActiveFixSession inActiveFixSession) {
        boolean brokersStatusChanged = false;
        BrokerID activeFixSessionKey = new BrokerID(inActiveFixSession.getFixSession().getName());
        SortedMap<BrokerID, ActiveFixSession> sortedMap = this.availableBrokers;
        synchronized (sortedMap) {
            if (inActiveFixSession.getStatus().isLoggedOn() && !inActiveFixSession.getFixSession().isAcceptor()) {
                brokersStatusChanged = this.availableBrokers.put(activeFixSessionKey, inActiveFixSession) == null;
            } else {
                boolean bl = brokersStatusChanged = this.availableBrokers.remove(activeFixSessionKey) != null;
            }
            if (brokersStatusChanged) {
                this.availableBrokers.notifyAll();
            }
        }
        if (brokersStatusChanged) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    BrokerID currentSelectedBroker = (BrokerID)OrderTicketView.this.brokerComboBox.getValue();
                    OrderTicketView.this.brokerComboBox.getItems().clear();
                    OrderTicketView.this.brokerComboBox.valueProperty().set(null);
                    OrderTicketView.this.brokerComboBox.getItems().add((Object)AUTO_SELECT_BROKER);
                    OrderTicketView.this.brokerComboBox.getItems().addAll(OrderTicketView.this.availableBrokers.keySet());
                    if (AUTO_SELECT_BROKER.equals((Object)currentSelectedBroker)) {
                        OrderTicketView.this.brokerComboBox.setValue((Object)AUTO_SELECT_BROKER);
                    } else if (OrderTicketView.this.availableBrokers.containsKey(currentSelectedBroker)) {
                        OrderTicketView.this.brokerComboBox.setValue((Object)currentSelectedBroker);
                    } else {
                        OrderTicketView.this.brokerComboBox.setValue((Object)AUTO_SELECT_BROKER);
                    }
                }
            });
        }
    }

    private void fillFromExecutionReport(Optional<ExecutionReport> inReportOption) {
        if (inReportOption.isEmpty()) {
            return;
        }
        ExecutionReport report = inReportOption.get();
        if (report.getBrokerId() != null) {
            this.brokerComboBox.valueProperty().set((Object)report.getBrokerId());
        }
        if (report.getSide() != null) {
            this.sideComboBox.valueProperty().set((Object)report.getSide());
        }
        if (report.getLeavesQuantity() != null) {
            this.quantityTextField.setText(report.getLeavesQuantity().toPlainString());
        }
        if (report.getInstrument() != null) {
            this.symbolTextField.setText(report.getInstrument().getSymbol());
        }
        if (report.getOrderType() != null) {
            this.orderTypeComboBox.setValue((Object)report.getOrderType());
        }
        if (report.getPrice() != null) {
            this.priceTextField.setText(report.getPrice().toPlainString());
        }
        if (report.getTimeInForce() != null) {
            this.timeInForceComboBox.setValue((Object)report.getTimeInForce());
        }
        if (report.getText() != null) {
            this.textTextField.setText(report.getText());
        }
        if (report.getAccount() != null) {
            this.accountTextField.setText(report.getAccount());
        }
        if (report.getLastMarket() != null) {
            this.exDestinationTextField.setText(report.getLastMarket());
        }
    }

    private void updatePegToMidpointPrice() {
        if (this.pegToMidpointBidEventProperty.get() == null || this.pegToMidpointAskEventProperty.get() == null) {
            this.priceTextField.textProperty().set((Object)"");
            return;
        }
        BigDecimal askPrice = ((AskEvent)this.pegToMidpointAskEventProperty.get()).getPrice();
        BigDecimal bidPrice = ((BidEvent)this.pegToMidpointBidEventProperty.get()).getPrice();
        try {
            BigDecimal midpointPirce = askPrice.add(bidPrice).divide(new BigDecimal(2), PlatformServices.divisionContext);
            this.priceTextField.textProperty().set((Object)BigDecimalUtil.renderCurrency((BigDecimal)midpointPirce));
        }
        catch (Exception e) {
            SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Cannot set peg-to-midpoint price, will try again shortly", (Object[])new Object[0]);
        }
    }

    private void handleMarketDataRequestError(String inMessage) {
        this.uiMessageService.post(new NotificationEvent("Peg-to-Midpoint Market Data Request", "Unable to request market data for peg-to-midpoint price: " + inMessage, Alert.AlertType.ERROR));
        this.pegToMidpointCheckBox.selectedProperty().set(false);
        this.priceTextField.textProperty().set((Object)"");
        this.cancelPegToMidpointMarketDataRequest();
    }

    private void doPegToMidpointMarketDataRequest() {
        if (!this.pegToMidpointCheckBox.selectedProperty().get()) {
            return;
        }
        this.cancelPegToMidpointMarketDataRequest();
        if (this.symbolTextField.textProperty().get() != null) {
            this.pegToMidpointMarketDataRequestId = this.marketDataClient.request(MarketDataRequestBuilder.newRequest().withSymbols((String)this.symbolTextField.textProperty().get()).withContent(new Content[]{Content.TOP_OF_BOOK}).create(), new MarketDataListener(){

                public void receiveMarketData(Event inEvent) {
                    if (inEvent instanceof BidEvent) {
                        OrderTicketView.this.pegToMidpointBidEventProperty.set((Object)((BidEvent)inEvent));
                    } else if (inEvent instanceof AskEvent) {
                        OrderTicketView.this.pegToMidpointAskEventProperty.set((Object)((AskEvent)inEvent));
                    } else {
                        OrderTicketView.this.handleMarketDataRequestError("Received unexpected peg-to-midpoint event: " + inEvent.getClass());
                    }
                }

                public void onError(Throwable inThrowable) {
                    OrderTicketView.this.handleMarketDataRequestError(PlatformServices.getMessage((Throwable)inThrowable));
                }

                public void onError(I18NBoundMessage inMessage) {
                    OrderTicketView.this.handleMarketDataRequestError(inMessage.getText());
                }

                public void onError(String inMessage) {
                    OrderTicketView.this.handleMarketDataRequestError(inMessage);
                }
            });
        }
    }

    private void cancelPegToMidpointMarketDataRequest() {
        SLF4JLoggerProxy.debug((Object)this, (String)"Canceling market data request: {}", (Object[])new Object[]{this.pegToMidpointMarketDataRequestId});
        if (this.pegToMidpointMarketDataRequestId != null) {
            try {
                this.marketDataClient.cancel(this.pegToMidpointMarketDataRequestId);
            }
            catch (Exception exception) {
            }
            finally {
                this.pegToMidpointMarketDataRequestId = null;
            }
        }
    }

    private void adjustSendButton() {
        OrderType orderType;
        boolean enabled = true;
        enabled &= this.sideComboBox.getValue() != null;
        enabled &= StringUtils.trimToNull((String)this.quantityTextField.getText()) != null;
        enabled &= StringUtils.trimToNull((String)this.symbolTextField.getText()) != null;
        if ((enabled &= this.orderTypeComboBox.getValue() != null) && !(orderType = (OrderType)this.orderTypeComboBox.getValue()).isMarketOrder()) {
            enabled &= StringUtils.trimToNull((String)this.priceTextField.getText()) != null;
        }
        StringBuilder windowCaption = new StringBuilder();
        if (this.sideComboBox.getValue() == null) {
            windowCaption.append("Trade");
        } else {
            Side currentSide = (Side)this.sideComboBox.getValue();
            if (currentSide.isBuy()) {
                windowCaption.append("Buy");
            } else {
                windowCaption.append("Sell");
            }
        }
        if (this.resolvedInstrument != null) {
            windowCaption.append(" ").append(this.resolvedInstrument.getFullSymbol());
        }
        this.sendButton.setDisable(!enabled);
    }

    private void resetTicket(boolean inCompletelyReset) {
        SLF4JLoggerProxy.debug((Object)this, (String)"Clearing order ticket");
        this.quantityTextField.clear();
        if (inCompletelyReset) {
            this.brokerComboBox.setValue((Object)AUTO_SELECT_BROKER);
            this.sideComboBox.setValue(null);
            this.symbolTextField.clear();
            this.orderTypeComboBox.setValue(null);
            this.priceTextField.clear();
            this.timeInForceComboBox.setValue(null);
            this.accountTextField.clear();
            this.exDestinationTextField.clear();
            this.maxFloorTextField.clear();
            this.pegToMidpointCheckBox.selectedProperty().set(false);
            this.pegToMidpointLockedCheckBox.selectedProperty().set(false);
            this.brokerAlgoComboBox.setValue(null);
            this.brokerComboBox.requestFocus();
        } else {
            this.quantityTextField.requestFocus();
        }
    }

    private static class DisplayCustomField {
        private final BooleanProperty isEnabled = new SimpleBooleanProperty();
        private final StringProperty key = new SimpleStringProperty();
        private final StringProperty value = new SimpleStringProperty();

        private DisplayCustomField() {
        }

        private BooleanProperty isEnabledProperty() {
            return this.isEnabled;
        }

        private StringProperty keyProperty() {
            return this.key;
        }

        private StringProperty valueProperty() {
            return this.value;
        }
    }
}

