/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.trade.view.reports;

import java.math.BigDecimal;
import java.util.Date;
import org.marketcetera.core.instruments.InstrumentFromMessage;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.HasBrokerID;
import org.marketcetera.trade.HasReportID;
import org.marketcetera.trade.Hierarchy;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.Originator;
import org.marketcetera.trade.Report;
import org.marketcetera.trade.ReportID;
import org.marketcetera.trade.ReportType;
import org.marketcetera.trade.Side;
import org.marketcetera.ui.trade.view.DeletableFixMessageDisplayType;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import quickfix.FieldMap;
import quickfix.FieldNotFound;
import quickfix.InvalidMessage;
import quickfix.Message;

public class DisplayReport
implements DeletableFixMessageDisplayType,
HasReportID,
HasBrokerID {
    private final OrderID originalOrderId;
    private final OrderStatus orderStatus;
    private final Side side;
    private final Report report;
    private final Instrument instrument;
    private final Message fixMessage;
    private final BigDecimal orderQuantity;
    private final BigDecimal cumulativeQuantity;
    private final BigDecimal leavesQuantity;
    private final BigDecimal lastQuantity;
    private final BigDecimal orderPrice;
    private final BigDecimal averagePrice;
    private final BigDecimal lastPrice;
    private final String account;
    private final String exchange;

    public OrderID getOrderID() {
        return this.report.getOrderID();
    }

    public OrderID getOriginalOrderId() {
        return this.originalOrderId;
    }

    public void setOrderId(OrderID inOrderId) {
        throw new UnsupportedOperationException();
    }

    public String getTrader() {
        return this.report.getActor().getName();
    }

    public String getFixMessage() {
        return this.report.getFixMessage();
    }

    public String getSessionID() {
        return this.report.getSessionId().toString();
    }

    public int getMsgSeqNum() {
        return this.report.getMsgSeqNum();
    }

    public Date getSendingTime() {
        return this.report.getSendingTime();
    }

    public Date getTransactTime() {
        return this.report.getTransactTime();
    }

    public ReportType getMsgType() {
        return this.report.getReportType();
    }

    public ReportID getReportID() {
        return this.report.getReportID();
    }

    public Originator getOriginator() {
        return this.report.getOriginator();
    }

    public Hierarchy getHierarchy() {
        return this.report.getHierarchy();
    }

    public String getText() {
        return this.report.getText();
    }

    public Message getMessage() {
        return this.fixMessage;
    }

    public OrderID getOrderId() {
        return this.report.getOrderID();
    }

    public OrderStatus getOrderStatus() {
        return this.orderStatus;
    }

    public Side getSide() {
        return this.side;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public BigDecimal getOrderQuantity() {
        return this.orderQuantity;
    }

    public BigDecimal getCumulativeQuantity() {
        return this.cumulativeQuantity;
    }

    public BigDecimal getLeavesQuantity() {
        return this.leavesQuantity;
    }

    public BigDecimal getOrderPrice() {
        return this.orderPrice;
    }

    public BigDecimal getAveragePrice() {
        return this.averagePrice;
    }

    public String getAccount() {
        return this.account;
    }

    public BigDecimal getLastQuantity() {
        return this.lastQuantity;
    }

    public BigDecimal getLastPrice() {
        return this.lastPrice;
    }

    public String getExchange() {
        return this.exchange;
    }

    public BrokerID getBrokerId() {
        return this.report.getBrokerID();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DisplayReport [report=").append(this.report).append("]");
        return builder.toString();
    }

    public DisplayReport(Report inReport) {
        this.report = inReport;
        try {
            this.fixMessage = new Message(this.report.getFixMessage());
            this.orderStatus = this.fixMessage.isSetField(39) ? OrderStatus.getInstanceForFIXMessage((Message)this.fixMessage) : null;
            this.side = this.fixMessage.isSetField(54) ? Side.getInstanceForFIXValue((char)this.fixMessage.getChar(54)) : null;
            this.originalOrderId = this.fixMessage.isSetField(41) ? new OrderID(this.fixMessage.getString(41)) : null;
            Instrument tmpInstrument = null;
            if (this.fixMessage.isSetField(55)) {
                try {
                    tmpInstrument = ((InstrumentFromMessage)InstrumentFromMessage.SELECTOR.forValue((Object)this.fixMessage)).extract((FieldMap)this.fixMessage);
                }
                catch (Exception e) {
                    SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
                }
            } else {
                tmpInstrument = null;
            }
            this.instrument = tmpInstrument;
            this.orderQuantity = this.fixMessage.isSetField(38) ? this.fixMessage.getDecimal(38) : null;
            this.cumulativeQuantity = this.fixMessage.isSetField(14) ? this.fixMessage.getDecimal(14) : null;
            this.leavesQuantity = this.fixMessage.isSetField(151) ? this.fixMessage.getDecimal(151) : null;
            this.lastQuantity = this.fixMessage.isSetField(32) ? this.fixMessage.getDecimal(32) : null;
            this.orderPrice = this.fixMessage.isSetField(44) ? this.fixMessage.getDecimal(44) : null;
            this.averagePrice = this.fixMessage.isSetField(6) ? this.fixMessage.getDecimal(6) : null;
            this.lastPrice = this.fixMessage.isSetField(31) ? this.fixMessage.getDecimal(31) : null;
            this.account = this.fixMessage.isSetField(1) ? this.fixMessage.getString(1) : null;
            this.exchange = this.fixMessage.isSetField(207) ? this.fixMessage.getString(207) : null;
        }
        catch (FieldNotFound | InvalidMessage e) {
            throw new RuntimeException(e);
        }
    }
}

