/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.trade.view.suggestions;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.marketcetera.core.BigDecimalUtil;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.Suggestion;
import org.marketcetera.trade.SuggestionListener;
import org.marketcetera.trade.TradePermissions;
import org.marketcetera.ui.PhotonServices;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.service.trade.TradeClientService;
import org.marketcetera.ui.trade.event.SuggestionEvent;
import org.marketcetera.ui.trade.view.suggestions.DisplaySuggestion;
import org.marketcetera.ui.view.AbstractContentView;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.nocrala.tools.texttablefmt.BorderStyle;
import org.nocrala.tools.texttablefmt.ShownBorders;
import org.nocrala.tools.texttablefmt.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
@AutoConfiguration
@Scope(value="prototype")
public class SuggestionsView
extends AbstractContentView {
    @Autowired
    private ApplicationContext applicationContext;
    private TableColumn<DisplaySuggestion, String> identifierColumn;
    private TableColumn<DisplaySuggestion, Side> sideColumn;
    private TableColumn<DisplaySuggestion, BigDecimal> quantityColumn;
    private TableColumn<DisplaySuggestion, BigDecimal> priceColumn;
    private TableColumn<DisplaySuggestion, BigDecimal> scoreColumn;
    private TableColumn<DisplaySuggestion, Instrument> instrumentColumn;
    private TableColumn<DisplaySuggestion, OrderType> orderTypeColumn;
    private TableColumn<DisplaySuggestion, Date> timestampColumn;
    private ContextMenu suggestionContextMenu;
    private MenuItem executeMenuItem;
    private MenuItem deleteMenuItem;
    private MenuItem copyMenuItem;
    private SuggestionListener suggestionListener;
    private VBox mainLayout;
    private TableView<DisplaySuggestion> suggestionTable;
    private TradeClientService tradeClient;
    private static final String NAME = "Suggestions View";

    @Override
    protected void onStart() {
        this.tradeClient = this.serviceManager.getService(TradeClientService.class);
        this.mainLayout = new VBox(10.0);
        this.initializeSuggestionTable();
        this.mainLayout.getChildren().add(this.suggestionTable);
        this.suggestionTable.prefWidthProperty().bind((ObservableValue)this.mainLayout.widthProperty());
        this.suggestionTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.initializeSuggestionListener();
    }

    @Override
    public void onClose() {
        if (this.suggestionListener != null) {
            try {
                this.tradeClient.removeSuggestionListener(this.suggestionListener);
                this.suggestionListener = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.onClose();
    }

    @Override
    public Region getMainLayout() {
        return this.mainLayout;
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    protected void onClientConnect() {
        this.updateSuggestions();
        this.initializeSuggestionListener();
    }

    @Override
    protected void onClientDisconnect() {
        Platform.runLater(() -> this.suggestionTable.getItems().clear());
    }

    public SuggestionsView(Region inParent, NewWindowEvent inEvent, Properties inProperties) {
        super(inParent, inEvent, inProperties);
    }

    private void initializeSuggestionListener() {
        if (this.suggestionListener != null) {
            try {
                this.tradeClient.removeSuggestionListener(this.suggestionListener);
                this.suggestionListener = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.suggestionListener = new SuggestionListener(){

            public void receiveSuggestion(Suggestion inSuggestion) {
                SLF4JLoggerProxy.trace((Object)SuggestionsView.this, (String)"Received {}", (Object[])new Object[]{inSuggestion});
                SuggestionsView.this.suggestionTable.getItems().add((Object)new DisplaySuggestion(inSuggestion));
            }
        };
        this.tradeClient.addSuggestionListener(this.suggestionListener);
    }

    private void updateSuggestions() {
    }

    private void initializeSuggestionTable() {
        this.suggestionTable = new TableView();
        this.suggestionTable.setPlaceholder((Node)new Label("no suggestions"));
        this.initializeSuggestionTableColumns();
        this.initializeSuggestionContextMenu();
        this.suggestionTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    public static TableCell<DisplaySuggestion, Instrument> renderInstrumentCell(TableColumn<DisplaySuggestion, Instrument> inTableColumn) {
        TableCell<DisplaySuggestion, Instrument> tableCell = new TableCell<DisplaySuggestion, Instrument>(){

            protected void updateItem(Instrument inItem, boolean isEmpty) {
                super.updateItem((Object)inItem, isEmpty);
                this.setText(null);
                this.setGraphic(null);
                if (!isEmpty && inItem != null) {
                    this.setText(inItem.getFullSymbol());
                }
            }
        };
        return tableCell;
    }

    private void initializeSuggestionTableColumns() {
        this.identifierColumn = new TableColumn("Identifier");
        this.identifierColumn.setCellValueFactory((Callback)new PropertyValueFactory("identifier"));
        this.scoreColumn = new TableColumn("Score");
        this.scoreColumn.setCellValueFactory((Callback)new PropertyValueFactory("score"));
        this.scoreColumn.setCellFactory(tableColumn -> PhotonServices.renderNumberCell(tableColumn, 4, 4));
        this.quantityColumn = new TableColumn("Quantity");
        this.quantityColumn.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.quantityColumn.setCellFactory(tableColumn -> PhotonServices.renderNumberCell(tableColumn));
        this.sideColumn = new TableColumn("Side");
        this.sideColumn.setCellValueFactory((Callback)new PropertyValueFactory("side"));
        this.quantityColumn = new TableColumn("Quantity");
        this.quantityColumn.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.quantityColumn.setCellFactory(tableColumn -> PhotonServices.renderNumberCell(tableColumn));
        this.instrumentColumn = new TableColumn("Instrument");
        this.instrumentColumn.setCellValueFactory((Callback)new PropertyValueFactory("instrument"));
        this.instrumentColumn.setCellFactory(tableColumn -> SuggestionsView.renderInstrumentCell((TableColumn<DisplaySuggestion, Instrument>)tableColumn));
        this.priceColumn = new TableColumn("Price");
        this.priceColumn.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.priceColumn.setCellFactory(tableColumn -> PhotonServices.renderCurrencyCell(tableColumn));
        this.orderTypeColumn = new TableColumn("Order Type");
        this.orderTypeColumn.setCellValueFactory((Callback)new PropertyValueFactory("orderType"));
        this.timestampColumn = new TableColumn("Timestamp");
        this.timestampColumn.setCellValueFactory((Callback)new PropertyValueFactory("timestamp"));
        this.timestampColumn.setCellFactory(tableColumn -> PhotonServices.renderDateCell(tableColumn));
        this.suggestionTable.getColumns().add(this.identifierColumn);
        this.suggestionTable.getColumns().add(this.scoreColumn);
        this.suggestionTable.getColumns().add(this.sideColumn);
        this.suggestionTable.getColumns().add(this.instrumentColumn);
        this.suggestionTable.getColumns().add(this.quantityColumn);
        this.suggestionTable.getColumns().add(this.priceColumn);
        this.suggestionTable.getColumns().add(this.orderTypeColumn);
        this.suggestionTable.getColumns().add(this.timestampColumn);
    }

    protected void enableContextMenuItems(Collection<DisplaySuggestion> inSelectedItems) {
        if (inSelectedItems == null || inSelectedItems.isEmpty()) {
            this.executeMenuItem.setDisable(true);
            this.deleteMenuItem.setDisable(true);
            return;
        }
        this.executeMenuItem.setDisable(!this.authzHelperService.hasPermission((GrantedAuthority)TradePermissions.SendOrderAction));
        this.deleteMenuItem.setDisable(false);
    }

    private Collection<DisplaySuggestion> getSelectedSuggestions() {
        return this.suggestionTable.getSelectionModel().getSelectedItems();
    }

    private void initializeSuggestionContextMenu() {
        this.executeMenuItem = new MenuItem("Execute");
        this.executeMenuItem.setOnAction(event -> {
            Collection<DisplaySuggestion> selectedItems = this.getSelectedSuggestions();
            if (selectedItems == null || selectedItems.isEmpty()) {
                return;
            }
            this.doExecute(selectedItems);
        });
        this.deleteMenuItem = new MenuItem("Delete");
        this.deleteMenuItem.setOnAction(event -> {
            Collection<DisplaySuggestion> selectedItems = this.getSelectedSuggestions();
            if (selectedItems == null || selectedItems.isEmpty()) {
                return;
            }
            this.doDelete(selectedItems);
        });
        this.copyMenuItem = new MenuItem("Copy");
        this.copyMenuItem.setOnAction(event -> {
            Collection<DisplaySuggestion> selectedItems = this.getSelectedSuggestions();
            if (selectedItems == null || selectedItems.isEmpty()) {
                return;
            }
            this.doCopy(selectedItems);
        });
        this.suggestionContextMenu = new ContextMenu();
        this.suggestionContextMenu.getItems().addAll((Object[])new MenuItem[]{this.executeMenuItem, this.deleteMenuItem, new SeparatorMenuItem(), this.copyMenuItem});
        this.suggestionTable.setContextMenu(this.suggestionContextMenu);
        this.suggestionTable.getSelectionModel().selectedItemProperty().addListener((inObservable, inOldValue, inNewValue) -> this.enableContextMenuItems(this.getSelectedSuggestions()));
    }

    private void doExecute(Collection<DisplaySuggestion> inSuggestions) {
        for (DisplaySuggestion displaySuggestion : inSuggestions) {
            this.uiMessageService.post(this.applicationContext.getBean(SuggestionEvent.class, new Object[]{((Side)displaySuggestion.sideProperty().get()).name() + " " + ((Instrument)displaySuggestion.instrumentProperty().get()).getFullSymbol(), displaySuggestion.sourceProperty().get()}));
        }
    }

    private void doDelete(Collection<DisplaySuggestion> inSuggestions) {
        this.suggestionTable.getItems().removeAll(inSuggestions);
    }

    private void doCopy(Collection<DisplaySuggestion> inSuggestions) {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(this.renderSuggestions(inSuggestions));
        clipboard.setContent((Map)clipboardContent);
    }

    private String renderSuggestions(Collection<DisplaySuggestion> inSuggestions) {
        Table table = new Table(8, BorderStyle.CLASSIC_COMPATIBLE_WIDE, ShownBorders.ALL, false);
        table.addCell("Trade Suggestions", PlatformServices.cellStyle, 8);
        table.addCell("Identifier", PlatformServices.cellStyle);
        table.addCell("Score", PlatformServices.cellStyle);
        table.addCell("Side", PlatformServices.cellStyle);
        table.addCell("Instrument", PlatformServices.cellStyle);
        table.addCell("Quantity", PlatformServices.cellStyle);
        table.addCell("Price", PlatformServices.cellStyle);
        table.addCell("Order Type", PlatformServices.cellStyle);
        table.addCell("Timestamp", PlatformServices.cellStyle);
        for (DisplaySuggestion suggestion : inSuggestions) {
            table.addCell((String)suggestion.identifierProperty().get());
            table.addCell(BigDecimalUtil.renderDecimal((BigDecimal)((BigDecimal)suggestion.scoreProperty().get()), (int)4, (int)4));
            table.addCell(((Side)suggestion.sideProperty().get()).name());
            table.addCell(((Instrument)suggestion.instrumentProperty().get()).getFullSymbol());
            table.addCell(BigDecimalUtil.render((BigDecimal)((BigDecimal)suggestion.quantityProperty().get())));
            table.addCell(BigDecimalUtil.renderCurrency((BigDecimal)((BigDecimal)suggestion.priceProperty().get())));
            table.addCell(((OrderType)suggestion.orderTypeProperty().get()).name());
            table.addCell(String.valueOf(suggestion.timestampProperty().get()));
        }
        return table.render();
    }
}

