/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.view;

import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javax.annotation.PostConstruct;
import org.marketcetera.ui.PhotonServices;
import org.marketcetera.ui.service.AuthorizationHelperService;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.ui.view.MenuContent;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ApplicationMenu {
    private SortedSet<MenuItemMetaData> topLevelContent = new TreeSet<MenuItemMetaData>();
    @Autowired
    private AuthorizationHelperService authzHelperService;
    @Autowired
    private ApplicationContext applicationContext;
    private MenuBar menu;

    @PostConstruct
    public void start() {
        this.initMenu();
    }

    public void refreshMenuPermissions() {
        SessionUser currentUser = SessionUser.getCurrent();
        if (currentUser == null) {
            this.menu.setVisible(false);
            return;
        }
        this.menu.setVisible(true);
        for (MenuItemMetaData topLevelContentItem : this.topLevelContent) {
            this.evaluatePermissions(topLevelContentItem.getAllPermissions(), SessionUser.getCurrent().getPermissions(), topLevelContentItem.getMenuItem());
            if (!topLevelContentItem.getMenuItem().isVisible()) continue;
            boolean atLeastOneChildVisible = false;
            for (MenuItemMetaData childContentItem : topLevelContentItem.getChildItems()) {
                this.evaluatePermissions(childContentItem.getAllPermissions(), SessionUser.getCurrent().getPermissions(), childContentItem.getMenuItem());
                atLeastOneChildVisible |= childContentItem.getMenuItem().isVisible();
            }
            if (topLevelContentItem.getChildItems().isEmpty()) continue;
            topLevelContentItem.getMenuItem().setVisible(atLeastOneChildVisible);
        }
    }

    public MenuBar getMenu() {
        return this.menu;
    }

    private void initMenu() {
        TreeMap<MenuContent, TreeSet<MenuContent>> categoryContent = new TreeMap<MenuContent, TreeSet<MenuContent>>(MenuContent.comparator);
        for (Map.Entry entry : this.applicationContext.getBeansOfType(MenuContent.class).entrySet()) {
            MenuContent contentItem = (MenuContent)entry.getValue();
            MenuContent contentCategory = contentItem.getCategory();
            if (contentCategory == null) {
                this.topLevelContent.add(new MenuItemMetaData(contentItem));
                continue;
            }
            TreeSet<MenuContent> contentForCategory = (TreeSet<MenuContent>)categoryContent.get(contentCategory);
            if (contentForCategory == null) {
                contentForCategory = new TreeSet<MenuContent>(MenuContent.comparator);
                categoryContent.put(contentCategory, contentForCategory);
            }
            contentForCategory.add(contentItem);
            this.topLevelContent.add(new MenuItemMetaData(contentCategory));
        }
        this.menu = new MenuBar();
        for (MenuItemMetaData topLevelContentItem : this.topLevelContent) {
            Menu parent = new Menu();
            parent.setText(topLevelContentItem.getMenuCaption());
            if (topLevelContentItem.getMenuIcon() != null) {
                // empty if block
            }
            this.menu.getMenus().add((Object)parent);
            topLevelContentItem.setMenuItem((MenuItem)parent);
            SortedSet childItems = (SortedSet)categoryContent.get(topLevelContentItem);
            if (childItems == null || childItems.isEmpty()) {
                MenuItem placeholderMenuItem = new MenuItem();
                parent.getItems().add((Object)placeholderMenuItem);
                parent.showingProperty().addListener((observableValue, oldValue, newValue) -> {
                    if (newValue.booleanValue()) {
                        ((MenuItem)parent.getItems().get(0)).fire();
                    }
                });
                placeholderMenuItem.setOnAction(e -> topLevelContentItem.getCommand().run());
                continue;
            }
            for (MenuContent childItem : childItems) {
                MenuItem newChildItem = new MenuItem();
                newChildItem.setText(childItem.getMenuCaption());
                if (childItem.getMenuIcon() != null) {
                    newChildItem.setGraphic(PhotonServices.getSvgResource(childItem.getMenuIcon(), 0.75));
                }
                newChildItem.setOnAction(e -> childItem.getCommand().run());
                parent.getItems().add((Object)newChildItem);
                MenuItemMetaData newChildItemMetaData = new MenuItemMetaData(childItem);
                newChildItemMetaData.setMenuItem(newChildItem);
                topLevelContentItem.getChildItems().add(newChildItemMetaData);
            }
        }
    }

    private void evaluatePermissions(Set<GrantedAuthority> inRequiredPermissions, Set<GrantedAuthority> inActualPermissions, MenuItem inMenuItem) {
        inMenuItem.setVisible(true);
        if (inRequiredPermissions != null) {
            for (GrantedAuthority requiredPermission : inRequiredPermissions) {
                if (this.authzHelperService.hasPermission(requiredPermission)) continue;
                SLF4JLoggerProxy.trace((Object)this, (String)"Cannot display {}, {} not in {}", (Object[])new Object[]{inMenuItem.getText(), requiredPermission, inActualPermissions});
                inMenuItem.setVisible(false);
                break;
            }
        }
    }

    private class MenuItemMetaData
    implements Comparable<MenuItemMetaData>,
    MenuContent {
        private MenuItem menuItem;
        private final MenuContent menuContent;
        private final SortedSet<MenuItemMetaData> childItems = new TreeSet<MenuItemMetaData>();

        @Override
        public Set<GrantedAuthority> getAllPermissions() {
            return this.menuContent.getAllPermissions();
        }

        @Override
        public String getMenuCaption() {
            return this.menuContent.getMenuCaption();
        }

        @Override
        public int getWeight() {
            return this.menuContent.getWeight();
        }

        @Override
        public MenuContent getCategory() {
            return this.menuContent.getCategory();
        }

        @Override
        public URL getMenuIcon() {
            return this.menuContent.getMenuIcon();
        }

        @Override
        public Runnable getCommand() {
            return this.menuContent.getCommand();
        }

        @Override
        public int compareTo(MenuItemMetaData inO) {
            return Integer.valueOf(this.getMenuContent().getWeight()).compareTo(inO.getMenuContent().getWeight());
        }

        public String toString() {
            return this.menuContent.getMenuCaption() + " children: " + this.childItems;
        }

        private MenuContent getMenuContent() {
            return this.menuContent;
        }

        private SortedSet<MenuItemMetaData> getChildItems() {
            return this.childItems;
        }

        private MenuItem getMenuItem() {
            return this.menuItem;
        }

        private MenuItemMetaData(MenuContent inMenuContent) {
            this.menuContent = inMenuContent;
        }

        private void setMenuItem(MenuItem inMenuItem) {
            this.menuItem = inMenuItem;
        }
    }
}

