/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui;

import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.marketcetera.core.ClientStatusListener;
import org.marketcetera.ui.service.ServiceManager;
import org.marketcetera.ui.service.admin.AdminClientService;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@EnableAutoConfiguration
@Scope(value="prototype")
public class ClientStatusUpdater
implements ClientStatusListener {
    private Image availableImage;
    private Image unavailableImage;
    private Image unknownImage;
    @Autowired
    private ServiceManager serviceManager;
    private final ImageView target;

    public ClientStatusUpdater(ImageView inTarget) {
        this.target = inTarget;
    }

    @PostConstruct
    public void start() {
        AdminClientService adminClientService = this.serviceManager.getService(AdminClientService.class);
        this.availableImage = new Image(String.valueOf(this.getClass().getClassLoader().getResource("images/LedGreen.gif")));
        this.unavailableImage = new Image(String.valueOf(this.getClass().getClassLoader().getResource("images/LedRed.gif")));
        this.unknownImage = new Image(String.valueOf(this.getClass().getClassLoader().getResource("images/LedNone.gif")));
        if (adminClientService.isRunning()) {
            this.setAvailable();
        } else {
            this.setUnavailable();
        }
        adminClientService.addClientStatusListener(this);
    }

    @PreDestroy
    public void stop() {
        AdminClientService adminClientService = this.serviceManager.getService(AdminClientService.class);
        adminClientService.removeClientStatusListener(this);
        this.setUnknown();
    }

    public void receiveClientStatus(boolean inIsAvailable) {
        SLF4JLoggerProxy.debug((Object)this, (String)"{} received client status: {}", (Object[])new Object[]{this.getClass().getSimpleName(), inIsAvailable});
        if (inIsAvailable) {
            this.setAvailable();
        } else {
            this.setUnavailable();
        }
    }

    private void setAvailable() {
        this.updateImage(this.availableImage, "Server is available");
    }

    private void setUnavailable() {
        this.updateImage(this.unavailableImage, "Server is unavailable");
    }

    private void setUnknown() {
        this.updateImage(this.unknownImage, "Server connection status is unknown");
    }

    private void updateImage(final Image inImage, final String inTooltipMessage) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ClientStatusUpdater.this.target.setImage(inImage);
                Tooltip.install((Node)ClientStatusUpdater.this.target, (Tooltip)new Tooltip(inTooltipMessage));
            }
        });
    }
}

