/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui;

import io.grpc.StatusRuntimeException;
import java.io.IOException;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.ui.PhotonApp;
import org.marketcetera.ui.PhotonServices;
import org.marketcetera.ui.events.LoginEvent;
import org.marketcetera.ui.service.NoServiceException;
import org.marketcetera.ui.service.ServerConnectionService;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.ui.service.UiMessageService;
import org.marketcetera.ui.view.ValidatingTextField;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.ws.stateful.Authenticator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class LoginView
extends Stage {
    private Scene mainScene;
    private Button loginButton;
    private PasswordField passwordText;
    private TextField usernameText;
    private Label adviceLabel;
    private ServerConnectionService.ServerConnectionData serverConnectionData;
    private boolean serverConnectionDataChanged;
    @Autowired
    private ServerConnectionService serverConnectionService;
    @Autowired
    private Authenticator webAuthenticator;
    @Autowired
    private UiMessageService webMessageService;

    @PostConstruct
    public void start() {
        this.serverConnectionDataChanged = false;
        this.serverConnectionData = this.serverConnectionService.getConnectionData();
        this.initModality(Modality.APPLICATION_MODAL);
        HBox usernameBox = new HBox(5.0);
        Label usernameLabel = new Label("Username");
        this.usernameText = new TextField();
        usernameBox.getChildren().addAll((Object[])new Node[]{usernameLabel, this.usernameText});
        HBox passwordBox = new HBox(5.0);
        Label passwordLabel = new Label("Password");
        this.passwordText = new PasswordField();
        passwordBox.getChildren().addAll((Object[])new Node[]{passwordLabel, this.passwordText});
        SimpleBooleanProperty networkInvalid = new SimpleBooleanProperty(false);
        SimpleBooleanProperty credentialsInvalid = new SimpleBooleanProperty(true);
        SimpleBooleanProperty disableLogin = new SimpleBooleanProperty(networkInvalid.get() || credentialsInvalid.get());
        networkInvalid.addListener((arg_0, arg_1, arg_2) -> LoginView.lambda$start$0((BooleanProperty)disableLogin, (BooleanProperty)networkInvalid, (BooleanProperty)credentialsInvalid, arg_0, arg_1, arg_2));
        credentialsInvalid.addListener((arg_0, arg_1, arg_2) -> LoginView.lambda$start$1((BooleanProperty)disableLogin, (BooleanProperty)networkInvalid, (BooleanProperty)credentialsInvalid, arg_0, arg_1, arg_2));
        this.loginButton = new Button("Login");
        this.loginButton.setOnAction(this::onLogin);
        this.loginButton.setDisable(true);
        this.usernameText.textProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$start$2((BooleanProperty)credentialsInvalid, (BooleanProperty)disableLogin, (BooleanProperty)networkInvalid, arg_0, arg_1, arg_2));
        this.passwordText.textProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$start$3((BooleanProperty)credentialsInvalid, (BooleanProperty)disableLogin, (BooleanProperty)networkInvalid, arg_0, arg_1, arg_2));
        this.adviceLabel = new Label();
        this.adviceLabel.setVisible(false);
        this.setOnCloseRequest(this::onCloseRequest);
        VBox root = new VBox(5.0);
        root.setPadding(new Insets(10.0));
        root.addEventHandler(KeyEvent.KEY_PRESSED, arg_0 -> this.lambda$start$4((BooleanProperty)networkInvalid, arg_0));
        this.loginButton.disableProperty().bind((ObservableValue)disableLogin);
        GridPane serverConnectionGrid = new GridPane();
        ValidatingTextField hostnameTextField = new ValidatingTextField(input -> PhotonServices.isValidHostNameSyntax(input));
        hostnameTextField.setPromptText("MATP host or ip address");
        hostnameTextField.textProperty().set((Object)this.serverConnectionData.getHostname());
        ValidatingTextField portTextField = new ValidatingTextField(input -> StringUtils.trimToNull((String)input) != null && input.matches("^([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])$"));
        portTextField.setPromptText("MATP port");
        portTextField.textProperty().set((Object)String.valueOf(this.serverConnectionData.getPort()));
        CheckBox useSslCheckBox = new CheckBox();
        useSslCheckBox.selectedProperty().set(this.serverConnectionData.useSsl());
        useSslCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.serverConnectionData.setUseSsl((boolean)newValue);
            this.serverConnectionDataChanged = true;
        });
        hostnameTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$start$8((BooleanProperty)networkInvalid, hostnameTextField, portTextField, (BooleanProperty)disableLogin, (BooleanProperty)credentialsInvalid, arg_0, arg_1, arg_2));
        portTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$start$9((BooleanProperty)networkInvalid, hostnameTextField, portTextField, (BooleanProperty)disableLogin, (BooleanProperty)credentialsInvalid, arg_0, arg_1, arg_2));
        serverConnectionGrid.setHgap(10.0);
        serverConnectionGrid.setVgap(10.0);
        serverConnectionGrid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        serverConnectionGrid.add((Node)new Label("Hostname"), 0, 0);
        serverConnectionGrid.add((Node)hostnameTextField, 1, 0);
        serverConnectionGrid.add((Node)new Label("Port"), 0, 1);
        serverConnectionGrid.add((Node)portTextField, 1, 1);
        serverConnectionGrid.add((Node)new Label("SSL"), 0, 2);
        serverConnectionGrid.add((Node)useSslCheckBox, 1, 2);
        Accordion accordion = new Accordion();
        TitledPane pane1 = new TitledPane("Server Connection", (Node)serverConnectionGrid);
        pane1.setAnimated(false);
        pane1.expandedProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.sizeToScene()));
        accordion.getPanes().add((Object)pane1);
        VBox serverConnectionLayout = new VBox(new Node[]{accordion});
        root.getChildren().addAll((Object[])new Node[]{usernameBox, passwordBox, serverConnectionLayout, this.adviceLabel, this.loginButton});
        this.mainScene = new Scene((Parent)root);
        PhotonServices.style(this.mainScene);
        this.setScene(this.mainScene);
        this.setTitle("Login");
        this.initStyle(StageStyle.UTILITY);
        this.setResizable(false);
    }

    private void onLogin(ActionEvent inEvent) {
        boolean authenticationSuccess;
        String message;
        String username;
        block9: {
            if (this.serverConnectionDataChanged) {
                this.serverConnectionDataChanged = false;
                try {
                    this.serverConnectionService.setConnectionData(this.serverConnectionData);
                }
                catch (IOException e) {
                    SLF4JLoggerProxy.warn((Object)((Object)this), (Throwable)e, (String)"Unable to update config with changes", (Object[])new Object[0]);
                }
            }
            this.adviceLabel.setText("");
            this.adviceLabel.setVisible(false);
            this.sizeToScene();
            username = StringUtils.trimToNull((String)this.usernameText.getText());
            String password = StringUtils.trimToNull((String)this.passwordText.getText());
            SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Attempting to log in {}", (Object[])new Object[]{username});
            SessionUser sessionUser = new SessionUser(username, password);
            SessionUser.getCurrent().setAttribute(SessionUser.class, sessionUser);
            message = null;
            try {
                authenticationSuccess = this.webAuthenticator.shouldAllow(null, username, password.toCharArray());
                if (authenticationSuccess) {
                    SLF4JLoggerProxy.info((Object)((Object)this), (String)"{} logged in", (Object[])new Object[]{username});
                    this.webMessageService.post(new LoginEvent(sessionUser));
                    this.close();
                } else {
                    message = "Username or password does not match";
                }
            }
            catch (StatusRuntimeException | NoServiceException e) {
                message = PlatformServices.getMessage((Throwable)e);
                authenticationSuccess = false;
            }
            catch (Exception e) {
                authenticationSuccess = false;
                if (message != null) break block9;
                message = PlatformServices.getMessage((Throwable)e);
            }
        }
        if (!authenticationSuccess) {
            SLF4JLoggerProxy.warn((Object)((Object)this), (String)"{} failed to log in: {}", (Object[])new Object[]{username, message});
            SessionUser.getCurrent().setAttribute(SessionUser.class, null);
            this.adviceLabel.setVisible(true);
            this.adviceLabel.setStyle(PhotonServices.errorMessage);
            this.adviceLabel.setText(message);
            this.passwordText.textProperty().set((Object)"");
            this.sizeToScene();
        }
    }

    private void onCloseRequest(WindowEvent inEvent) {
        PhotonApp.getApp().doAppShutdown();
    }

    private /* synthetic */ void lambda$start$9(BooleanProperty networkInvalid, ValidatingTextField hostnameTextField, ValidatingTextField portTextField, BooleanProperty disableLogin, BooleanProperty credentialsInvalid, ObservableValue observable, String oldValue, String newValue) {
        networkInvalid.set(!hostnameTextField.isValidProperty().get() || !portTextField.isValidProperty().get());
        disableLogin.set(networkInvalid.get() || credentialsInvalid.get());
        String rawValue = StringUtils.trimToNull((String)newValue);
        if (rawValue != null) {
            try {
                this.serverConnectionData.setPort(Integer.parseInt(rawValue));
                this.serverConnectionDataChanged = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private /* synthetic */ void lambda$start$8(BooleanProperty networkInvalid, ValidatingTextField hostnameTextField, ValidatingTextField portTextField, BooleanProperty disableLogin, BooleanProperty credentialsInvalid, ObservableValue observable, String oldValue, String newValue) {
        networkInvalid.set(!hostnameTextField.isValidProperty().get() || !portTextField.isValidProperty().get());
        disableLogin.set(networkInvalid.get() || credentialsInvalid.get());
        this.serverConnectionDataChanged = true;
        this.serverConnectionData.setHostname(StringUtils.trimToNull((String)newValue));
    }

    private /* synthetic */ void lambda$start$4(BooleanProperty networkInvalid, KeyEvent event) {
        if (networkInvalid.get()) {
            return;
        }
        if (event.getCode() == KeyCode.ENTER) {
            this.loginButton.fire();
            event.consume();
        } else if (event.getCode() == KeyCode.ESCAPE) {
            this.fireEvent((Event)new WindowEvent((Window)this, WindowEvent.WINDOW_CLOSE_REQUEST));
        }
    }

    private /* synthetic */ void lambda$start$3(BooleanProperty credentialsInvalid, BooleanProperty disableLogin, BooleanProperty networkInvalid, ObservableValue observable, String oldValue, String newValue) {
        credentialsInvalid.set(StringUtils.trimToNull((String)((String)this.usernameText.textProperty().get())) == null || StringUtils.trimToNull((String)newValue) == null);
        disableLogin.set(networkInvalid.get() || credentialsInvalid.get());
    }

    private /* synthetic */ void lambda$start$2(BooleanProperty credentialsInvalid, BooleanProperty disableLogin, BooleanProperty networkInvalid, ObservableValue observable, String oldValue, String newValue) {
        credentialsInvalid.set(StringUtils.trimToNull((String)newValue) == null || StringUtils.trimToNull((String)((String)this.passwordText.textProperty().get())) == null);
        disableLogin.set(networkInvalid.get() || credentialsInvalid.get());
    }

    private static /* synthetic */ void lambda$start$1(BooleanProperty disableLogin, BooleanProperty networkInvalid, BooleanProperty credentialsInvalid, ObservableValue observable, Boolean oldValue, Boolean newValue) {
        disableLogin.set(networkInvalid.get() || credentialsInvalid.get());
    }

    private static /* synthetic */ void lambda$start$0(BooleanProperty disableLogin, BooleanProperty networkInvalid, BooleanProperty credentialsInvalid, ObservableValue observable, Boolean oldValue, Boolean newValue) {
        disableLogin.set(networkInvalid.get() || credentialsInvalid.get());
    }
}

