/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui;

import java.util.Arrays;
import org.marketcetera.admin.AdminRpcClientFactory;
import org.marketcetera.admin.PermissionFactory;
import org.marketcetera.admin.RoleFactory;
import org.marketcetera.admin.UserAttributeFactory;
import org.marketcetera.admin.UserFactory;
import org.marketcetera.admin.impl.SimplePermissionFactory;
import org.marketcetera.admin.impl.SimpleRoleFactory;
import org.marketcetera.admin.impl.SimpleUserAttributeFactory;
import org.marketcetera.admin.impl.SimpleUserFactory;
import org.marketcetera.cluster.ClusterDataFactory;
import org.marketcetera.cluster.SimpleClusterDataFactory;
import org.marketcetera.core.XmlService;
import org.marketcetera.fix.FixAdminRpcClientFactory;
import org.marketcetera.fix.FixSessionAttributeDescriptorFactory;
import org.marketcetera.fix.MutableActiveFixSessionFactory;
import org.marketcetera.fix.MutableFixSessionFactory;
import org.marketcetera.fix.impl.SimpleActiveFixSessionFactory;
import org.marketcetera.fix.impl.SimpleFixSessionAttributeDescriptorFactory;
import org.marketcetera.fix.impl.SimpleFixSessionFactory;
import org.marketcetera.marketdata.rpc.client.MarketDataRpcClientFactory;
import org.marketcetera.strategy.SimpleStrategyInstanceFactory;
import org.marketcetera.strategy.SimpleStrategyMessageFactory;
import org.marketcetera.strategy.StrategyInstanceFactory;
import org.marketcetera.strategy.StrategyMessageFactory;
import org.marketcetera.strategy.StrategyRpcClientFactory;
import org.marketcetera.symbol.IterativeSymbolResolver;
import org.marketcetera.symbol.PatternSymbolResolver;
import org.marketcetera.symbol.SymbolResolverService;
import org.marketcetera.trade.AverageFillPriceFactory;
import org.marketcetera.trade.MutableExecutionReportSummaryFactory;
import org.marketcetera.trade.MutableOrderSummaryFactory;
import org.marketcetera.trade.MutableReportFactory;
import org.marketcetera.trade.SimpleAverageFillPrice;
import org.marketcetera.trade.SimpleAverageFillPriceFactory;
import org.marketcetera.trade.SimpleExecutionReportSummaryFactory;
import org.marketcetera.trade.SimpleOrderSummaryFactory;
import org.marketcetera.trade.SimpleReportFactory;
import org.marketcetera.trade.TradeContextClassProvider;
import org.marketcetera.trading.rpc.TradeRpcClientFactory;
import org.marketcetera.ui.service.ServiceManager;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.ui.service.admin.AdminClientService;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.ws.stateful.Authenticator;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"file:conf/application.properties"})
public class PhotonConfiguration {
    @Value(value="${metc.security.use.ssl:false}")
    private boolean useSsl;

    @Bean
    public SymbolResolverService getSymbolResolverService() {
        IterativeSymbolResolver symbolResolverService = new IterativeSymbolResolver();
        symbolResolverService.getSymbolResolvers().add(new PatternSymbolResolver());
        return symbolResolverService;
    }

    @Bean
    public XmlService getXmlService() {
        XmlService xmlService = new XmlService();
        xmlService.getContextPath().addAll(Arrays.asList(new TradeContextClassProvider().getContextClasses()));
        xmlService.getContextPath().add(SimpleAverageFillPrice.class);
        return xmlService;
    }

    @Bean
    public StrategyMessageFactory getStrategyMessageFactory() {
        return new SimpleStrategyMessageFactory();
    }

    @Bean
    public StrategyInstanceFactory getStrategyInstanceFactory() {
        return new SimpleStrategyInstanceFactory();
    }

    @Bean
    public AverageFillPriceFactory getAverageFillPriceFactory() {
        return new SimpleAverageFillPriceFactory();
    }

    @Bean
    public MutableReportFactory getReportFactory() {
        return new SimpleReportFactory();
    }

    @Bean
    public MutableExecutionReportSummaryFactory getExecutionReportSummaryFactory() {
        return new SimpleExecutionReportSummaryFactory();
    }

    @Bean
    public MutableOrderSummaryFactory getOrderSummaryFactory() {
        return new SimpleOrderSummaryFactory();
    }

    @Bean
    public TradeRpcClientFactory getTradeClientFactory() {
        return new TradeRpcClientFactory();
    }

    @Bean
    public StrategyRpcClientFactory getStrategyClientFactory() {
        return new StrategyRpcClientFactory();
    }

    @Bean
    public AdminRpcClientFactory getAdminClientFactory() {
        return new AdminRpcClientFactory();
    }

    @Bean
    public FixAdminRpcClientFactory getFixAdminClientFactory() {
        return new FixAdminRpcClientFactory();
    }

    @Bean
    public MarketDataRpcClientFactory getMarketDataClientFactory() {
        return new MarketDataRpcClientFactory();
    }

    @Bean
    public UserAttributeFactory getUserAttributeFactory() {
        return new SimpleUserAttributeFactory();
    }

    @Bean
    public PermissionFactory getPermissionFactory() {
        return new SimplePermissionFactory();
    }

    @Bean
    public UserFactory getUserFactory() {
        return new SimpleUserFactory();
    }

    @Bean
    public RoleFactory getRoleFactory() {
        return new SimpleRoleFactory();
    }

    @Bean
    public FixSessionAttributeDescriptorFactory getFixSessionAttributeDescriptorFactory() {
        return new SimpleFixSessionAttributeDescriptorFactory();
    }

    @Bean
    public MutableActiveFixSessionFactory getActiveFixSessionFactory() {
        return new SimpleActiveFixSessionFactory();
    }

    @Bean
    public MutableFixSessionFactory getFixSessionFactory() {
        return new SimpleFixSessionFactory();
    }

    @Bean
    public ClusterDataFactory getClusterDataFactory() {
        return new SimpleClusterDataFactory();
    }

    @Bean
    public Authenticator getAuthenticator(final ServiceManager inServiceManager) {
        Authenticator authenticator = new Authenticator(){

            public boolean shouldAllow(StatelessClientContext inContext, String inUser, char[] inPassword) throws I18NException {
                AdminClientService adminClientService = inServiceManager.getService(AdminClientService.class);
                SessionUser.getCurrent().getPermissions().addAll(adminClientService.getPermissionsForUser());
                return true;
            }
        };
        return authenticator;
    }
}

