/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Dialog;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.image.Image;
import javafx.util.Callback;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.girod.javafx.svgimage.SVGImage;
import org.girod.javafx.svgimage.SVGLoader;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormatter;
import org.marketcetera.admin.User;
import org.marketcetera.core.BigDecimalUtil;
import org.marketcetera.core.time.TimeFactoryImpl;
import org.marketcetera.persist.SummaryNDEntityBase;
import org.marketcetera.trade.HasInstrument;
import org.marketcetera.trade.Instrument;
import org.marketcetera.ui.service.ServiceManager;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.ui.service.admin.AdminClientService;
import org.marketcetera.util.log.SLF4JLoggerProxy;

public abstract class PhotonServices {
    public static final DateTimeFormatter isoDateFormatter = TimeFactoryImpl.FULL_MILLISECONDS;
    public static String successMessage = String.format("-fx-text-fill: GREEN;", new Object[0]);
    public static String errorMessage = String.format("-fx-text-fill: RED;", new Object[0]);
    public static String errorStyle = String.format("-fx-border-color: RED; -fx-border-width: 2; -fx-border-radius: 5;", new Object[0]);
    public static String successStyle = String.format("-fx-border-color: #A9A9A9; -fx-border-width: 2; -fx-border-radius: 5;", new Object[0]);

    public static Image getIcon(String inUrl) {
        return new Image(String.valueOf(PhotonServices.class.getClassLoader().getResource(inUrl)));
    }

    public static Optional<User> getCurrentUser() {
        SessionUser currentSessionUser = SessionUser.getCurrent();
        if (currentSessionUser == null) {
            return Optional.empty();
        }
        User currentUser = currentSessionUser.getAttribute(User.class);
        if (currentUser == null) {
            AdminClientService adminClient = ServiceManager.getInstance().getService(AdminClientService.class);
            currentUser = adminClient.getCurrentUser();
            currentSessionUser.setAttribute(User.class, currentUser);
        }
        return Optional.of(currentUser);
    }

    public static <Clazz> Dialog<Clazz> style(Dialog<Clazz> inDialog) {
        PhotonServices.style((Parent)inDialog.getDialogPane());
        return inDialog;
    }

    public static Scene style(Scene inScene) {
        inScene.getStylesheets().clear();
        inScene.getStylesheets().add((Object)PhotonServices.getStyleSheetUrl());
        return inScene;
    }

    public static Parent style(Parent inParent) {
        inParent.getStylesheets().clear();
        inParent.getStylesheets().add((Object)PhotonServices.getStyleSheetUrl());
        return inParent;
    }

    public static Alert generateAlert(String inTitle, String inContent, Alert.AlertType inAlertType) {
        Alert alert = new Alert(inAlertType);
        alert.setTitle(inTitle);
        alert.setContentText(inContent);
        PhotonServices.style(alert);
        return alert;
    }

    public static boolean isSocketAlive(String inHostname, int inPort) {
        boolean isAlive = false;
        InetSocketAddress socketAddress = new InetSocketAddress(inHostname, inPort);
        Socket socket = new Socket();
        int timeout = 2000;
        try {
            socket.connect(socketAddress, timeout);
            socket.close();
            isAlive = true;
        }
        catch (SocketTimeoutException e) {
            SLF4JLoggerProxy.warn(PhotonServices.class, (String)("SocketTimeoutException {}:{} -> " + e.getMessage()), (Object[])new Object[]{inHostname, inPort, ExceptionUtils.getCause((Throwable)e)});
        }
        catch (IOException e) {
            SLF4JLoggerProxy.warn(PhotonServices.class, (String)("IOException {}:{} -> " + e.getMessage()), (Object[])new Object[]{inHostname, inPort, ExceptionUtils.getCause((Throwable)e)});
        }
        return isAlive;
    }

    public static boolean isValidHostNameSyntax(String inCandidateHostname) {
        if (inCandidateHostname.contains("/")) {
            return false;
        }
        try {
            return new URI("my://userinfo@" + inCandidateHostname + ":80").getHost() != null;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static Node getSvgResource(URL inUrl) {
        return PhotonServices.getSvgResource(inUrl, 0.5);
    }

    public static Node getSvgResource(URL inUrl, double inScale) {
        SVGImage svgImage = SVGLoader.load((URL)inUrl);
        svgImage.setScaleX(inScale);
        svgImage.setScaleY(inScale);
        return svgImage;
    }

    public static TableCell<? extends HasInstrument, Instrument> renderInstrumentCell(TableColumn<? extends HasInstrument, Instrument> inTableColumn) {
        TableCell<HasInstrument, Instrument> tableCell = new TableCell<HasInstrument, Instrument>(){

            protected void updateItem(Instrument inItem, boolean isEmpty) {
                super.updateItem((Object)inItem, isEmpty);
                this.setText(null);
                this.setGraphic(null);
                if (!isEmpty && inItem != null) {
                    this.setText(inItem.getFullSymbol());
                }
            }
        };
        return tableCell;
    }

    public static <T> TableCell<T, BigDecimal> renderNumberCell(TableColumn<T, BigDecimal> inTableColumn) {
        TableCell tableCell = new TableCell<T, BigDecimal>(){

            protected void updateItem(BigDecimal inItem, boolean isEmpty) {
                super.updateItem((Object)inItem, isEmpty);
                this.setText(null);
                this.setGraphic(null);
                if (!isEmpty && inItem != null) {
                    this.setText(BigDecimalUtil.render((BigDecimal)inItem));
                }
            }
        };
        return tableCell;
    }

    public static <T> TableCell<T, BigDecimal> renderNumberCell(TableColumn<T, BigDecimal> inTableColumn, final int inPreferredScale, final int inMaxScale) {
        TableCell tableCell = new TableCell<T, BigDecimal>(){

            protected void updateItem(BigDecimal inItem, boolean isEmpty) {
                super.updateItem((Object)inItem, isEmpty);
                this.setText(null);
                this.setGraphic(null);
                if (!isEmpty && inItem != null) {
                    this.setText(BigDecimalUtil.renderDecimal((BigDecimal)inItem, (int)inPreferredScale, (int)inMaxScale));
                }
            }
        };
        return tableCell;
    }

    public static <T> TableCell<T, BigDecimal> renderCurrencyCell(TableColumn<T, BigDecimal> inTableColumn) {
        TableCell tableCell = new TableCell<T, BigDecimal>(){

            protected void updateItem(BigDecimal inItem, boolean isEmpty) {
                super.updateItem((Object)inItem, isEmpty);
                this.setText(null);
                this.setGraphic(null);
                if (!isEmpty && inItem != null) {
                    this.setText(BigDecimalUtil.renderCurrency((BigDecimal)inItem));
                }
            }
        };
        return tableCell;
    }

    public static <T> TableCell<T, Date> renderDateCell(TableColumn<T, Date> inTableColumn) {
        TableCell tableCell = new TableCell<T, Date>(){

            protected void updateItem(Date inItem, boolean isEmpty) {
                super.updateItem((Object)inItem, isEmpty);
                this.setText(null);
                this.setGraphic(null);
                if (!isEmpty) {
                    this.setText(isoDateFormatter.print((ReadableInstant)new DateTime((Object)inItem)));
                }
            }
        };
        return tableCell;
    }

    public static <T> TableCell<T, DateTime> renderDateTimeCell(TableColumn<T, DateTime> inTableColumn) {
        TableCell tableCell = new TableCell<T, DateTime>(){

            protected void updateItem(DateTime inItem, boolean isEmpty) {
                super.updateItem((Object)inItem, isEmpty);
                this.setText(null);
                this.setGraphic(null);
                if (!isEmpty) {
                    this.setText(isoDateFormatter.print((ReadableInstant)inItem));
                }
            }
        };
        return tableCell;
    }

    public static <T> TableCell<T, Period> renderPeriodCell(TableColumn<T, Period> inTableColumn) {
        TableCell tableCell = new TableCell<T, Period>(){

            protected void updateItem(Period inItem, boolean isEmpty) {
                super.updateItem((Object)inItem, isEmpty);
                this.setText(null);
                this.setGraphic(null);
                if (!isEmpty) {
                    this.setText(TimeFactoryImpl.periodFormatter.print((ReadablePeriod)inItem));
                }
            }
        };
        return tableCell;
    }

    private static String getStyleSheetUrl() {
        File cssFile = new File("conf/photon.css");
        Object filePath = "file:///" + cssFile.getAbsolutePath();
        filePath = ((String)filePath).replace("\\", "/");
        filePath = ((String)filePath).replace(" ", "%20");
        return filePath;
    }

    public static class NDEntityCellFactory<Clazz extends SummaryNDEntityBase>
    implements Callback<ListView<Clazz>, ListCell<Clazz>> {
        public ListCell<Clazz> call(ListView<Clazz> inParameter) {
            return new ListCell<Clazz>(){

                public void updateItem(Clazz inData, boolean isEmpty) {
                    super.updateItem(inData, isEmpty);
                    if (isEmpty || inData == null) {
                        this.setText(null);
                    } else {
                        this.setText(inData.getName());
                    }
                }
            };
        }
    }
}

