/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.admin.view;

import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;
import org.marketcetera.admin.AdminPermissions;
import org.marketcetera.admin.Permission;
import org.marketcetera.admin.impl.SimplePermission;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.ui.PhotonServices;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.events.NotificationEvent;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.ui.view.AbstractContentView;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PermissionView
extends AbstractContentView {
    private MenuItem updatePermissionMenuItem;
    private MenuItem deletePermissionMenuItem;
    private TableColumn<SimplePermission, String> nameColumn;
    private TableColumn<SimplePermission, String> descriptionColumn;
    private HBox buttonLayout;
    private Button addPermissionButton;
    private TableView<SimplePermission> permissionsTable;
    private ContextMenu permissionsTableContextMenu;
    private VBox mainLayout;
    private static final String NAME = "Permissions View";

    public PermissionView(Region inParentWindow, NewWindowEvent inEvent, Properties inViewProperties) {
        super(inParentWindow, inEvent, inViewProperties);
    }

    @Override
    public Region getMainLayout() {
        return this.mainLayout;
    }

    @Override
    protected void onStart() {
        this.mainLayout = new VBox(5.0);
        this.initializeTable();
        this.buttonLayout = new HBox(5.0);
        this.addPermissionButton = new Button("Add Permission");
        boolean userHasCreatePermissionPermission = this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.CreatePermissionAction);
        this.addPermissionButton.setVisible(userHasCreatePermissionPermission);
        this.addPermissionButton.setDisable(!userHasCreatePermissionPermission);
        this.addPermissionButton.setOnAction(event -> this.doAddOrUpdatePermission(new SimplePermission(), true));
        this.buttonLayout.getChildren().add((Object)this.addPermissionButton);
        this.mainLayout.getChildren().addAll((Object[])new Node[]{this.permissionsTable, this.buttonLayout});
    }

    private void updatePermissions() {
        this.permissionsTable.getItems().clear();
        this.adminClientService.getPermissions().forEach(permission -> {
            if (permission instanceof SimplePermission) {
                this.permissionsTable.getItems().add((Object)((SimplePermission)permission));
            } else {
                SimplePermission newPermission = new SimplePermission();
                newPermission.setName(permission.getName());
                newPermission.setDescription(permission.getDescription());
                this.permissionsTable.getItems().add((Object)newPermission);
            }
        });
    }

    private void initializeTable() {
        this.permissionsTable = new TableView();
        this.permissionsTable.setPlaceholder((Node)new Label("no permissions to display"));
        this.initializeColumns();
        this.initializeContextMenu();
        this.permissionsTable.getSelectionModel().selectedItemProperty().addListener((inObservable, inOldValue, inNewValue) -> this.enableContextMenuItems((SimplePermission)inNewValue));
        this.updatePermissions();
    }

    private void enableContextMenuItems(SimplePermission inNewValue) {
        if (inNewValue == null) {
            return;
        }
    }

    private void doContextMenuAction(SimplePermission inSelectedItem, String inTitle, String inContent, Consumer<String> inAction) {
        if (inSelectedItem == null) {
            return;
        }
        Alert alert = PhotonServices.generateAlert(inTitle, inContent + "?", Alert.AlertType.CONFIRMATION);
        ButtonType okButton = new ButtonType("Ok", ButtonBar.ButtonData.OK_DONE);
        ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{okButton, cancelButton});
        alert.showAndWait().ifPresent(type -> {
            if (type == okButton) {
                try {
                    SLF4JLoggerProxy.info((Object)this, (String)"{} performing {} on {}", (Object[])new Object[]{SessionUser.getCurrent(), inTitle, inSelectedItem});
                    inAction.accept(inSelectedItem.getName());
                    SLF4JLoggerProxy.info((Object)this, (String)"{} on {} succeeded", (Object[])new Object[]{inTitle, inSelectedItem});
                    this.updatePermissions();
                    this.uiMessageService.post(new NotificationEvent(inTitle, inContent + " succeeded", Alert.AlertType.INFORMATION));
                }
                catch (Exception e) {
                    String message = PlatformServices.getMessage((Throwable)e);
                    SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Unable to perform {} on {}: {}", (Object[])new Object[]{inTitle, inSelectedItem, message});
                    this.uiMessageService.post(new NotificationEvent(inTitle, inContent + " failed: " + message, Alert.AlertType.ERROR));
                }
            } else {
                return;
            }
        });
    }

    private void initializeContextMenu() {
        this.permissionsTableContextMenu = new ContextMenu();
        this.deletePermissionMenuItem = new MenuItem("Delete");
        this.deletePermissionMenuItem.setOnAction(event -> {
            SimplePermission selectedPermission = (SimplePermission)this.permissionsTable.getSelectionModel().getSelectedItem();
            if (selectedPermission == null) {
                return;
            }
            this.doContextMenuAction(selectedPermission, "Delete Permission", "Delete " + selectedPermission.getName(), inPermissionName -> this.adminClientService.deletePermission((String)inPermissionName));
        });
        this.updatePermissionMenuItem = new MenuItem("Edit");
        this.updatePermissionMenuItem.setOnAction(event -> {
            SimplePermission selectedPermission = (SimplePermission)this.permissionsTable.getSelectionModel().getSelectedItem();
            if (selectedPermission == null) {
                return;
            }
            this.doAddOrUpdatePermission(selectedPermission, false);
        });
        if (this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.UpdatePermissionAction)) {
            this.permissionsTableContextMenu.getItems().add((Object)this.updatePermissionMenuItem);
        }
        if (this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.DeletePermissionAction)) {
            this.permissionsTableContextMenu.getItems().add((Object)this.deletePermissionMenuItem);
        }
        this.permissionsTable.setContextMenu(this.permissionsTableContextMenu);
    }

    private void doAddOrUpdatePermission(SimplePermission inSelectedPermission, boolean inIsAdd) {
        Dialog roleDialog = new Dialog();
        VBox mainLayout = new VBox(5.0);
        GridPane roleDialogGrid = new GridPane();
        roleDialogGrid.setHgap(10.0);
        roleDialogGrid.setVgap(10.0);
        roleDialogGrid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        final TextField nameField = new TextField();
        TextField descriptionField = new TextField();
        final Label adviceLabel = new Label();
        ButtonType okButtonType = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
        roleDialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{okButtonType, ButtonType.CANCEL});
        SimpleBooleanProperty disableOkButton = new SimpleBooleanProperty(false);
        Function<Void, Boolean> disableOkFunction = new Function<Void, Boolean>(){

            @Override
            public Boolean apply(Void inIgnored) {
                adviceLabel.setText("");
                adviceLabel.setStyle(PhotonServices.successMessage);
                nameField.setStyle(PhotonServices.successStyle);
                String computedValue = StringUtils.trimToNull((String)nameField.getText());
                if (computedValue == null) {
                    adviceLabel.setText("Name required");
                    adviceLabel.setStyle(PhotonServices.errorMessage);
                    nameField.setStyle(PhotonServices.errorStyle);
                    return true;
                }
                if (computedValue.length() > 255) {
                    adviceLabel.setText("Name may contain up to 255 characters");
                    adviceLabel.setStyle(PhotonServices.errorMessage);
                    nameField.setStyle(PhotonServices.errorStyle);
                    return true;
                }
                return false;
            }
        };
        nameField.setText(inSelectedPermission.getName());
        descriptionField.setText(inSelectedPermission.getDescription());
        roleDialog.getDialogPane().lookupButton(okButtonType).disableProperty().bind((ObservableValue)disableOkButton);
        nameField.textProperty().addListener((arg_0, arg_1, arg_2) -> PermissionView.lambda$doAddOrUpdatePermission$7((BooleanProperty)disableOkButton, disableOkFunction, arg_0, arg_1, arg_2));
        int rowCount = 0;
        roleDialogGrid.add((Node)new Label((String)(inIsAdd ? "Create New Permission" : "Update " + inSelectedPermission.getName())), 0, rowCount, 2, 1);
        roleDialogGrid.add((Node)new Label("Name"), 0, ++rowCount);
        roleDialogGrid.add((Node)nameField, 1, rowCount);
        roleDialogGrid.add((Node)new Label("Description"), 0, ++rowCount);
        roleDialogGrid.add((Node)descriptionField, 1, rowCount);
        roleDialogGrid.add((Node)adviceLabel, 0, ++rowCount, 2, 1);
        mainLayout.getChildren().addAll((Object[])new Node[]{roleDialogGrid});
        roleDialog.getDialogPane().setContent((Node)mainLayout);
        roleDialog.setResultConverter(dialogButton -> {
            if (dialogButton == okButtonType) {
                return inSelectedPermission;
            }
            return null;
        });
        PhotonServices.style(roleDialog.getDialogPane().getScene());
        roleDialog.getDialogPane().getScene().getWindow().sizeToScene();
        Optional permissionOption = roleDialog.showAndWait();
        if (permissionOption.isPresent()) {
            try {
                SimplePermission permission = (SimplePermission)permissionOption.get();
                permission.setDescription(descriptionField.getText());
                permission.setName(nameField.getText());
                if (inIsAdd) {
                    this.adminClientService.createPermission((Permission)permission);
                } else {
                    this.adminClientService.updatePermission(inSelectedPermission.getName(), (Permission)permission);
                }
                this.uiMessageService.post(new NotificationEvent(inIsAdd ? "Create Permission" : "Update Permission", "Permission '" + inSelectedPermission.getName() + "' " + (inIsAdd ? "created" : "updated"), Alert.AlertType.INFORMATION));
            }
            catch (Exception e) {
                String message = PlatformServices.getMessage((Throwable)e);
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Unable to create or update role {}: {}", (Object[])new Object[]{inSelectedPermission, message});
                this.uiMessageService.post(new NotificationEvent(inIsAdd ? "Create Permission" : "Update Permission", (inIsAdd ? "Create" : "Update") + " role failed: " + message, Alert.AlertType.ERROR));
            }
        }
        this.updatePermissions();
    }

    private void initializeColumns() {
        this.nameColumn = new TableColumn("Name");
        this.nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.descriptionColumn = new TableColumn("Description");
        this.descriptionColumn.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.permissionsTable.getColumns().add(this.nameColumn);
        this.permissionsTable.getColumns().add(this.descriptionColumn);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    private static /* synthetic */ void lambda$doAddOrUpdatePermission$7(BooleanProperty disableOkButton, Function disableOkFunction, ObservableValue observer, String oldValue, String newValue) {
        disableOkButton.set(((Boolean)disableOkFunction.apply(null)).booleanValue());
    }
}

