/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.admin.view;

import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.marketcetera.admin.AdminPermissions;
import org.marketcetera.admin.Permission;
import org.marketcetera.admin.Role;
import org.marketcetera.admin.impl.SimplePermission;
import org.marketcetera.admin.impl.SimpleRole;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.ui.PhotonServices;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.events.NotificationEvent;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.ui.view.AbstractContentView;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class RoleView
extends AbstractContentView {
    private MenuItem updateRoleMenuItem;
    private MenuItem deleteRoleMenuItem;
    private TableColumn<SimpleRole, String> nameColumn;
    private TableColumn<SimpleRole, String> descriptionColumn;
    private HBox buttonLayout;
    private Button addRoleButton;
    private TableView<SimpleRole> rolesTable;
    private ContextMenu rolesTableContextMenu;
    private VBox mainLayout;
    private static final String NAME = "Roles View";

    public RoleView(Region inParentWindow, NewWindowEvent inEvent, Properties inViewProperties) {
        super(inParentWindow, inEvent, inViewProperties);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public Region getMainLayout() {
        return this.mainLayout;
    }

    @Override
    protected void onStart() {
        this.mainLayout = new VBox(5.0);
        this.initializeTable();
        this.buttonLayout = new HBox(5.0);
        this.addRoleButton = new Button("Add Role");
        boolean userHasCreateRolePermission = this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.CreateRoleAction);
        this.addRoleButton.setVisible(userHasCreateRolePermission);
        this.addRoleButton.setDisable(!userHasCreateRolePermission);
        this.addRoleButton.setOnAction(event -> this.doAddOrUpdateRole(new SimpleRole(), true));
        this.buttonLayout.getChildren().add((Object)this.addRoleButton);
        this.mainLayout.getChildren().addAll((Object[])new Node[]{this.rolesTable, this.buttonLayout});
    }

    private void updateRoles() {
        this.rolesTable.getItems().clear();
        this.adminClientService.getRoles().forEach(role -> {
            if (role instanceof SimpleRole) {
                this.rolesTable.getItems().add((Object)((SimpleRole)role));
            } else {
                SimpleRole newRole = new SimpleRole();
                newRole.setName(role.getName());
                newRole.setDescription(role.getDescription());
                for (Permission permission : role.getPermissions()) {
                    if (permission instanceof SimplePermission) {
                        newRole.getPermissions().add(permission);
                        continue;
                    }
                    SimplePermission newPermission = new SimplePermission();
                    newPermission.setName(permission.getName());
                    newPermission.setDescription(permission.getDescription());
                    newRole.getPermissions().add(newPermission);
                }
                this.rolesTable.getItems().add((Object)newRole);
            }
        });
    }

    private void initializeTable() {
        this.rolesTable = new TableView();
        this.rolesTable.setPlaceholder((Node)new Label("no roles to display"));
        this.initializeColumns();
        this.initializeContextMenu();
        this.rolesTable.getSelectionModel().selectedItemProperty().addListener((inObservable, inOldValue, inNewValue) -> this.enableContextMenuItems((SimpleRole)inNewValue));
        this.updateRoles();
    }

    private void enableContextMenuItems(SimpleRole inNewValue) {
        if (inNewValue == null) {
            return;
        }
    }

    private void doContextMenuAction(SimpleRole inSelectedItem, String inTitle, String inContent, Consumer<String> inAction) {
        if (inSelectedItem == null) {
            return;
        }
        Alert alert = PhotonServices.generateAlert(inTitle, inContent + "?", Alert.AlertType.CONFIRMATION);
        ButtonType okButton = new ButtonType("Ok", ButtonBar.ButtonData.OK_DONE);
        ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{okButton, cancelButton});
        alert.showAndWait().ifPresent(type -> {
            if (type == okButton) {
                try {
                    SLF4JLoggerProxy.info((Object)this, (String)"{} performing {} on {}", (Object[])new Object[]{SessionUser.getCurrent(), inTitle, inSelectedItem});
                    inAction.accept(inSelectedItem.getName());
                    SLF4JLoggerProxy.info((Object)this, (String)"{} on {} succeeded", (Object[])new Object[]{inTitle, inSelectedItem});
                    this.updateRoles();
                    this.uiMessageService.post(new NotificationEvent(inTitle, inContent + " succeeded", Alert.AlertType.INFORMATION));
                }
                catch (Exception e) {
                    String message = PlatformServices.getMessage((Throwable)e);
                    SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Unable to perform {} on {}: {}", (Object[])new Object[]{inTitle, inSelectedItem, message});
                    this.uiMessageService.post(new NotificationEvent(inTitle, inContent + " failed: " + message, Alert.AlertType.ERROR));
                }
            } else {
                return;
            }
        });
    }

    private void initializeContextMenu() {
        this.rolesTableContextMenu = new ContextMenu();
        this.deleteRoleMenuItem = new MenuItem("Delete");
        this.deleteRoleMenuItem.setOnAction(event -> {
            SimpleRole selectedRole = (SimpleRole)this.rolesTable.getSelectionModel().getSelectedItem();
            if (selectedRole == null) {
                return;
            }
            this.doContextMenuAction(selectedRole, "Delete Role", "Delete " + selectedRole.getName(), inRoleName -> this.adminClientService.deleteRole((String)inRoleName));
        });
        this.updateRoleMenuItem = new MenuItem("Edit");
        this.updateRoleMenuItem.setOnAction(event -> {
            SimpleRole selectedRole = (SimpleRole)this.rolesTable.getSelectionModel().getSelectedItem();
            if (selectedRole == null) {
                return;
            }
            this.doAddOrUpdateRole(selectedRole, false);
        });
        if (this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.UpdateRoleAction)) {
            this.rolesTableContextMenu.getItems().add((Object)this.updateRoleMenuItem);
        }
        if (this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.DeleteRoleAction)) {
            this.rolesTableContextMenu.getItems().add((Object)this.deleteRoleMenuItem);
        }
        this.rolesTable.setContextMenu(this.rolesTableContextMenu);
    }

    private void doAddOrUpdateRole(SimpleRole inSelectedRole, boolean inIsAdd) {
        Dialog roleDialog = new Dialog();
        VBox mainLayout = new VBox(5.0);
        GridPane roleDialogGrid = new GridPane();
        roleDialogGrid.setHgap(10.0);
        roleDialogGrid.setVgap(10.0);
        roleDialogGrid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        final TextField nameField = new TextField();
        TextField descriptionField = new TextField();
        GridPane permissionsListLayout = new GridPane();
        permissionsListLayout.setHgap(10.0);
        permissionsListLayout.setVgap(10.0);
        permissionsListLayout.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        ListView leftListView = new ListView();
        ListView rightListView = new ListView();
        leftListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        rightListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        leftListView.setCellFactory((Callback)PermissionCellFactory.instance);
        rightListView.setCellFactory((Callback)PermissionCellFactory.instance);
        VBox moveButtonLayout = new VBox(5.0);
        Button moveLeftButton = new Button("<");
        Button moveRightButton = new Button(">");
        moveButtonLayout.setAlignment(Pos.CENTER);
        moveButtonLayout.getChildren().addAll((Object[])new Node[]{moveLeftButton, moveRightButton});
        int rowCount = 0;
        permissionsListLayout.add((Node)new Label("Permissions"), 0, rowCount, 3, 1);
        permissionsListLayout.add((Node)new Label("Available"), 0, ++rowCount);
        permissionsListLayout.add((Node)new Label("Selected"), 2, rowCount);
        permissionsListLayout.add((Node)leftListView, 0, ++rowCount);
        permissionsListLayout.add((Node)moveButtonLayout, 1, rowCount);
        permissionsListLayout.add((Node)rightListView, 2, rowCount);
        rightListView.getItems().addAll((Collection)inSelectedRole.getPermissions());
        leftListView.getItems().addAll(this.adminClientService.getPermissions());
        Comparator<Permission> permissionComparator = new Comparator<Permission>(){

            @Override
            public int compare(Permission inO1, Permission inO2) {
                return new CompareToBuilder().append((Object)inO1.getName(), (Object)inO2.getName()).toComparison();
            }
        };
        for (Permission permission : rightListView.getItems()) {
            leftListView.getItems().remove((Object)permission);
        }
        for (Permission permission : leftListView.getItems()) {
            rightListView.getItems().remove((Object)permission);
        }
        leftListView.getItems().sort((Comparator)permissionComparator);
        rightListView.getItems().sort((Comparator)permissionComparator);
        moveLeftButton.setOnAction(event -> {
            ObservableList selectedItems = rightListView.getSelectionModel().getSelectedItems();
            if (selectedItems == null) {
                return;
            }
            selectedItems.forEach(permission -> leftListView.getItems().add(permission));
            rightListView.getItems().removeAll((Collection)selectedItems);
            leftListView.getItems().sort(permissionComparator);
            rightListView.getItems().sort(permissionComparator);
        });
        moveRightButton.setOnAction(event -> {
            ObservableList selectedItems = leftListView.getSelectionModel().getSelectedItems();
            if (selectedItems == null) {
                return;
            }
            selectedItems.forEach(permission -> rightListView.getItems().add(permission));
            leftListView.getItems().removeAll((Collection)selectedItems);
            leftListView.getItems().sort(permissionComparator);
            rightListView.getItems().sort(permissionComparator);
        });
        final Label adviceLabel = new Label();
        ButtonType okButtonType = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
        roleDialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{okButtonType, ButtonType.CANCEL});
        SimpleBooleanProperty disableOkButton = new SimpleBooleanProperty(false);
        Function<Void, Boolean> disableOkFunction = new Function<Void, Boolean>(){

            @Override
            public Boolean apply(Void inIgnored) {
                adviceLabel.setText("");
                adviceLabel.setStyle(PhotonServices.successMessage);
                nameField.setStyle(PhotonServices.successStyle);
                String computedValue = StringUtils.trimToNull((String)nameField.getText());
                if (computedValue == null) {
                    adviceLabel.setText("Name required");
                    adviceLabel.setStyle(PhotonServices.errorMessage);
                    nameField.setStyle(PhotonServices.errorStyle);
                    return true;
                }
                if (computedValue.length() > 255) {
                    adviceLabel.setText("Name may contain up to 255 characters");
                    adviceLabel.setStyle(PhotonServices.errorMessage);
                    nameField.setStyle(PhotonServices.errorStyle);
                    return true;
                }
                return false;
            }
        };
        nameField.setText(inSelectedRole.getName());
        descriptionField.setText(inSelectedRole.getDescription());
        roleDialog.getDialogPane().lookupButton(okButtonType).disableProperty().bind((ObservableValue)disableOkButton);
        nameField.textProperty().addListener((arg_0, arg_1, arg_2) -> RoleView.lambda$doAddOrUpdateRole$11((BooleanProperty)disableOkButton, disableOkFunction, arg_0, arg_1, arg_2));
        rowCount = 0;
        roleDialogGrid.add((Node)new Label((String)(inIsAdd ? "Create New Role" : "Update " + inSelectedRole.getName())), 0, rowCount, 2, 1);
        roleDialogGrid.add((Node)new Label("Name"), 0, ++rowCount);
        roleDialogGrid.add((Node)nameField, 1, rowCount);
        roleDialogGrid.add((Node)new Label("Description"), 0, ++rowCount);
        roleDialogGrid.add((Node)descriptionField, 1, rowCount);
        roleDialogGrid.add((Node)adviceLabel, 0, ++rowCount, 2, 1);
        mainLayout.getChildren().addAll((Object[])new Node[]{roleDialogGrid, permissionsListLayout});
        roleDialog.getDialogPane().setContent((Node)mainLayout);
        roleDialog.setResultConverter(dialogButton -> {
            if (dialogButton == okButtonType) {
                return inSelectedRole;
            }
            return null;
        });
        PhotonServices.style(roleDialog.getDialogPane().getScene());
        roleDialog.getDialogPane().getScene().getWindow().sizeToScene();
        Optional roleOption = roleDialog.showAndWait();
        if (roleOption.isPresent()) {
            try {
                SimpleRole role = (SimpleRole)roleOption.get();
                role.setDescription(descriptionField.getText());
                role.setName(nameField.getText());
                role.getPermissions().clear();
                role.getPermissions().addAll(rightListView.getItems());
                if (inIsAdd) {
                    this.adminClientService.createRole((Role)role);
                } else {
                    this.adminClientService.updateRole(inSelectedRole.getName(), (Role)role);
                }
                this.uiMessageService.post(new NotificationEvent(inIsAdd ? "Create Role" : "Update Role", "Role '" + inSelectedRole.getName() + "' " + (inIsAdd ? "created" : "updated"), Alert.AlertType.INFORMATION));
            }
            catch (Exception e) {
                String message = PlatformServices.getMessage((Throwable)e);
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Unable to create or update role {}: {}", (Object[])new Object[]{inSelectedRole, message});
                this.uiMessageService.post(new NotificationEvent(inIsAdd ? "Create Role" : "Update Role", (inIsAdd ? "Create" : "Update") + " role failed: " + message, Alert.AlertType.ERROR));
            }
        }
        this.updateRoles();
    }

    private void initializeColumns() {
        this.nameColumn = new TableColumn("Name");
        this.nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.descriptionColumn = new TableColumn("Description");
        this.descriptionColumn.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.rolesTable.getColumns().add(this.nameColumn);
        this.rolesTable.getColumns().add(this.descriptionColumn);
    }

    private static /* synthetic */ void lambda$doAddOrUpdateRole$11(BooleanProperty disableOkButton, Function disableOkFunction, ObservableValue observer, String oldValue, String newValue) {
        disableOkButton.set(((Boolean)disableOkFunction.apply(null)).booleanValue());
    }

    private static class PermissionCellFactory
    implements Callback<ListView<Permission>, ListCell<Permission>> {
        private static final PermissionCellFactory instance = new PermissionCellFactory();

        private PermissionCellFactory() {
        }

        public ListCell<Permission> call(ListView<Permission> param) {
            return new ListCell<Permission>(){

                public void updateItem(Permission person, boolean empty) {
                    super.updateItem((Object)person, empty);
                    if (empty || person == null) {
                        this.setText(null);
                    } else {
                        this.setText(person.getName());
                    }
                }
            };
        }
    }
}

