/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.admin.view;

import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PasswordField;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;
import org.marketcetera.admin.AdminPermissions;
import org.marketcetera.admin.User;
import org.marketcetera.admin.impl.SimpleUser;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.ui.PhotonServices;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.events.NotificationEvent;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.ui.view.AbstractContentView;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class UserView
extends AbstractContentView {
    private MenuItem updateUserMenuItem;
    private MenuItem deleteUserMenuItem;
    private MenuItem deactivateUserMenuItem;
    private MenuItem activateUserMenuItem;
    private MenuItem resetPasswordMenuItem;
    private TableColumn<SimpleUser, String> nameColumn;
    private TableColumn<SimpleUser, String> descriptionColumn;
    private TableColumn<SimpleUser, Boolean> isActiveColumn;
    private HBox buttonLayout;
    private Button addUserButton;
    private TableView<SimpleUser> usersTable;
    private ContextMenu usersTableContextMenu;
    private VBox mainLayout;
    private static final String NAME = "Users View";

    public UserView(Region inParentWindow, NewWindowEvent inEvent, Properties inViewProperties) {
        super(inParentWindow, inEvent, inViewProperties);
    }

    @Override
    public Region getMainLayout() {
        return this.mainLayout;
    }

    @Override
    protected void onStart() {
        this.mainLayout = new VBox(5.0);
        this.initializeTable();
        this.buttonLayout = new HBox(5.0);
        this.addUserButton = new Button("Add User");
        boolean userHasCreateUserPermission = this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.CreateUserAction);
        this.addUserButton.setVisible(userHasCreateUserPermission);
        this.addUserButton.setDisable(!userHasCreateUserPermission);
        this.addUserButton.setOnAction(event -> this.doAddOrUpdateUser(new SimpleUser(), true));
        this.buttonLayout.getChildren().add((Object)this.addUserButton);
        this.mainLayout.getChildren().addAll((Object[])new Node[]{this.usersTable, this.buttonLayout});
    }

    private void updateUsers() {
        this.usersTable.getItems().clear();
        this.adminClientService.getUsers().forEach(user -> {
            if (user instanceof SimpleUser) {
                this.usersTable.getItems().add((Object)((SimpleUser)user));
            } else {
                this.usersTable.getItems().add((Object)new SimpleUser(user.getName(), user.getDescription(), "", user.isActive()));
            }
        });
    }

    private void initializeTable() {
        this.usersTable = new TableView();
        this.usersTable.setPlaceholder((Node)new Label("no users to display"));
        this.initializeColumns();
        this.initializeContextMenu();
        this.usersTable.getSelectionModel().selectedItemProperty().addListener((inObservable, inOldValue, inNewValue) -> this.enableContextMenuItems((SimpleUser)inNewValue));
        this.updateUsers();
    }

    private void enableContextMenuItems(SimpleUser inNewValue) {
        if (inNewValue == null) {
            return;
        }
        if (inNewValue.isActive()) {
            this.activateUserMenuItem.setDisable(true);
            this.deactivateUserMenuItem.setDisable(false);
            this.deleteUserMenuItem.setDisable(true);
        } else {
            this.activateUserMenuItem.setDisable(false);
            this.deactivateUserMenuItem.setDisable(true);
            this.deleteUserMenuItem.setDisable(false);
        }
    }

    private void doContextMenuAction(SimpleUser inSelectedItem, String inTitle, String inContent, Consumer<String> inAction) {
        if (inSelectedItem == null) {
            return;
        }
        Alert alert = PhotonServices.generateAlert(inTitle, inContent + "?", Alert.AlertType.CONFIRMATION);
        ButtonType okButton = new ButtonType("Ok", ButtonBar.ButtonData.OK_DONE);
        ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{okButton, cancelButton});
        alert.showAndWait().ifPresent(type -> {
            if (type == okButton) {
                try {
                    SLF4JLoggerProxy.info((Object)this, (String)"{} performing {} on {}", (Object[])new Object[]{SessionUser.getCurrent(), inTitle, inSelectedItem});
                    inAction.accept(inSelectedItem.getName());
                    SLF4JLoggerProxy.info((Object)this, (String)"{} on {} succeeded", (Object[])new Object[]{inTitle, inSelectedItem});
                    this.updateUsers();
                    this.uiMessageService.post(new NotificationEvent(inTitle, inContent + " succeeded", Alert.AlertType.INFORMATION));
                }
                catch (Exception e) {
                    String message = PlatformServices.getMessage((Throwable)e);
                    SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Unable to perform {} on {}: {}", (Object[])new Object[]{inTitle, inSelectedItem, message});
                    this.uiMessageService.post(new NotificationEvent(inTitle, inContent + " failed: " + message, Alert.AlertType.ERROR));
                }
            } else {
                return;
            }
        });
    }

    private void initializeContextMenu() {
        this.usersTableContextMenu = new ContextMenu();
        this.deleteUserMenuItem = new MenuItem("Delete");
        this.deleteUserMenuItem.setOnAction(event -> {
            SimpleUser selectedUser = (SimpleUser)this.usersTable.getSelectionModel().getSelectedItem();
            if (selectedUser == null) {
                return;
            }
            if (selectedUser.getName().equals(SessionUser.getCurrent().getUsername())) {
                SLF4JLoggerProxy.warn((Object)this, (String)"Cannot delete current user {}", (Object[])new Object[]{selectedUser});
                this.uiMessageService.post(new NotificationEvent("Delete User", "Cannot delete current user", Alert.AlertType.ERROR));
                return;
            }
            this.doContextMenuAction(selectedUser, "Delete User", "Delete " + selectedUser.getName(), inUsername -> this.adminClientService.deleteUser((String)inUsername));
        });
        this.deactivateUserMenuItem = new MenuItem("Deactivate");
        this.deactivateUserMenuItem.setOnAction(event -> {
            SimpleUser selectedUser = (SimpleUser)this.usersTable.getSelectionModel().getSelectedItem();
            if (selectedUser == null) {
                return;
            }
            if (selectedUser.getName().equals(SessionUser.getCurrent().getUsername())) {
                SLF4JLoggerProxy.warn((Object)this, (String)"Cannot deactivate current user {}", (Object[])new Object[]{selectedUser});
                this.uiMessageService.post(new NotificationEvent("Deactivate User", "Cannot deactivate current user", Alert.AlertType.ERROR));
                return;
            }
            this.doContextMenuAction(selectedUser, "Deactivate User", "Deactivate " + selectedUser.getName(), inUsername -> this.adminClientService.deactivateUser((String)inUsername));
        });
        this.activateUserMenuItem = new MenuItem("Activate");
        this.updateUserMenuItem = new MenuItem("Edit");
        this.updateUserMenuItem.setOnAction(event -> {
            SimpleUser selectedUser = (SimpleUser)this.usersTable.getSelectionModel().getSelectedItem();
            if (selectedUser == null) {
                return;
            }
            this.doAddOrUpdateUser(selectedUser, false);
        });
        this.resetPasswordMenuItem = new MenuItem("Reset Password");
        this.resetPasswordMenuItem.setOnAction(event -> {
            SimpleUser selectedUser = (SimpleUser)this.usersTable.getSelectionModel().getSelectedItem();
            if (selectedUser == null) {
                return;
            }
            this.doResetPassword(selectedUser);
        });
        boolean atLeastOneGroupOneMenuItem = false;
        boolean separatorOneAdded = false;
        if (this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.UpdateUserAction)) {
            this.usersTableContextMenu.getItems().add((Object)this.updateUserMenuItem);
            atLeastOneGroupOneMenuItem = true;
        }
        if (this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.ResetUserPasswordAction)) {
            this.usersTableContextMenu.getItems().add((Object)this.resetPasswordMenuItem);
            atLeastOneGroupOneMenuItem = true;
        }
        if (this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.DeleteUserAction)) {
            if (atLeastOneGroupOneMenuItem && !separatorOneAdded) {
                this.usersTableContextMenu.getItems().add((Object)new SeparatorMenuItem());
                separatorOneAdded = true;
            }
            this.usersTableContextMenu.getItems().add((Object)this.deleteUserMenuItem);
        }
        if (this.authzHelperService.hasPermission((GrantedAuthority)AdminPermissions.DeleteUserAction)) {
            if (atLeastOneGroupOneMenuItem && !separatorOneAdded) {
                this.usersTableContextMenu.getItems().add((Object)new SeparatorMenuItem());
                separatorOneAdded = true;
            }
            this.usersTableContextMenu.getItems().add((Object)this.deactivateUserMenuItem);
        }
        this.usersTable.setContextMenu(this.usersTableContextMenu);
    }

    private void doResetPassword(SimpleUser inSelectedUser) {
        Dialog resetPasswordDialog = new Dialog();
        resetPasswordDialog.setTitle("Reset Password");
        GridPane passwordDialogGrid = new GridPane();
        passwordDialogGrid.setHgap(10.0);
        passwordDialogGrid.setVgap(10.0);
        passwordDialogGrid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        PasswordField password1Field = new PasswordField();
        PasswordField password2Field = new PasswordField();
        Label adviceLabel = new Label();
        ButtonType okButtonType = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
        resetPasswordDialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{okButtonType, ButtonType.CANCEL});
        password2Field.textProperty().addListener((observable, oldValue, newValue) -> {
            String password1Value = StringUtils.trimToNull((String)password1Field.getText());
            String password2Value = StringUtils.trimToNull((String)password2Field.getText());
            if (password1Value == null) {
                adviceLabel.setText("Password required");
                password1Field.setStyle(PhotonServices.errorStyle);
                adviceLabel.setStyle(PhotonServices.errorMessage);
                resetPasswordDialog.getDialogPane().lookupButton(okButtonType).setDisable(true);
            } else if (password1Value.equals(password2Value)) {
                adviceLabel.setText("");
                adviceLabel.setStyle(PhotonServices.successMessage);
                password1Field.setStyle(PhotonServices.successStyle);
                password2Field.setStyle(PhotonServices.successStyle);
                resetPasswordDialog.getDialogPane().lookupButton(okButtonType).setDisable(false);
            } else {
                adviceLabel.setText("Passwords do not match");
                password1Field.setStyle(PhotonServices.errorStyle);
                password2Field.setStyle(PhotonServices.errorStyle);
                adviceLabel.setStyle(PhotonServices.errorMessage);
                resetPasswordDialog.getDialogPane().lookupButton(okButtonType).setDisable(true);
            }
        });
        passwordDialogGrid.add((Node)new Label("Reset " + inSelectedUser.getName() + " Password"), 0, 0, 2, 1);
        passwordDialogGrid.add((Node)new Label("New Password"), 0, 1);
        passwordDialogGrid.add((Node)password1Field, 1, 1);
        passwordDialogGrid.add((Node)new Label("Verify Password"), 0, 2);
        passwordDialogGrid.add((Node)password2Field, 1, 2);
        passwordDialogGrid.add((Node)adviceLabel, 0, 3, 2, 1);
        resetPasswordDialog.getDialogPane().setContent((Node)passwordDialogGrid);
        resetPasswordDialog.getDialogPane().lookupButton(okButtonType).setDisable(true);
        resetPasswordDialog.setResultConverter(dialogButton -> {
            if (dialogButton == okButtonType) {
                return password1Field.getText();
            }
            return null;
        });
        PhotonServices.style(resetPasswordDialog.getDialogPane().getScene());
        Optional newPasswordOption = resetPasswordDialog.showAndWait();
        if (newPasswordOption.isPresent()) {
            try {
                this.adminClientService.resetUserPassword(inSelectedUser.getName(), (String)newPasswordOption.get());
                this.uiMessageService.post(new NotificationEvent("Reset Password", "Password for '" + inSelectedUser.getName() + "' reset", Alert.AlertType.INFORMATION));
            }
            catch (Exception e) {
                String message = PlatformServices.getMessage((Throwable)e);
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Unable to reset password for {}: {}", (Object[])new Object[]{inSelectedUser, message});
                this.uiMessageService.post(new NotificationEvent("Reset Password", "Reset Password for '" + inSelectedUser.getName() + "' failed: " + message, Alert.AlertType.ERROR));
            }
        }
    }

    private void doAddOrUpdateUser(SimpleUser inSelectedUser, final boolean inIsAdd) {
        Dialog userDialog = new Dialog();
        GridPane userDialogGrid = new GridPane();
        userDialogGrid.setHgap(10.0);
        userDialogGrid.setVgap(10.0);
        userDialogGrid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        final TextField usernameField = new TextField();
        TextField descriptionField = new TextField();
        final PasswordField password1Field = new PasswordField();
        final PasswordField password2Field = new PasswordField();
        CheckBox isActiveCheckBox = new CheckBox();
        isActiveCheckBox.setIndeterminate(false);
        final Label adviceLabel = new Label();
        ButtonType okButtonType = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
        userDialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{okButtonType, ButtonType.CANCEL});
        SimpleBooleanProperty disableOkButton = new SimpleBooleanProperty(false);
        Function<Void, Boolean> disableOkFunction = new Function<Void, Boolean>(){

            @Override
            public Boolean apply(Void inIgnored) {
                adviceLabel.setText("");
                adviceLabel.setStyle(PhotonServices.successMessage);
                usernameField.setStyle(PhotonServices.successStyle);
                password1Field.setStyle(PhotonServices.successStyle);
                password2Field.setStyle(PhotonServices.successStyle);
                String computedValue = StringUtils.trimToNull((String)usernameField.getText());
                if (computedValue == null) {
                    adviceLabel.setText("Name required");
                    adviceLabel.setStyle(PhotonServices.errorMessage);
                    usernameField.setStyle(PhotonServices.errorStyle);
                    return true;
                }
                if (computedValue.length() > 255) {
                    adviceLabel.setText("Name may contain up to 255 characters");
                    adviceLabel.setStyle(PhotonServices.errorMessage);
                    usernameField.setStyle(PhotonServices.errorStyle);
                    return true;
                }
                if (inIsAdd) {
                    String password1Value = StringUtils.trimToNull((String)password1Field.getText());
                    String password2Value = StringUtils.trimToNull((String)password2Field.getText());
                    if (password1Value == null) {
                        if (password2Value == null) {
                            return true;
                        }
                        adviceLabel.setText("Password required");
                        password1Field.setStyle(PhotonServices.errorStyle);
                        adviceLabel.setStyle(PhotonServices.errorMessage);
                        return true;
                    }
                    if (password2Value == null) {
                        return true;
                    }
                    if (!password1Value.equals(password2Value)) {
                        adviceLabel.setText("Passwords do not match");
                        password1Field.setStyle(PhotonServices.errorStyle);
                        password2Field.setStyle(PhotonServices.errorStyle);
                        adviceLabel.setStyle(PhotonServices.errorMessage);
                        return true;
                    }
                }
                return false;
            }
        };
        if (inIsAdd) {
            password1Field.textProperty().addListener((arg_0, arg_1, arg_2) -> UserView.lambda$doAddOrUpdateUser$12((BooleanProperty)disableOkButton, disableOkFunction, arg_0, arg_1, arg_2));
            password2Field.textProperty().addListener((arg_0, arg_1, arg_2) -> UserView.lambda$doAddOrUpdateUser$13((BooleanProperty)disableOkButton, disableOkFunction, arg_0, arg_1, arg_2));
        } else {
            usernameField.setText(inSelectedUser.getName());
            descriptionField.setText(inSelectedUser.getDescription());
        }
        isActiveCheckBox.setSelected(inSelectedUser.isActive());
        userDialog.getDialogPane().lookupButton(okButtonType).disableProperty().bind((ObservableValue)disableOkButton);
        usernameField.textProperty().addListener((arg_0, arg_1, arg_2) -> UserView.lambda$doAddOrUpdateUser$14((BooleanProperty)disableOkButton, disableOkFunction, arg_0, arg_1, arg_2));
        int rowCount = 0;
        userDialogGrid.add((Node)new Label((String)(inIsAdd ? "Create New User" : "Update " + inSelectedUser.getName())), 0, rowCount, 2, 1);
        userDialogGrid.add((Node)new Label("Username"), 0, ++rowCount);
        userDialogGrid.add((Node)usernameField, 1, rowCount);
        userDialogGrid.add((Node)new Label("Description"), 0, ++rowCount);
        userDialogGrid.add((Node)descriptionField, 1, rowCount);
        if (inIsAdd) {
            userDialogGrid.add((Node)new Label("Password"), 0, ++rowCount);
            userDialogGrid.add((Node)password1Field, 1, rowCount);
            userDialogGrid.add((Node)new Label("Verify Password"), 0, ++rowCount);
            userDialogGrid.add((Node)password2Field, 1, rowCount);
        }
        userDialogGrid.add((Node)new Label("User Active"), 0, ++rowCount);
        userDialogGrid.add((Node)isActiveCheckBox, 1, rowCount);
        userDialogGrid.add((Node)adviceLabel, 0, ++rowCount, 2, 1);
        userDialog.getDialogPane().setContent((Node)userDialogGrid);
        userDialog.setResultConverter(dialogButton -> {
            if (dialogButton == okButtonType) {
                return inSelectedUser;
            }
            return null;
        });
        PhotonServices.style(userDialog.getDialogPane().getScene());
        Optional userOption = userDialog.showAndWait();
        if (userOption.isPresent()) {
            try {
                SimpleUser user = (SimpleUser)userOption.get();
                user.setDescription(descriptionField.getText());
                user.setHashedPassword(password1Field.getText());
                user.setIsActive(isActiveCheckBox.isSelected());
                user.setName(usernameField.getText());
                if (inIsAdd) {
                    this.adminClientService.createUser((User)user, password1Field.getText());
                } else {
                    this.adminClientService.updateUser(inSelectedUser.getName(), (User)user);
                }
                this.uiMessageService.post(new NotificationEvent(inIsAdd ? "Create User" : "Update User", "User '" + inSelectedUser.getName() + "' " + (inIsAdd ? "created" : "updated"), Alert.AlertType.INFORMATION));
            }
            catch (Exception e) {
                String message = PlatformServices.getMessage((Throwable)e);
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Unable to change password for {}: {}", (Object[])new Object[]{inSelectedUser, message});
                this.uiMessageService.post(new NotificationEvent(inIsAdd ? "Create User" : "Update User", (inIsAdd ? "Create" : "Update") + " user failed: " + message, Alert.AlertType.ERROR));
            }
        }
        this.updateUsers();
    }

    private void initializeColumns() {
        this.nameColumn = new TableColumn("Name");
        this.nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.descriptionColumn = new TableColumn("Description");
        this.descriptionColumn.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.isActiveColumn = new TableColumn("Active");
        this.isActiveColumn.setCellValueFactory((Callback)new PropertyValueFactory("active"));
        this.usersTable.getColumns().add(this.nameColumn);
        this.usersTable.getColumns().add(this.descriptionColumn);
        this.usersTable.getColumns().add(this.isActiveColumn);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    private static /* synthetic */ void lambda$doAddOrUpdateUser$14(BooleanProperty disableOkButton, Function disableOkFunction, ObservableValue observer, String oldValue, String newValue) {
        disableOkButton.set(((Boolean)disableOkFunction.apply(null)).booleanValue());
    }

    private static /* synthetic */ void lambda$doAddOrUpdateUser$13(BooleanProperty disableOkButton, Function disableOkFunction, ObservableValue observable, String oldValue, String newValue) {
        disableOkButton.set(((Boolean)disableOkFunction.apply(null)).booleanValue());
    }

    private static /* synthetic */ void lambda$doAddOrUpdateUser$12(BooleanProperty disableOkButton, Function disableOkFunction, ObservableValue observable, String oldValue, String newValue) {
        disableOkButton.set(((Boolean)disableOkFunction.apply(null)).booleanValue());
    }
}

