/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.fixadmin;

import com.google.common.eventbus.Subscribe;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.marketcetera.brokers.BrokerStatusListener;
import org.marketcetera.fix.ActiveFixSession;
import org.marketcetera.ui.events.LoginEvent;
import org.marketcetera.ui.events.LogoutEvent;
import org.marketcetera.ui.events.NotificationEvent;
import org.marketcetera.ui.service.ServiceManager;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.ui.service.UiMessageService;
import org.marketcetera.ui.service.admin.AdminClientService;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FixSessionWatcher {
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private UiMessageService messageService;

    @PostConstruct
    public void start() {
        this.messageService.register(this);
    }

    @PreDestroy
    public void stop() {
        this.messageService.unregister(this);
    }

    @Subscribe
    public void onLogin(LoginEvent inEvent) {
        SLF4JLoggerProxy.trace((Object)this, (String)"{} logged in", (Object[])new Object[]{inEvent.getSessionUser()});
        SessionUser currentUser = inEvent.getSessionUser();
        FixSessionWatcherSubscriber subscriber = currentUser.getAttribute(FixSessionWatcherSubscriber.class);
        if (subscriber == null) {
            subscriber = new FixSessionWatcherSubscriber(currentUser);
            currentUser.setAttribute(FixSessionWatcherSubscriber.class, subscriber);
        }
        this.serviceManager.getService(AdminClientService.class).addBrokerStatusListener(subscriber);
    }

    @Subscribe
    public void onLogout(LogoutEvent inEvent) {
        SessionUser currentUser = SessionUser.getCurrent();
        SLF4JLoggerProxy.trace((Object)this, (String)"{} logged out", (Object[])new Object[]{currentUser});
        if (currentUser == null) {
            return;
        }
        FixSessionWatcherSubscriber subscriber = currentUser.getAttribute(FixSessionWatcherSubscriber.class);
        if (subscriber != null) {
            this.serviceManager.getService(AdminClientService.class).removeBrokerStatusListener(subscriber);
        }
    }

    private class FixSessionWatcherSubscriber
    implements BrokerStatusListener {
        private final SessionUser user;

        public void receiveBrokerStatus(final ActiveFixSession inActiveFixSession) {
            SLF4JLoggerProxy.trace((Object)FixSessionWatcher.this, (String)"{} notifying {}", (Object[])new Object[]{this.user, inActiveFixSession});
            final StringBuilder prettyStatus = new StringBuilder();
            for (String statusComponent : inActiveFixSession.getStatus().name().split("_")) {
                prettyStatus.append(StringUtils.lowerCase((String)statusComponent)).append(' ');
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Alert.AlertType alertType = null;
                    switch (inActiveFixSession.getStatus()) {
                        case CONNECTED: {
                            alertType = Alert.AlertType.INFORMATION;
                            break;
                        }
                        default: {
                            alertType = Alert.AlertType.ERROR;
                        }
                    }
                    FixSessionWatcher.this.messageService.post(new NotificationEvent("FIX Session Status", inActiveFixSession.getFixSession().getName() + " " + StringUtils.trim((String)prettyStatus.toString()), alertType));
                }
            });
        }

        private FixSessionWatcherSubscriber(SessionUser inUser) {
            this.user = inUser;
        }
    }
}

