/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.marketdata.service;

import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.marketcetera.marketdata.Capability;
import org.marketcetera.marketdata.MarketDataClient;
import org.marketcetera.marketdata.MarketDataListener;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.marketdata.rpc.client.MarketDataRpcClientFactory;
import org.marketcetera.marketdata.rpc.client.MarketDataRpcClientParameters;
import org.marketcetera.ui.service.ConnectableService;
import org.marketcetera.ui.service.ServiceManager;
import org.marketcetera.util.log.SLF4JLoggerProxy;

public class MarketDataClientService
implements ConnectableService {
    private MarketDataClient marketDataClient;
    private MarketDataRpcClientFactory marketDataClientFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(String inUsername, String inPassword, String inHostname, int inPort, boolean inUseSsl) throws Exception {
        if (this.marketDataClient != null) {
            try {
                this.marketDataClient.stop();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)this, (String)"Unable to stop existing market data client for {}: {}", (Object[])new Object[]{inUsername, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
            finally {
                this.marketDataClient = null;
            }
        }
        SLF4JLoggerProxy.debug((Object)this, (String)"Creating market data client for {} to {}:{} with ssl: {}", (Object[])new Object[]{inUsername, inHostname, inPort, inUseSsl});
        MarketDataRpcClientParameters params = new MarketDataRpcClientParameters();
        params.setHostname(inHostname);
        params.setPort(inPort);
        params.setUsername(inUsername);
        params.setPassword(inPassword);
        params.setUseSsl(inUseSsl);
        this.marketDataClient = this.marketDataClientFactory.create(params);
        this.marketDataClient.start();
        return this.marketDataClient.isRunning();
    }

    @Override
    public void disconnect() {
        if (this.marketDataClient != null) {
            try {
                this.marketDataClient.close();
            }
            catch (IOException e) {
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
            }
        }
        this.marketDataClient = null;
    }

    @Override
    public boolean isRunning() {
        return this.marketDataClient != null && this.marketDataClient.isRunning();
    }

    public String request(MarketDataRequest inRequest, MarketDataListener inMarketDataListener) {
        return this.marketDataClient.request(inRequest, inMarketDataListener);
    }

    public void cancel(String inRequestId) {
        this.marketDataClient.cancel(inRequestId);
    }

    public Set<Capability> getAvailableCapability() {
        return this.marketDataClient.getAvailableCapability();
    }

    public Set<String> getProviders() {
        return this.marketDataClient.getProviders();
    }

    public static MarketDataClientService getInstance() {
        return ServiceManager.getInstance().getService(MarketDataClientService.class);
    }

    public void setMarketDataClientFactory(MarketDataRpcClientFactory inMarketDataClientFactory) {
        this.marketDataClientFactory = inMarketDataClientFactory;
    }
}

