/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.marketdata.view;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Properties;
import java.util.SortedMap;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.joda.time.DateTime;
import org.marketcetera.event.AggregateEvent;
import org.marketcetera.event.AskEvent;
import org.marketcetera.event.BidEvent;
import org.marketcetera.event.Event;
import org.marketcetera.event.QuoteEvent;
import org.marketcetera.marketdata.Content;
import org.marketcetera.marketdata.MarketDataListener;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.marketdata.MarketDataRequestBuilder;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderSingleSuggestion;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.Side;
import org.marketcetera.ui.PhotonServices;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.marketdata.event.MarketDataDetailEvent;
import org.marketcetera.ui.marketdata.service.MarketDataClientService;
import org.marketcetera.ui.marketdata.view.MarketDataQuoteItem;
import org.marketcetera.ui.service.trade.TradeClientService;
import org.marketcetera.ui.trade.event.SuggestionEvent;
import org.marketcetera.ui.view.AbstractContentView;
import org.marketcetera.ui.view.ContentView;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class MarketDataDetailView
extends AbstractContentView
implements ContentView {
    private static final String ALL_PROVIDERS = "<all providers>";
    private String depthMarketDataRequestId;
    private final SortedMap<Integer, MarketDataQuoteItem> bids = Maps.newTreeMap();
    private final SortedMap<Integer, MarketDataQuoteItem> asks = Maps.newTreeMap();
    private Instrument marketDataInstrument;
    private GridPane marketDataLayout;
    private ContextMenu bidMarketDataContextMenu;
    private ContextMenu askMarketDataContextMenu;
    private MenuItem buyMarketDataMenuItem;
    private MenuItem sellMarketDataMenuItem;
    private TableView<MarketDataQuoteItem> bidMarketDataTable;
    private TableView<MarketDataQuoteItem> askMarketDataTable;
    private MarketDataClientService marketDataClient;
    private TradeClientService tradeClient;
    private VBox rootLayout;
    private final String symbolKey = "SYMBOL";
    private HBox addSymbolLayout;
    private TextField addSymbolTextField;
    private Button addSymbolButton;
    private ComboBox<String> providerComboBox;
    private TableColumn<MarketDataQuoteItem, DateTime> bidTimestampColumn;
    private TableColumn<MarketDataQuoteItem, String> bidExchangeColumn;
    private TableColumn<MarketDataQuoteItem, BigDecimal> bidSizeColumn;
    private TableColumn<MarketDataQuoteItem, BigDecimal> bidPriceColumn;
    private TableColumn<MarketDataQuoteItem, BigDecimal> askSizeColumn;
    private TableColumn<MarketDataQuoteItem, BigDecimal> askPriceColumn;
    private TableColumn<MarketDataQuoteItem, DateTime> askTimestampColumn;
    private TableColumn<MarketDataQuoteItem, String> askExchangeColumn;
    private static final String NAME = "Market Data Detail View";

    @Override
    public Region getMainLayout() {
        return this.rootLayout;
    }

    @Override
    public void onClose() {
        super.onClose();
        try {
            if (this.depthMarketDataRequestId != null) {
                this.marketDataClient.cancel(this.depthMarketDataRequestId);
            }
            this.clearDepthDisplay();
        }
        catch (Exception e) {
            SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
        }
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    protected void onStart() {
        this.marketDataClient = this.serviceManager.getService(MarketDataClientService.class);
        SLF4JLoggerProxy.debug((Object)this, (String)"Available market data capabilities are: {}", (Object[])new Object[]{this.marketDataClient.getAvailableCapability()});
        this.tradeClient = this.serviceManager.getService(TradeClientService.class);
        this.rootLayout = new VBox(5.0);
        this.initializeAddSymbol();
        if (this.marketDataInstrument != null) {
            this.addSymbolTextField.setText(this.marketDataInstrument.getSymbol());
        }
        this.marketDataLayout = new GridPane();
        this.marketDataLayout.setHgap(10.0);
        this.marketDataLayout.setVgap(10.0);
        this.marketDataLayout.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.initializeTables();
        this.initializeChart();
        int rowCount = 0;
        this.marketDataLayout.add((Node)this.addSymbolLayout, 0, rowCount, 2, 1);
        this.marketDataLayout.add(this.bidMarketDataTable, 0, ++rowCount);
        this.marketDataLayout.add(this.askMarketDataTable, 1, rowCount);
        this.marketDataLayout.setMaxWidth(Double.MAX_VALUE);
        this.marketDataLayout.setMaxHeight(Double.MAX_VALUE);
        RowConstraints addSymbolRowConstraint = new RowConstraints();
        addSymbolRowConstraint.setVgrow(Priority.NEVER);
        RowConstraints marketDataTableRowConstraint = new RowConstraints();
        marketDataTableRowConstraint.setVgrow(Priority.ALWAYS);
        this.marketDataLayout.getRowConstraints().addAll((Object[])new RowConstraints[]{addSymbolRowConstraint, marketDataTableRowConstraint});
        ColumnConstraints bidTableColumnConstraint = new ColumnConstraints();
        bidTableColumnConstraint.setHgrow(Priority.ALWAYS);
        bidTableColumnConstraint.setPercentWidth(50.0);
        ColumnConstraints askTableColumnConstraint = new ColumnConstraints();
        askTableColumnConstraint.setHgrow(Priority.ALWAYS);
        askTableColumnConstraint.setPercentWidth(50.0);
        this.marketDataLayout.prefWidthProperty().bind((ObservableValue)this.getParentWindow().widthProperty());
        this.marketDataLayout.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{bidTableColumnConstraint, askTableColumnConstraint});
        this.rootLayout.prefHeightProperty().bind((ObservableValue)this.getParentWindow().heightProperty());
        this.rootLayout.getChildren().addAll((Object[])new Node[]{this.marketDataLayout});
        this.rootLayout.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.addSymbolButton.fire();
                event.consume();
            }
        });
        if (this.marketDataInstrument != null) {
            this.doMarketDataRequest();
        }
        this.restoreSymbol();
    }

    public MarketDataDetailView(Region inParent, NewWindowEvent inEvent, Properties inProperties) {
        super(inParent, inEvent, inProperties);
        if (inEvent instanceof MarketDataDetailEvent) {
            MarketDataDetailEvent marketDataDetailEvent = (MarketDataDetailEvent)inEvent;
            this.marketDataInstrument = marketDataDetailEvent.getInstrument();
        }
    }

    private void initializeAddSymbol() {
        this.addSymbolLayout = new HBox(5.0);
        this.addSymbolTextField = new TextField();
        this.addSymbolButton = new Button();
        this.addSymbolButton.setGraphic((Node)new ImageView(PhotonServices.getIcon("images/add.png")));
        this.addSymbolButton.setDisable(true);
        this.addSymbolTextField.textProperty().addListener((observableValue, oldValue, newValue) -> this.addSymbolButton.setDisable((newValue = this.tradeClient.getTreatedSymbol((String)newValue)) == null));
        this.addSymbolButton.setOnAction(event -> {
            String symbol = this.tradeClient.getTreatedSymbol(this.addSymbolTextField.getText());
            if (symbol == null) {
                return;
            }
            this.addSymbolTextField.textProperty().set((Object)symbol);
            this.marketDataInstrument = this.tradeClient.resolveSymbol(symbol);
            this.updateViewProperties();
            this.doMarketDataRequest();
            this.addSymbolTextField.setText(null);
        });
        this.addSymbolLayout.setAlignment(Pos.CENTER_LEFT);
        this.providerComboBox = new ComboBox();
        this.providerComboBox.getItems().add((Object)ALL_PROVIDERS);
        this.providerComboBox.getItems().addAll(this.marketDataClient.getProviders());
        this.addSymbolLayout.getChildren().addAll((Object[])new Node[]{this.providerComboBox, this.addSymbolTextField, this.addSymbolButton});
    }

    private void initializeTables() {
        this.bidMarketDataTable = new TableView();
        this.bidMarketDataTable.setPlaceholder((Node)new Label("no bid data"));
        this.askMarketDataTable = new TableView();
        this.askMarketDataTable.setPlaceholder((Node)new Label("no ask data"));
        this.initializeColumns();
        this.initializeContextMenu();
        this.bidMarketDataTable.getColumns().forEach(column -> {
            column.setReorderable(false);
            column.setSortable(false);
        });
        this.askMarketDataTable.getColumns().forEach(column -> {
            column.setReorderable(false);
            column.setSortable(false);
        });
        this.bidMarketDataTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.askMarketDataTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
    }

    private void initializeColumns() {
        this.bidTimestampColumn = new TableColumn("Timestamp");
        this.bidTimestampColumn.setCellValueFactory((Callback)new PropertyValueFactory("timestamp"));
        this.bidTimestampColumn.setCellFactory(tableColumn -> PhotonServices.renderDateTimeCell(tableColumn));
        this.bidExchangeColumn = new TableColumn("Exchange");
        this.bidExchangeColumn.setCellValueFactory((Callback)new PropertyValueFactory("exchange"));
        this.bidSizeColumn = new TableColumn("Size");
        this.bidSizeColumn.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.bidSizeColumn.setCellFactory(tableColumn -> PhotonServices.renderNumberCell(tableColumn));
        this.bidPriceColumn = new TableColumn("Price");
        this.bidPriceColumn.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.bidPriceColumn.setCellFactory(tableColumn -> PhotonServices.renderCurrencyCell(tableColumn));
        this.bidMarketDataTable.getColumns().add(this.bidTimestampColumn);
        this.bidMarketDataTable.getColumns().add(this.bidExchangeColumn);
        this.bidMarketDataTable.getColumns().add(this.bidSizeColumn);
        this.bidMarketDataTable.getColumns().add(this.bidPriceColumn);
        this.askPriceColumn = new TableColumn("Price");
        this.askPriceColumn.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.askPriceColumn.setCellFactory(tableColumn -> PhotonServices.renderCurrencyCell(tableColumn));
        this.askSizeColumn = new TableColumn("Size");
        this.askSizeColumn.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.askSizeColumn.setCellFactory(tableColumn -> PhotonServices.renderNumberCell(tableColumn));
        this.askTimestampColumn = new TableColumn("Timestamp");
        this.askTimestampColumn.setCellValueFactory((Callback)new PropertyValueFactory("timestamp"));
        this.askTimestampColumn.setCellFactory(tableColumn -> PhotonServices.renderDateTimeCell(tableColumn));
        this.askExchangeColumn = new TableColumn("Exchange");
        this.askExchangeColumn.setCellValueFactory((Callback)new PropertyValueFactory("exchange"));
        this.askMarketDataTable.getColumns().add(this.askPriceColumn);
        this.askMarketDataTable.getColumns().add(this.askSizeColumn);
        this.askMarketDataTable.getColumns().add(this.askExchangeColumn);
        this.askMarketDataTable.getColumns().add(this.askTimestampColumn);
    }

    private void initializeContextMenu() {
        this.buyMarketDataMenuItem = new MenuItem("Buy");
        this.buyMarketDataMenuItem.setOnAction(event -> {
            MarketDataQuoteItem selectedItem = (MarketDataQuoteItem)this.bidMarketDataTable.getSelectionModel().getSelectedItem();
            this.buyOrSellAction(Side.Buy, (BigDecimal)selectedItem.priceProperty().get());
        });
        this.sellMarketDataMenuItem = new MenuItem("Sell");
        this.sellMarketDataMenuItem.setOnAction(event -> {
            MarketDataQuoteItem selectedItem = (MarketDataQuoteItem)this.bidMarketDataTable.getSelectionModel().getSelectedItem();
            this.buyOrSellAction(Side.Sell, (BigDecimal)selectedItem.priceProperty().get());
        });
        this.bidMarketDataContextMenu = new ContextMenu();
        this.askMarketDataContextMenu = new ContextMenu();
        this.bidMarketDataContextMenu.getItems().addAll((Object[])new MenuItem[]{this.sellMarketDataMenuItem});
        this.askMarketDataContextMenu.getItems().addAll((Object[])new MenuItem[]{this.buyMarketDataMenuItem});
        this.bidMarketDataTable.setContextMenu(this.bidMarketDataContextMenu);
        this.askMarketDataTable.setContextMenu(this.askMarketDataContextMenu);
    }

    private void buyOrSellAction(Side inSide, BigDecimal inPrice) {
        OrderSingle orderSingle = Factory.getInstance().createOrderSingle();
        orderSingle.setInstrument(this.marketDataInstrument);
        orderSingle.setOrderType(OrderType.Limit);
        orderSingle.setPrice(inPrice);
        orderSingle.setSide(inSide);
        OrderSingleSuggestion suggestion = Factory.getInstance().createOrderSingleSuggestion();
        suggestion.setIdentifier("Market Data List View Action");
        suggestion.setScore(BigDecimal.ONE);
        suggestion.setOrder(orderSingle);
        this.uiMessageService.post(this.applicationContext.getBean(SuggestionEvent.class, new Object[]{inSide.name() + " " + this.marketDataInstrument.getSymbol(), suggestion}));
    }

    private void doMarketDataRequest() {
        if (this.depthMarketDataRequestId != null) {
            this.marketDataClient.cancel(this.depthMarketDataRequestId);
        }
        Platform.runLater(() -> {
            this.bidMarketDataTable.getItems().clear();
            this.askMarketDataTable.getItems().clear();
        });
        this.bids.clear();
        this.asks.clear();
        this.depthMarketDataRequestId = UUID.randomUUID().toString();
        MarketDataRequestBuilder depthRequestBuilder = MarketDataRequestBuilder.newRequest().withRequestId(this.depthMarketDataRequestId).withSymbols(this.marketDataInstrument.getSymbol());
        depthRequestBuilder = depthRequestBuilder.withContent(new Content[]{Content.AGGREGATED_DEPTH});
        if (this.providerComboBox.valueProperty().get() != null && this.providerComboBox.valueProperty().get() != ALL_PROVIDERS) {
            depthRequestBuilder.withProvider((String)this.providerComboBox.valueProperty().get());
        }
        MarketDataRequest depthRequest = depthRequestBuilder.create();
        this.marketDataClient.request(depthRequest, new MarketDataListener(){

            public void receiveMarketData(Event inEvent) {
                MarketDataDetailView.this.updateDepthMarketData(inEvent);
            }
        });
    }

    @Override
    protected void onClientConnect() {
        this.doMarketDataRequest();
    }

    @Override
    protected void onClientDisconnect() {
        Platform.runLater(() -> {
            this.bidMarketDataTable.getItems().clear();
            this.askMarketDataTable.getItems().clear();
        });
    }

    private void restoreSymbol() {
        Properties windowProperties = this.getViewProperties();
        String symbol = windowProperties.getProperty("SYMBOL");
        if (symbol != null) {
            this.marketDataInstrument = this.tradeClient.resolveSymbol(symbol);
            this.doMarketDataRequest();
        }
    }

    private void updateViewProperties() {
        if (this.marketDataInstrument != null) {
            this.getViewProperties().setProperty("SYMBOL", this.marketDataInstrument.getFullSymbol());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateDepthMarketData(Event inEvent) {
        SLF4JLoggerProxy.trace((Object)this, (String)"{} received depth event: {}", (Object[])new Object[]{this, inEvent});
        if (inEvent instanceof QuoteEvent) {
            QuoteEvent quoteEvent = (QuoteEvent)inEvent;
            MarketDataQuoteItem quoteItem = new MarketDataQuoteItem(quoteEvent);
            if (quoteEvent instanceof BidEvent) {
                this.bids.put(quoteEvent.getLevel(), quoteItem);
            } else {
                if (!(quoteEvent instanceof AskEvent)) {
                    SLF4JLoggerProxy.warn((Object)this, (String)"Discarding unexpected event: {}", (Object[])new Object[]{inEvent});
                    return;
                }
                this.asks.put(quoteEvent.getLevel(), quoteItem);
            }
        } else if (inEvent instanceof AggregateEvent) {
            AggregateEvent aggregateEvent = (AggregateEvent)inEvent;
        }
        this.refreshDepthDisplay();
    }

    private void clearDepthDisplay() {
        this.bidMarketDataTable.getItems().clear();
        this.askMarketDataTable.getItems().clear();
    }

    private void refreshDepthDisplay() {
        Platform.runLater(() -> {
            this.clearDepthDisplay();
            this.bidMarketDataTable.getItems().addAll(this.bids.values());
            this.askMarketDataTable.getItems().addAll(this.asks.values());
        });
    }

    private void initializeChart() {
    }
}

